/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.handler;

import io.netty.channel.ChannelHandlerContext;
import java.util.function.Consumer;
import org.fisco.bcos.sdk.channel.ChannelVersionNegotiation;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.network.MsgHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNodeVersionHandler
implements MsgHandler {
    private static Logger logger = LoggerFactory.getLogger(GetNodeVersionHandler.class);
    private final Consumer<String> nodeVersionUpdater;

    public GetNodeVersionHandler(Consumer<String> nodeVersionUpdater) {
        this.nodeVersionUpdater = nodeVersionUpdater;
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx) {
        String peerIpAndPort = ChannelVersionNegotiation.getPeerHost(ctx);
        this.nodeVersionUpdater.accept(peerIpAndPort);
        logger.info("GetNodeVersionHandler: onConnect, endpoint: {}", (Object)peerIpAndPort);
    }

    @Override
    public void onMessage(ChannelHandlerContext ctx, Message msg) {
    }

    @Override
    public void onDisconnect(ChannelHandlerContext ctx) {
        logger.info("GetNodeVersionHandler: onDisconnect, endpoint: {}", (Object)ChannelVersionNegotiation.getPeerHost(ctx));
    }
}

