/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.fisco.bcos.sdk.channel.Channel;
import org.fisco.bcos.sdk.channel.ResponseCallback;
import org.fisco.bcos.sdk.channel.model.Options;
import org.fisco.bcos.sdk.client.RespCallback;
import org.fisco.bcos.sdk.client.exceptions.ClientException;
import org.fisco.bcos.sdk.client.protocol.request.JsonRpcRequest;
import org.fisco.bcos.sdk.model.JsonRpcResponse;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.model.Response;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.service.GroupManagerService;
import org.fisco.bcos.sdk.utils.ChannelUtils;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcService {
    protected final ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
    private static Logger logger = LoggerFactory.getLogger(JsonRpcService.class);
    private final GroupManagerService groupManagerService;
    public final Channel channel;
    private final Integer groupId;

    public JsonRpcService(GroupManagerService groupManagerService, Channel channel, Integer groupId) {
        this.groupManagerService = groupManagerService;
        this.channel = channel;
        this.groupId = groupId;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public GroupManagerService getGroupManagerService() {
        return this.groupManagerService;
    }

    public <T extends JsonRpcResponse> T sendRequestToPeer(JsonRpcRequest request, String peerIpPort, Class<T> responseType) {
        return this.sendRequestToPeer(request, MsgType.CHANNEL_RPC_REQUEST, responseType, peerIpPort);
    }

    public <T extends JsonRpcResponse> T sendRequestToGroup(JsonRpcRequest request, Class<T> responseType) {
        return this.sendRequestToGroup(request, MsgType.CHANNEL_RPC_REQUEST, responseType);
    }

    public <T extends JsonRpcResponse> T sendRequestToPeer(JsonRpcRequest request, MsgType messageType, Class<T> responseType, String peerIpPort) {
        Message message = this.encodeRequestToMessage(request, (short)messageType.getType());
        Response response = this.channel.sendToPeer(message, peerIpPort);
        return this.parseResponseIntoJsonRpcResponse(request, response, responseType);
    }

    public <T extends JsonRpcResponse> T sendRequestToGroup(JsonRpcRequest request, MsgType messageType, Class<T> responseType) {
        Message message = this.encodeRequestToMessage(request, (short)messageType.getType());
        Response response = this.groupManagerService.sendMessageToGroup(this.groupId, message);
        if (response == null) {
            throw new ClientException("sendRequestToGroup to " + this.groupId + " failed for select peers to send message failed, please make sure that the group exists");
        }
        return this.parseResponseIntoJsonRpcResponse(request, response, responseType);
    }

    public <T extends JsonRpcResponse> void asyncSendRequestToPeer(JsonRpcRequest request, String peerIpAndPort, Class<T> responseType, RespCallback<T> callback) {
        this.asyncSendRequestToPeer(request, MsgType.CHANNEL_RPC_REQUEST, peerIpAndPort, responseType, callback);
    }

    public <T extends JsonRpcResponse> void asyncSendRequestToPeer(final JsonRpcRequest request, MsgType messageType, String peerIpAndPort, final Class<T> responseType, final RespCallback<T> callback) {
        Message message = this.encodeRequestToMessage(request, (short)messageType.getType());
        this.channel.asyncSendToPeer(message, peerIpAndPort, new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                try {
                    Object jsonRpcResponse = JsonRpcService.this.parseResponseIntoJsonRpcResponse(request, response, responseType);
                    callback.onResponse(jsonRpcResponse);
                }
                catch (ClientException e) {
                    Response errorResponse = new Response();
                    errorResponse.setErrorMessage(e.getErrorMessage());
                    errorResponse.setErrorCode(e.getErrorCode());
                    callback.onError(errorResponse);
                }
            }
        }, new Options());
    }

    public <T extends JsonRpcResponse> void asyncSendRequestToGroup(JsonRpcRequest request, Class<T> responseType, RespCallback<T> callback) {
        this.asyncSendRequestToGroup(request, MsgType.CHANNEL_RPC_REQUEST, responseType, callback);
    }

    public <T extends JsonRpcResponse> void asyncSendRequestToGroup(final JsonRpcRequest request, MsgType messageType, final Class<T> responseType, final RespCallback<T> callback) {
        Message message = this.encodeRequestToMessage(request, (short)messageType.getType());
        this.groupManagerService.asyncSendMessageToGroup(this.groupId, message, new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                try {
                    Object jsonRpcResponse = JsonRpcService.this.parseResponseIntoJsonRpcResponse(request, response, responseType);
                    callback.onResponse(jsonRpcResponse);
                }
                catch (ClientException e) {
                    callback.onError(response);
                }
            }
        });
    }

    public <T extends JsonRpcResponse> void asyncSendTransactionToGroup(final JsonRpcRequest request, final TransactionCallback callback, final Class<T> responseType) {
        final Message message = this.encodeRequestToMessage(request, (short)MsgType.CHANNEL_RPC_REQUEST.getType());
        this.groupManagerService.asyncSendTransaction(this.groupId, message, callback, new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                try {
                    JsonRpcService.this.parseResponseIntoJsonRpcResponse(request, response, responseType);
                }
                catch (ClientException e) {
                    if (message != null) {
                        JsonRpcService.this.groupManagerService.eraseTransactionSeq(message.getSeq());
                    }
                    if (response != null) {
                        JsonRpcService.this.groupManagerService.eraseTransactionSeq(response.getMessageID());
                    }
                    callback.onError(e.getErrorCode(), e.getErrorMessage());
                }
            }
        });
    }

    protected <T extends JsonRpcResponse> T parseResponseIntoJsonRpcResponse(JsonRpcRequest request, Response response, Class<T> responseType) {
        try {
            if (response.getErrorCode() == 0) {
                JsonRpcResponse jsonRpcResponse = (JsonRpcResponse)this.objectMapper.readValue(response.getContent(), responseType);
                if (jsonRpcResponse.getError() != null) {
                    logger.error("parseResponseIntoJsonRpcResponse failed for non-empty error message, method: {}, group: {}, seq: {}, retErrorMessage: {}, retErrorCode: {}", new Object[]{request.getMethod(), this.groupId, response.getMessageID(), jsonRpcResponse.getError().getMessage(), jsonRpcResponse.getError().getCode()});
                    throw new ClientException(jsonRpcResponse.getError().getCode(), jsonRpcResponse.getError().getMessage(), "parseResponseIntoJsonRpcResponse failed for non-empty error message, method: " + request.getMethod() + " ,group: " + this.groupId + " ,seq:" + response.getMessageID() + ",retErrorMessage: " + jsonRpcResponse.getError().getMessage());
                }
                return (T)jsonRpcResponse;
            }
            logger.error("parseResponseIntoJsonRpcResponse failed, method: {}, group: {}, seq: {}, retErrorMessage: {}, retErrorCode: {}", new Object[]{request.getMethod(), this.groupId, response.getMessageID(), response.getErrorMessage(), response.getErrorCode()});
            throw new ClientException(response.getErrorCode(), response.getErrorMessage(), "get response failed, errorCode:" + response.getErrorCode() + ", error message:" + response.getErrorMessage());
        }
        catch (JsonProcessingException e) {
            logger.error("parseResponseIntoJsonRpcResponse failed for decode the message exception, errorMessage: {}, groupId: {}", (Object)e.getMessage(), (Object)this.groupId);
            throw new ClientException("parseResponseIntoJsonRpcResponse failed for decode the message exceptioned, error message:" + e.getMessage(), e);
        }
    }

    private Message encodeRequestToMessage(JsonRpcRequest request, Short messageType) {
        try {
            byte[] encodedData = this.objectMapper.writeValueAsBytes((Object)request);
            Message message = new Message();
            message.setSeq(ChannelUtils.newSeq());
            message.setResult(0);
            message.setType(messageType);
            message.setData(encodedData);
            logger.trace("encodeRequestToMessage, seq: {}, method: {}, messageType: {}", new Object[]{message.getSeq(), request.getMethod(), message.getType()});
            return message;
        }
        catch (JsonProcessingException e) {
            logger.error("sendRequestToGroup failed for decode the message exceptioned, errorMessge: {}", (Object)e.getMessage());
            throw new ClientException("sendRequestToGroup to " + this.groupId + "failed for decode the message exceptioned, error message:" + e.getMessage(), e);
        }
    }
}

