/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.amop;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.fisco.bcos.sdk.amop.Amop;
import org.fisco.bcos.sdk.amop.AmopCallback;
import org.fisco.bcos.sdk.amop.AmopMsgOut;
import org.fisco.bcos.sdk.amop.AmopResponse;
import org.fisco.bcos.sdk.amop.AmopResponseCallback;
import org.fisco.bcos.sdk.amop.exception.AmopException;
import org.fisco.bcos.sdk.amop.topic.AmopMsgHandler;
import org.fisco.bcos.sdk.amop.topic.TopicManager;
import org.fisco.bcos.sdk.channel.Channel;
import org.fisco.bcos.sdk.channel.ResponseCallback;
import org.fisco.bcos.sdk.channel.model.Options;
import org.fisco.bcos.sdk.config.ConfigOption;
import org.fisco.bcos.sdk.config.model.AmopTopic;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.keystore.KeyTool;
import org.fisco.bcos.sdk.crypto.keystore.P12KeyStore;
import org.fisco.bcos.sdk.crypto.keystore.PEMKeyStore;
import org.fisco.bcos.sdk.model.AmopMsg;
import org.fisco.bcos.sdk.model.Message;
import org.fisco.bcos.sdk.model.MsgType;
import org.fisco.bcos.sdk.model.Response;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmopImp
implements Amop {
    private static Logger logger = LoggerFactory.getLogger(AmopImp.class);
    private Channel channel;
    private TopicManager topicManager;
    private AmopMsgHandler amopMsgHandler;
    private CryptoSuite cryptoSuite = new CryptoSuite(0);

    public AmopImp(Channel channel, ConfigOption config) {
        this.channel = channel;
        this.topicManager = new TopicManager();
        try {
            this.loadConfiguredTopics(config);
        }
        catch (AmopException e) {
            logger.error("Amop topic is not configured right, error:{}", (Throwable)e);
        }
        this.amopMsgHandler = new AmopMsgHandler(this.channel, this.topicManager);
        this.channel.addMessageHandler(MsgType.REQUEST_TOPICCERT, this.amopMsgHandler);
        this.channel.addMessageHandler(MsgType.AMOP_REQUEST, this.amopMsgHandler);
        this.channel.addMessageHandler(MsgType.AMOP_MULBROADCAST, this.amopMsgHandler);
        this.channel.addMessageHandler(MsgType.AMOP_RESPONSE, this.amopMsgHandler);
        this.channel.addEstablishHandler(this.amopMsgHandler);
    }

    @Override
    public void subscribeTopic(String topicName, AmopCallback callback) {
        logger.info("subscribe normal topic, topic:{}", (Object)topicName);
        this.topicManager.addTopic(topicName, callback);
        this.sendSubscribe();
    }

    @Override
    public void subscribePrivateTopics(String topicName, KeyTool privateKeyTool, AmopCallback callback) {
        logger.info("subscribe private topic, topic:{}", (Object)topicName);
        CryptoKeyPair cryptoKeyPair = this.cryptoSuite.getKeyPairFactory().createKeyPair(privateKeyTool.getKeyPair());
        this.topicManager.addPrivateTopicSubscribe(topicName, cryptoKeyPair, callback);
        this.sendSubscribe();
    }

    @Override
    public void subscribePrivateTopics(String topicName, String hexPrivateKey, AmopCallback callback) {
        logger.info("subscribe private topic, topic:{}", (Object)topicName);
        CryptoKeyPair cryptoKeyPair = this.cryptoSuite.getKeyPairFactory().createKeyPair(hexPrivateKey);
        this.topicManager.addPrivateTopicSubscribe(topicName, cryptoKeyPair, callback);
        this.sendSubscribe();
    }

    @Override
    public void publishPrivateTopic(String topicName, List<KeyTool> publicKeyTools) {
        logger.info("setup private topic, topic:{} pubKey len:{}", (Object)topicName, (Object)publicKeyTools.size());
        this.topicManager.addPrivateTopicSend(topicName, publicKeyTools);
        this.sendSubscribe();
    }

    @Override
    public void publishPrivateTopicWithHexPublicKeyList(String topicName, List<String> publicKeyList) {
        logger.info("setup private topic, topic:{} pubKey len:{}", (Object)topicName, (Object)publicKeyList.size());
        this.topicManager.addPrivateTopicSendWithHexPublicKey(topicName, publicKeyList);
        this.sendSubscribe();
    }

    @Override
    public void unsubscribeTopic(String topicName) {
        logger.info("unsubscribe topic, topic:{}", (Object)topicName);
        this.topicManager.removeTopic(topicName);
        this.sendSubscribe();
    }

    @Override
    public void sendAmopMsg(AmopMsgOut content, final AmopResponseCallback callback) {
        if (!this.topicManager.canSendTopicMsg(content)) {
            logger.error("can not send this amop private msg out, you have not configured the public keys. topic:{}", (Object)content.getTopic());
        }
        AmopMsg msg = new AmopMsg();
        msg.setResult(0);
        msg.setSeq(this.newSeq());
        msg.setType((short)MsgType.AMOP_REQUEST.getType());
        msg.setTopic(content.getTopic());
        msg.setData(content.getContent());
        Options ops = new Options();
        ops.setTimeout(content.getTimeout());
        ResponseCallback cb = new ResponseCallback(){

            @Override
            public void onResponse(Response response) {
                logger.trace("receive response from subscriber, seq:{}", (Object)response.getMessageID());
                AmopResponse amopResponse = new AmopResponse(response);
                callback.onResponse(amopResponse);
            }
        };
        this.channel.asyncSendToRandom(msg, cb, ops);
        logger.info("send amop msg to a random peer, seq: {} topic: {}", (Object)msg.getSeq(), (Object)content.getTopic());
    }

    @Override
    public void broadcastAmopMsg(AmopMsgOut content) {
        if (!this.topicManager.canSendTopicMsg(content)) {
            logger.error("can not send this amop private msg out, you have not configured the public keys. topic:{}", (Object)content.getTopic());
        }
        AmopMsg amopMsg = new AmopMsg();
        amopMsg.setResult(0);
        amopMsg.setSeq(this.newSeq());
        amopMsg.setType((short)MsgType.AMOP_MULBROADCAST.getType());
        amopMsg.setTopic(content.getTopic());
        amopMsg.setData(content.getContent());
        this.channel.broadcast(amopMsg.getMessage());
        logger.info("broadcast amop msg to peers, seq:{} topic:{}", (Object)amopMsg.getSeq(), (Object)amopMsg.getTopic());
    }

    @Override
    public Set<String> getSubTopics() {
        return this.topicManager.getTopicNames();
    }

    @Override
    public void setCallback(AmopCallback cb) {
        this.topicManager.setCallback(cb);
    }

    @Override
    public void start() {
        logger.info("amop module started");
        this.amopMsgHandler.setIsRunning(true);
        this.sendSubscribe();
    }

    @Override
    public void stop() {
        logger.info("amop module stopped");
        this.amopMsgHandler.setIsRunning(false);
        this.unSubscribeAll();
    }

    private void unSubscribeAll() {
        List<String> peers = this.channel.getAvailablePeer();
        logger.info("unsubscribe all topics, inform {} peers", (Object)peers.size());
        for (String peer : peers) {
            try {
                this.unSubscribeToPeer(peer);
            }
            catch (JsonProcessingException e) {
                logger.error("Unsubscribe failed", (Throwable)e);
            }
        }
    }

    @Override
    public void sendSubscribe() {
        this.topicManager.updatePrivateTopicUUID();
        List<String> peers = this.channel.getAvailablePeer();
        logger.info("update subscribe inform {} peers", (Object)peers.size());
        for (String peer : peers) {
            try {
                this.updateSubscribeToPeer(peer);
            }
            catch (JsonProcessingException e) {
                logger.error("update amop subscription to node {}, json processed error, error message: {}", (Object)peer, (Object)e.getMessage());
            }
        }
    }

    private void updateSubscribeToPeer(String peer) throws JsonProcessingException {
        byte[] topics = this.getSubData(this.topicManager.getSubByPeer(peer));
        Message msg = new Message();
        msg.setType((short)MsgType.AMOP_CLIENT_TOPICS.getType());
        msg.setResult(0);
        msg.setSeq(this.newSeq());
        msg.setData(topics);
        Options opt = new Options();
        this.channel.asyncSendToPeer(msg, peer, null, opt);
        logger.debug("update topics to node, node:{}, topics:{}", (Object)peer, (Object)new String(topics));
    }

    private void unSubscribeToPeer(String peer) throws JsonProcessingException {
        Message msg = new Message();
        msg.setType((short)MsgType.AMOP_CLIENT_TOPICS.getType());
        msg.setResult(0);
        msg.setSeq(this.newSeq());
        byte[] topics = this.getSubData(this.topicManager.getBlockNotifyByPeer(peer));
        msg.setData(topics);
        Options opt = new Options();
        this.channel.asyncSendToPeer(msg, peer, null, opt);
        logger.info(" send update topic message request, seq: {}, content: {}", (Object)msg.getSeq(), (Object)new String(msg.getData()));
    }

    @Override
    private String newSeq() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    private byte[] getSubData(Set<String> topics) throws JsonProcessingException {
        byte[] topicBytes = ObjectMapperFactory.getObjectMapper().writeValueAsBytes((Object)topics.toArray());
        return topicBytes;
    }

    private void loadConfiguredTopics(ConfigOption config) throws AmopException {
        if (null == config.getAmopConfig() || null == config.getAmopConfig().getAmopTopicConfig()) {
            return;
        }
        List<AmopTopic> topics = config.getAmopConfig().getAmopTopicConfig();
        for (AmopTopic topic : topics) {
            if (null != topic.getPrivateKey()) {
                String privKeyFile = topic.getPrivateKey();
                KeyTool keyTool = privKeyFile.endsWith("p12") ? new P12KeyStore(privKeyFile, topic.getPassword()) : new PEMKeyStore(privKeyFile);
                this.topicManager.addPrivateTopicSubscribe(topic.getTopicName(), keyTool, null);
                continue;
            }
            if (null != topic.getPublicKeys()) {
                ArrayList<KeyTool> pubList = new ArrayList<KeyTool>();
                for (String pubKey : topic.getPublicKeys()) {
                    PEMKeyStore keyTool = new PEMKeyStore(pubKey);
                    pubList.add(keyTool);
                }
                this.topicManager.addPrivateTopicSend(topic.getTopicName(), pubList);
                continue;
            }
            throw new AmopException("Amop private topic is not configured right, please check your config file. Topic name " + topic.getTopicName() + ", neither private key nor public key list configured.");
        }
    }

    public Set<String> getAllTopics() {
        return this.topicManager.getAllTopics();
    }

    @Override
    public TopicManager getTopicManager() {
        return this.topicManager;
    }
}

