/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.wrapper;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.abi.TypeDecoder;
import org.fisco.bcos.sdk.abi.TypeEncoder;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.NumericType;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Bytes32;
import org.fisco.bcos.sdk.abi.datatypes.generated.Int256;
import org.fisco.bcos.sdk.abi.datatypes.generated.Uint256;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ABIObject {
    private static final Logger logger = LoggerFactory.getLogger(ABIObject.class);
    private String name;
    private ObjectType type;
    private ValueType valueType;
    private NumericType numericValue;
    private Bytes bytesValue;
    private int bytesLength;
    private Address addressValue;
    private Bool boolValue;
    private DynamicBytes dynamicBytesValue;
    private Utf8String stringValue;
    private ListType listType;
    private List<ABIObject> listValues;
    private int listLength;
    private ABIObject listValueType;
    private List<ABIObject> structFields;

    public ABIObject(ObjectType type) {
        this.type = type;
        switch (type) {
            case VALUE: {
                break;
            }
            case STRUCT: {
                this.structFields = new LinkedList<ABIObject>();
                break;
            }
            case LIST: {
                this.listValues = new LinkedList<ABIObject>();
            }
        }
    }

    public ABIObject(ValueType valueType) {
        this.type = ObjectType.VALUE;
        this.valueType = valueType;
    }

    public ABIObject(ValueType bytesValueType, int bytesLength) {
        this(bytesValueType);
        this.bytesLength = bytesLength;
    }

    public ABIObject(ListType listType) {
        this.type = ObjectType.LIST;
        this.listType = listType;
        this.listValues = new LinkedList<ABIObject>();
    }

    public ABIObject(Uint256 uintValue) {
        this(ValueType.UINT);
        this.numericValue = uintValue;
    }

    public ABIObject(Int256 intValue) {
        this(ValueType.INT);
        this.numericValue = intValue;
    }

    public ABIObject(Address addressValue) {
        this(ValueType.ADDRESS);
        this.addressValue = addressValue;
    }

    public ABIObject(Bool boolValue) {
        this(ValueType.BOOL);
        this.boolValue = boolValue;
    }

    public ABIObject(Utf8String stringValue) {
        this(ValueType.STRING);
        this.stringValue = stringValue;
    }

    public ABIObject(DynamicBytes dynamicBytesValue) {
        this(ValueType.DBYTES);
        this.dynamicBytesValue = dynamicBytesValue;
    }

    public ABIObject(Bytes bytesValue) {
        this(ValueType.BYTES);
        this.bytesValue = bytesValue;
    }

    public ABIObject(Bytes bytesValue, int bytesLength) {
        this(bytesValue);
        this.bytesLength = bytesLength;
    }

    public ABIObject newObjectWithoutValue() {
        ABIObject abiObject = new ABIObject(this.type);
        abiObject.setValueType(this.getValueType());
        abiObject.setName(this.getName());
        abiObject.setListType(this.getListType());
        abiObject.setListLength(this.getListLength());
        if (this.getListValueType() != null) {
            abiObject.setListValueType(this.getListValueType().newObjectWithoutValue());
        }
        if (this.listValues != null) {
            for (ABIObject obj : this.listValues) {
                abiObject.listValues.add(obj.newObjectWithoutValue());
            }
        }
        if (this.structFields != null) {
            for (ABIObject obj : this.structFields) {
                abiObject.structFields.add(obj.newObjectWithoutValue());
            }
        }
        return abiObject;
    }

    public ABIObject newObject() {
        ABIObject abiObject = new ABIObject(this.type);
        abiObject.setBytesLength(this.bytesLength);
        abiObject.setValueType(this.getValueType());
        abiObject.setName(this.getName());
        if (this.getNumericValue() != null) {
            abiObject.setNumericValue(new NumericType(this.getNumericValue().getTypeAsString(), this.getNumericValue().getValue()){

                @Override
                public boolean dynamicType() {
                    return false;
                }

                @Override
                public int offset() {
                    return 1;
                }
            });
        }
        if (this.getBoolValue() != null) {
            abiObject.setBoolValue(new Bool(this.getBoolValue().getValue()));
        }
        if (this.getStringValue() != null) {
            abiObject.setStringValue(new Utf8String(this.getStringValue().getValue()));
        }
        if (this.getDynamicBytesValue() != null) {
            abiObject.setDynamicBytesValue(new DynamicBytes(this.getDynamicBytesValue().getValue()));
        }
        if (this.getAddressValue() != null) {
            abiObject.setAddressValue(new Address(this.getAddressValue().toUint160()));
        }
        if (this.getBytesValue() != null) {
            abiObject.setBytesValue(new Bytes(this.getBytesValue().getValue().length, this.getBytesValue().getValue()));
        }
        abiObject.setListType(this.getListType());
        abiObject.setListLength(this.getListLength());
        if (this.getListValueType() != null) {
            abiObject.setListValueType(this.getListValueType().newObject());
        }
        if (this.listValues != null) {
            for (ABIObject obj : this.listValues) {
                abiObject.listValues.add(obj.newObject());
            }
        }
        if (this.structFields != null) {
            for (ABIObject obj : this.structFields) {
                abiObject.structFields.add(obj.newObject());
            }
        }
        return abiObject;
    }

    public boolean isDynamic() {
        switch (this.type) {
            case VALUE: {
                switch (this.valueType) {
                    case DBYTES: 
                    case STRING: {
                        return true;
                    }
                }
                return false;
            }
            case LIST: {
                switch (this.listType) {
                    case FIXED: {
                        return this.listValueType.isDynamic();
                    }
                    case DYNAMIC: {
                        return true;
                    }
                }
                break;
            }
            case STRUCT: {
                for (ABIObject abiObject : this.structFields) {
                    if (!abiObject.isDynamic()) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public int offset() {
        if (this.isDynamic()) {
            return 1;
        }
        int offset = 0;
        if (this.type == ObjectType.VALUE) {
            offset = 1;
        } else if (this.type == ObjectType.STRUCT) {
            int l = 0;
            for (ABIObject abiObject : this.structFields) {
                l += abiObject.offset();
            }
            offset = l;
        } else {
            int length = this.listLength;
            int basicOffset = this.listValueType.offset();
            offset = length * basicOffset;
        }
        return offset;
    }

    public int offsetAsByteLength() {
        return this.offset() * 32;
    }

    public int offsetAsHexLength() {
        return this.offset() * 64;
    }

    public String encode() {
        StringBuffer stringBuffer = new StringBuffer();
        block0 : switch (this.type) {
            case VALUE: {
                switch (this.valueType) {
                    case UINT: 
                    case INT: {
                        stringBuffer.append(TypeEncoder.encode(this.numericValue));
                        break block0;
                    }
                    case BOOL: {
                        stringBuffer.append(TypeEncoder.encode(this.boolValue));
                        break block0;
                    }
                    case FIXED: 
                    case UFIXED: {
                        throw new UnsupportedOperationException(" Unsupported fixed/unfixed type. ");
                    }
                    case BYTES: {
                        stringBuffer.append(TypeEncoder.encode(this.bytesValue));
                        break block0;
                    }
                    case ADDRESS: {
                        stringBuffer.append(TypeEncoder.encode(this.addressValue));
                        break block0;
                    }
                    case DBYTES: {
                        stringBuffer.append(TypeEncoder.encode(this.dynamicBytesValue));
                        break block0;
                    }
                    case STRING: {
                        stringBuffer.append(TypeEncoder.encode(this.stringValue));
                        break block0;
                    }
                }
                throw new UnsupportedOperationException(" Unrecognized valueType: " + (Object)((Object)this.valueType));
            }
            case STRUCT: {
                long dynamicOffset = 0L;
                for (ABIObject abiObject : this.structFields) {
                    dynamicOffset += (long)abiObject.offsetAsByteLength();
                }
                StringBuffer fixedBuffer = new StringBuffer();
                StringBuffer dynamicBuffer = new StringBuffer();
                for (ABIObject abiObject : this.structFields) {
                    String encodeValue = abiObject.encode();
                    if (abiObject.isDynamic()) {
                        fixedBuffer.append(TypeEncoder.encode(new Uint256(dynamicOffset)));
                        dynamicBuffer.append(encodeValue);
                        dynamicOffset += (long)(encodeValue.length() >> 1);
                        continue;
                    }
                    fixedBuffer.append(encodeValue);
                }
                stringBuffer.append(fixedBuffer).append(dynamicBuffer);
                break;
            }
            case LIST: {
                StringBuffer lengthBuffer = new StringBuffer();
                StringBuffer listValueBuffer = new StringBuffer();
                StringBuffer offsetBuffer = new StringBuffer();
                if (this.listType == ListType.DYNAMIC) {
                    lengthBuffer.append(TypeEncoder.encode(new Uint256(this.listValues.size())));
                }
                int dynamicOffset = this.listValues.size() * 32;
                for (ABIObject abiObject : this.listValues) {
                    String listValueEncode = abiObject.encode();
                    listValueBuffer.append(abiObject.encode());
                    if (!abiObject.isDynamic()) continue;
                    offsetBuffer.append(TypeEncoder.encode(new Uint256(dynamicOffset)));
                    dynamicOffset += listValueEncode.length() >> 1;
                }
                stringBuffer.append(lengthBuffer).append(offsetBuffer).append(listValueBuffer);
                break;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ABI: {}", (Object)stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    public ABIObject decode(String input) {
        return this.decode(input, 0);
    }

    private ABIObject decode(String input, int offset) {
        ABIObject abiObject = this.newObject();
        switch (this.type) {
            case VALUE: {
                switch (this.valueType) {
                    case BOOL: {
                        abiObject.setBoolValue(TypeDecoder.decode(input, offset, Bool.class));
                        break;
                    }
                    case UINT: {
                        abiObject.setNumericValue(TypeDecoder.decode(input, offset, Uint256.class));
                        break;
                    }
                    case INT: {
                        abiObject.setNumericValue(TypeDecoder.decode(input, offset, Int256.class));
                        break;
                    }
                    case FIXED: 
                    case UFIXED: {
                        throw new UnsupportedOperationException(" Unsupported fixed/unfixed type. ");
                    }
                    case BYTES: {
                        abiObject.setBytesValue(TypeDecoder.decode(input, offset, Bytes32.class));
                        break;
                    }
                    case ADDRESS: {
                        abiObject.setAddressValue(TypeDecoder.decode(input, offset, Address.class));
                        break;
                    }
                    case DBYTES: {
                        abiObject.setDynamicBytesValue(TypeDecoder.decode(input, offset, DynamicBytes.class));
                        break;
                    }
                    case STRING: {
                        abiObject.setStringValue(TypeDecoder.decode(input, offset, Utf8String.class));
                    }
                }
                break;
            }
            case STRUCT: {
                int structOffset = offset;
                int initialOffset = offset;
                for (int i = 0; i < this.structFields.size(); ++i) {
                    ABIObject structObject = abiObject.structFields.get(i);
                    ABIObject itemObject = null;
                    if (structObject.isDynamic()) {
                        int structValueOffset = TypeDecoder.decode(input, structOffset, Uint256.class).getValue().intValue();
                        itemObject = structObject.decode(input, initialOffset + (structValueOffset << 1));
                    } else {
                        itemObject = structObject.decode(input, structOffset);
                    }
                    abiObject.structFields.set(i, itemObject);
                    structOffset += structObject.offsetAsHexLength();
                }
                break;
            }
            case LIST: {
                int listOffset = offset;
                int initialOffset = offset;
                int listLength = 0;
                if (this.listType == ListType.DYNAMIC) {
                    listLength = TypeDecoder.decode(input, listOffset, Uint256.class).getValue().intValue();
                    listOffset += 64;
                    initialOffset += 64;
                } else {
                    listLength = abiObject.getListLength();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace(" listType: {}, listLength: {}", (Object)this.listType, (Object)listLength);
                }
                ABIObject listValueObject = abiObject.getListValueType();
                for (int i = 0; i < listLength; ++i) {
                    ABIObject itemABIObject = null;
                    if (listValueObject.isDynamic()) {
                        int listValueOffset = TypeDecoder.decode(input, listOffset, Uint256.class).getValue().intValue();
                        itemABIObject = abiObject.getListValueType().decode(input, initialOffset + (listValueOffset << 1));
                    } else {
                        itemABIObject = abiObject.getListValueType().decode(input, listOffset);
                    }
                    listOffset += listValueObject.offsetAsHexLength();
                    abiObject.getListValues().add(itemABIObject);
                }
                break;
            }
        }
        return abiObject;
    }

    public ObjectType getType() {
        return this.type;
    }

    public void setType(ObjectType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public NumericType getNumericValue() {
        return this.numericValue;
    }

    public Bool getBoolValue() {
        return this.boolValue;
    }

    public void setBoolValue(Bool boolValue) {
        this.type = ObjectType.VALUE;
        this.valueType = ValueType.BOOL;
        this.boolValue = boolValue;
    }

    public void setNumericValue(NumericType numericValue) {
        this.type = ObjectType.VALUE;
        this.valueType = numericValue.getTypeAsString().startsWith("int") || numericValue instanceof Int256 ? ValueType.INT : ValueType.UINT;
        this.numericValue = numericValue;
    }

    public Bytes getBytesValue() {
        return this.bytesValue;
    }

    public void setBytesValue(Bytes bytesValue) {
        this.type = ObjectType.VALUE;
        this.valueType = ValueType.BYTES;
        this.bytesValue = bytesValue;
    }

    public Address getAddressValue() {
        return this.addressValue;
    }

    public void setAddressValue(Address addressValue) {
        this.type = ObjectType.VALUE;
        this.valueType = ValueType.ADDRESS;
        this.addressValue = addressValue;
    }

    public List<ABIObject> getStructFields() {
        return this.structFields;
    }

    public void setStructFields(List<ABIObject> structFields) {
        this.type = ObjectType.STRUCT;
        this.structFields = structFields;
    }

    public ListType getListType() {
        return this.listType;
    }

    public void setListType(ListType listType) {
        this.listType = listType;
    }

    public List<ABIObject> getListValues() {
        return this.listValues;
    }

    public void setListValues(List<ABIObject> listValues) {
        this.type = ObjectType.LIST;
        this.listValues = listValues;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public DynamicBytes getDynamicBytesValue() {
        return this.dynamicBytesValue;
    }

    public void setDynamicBytesValue(DynamicBytes dynamicBytesValue) {
        this.dynamicBytesValue = dynamicBytesValue;
    }

    public Utf8String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(Utf8String stringValue) {
        this.stringValue = stringValue;
    }

    public ABIObject getListValueType() {
        return this.listValueType;
    }

    public void setListValueType(ABIObject listValueType) {
        this.listValueType = listValueType;
    }

    public int getListLength() {
        return this.listLength;
    }

    public void setListLength(int listLength) {
        this.listLength = listLength;
    }

    public int getBytesLength() {
        return this.bytesLength;
    }

    public void setBytesLength(int bytesLength) {
        this.bytesLength = bytesLength;
    }

    public String toString() {
        String str = "ABIObject{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type);
        if (this.type == ObjectType.VALUE) {
            str = str + ", valueType=" + (Object)((Object)this.valueType);
            switch (this.valueType) {
                case BOOL: {
                    str = str + ", booValueType=";
                    str = str + (Objects.isNull(this.boolValue) ? "null" : this.boolValue.getValue());
                    break;
                }
                case UINT: 
                case INT: {
                    str = str + ", numericValue=";
                    str = str + (Objects.isNull(this.numericValue) ? "null" : this.numericValue.getValue());
                    break;
                }
                case ADDRESS: {
                    str = str + ", addressValue=";
                    str = str + (Objects.isNull(this.addressValue) ? "null" : this.addressValue.getValue());
                    break;
                }
                case BYTES: {
                    str = str + ", bytesValue=";
                    str = str + (Objects.isNull(this.bytesValue) ? "null" : (Object)this.bytesValue.getValue());
                    break;
                }
                case DBYTES: {
                    str = str + ", dynamicBytesValue=";
                    str = str + (Objects.isNull(this.dynamicBytesValue) ? "null" : (Object)this.dynamicBytesValue.getValue());
                }
                default: {
                    str = str + ", stringValue=";
                    str = str + (Objects.isNull(this.stringValue) ? "null" : this.stringValue.getValue());
                    break;
                }
            }
        } else if (this.type == ObjectType.LIST) {
            str = str + ", listType=" + (Object)((Object)this.listType);
            str = str + ", listValues=" + this.listValues + ", listLength=" + this.listLength;
        } else if (this.type == ObjectType.STRUCT) {
            str = str + ", structFields=" + this.structFields;
        }
        str = str + '}';
        return str;
    }

    public static enum ObjectType {
        VALUE,
        STRUCT,
        LIST;

    }

    public static enum ValueType {
        BOOL,
        UINT,
        INT,
        BYTES,
        ADDRESS,
        STRING,
        DBYTES,
        FIXED,
        UFIXED;

    }

    public static enum ListType {
        DYNAMIC,
        FIXED;

    }
}

