/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.external.format.xml.shared;

import java.io.OutputStream;
import java.util.Arrays;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlWriter {
    private static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    private static final int NO_INDENTING = -1;
    private static final char[] SPACES = new char[1000];
    private final XMLStreamWriter writer;
    private final int indent;
    private int depth;
    private boolean lastWasIndent;

    private XmlWriter(XMLStreamWriter writer, int indent) {
        this.writer = writer;
        this.indent = indent;
    }

    public void writeStartElement(String localName) {
        this.indent();
        try {
            this.writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) {
        this.indent();
        try {
            this.writer.writeStartElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        this.indent();
        try {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) {
        try {
            this.indent();
            this.writer.writeEmptyElement(namespaceURI, localName);
            this.outdent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        try {
            this.indent();
            this.writer.writeEmptyElement(prefix, localName, namespaceURI);
            this.outdent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEmptyElement(String localName) {
        try {
            this.indent();
            this.writer.writeEmptyElement(localName);
            this.outdent();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEndElement() {
        try {
            this.outdent();
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEndDocument() {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeAttribute(String localName, String value) {
        try {
            this.writer.writeAttribute(localName, value);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        try {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeAttribute(String namespaceURI, String localName, String value) {
        try {
            this.writer.writeAttribute(namespaceURI, localName, value);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeNamespace(String prefix, String namespaceURI) {
        try {
            this.writer.writeNamespace(prefix, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeDefaultNamespace(String namespaceURI) {
        try {
            this.writer.writeDefaultNamespace(namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeComment(String data) {
        try {
            this.writer.writeComment(data);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeProcessingInstruction(String target) {
        try {
            this.writer.writeProcessingInstruction(target);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeProcessingInstruction(String target, String data) {
        try {
            this.writer.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeCData(String data) {
        try {
            this.writer.writeCData(data);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeDTD(String dtd) {
        try {
            this.writer.writeDTD(dtd);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeEntityRef(String name) {
        try {
            this.writer.writeEntityRef(name);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStartDocument() {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStartDocument(String version) {
        try {
            this.writer.writeStartDocument(version);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeStartDocument(String encoding, String version) {
        try {
            this.writer.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeCharacters(String text) {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeCharacters(char[] text, int start, int len) {
        try {
            this.writer.writeCharacters(text, start, len);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPrefix(String uri) {
        try {
            return this.writer.getPrefix(uri);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void setPrefix(String prefix, String uri) {
        try {
            this.writer.setPrefix(prefix, uri);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDefaultNamespace(String uri) {
        try {
            this.writer.writeDefaultNamespace(uri);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public void setNamespaceContext(NamespaceContext context) {
        try {
            this.writer.setNamespaceContext(context);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    public Object getProperty(String name) {
        return this.writer.getProperty(name);
    }

    private void indent() {
        if (this.indent != -1) {
            this.writeCharacters("\n");
            this.writeCharacters(SPACES, 0, this.depth * this.indent);
        }
        this.lastWasIndent = true;
        ++this.depth;
    }

    private void outdent() {
        --this.depth;
        if (this.indent != -1 && !this.lastWasIndent) {
            this.writeCharacters("\n");
            this.writeCharacters(SPACES, 0, this.depth * this.indent);
        }
        this.lastWasIndent = false;
    }

    public static XmlWriter newWriter(OutputStream stream) {
        try {
            return new XmlWriter(XML_OUTPUT_FACTORY.createXMLStreamWriter(stream), -1);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public static XmlWriter newIndentingWriter(OutputStream stream) {
        return XmlWriter.newIndentingWriter(stream, 2);
    }

    public static XmlWriter newIndentingWriter(OutputStream stream, int indentSize) {
        if (indentSize < 0) {
            throw new IllegalArgumentException("Indent size cannot be negative");
        }
        try {
            return new XmlWriter(XML_OUTPUT_FACTORY.createXMLStreamWriter(stream), indentSize);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Arrays.fill(SPACES, ' ');
    }
}

