/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.external.format.xml.shared.datatypes;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.utility.ListIterate;
import org.finos.legend.engine.external.format.xml.shared.datatypes.BooleanSimpleTypeHandler;
import org.finos.legend.engine.external.format.xml.shared.datatypes.BuiltInDataTypes;
import org.finos.legend.engine.external.format.xml.shared.datatypes.DoubleSimpleTypeHandler;
import org.finos.legend.engine.external.format.xml.shared.datatypes.Facet;
import org.finos.legend.engine.external.format.xml.shared.datatypes.FacetType;
import org.finos.legend.engine.external.format.xml.shared.datatypes.LongSimpleTypeHandler;
import org.finos.legend.engine.external.format.xml.shared.datatypes.SimpleTypeHandler;
import org.finos.legend.engine.external.format.xml.shared.datatypes.XsdWhiteSpaceType;

public class SimpleTypesContext {
    public static final BigDecimal BIG_DECIMAL_DOUBLE_MAX = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal BIG_DECIMAL_DOUBLE_MIN = BigDecimal.valueOf(Double.MIN_VALUE);
    private final Supplier<NamespaceContext> namespacesSupplier;
    private MutableMap<QName, SimpleTypeHandler<?>> definedTypes = Maps.mutable.empty();
    private ZoneOffset defaultTimezone = ZoneOffset.UTC;

    public SimpleTypesContext(Supplier<NamespaceContext> namespacesSupplier) {
        this.namespacesSupplier = namespacesSupplier;
        this.registerBuiltInTypes();
    }

    public <T> SimpleTypeHandler<T> handler(QName name) {
        if (this.definedTypes.containsKey((Object)name)) {
            return (SimpleTypeHandler)this.definedTypes.get((Object)name);
        }
        throw new IllegalArgumentException("Unknown datatype: " + name);
    }

    public <T> SimpleTypeHandler<T> defineType(QName base, Facet ... facets) {
        return this.defineType(new QName("anon", UUID.randomUUID().toString()), base, Arrays.asList(facets));
    }

    public <T> SimpleTypeHandler<T> defineType(QName name, QName base, Facet ... facets) {
        return this.defineType(name, base, Arrays.asList(facets));
    }

    public <T> SimpleTypeHandler<T> defineType(QName base, List<Facet> facets) {
        return this.defineType(new QName("anon", UUID.randomUUID().toString()), base, facets);
    }

    public <T> SimpleTypeHandler<T> defineType(QName name, QName base, List<Facet> facets) {
        if (this.definedTypes.containsKey((Object)name)) {
            throw new IllegalArgumentException("Type already defined: " + name);
        }
        return this.register(((Handler)this.handler(base)).derive(name, (List)facets));
    }

    public <T> SimpleTypeHandler<List<T>> defineListType(QName itemType, Facet ... facets) {
        return this.defineListType(new QName("anon", UUID.randomUUID().toString()), itemType, Arrays.asList(facets));
    }

    public <T> SimpleTypeHandler<List<T>> defineListType(QName name, QName itemType, Facet ... facets) {
        return this.defineListType(name, itemType, Arrays.asList(facets));
    }

    public <T> SimpleTypeHandler<List<T>> defineListType(QName name, QName itemType, List<Facet> facets) {
        if (this.definedTypes.containsKey((Object)name)) {
            throw new IllegalArgumentException("Type already defined: " + name);
        }
        SimpleTypeHandler itemHandler = ((Handler)this.handler(itemType)).derive(name, (List)facets);
        return this.register(new ListHandler(name, (Handler)itemHandler));
    }

    public <T> SimpleTypeHandler<T> defineUnionType(List<QName> memberTypes, Facet ... facets) {
        return this.defineUnionType(new QName("anon", UUID.randomUUID().toString()), memberTypes, Arrays.asList(facets));
    }

    public <T> SimpleTypeHandler<T> defineUnionType(QName name, List<QName> memberTypes, Facet ... facets) {
        return this.defineUnionType(name, memberTypes, Arrays.asList(facets));
    }

    public <T> SimpleTypeHandler<T> defineUnionType(QName name, List<QName> memberTypes, List<Facet> facets) {
        if (this.definedTypes.containsKey((Object)name)) {
            throw new IllegalArgumentException("Type already defined: " + name);
        }
        MutableList memberHandlers = ListIterate.collect(memberTypes, (Function & Serializable)t -> ((Handler)this.handler((QName)t)).derive(name, (List)facets));
        return this.register(new UnionHandler(name, (List)memberHandlers));
    }

    private void registerBuiltInTypes() {
        Handler xsString = (Handler)this.register(new StringHandler(BuiltInDataTypes.XS_STRING));
        this.register(xsString.derive(BuiltInDataTypes.XS_NORMALIZED_STRING, new Facet[]{FacetType.WHITESPACE.of("replace")}));
        Handler xsToken = (Handler)this.register(xsString.derive(BuiltInDataTypes.XS_TOKEN, new Facet[]{FacetType.WHITESPACE.of("collapse")}));
        this.register(xsToken.derive(BuiltInDataTypes.XS_NAME, new Facet[]{FacetType.PATTERN.of("[\\p{L}_][\\p{L}\\d_\\-\\.:]*")}));
        this.register(xsToken.derive(BuiltInDataTypes.XS_NCNAME, new Facet[]{FacetType.PATTERN.of("[\\p{L}_][\\p{L}\\d_\\-\\.]*")}));
        this.register(new QNameHandler(BuiltInDataTypes.XS_QNAME));
        Handler xsInteger = (Handler)this.register(new IntegerHandler(BuiltInDataTypes.XS_INTEGER));
        this.register(xsInteger.derive(BuiltInDataTypes.XS_NON_NEGATIVE_INTEGER, new Facet[]{FacetType.MIN_INCLUSIVE.of("0")}));
        this.register(xsInteger.derive(BuiltInDataTypes.XS_NON_POSITIVE_INTEGER, new Facet[]{FacetType.MAX_INCLUSIVE.of("0")}));
        this.register(xsInteger.derive(BuiltInDataTypes.XS_POSITIVE_INTEGER, new Facet[]{FacetType.MIN_EXCLUSIVE.of("0")}));
        this.register(xsInteger.derive(BuiltInDataTypes.XS_NEGATIVE_INTEGER, new Facet[]{FacetType.MAX_EXCLUSIVE.of("0")}));
        this.register(new IntHandler(BuiltInDataTypes.XS_INT));
        this.register(new LongHandler(BuiltInDataTypes.XS_LONG));
        this.register(new ShortHandler(BuiltInDataTypes.XS_SHORT));
        this.register(new ByteHandler(BuiltInDataTypes.XS_BYTE));
        this.register(new DoubleHandler(BuiltInDataTypes.XS_DOUBLE));
        this.register(new FloatHandler(BuiltInDataTypes.XS_FLOAT));
        this.register(new DecimalHandler(BuiltInDataTypes.XS_DECIMAL));
        this.register(new BooleanHandler(BuiltInDataTypes.XS_BOOLEAN));
        this.register(new DateHandler(BuiltInDataTypes.XS_DATE));
        this.register(new DateTimeHandler(BuiltInDataTypes.XS_DATE_TIME));
    }

    private <T> SimpleTypeHandler<T> register(SimpleTypeHandler<T> handler) {
        this.definedTypes.put((Object)handler.getName(), handler);
        return handler;
    }

    private class UnionHandler<T>
    implements SimpleTypeHandler<T> {
        private final QName name;
        private final List<Handler<T>> memberHandlers;

        private UnionHandler(QName name, List<Handler<T>> memberHandlers) {
            this.name = name;
            this.memberHandlers = memberHandlers;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public T parse(String text) {
            for (SimpleTypeHandler simpleTypeHandler : this.memberHandlers) {
                try {
                    return simpleTypeHandler.parse(text);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            throw new IllegalArgumentException("");
        }

        @Override
        public String toText(T value) {
            for (SimpleTypeHandler simpleTypeHandler : this.memberHandlers) {
                try {
                    return simpleTypeHandler.toText(value);
                }
                catch (Exception exception) {
                }
            }
            return value.toString();
        }

        @Override
        public SimpleTypeHandler<T> derive(QName derivativeName, Facet ... facets) {
            throw new UnsupportedOperationException("Derivation from union types is not supported");
        }

        @Override
        public SimpleTypeHandler<T> derive(QName derivativeName, List<Facet> facets) {
            throw new UnsupportedOperationException("Derivation from union types is not supported");
        }
    }

    private class ListHandler<T>
    implements SimpleTypeHandler<List<T>> {
        private final QName name;
        private final Handler<T> itemHandler;
        private final SimpleTypeHandler<String> xsToken;

        private ListHandler(QName name, Handler<T> itemHandler) {
            this.xsToken = SimpleTypesContext.this.handler(BuiltInDataTypes.XS_TOKEN);
            this.name = name;
            this.itemHandler = itemHandler;
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public List<T> parse(String text) {
            if (text == null) {
                return Collections.emptyList();
            }
            String cleaned = this.xsToken.parse(text);
            return Arrays.stream(cleaned.split(" ")).map(this.itemHandler::parse).collect(Collectors.toList());
        }

        @Override
        public String toText(List<T> value) {
            return value.stream().map(this.itemHandler::toText).collect(Collectors.joining(" "));
        }

        @Override
        public SimpleTypeHandler<List<T>> derive(QName derivativeName, Facet ... facets) {
            throw new UnsupportedOperationException("Derivation from list types is not supported");
        }

        @Override
        public SimpleTypeHandler<List<T>> derive(QName derivativeName, List<Facet> facets) {
            throw new UnsupportedOperationException("Derivation from list types is not supported");
        }
    }

    private class DateTimeHandler
    extends Handler<Temporal> {
        private final Pattern WITH_TIMEZONE;
        private final Pattern WITHOUT_TIMEZONE;

        private DateTimeHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
            this.WITH_TIMEZONE = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[+-]\\d{2}:?\\d{2})");
            this.WITHOUT_TIMEZONE = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?");
        }

        @Override
        protected Temporal doParse(String text) {
            try {
                if (this.WITH_TIMEZONE.matcher(text).matches()) {
                    return Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(text));
                }
                if (this.WITHOUT_TIMEZONE.matcher(text).matches()) {
                    return LocalDateTime.parse(text).atZone(SimpleTypesContext.this.defaultTimezone).toInstant();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.error(text);
        }

        @Override
        public String toText(Temporal value) {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(SimpleTypesContext.this.defaultTimezone).format(value);
        }

        @Override
        void checkMinAndMaxValues(Temporal value) {
            this.checkParsedValue(v -> this.minInclusive == null || this.compare(value, (Temporal)this.minInclusive) >= 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || this.compare(value, (Temporal)this.minExclusive) > 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || this.compare(value, (Temporal)this.maxInclusive) <= 0, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || this.compare(value, (Temporal)this.maxExclusive) < 0, value, () -> "above maximum");
        }

        private int compare(Temporal left, Temporal right) {
            Instant l = (Instant)left;
            Instant r = (Instant)right;
            return l.compareTo(r);
        }

        @Override
        public Handler<Temporal> derive(QName deriviativeName, List<Facet> facets) {
            DateHandler result = new DateHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class DateHandler
    extends Handler<Temporal> {
        private final Pattern WITH_TIMEZONE;
        private final Pattern WITHOUT_TIMEZONE;
        private final DateTimeFormatter ZONED_DATE_FORMAT;

        private DateHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
            this.WITH_TIMEZONE = Pattern.compile("\\d{4}-\\d{2}-\\d{2}(Z|\\+\\d{2}:?\\d{2})");
            this.WITHOUT_TIMEZONE = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");
            this.ZONED_DATE_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_OFFSET_DATE).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.NANO_OF_SECOND, 0L).toFormatter();
        }

        @Override
        protected Temporal doParse(String text) {
            try {
                if (this.WITH_TIMEZONE.matcher(text).matches()) {
                    return ZonedDateTime.parse(text, this.ZONED_DATE_FORMAT);
                }
                if (this.WITHOUT_TIMEZONE.matcher(text).matches()) {
                    return LocalDate.parse(text);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.error(text);
        }

        @Override
        public String toText(Temporal value) {
            return value instanceof LocalDate ? DateTimeFormatter.ISO_DATE.format(value) : DateTimeFormatter.ISO_OFFSET_DATE.format(value);
        }

        @Override
        void checkMinAndMaxValues(Temporal value) {
            this.checkParsedValue(v -> this.minInclusive == null || this.compare(value, (Temporal)this.minInclusive) >= 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || this.compare(value, (Temporal)this.minExclusive) > 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || this.compare(value, (Temporal)this.maxInclusive) <= 0, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || this.compare(value, (Temporal)this.maxExclusive) < 0, value, () -> "above maximum");
        }

        private int compare(Temporal left, Temporal right) {
            Instant l = left instanceof LocalDate ? ((LocalDate)left).atStartOfDay(SimpleTypesContext.this.defaultTimezone).toInstant() : ((ZonedDateTime)left).toInstant();
            Instant r = right instanceof LocalDate ? ((LocalDate)right).atStartOfDay(SimpleTypesContext.this.defaultTimezone).toInstant() : ((ZonedDateTime)right).toInstant();
            return l.compareTo(r);
        }

        @Override
        public Handler<Temporal> derive(QName deriviativeName, List<Facet> facets) {
            DateHandler result = new DateHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class DecimalHandler
    extends Handler<BigDecimal>
    implements DoubleSimpleTypeHandler {
        private final Pattern DECIMAL_PATTERN;
        private Double minInclusiveDouble;
        private Double minExclusiveDouble;
        private Double maxInclusiveDouble;
        private Double maxExclusiveDouble;

        private DecimalHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
            this.DECIMAL_PATTERN = Pattern.compile("[+-]?\\d*(\\.\\d*)?");
        }

        @Override
        protected BigDecimal doParse(String text) {
            if (!this.DECIMAL_PATTERN.matcher(text).matches()) {
                throw this.error(text);
            }
            return new BigDecimal(text).stripTrailingZeros();
        }

        @Override
        public double parseDouble(String text) {
            double parsed;
            String whiteSpaceProcessed = this.doPreParse(text);
            if (!this.DECIMAL_PATTERN.matcher(whiteSpaceProcessed).matches()) {
                throw this.error(whiteSpaceProcessed);
            }
            try {
                parsed = Double.parseDouble(whiteSpaceProcessed);
            }
            catch (Exception e) {
                throw this.error(whiteSpaceProcessed, () -> "(possibly range restricted due to modelling as PURE Float)");
            }
            if (this.enumerations != null) {
                this.checkEnumerations(BigDecimal.valueOf(parsed));
            }
            if (this.minInclusiveDouble != null && parsed < this.minInclusiveDouble) {
                throw this.error(whiteSpaceProcessed, () -> "below minimum");
            }
            if (this.minExclusiveDouble != null && parsed <= this.minExclusiveDouble) {
                throw this.error(whiteSpaceProcessed, () -> "below minimum");
            }
            if (this.maxInclusiveDouble != null && parsed > this.maxInclusiveDouble) {
                throw this.error(whiteSpaceProcessed, () -> "above maximum");
            }
            if (this.maxExclusiveDouble != null && parsed >= this.maxExclusiveDouble) {
                throw this.error(whiteSpaceProcessed, () -> "above maximum");
            }
            return parsed;
        }

        @Override
        void addFacet(Facet facet) {
            super.addFacet(facet);
            if (facet.getType() == FacetType.MIN_INCLUSIVE) {
                if (((BigDecimal)this.minInclusive).compareTo(BIG_DECIMAL_DOUBLE_MIN) < 0) {
                    this.minInclusiveDouble = null;
                    this.minExclusiveDouble = null;
                } else if (((BigDecimal)this.minInclusive).compareTo(BIG_DECIMAL_DOUBLE_MAX) > 0) {
                    this.minInclusiveDouble = null;
                    this.minExclusiveDouble = Double.MAX_VALUE;
                } else {
                    this.minInclusiveDouble = ((BigDecimal)this.minInclusive).doubleValue();
                    this.minExclusiveDouble = null;
                }
            } else if (facet.getType() == FacetType.MIN_EXCLUSIVE) {
                if (((BigDecimal)this.minExclusive).compareTo(BIG_DECIMAL_DOUBLE_MIN) < 0) {
                    this.minInclusiveDouble = null;
                    this.minExclusiveDouble = null;
                } else if (((BigDecimal)this.minExclusive).compareTo(BIG_DECIMAL_DOUBLE_MAX) > 0) {
                    this.minInclusiveDouble = null;
                    this.minExclusiveDouble = Double.MAX_VALUE;
                } else {
                    this.minInclusiveDouble = null;
                    this.minExclusiveDouble = ((BigDecimal)this.minExclusive).doubleValue();
                }
            } else if (facet.getType() == FacetType.MAX_INCLUSIVE) {
                if (((BigDecimal)this.maxInclusive).compareTo(BIG_DECIMAL_DOUBLE_MIN) < 0) {
                    this.maxInclusiveDouble = null;
                    this.maxExclusiveDouble = Double.MIN_VALUE;
                } else if (((BigDecimal)this.maxInclusive).compareTo(BIG_DECIMAL_DOUBLE_MAX) > 0) {
                    this.maxInclusiveDouble = null;
                    this.maxExclusiveDouble = null;
                } else {
                    this.maxInclusiveDouble = ((BigDecimal)this.maxInclusive).doubleValue();
                    this.maxExclusiveDouble = null;
                }
            } else if (facet.getType() == FacetType.MAX_EXCLUSIVE) {
                if (((BigDecimal)this.maxExclusive).compareTo(BIG_DECIMAL_DOUBLE_MIN) < 0) {
                    this.maxInclusiveDouble = null;
                    this.maxExclusiveDouble = Double.MIN_VALUE;
                } else if (((BigDecimal)this.maxExclusive).compareTo(BIG_DECIMAL_DOUBLE_MAX) > 0) {
                    this.maxInclusiveDouble = null;
                    this.maxExclusiveDouble = null;
                } else {
                    this.maxInclusiveDouble = null;
                    this.maxExclusiveDouble = ((BigDecimal)this.maxExclusive).doubleValue();
                }
            }
        }

        @Override
        public String toText(BigDecimal value) {
            return value.toString();
        }

        @Override
        public String toText(double value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(BigDecimal value) {
            this.checkParsedValue(v -> this.minInclusive == null || value.compareTo((BigDecimal)this.minInclusive) >= 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value.compareTo((BigDecimal)this.minExclusive) > 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value.compareTo((BigDecimal)this.maxInclusive) <= 0, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value.compareTo((BigDecimal)this.maxExclusive) < 0, value, () -> "above maximum");
        }

        @Override
        public Handler<BigDecimal> derive(QName deriviativeName, List<Facet> facets) {
            DecimalHandler result = new DecimalHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class IntegerHandler
    extends Handler<BigDecimal>
    implements LongSimpleTypeHandler {
        private final Pattern INTEGER_PATTERN;
        private Long minInclusiveLong;
        private Long minExclusiveLong;
        private Long maxInclusiveLong;
        private Long maxExclusiveLong;

        private IntegerHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
            this.INTEGER_PATTERN = Pattern.compile("[+-]?\\d*");
        }

        @Override
        protected BigDecimal doParse(String text) {
            if (!this.INTEGER_PATTERN.matcher(text).matches()) {
                throw this.error(text);
            }
            return new BigDecimal(text);
        }

        @Override
        public long parseLong(String text) {
            long parsed;
            String whiteSpaceProcessed = this.doPreParse(text);
            if (!this.INTEGER_PATTERN.matcher(whiteSpaceProcessed).matches()) {
                throw this.error(whiteSpaceProcessed);
            }
            try {
                parsed = Long.parseLong(whiteSpaceProcessed);
            }
            catch (Exception e) {
                throw this.error(whiteSpaceProcessed, () -> "(possibly range restricted due to modelling as PURE Integer)");
            }
            if (this.enumerations != null) {
                this.checkEnumerations(new BigDecimal(parsed));
            }
            if (this.minInclusiveLong != null && parsed < this.minInclusiveLong) {
                throw this.error(whiteSpaceProcessed, () -> "below minimum");
            }
            if (this.minExclusiveLong != null && parsed <= this.minExclusiveLong) {
                throw this.error(whiteSpaceProcessed, () -> "below minimum");
            }
            if (this.maxInclusiveLong != null && parsed > this.maxInclusiveLong) {
                throw this.error(whiteSpaceProcessed, () -> "above maximum");
            }
            if (this.maxExclusiveLong != null && parsed >= this.maxExclusiveLong) {
                throw this.error(whiteSpaceProcessed, () -> "above maximum");
            }
            return parsed;
        }

        @Override
        void addFacet(Facet facet) {
            super.addFacet(facet);
            if (facet.getType() == FacetType.MIN_INCLUSIVE) {
                if (((BigDecimal)this.minInclusive).compareTo(new BigDecimal(Long.MIN_VALUE)) < 0) {
                    this.minInclusiveLong = null;
                    this.minExclusiveLong = null;
                } else if (((BigDecimal)this.minInclusive).compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.minInclusiveLong = null;
                    this.minExclusiveLong = Long.MAX_VALUE;
                } else {
                    this.minInclusiveLong = ((BigDecimal)this.minInclusive).longValue();
                    this.minExclusiveLong = null;
                }
            } else if (facet.getType() == FacetType.MIN_EXCLUSIVE) {
                if (((BigDecimal)this.minExclusive).compareTo(new BigDecimal(Long.MIN_VALUE)) < 0) {
                    this.minInclusiveLong = null;
                    this.minExclusiveLong = null;
                } else if (((BigDecimal)this.minExclusive).compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.minInclusiveLong = null;
                    this.minExclusiveLong = Long.MAX_VALUE;
                } else {
                    this.minInclusiveLong = null;
                    this.minExclusiveLong = ((BigDecimal)this.minExclusive).longValue();
                }
            } else if (facet.getType() == FacetType.MAX_INCLUSIVE) {
                if (((BigDecimal)this.maxInclusive).compareTo(new BigDecimal(Long.MIN_VALUE)) < 0) {
                    this.maxInclusiveLong = null;
                    this.maxExclusiveLong = Long.MIN_VALUE;
                } else if (((BigDecimal)this.maxInclusive).compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.maxInclusiveLong = null;
                    this.maxExclusiveLong = null;
                } else {
                    this.maxInclusiveLong = ((BigDecimal)this.maxInclusive).longValue();
                    this.maxExclusiveLong = null;
                }
            } else if (facet.getType() == FacetType.MAX_EXCLUSIVE) {
                if (((BigDecimal)this.maxExclusive).compareTo(new BigDecimal(Long.MIN_VALUE)) < 0) {
                    this.maxInclusiveLong = null;
                    this.maxExclusiveLong = Long.MIN_VALUE;
                } else if (((BigDecimal)this.maxExclusive).compareTo(new BigDecimal(Long.MAX_VALUE)) > 0) {
                    this.maxInclusiveLong = null;
                    this.maxExclusiveLong = null;
                } else {
                    this.maxInclusiveLong = null;
                    this.maxExclusiveLong = ((BigDecimal)this.maxExclusive).longValue();
                }
            }
        }

        @Override
        public String toText(BigDecimal value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(long value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(BigDecimal value) {
            this.checkParsedValue(v -> this.minInclusive == null || value.compareTo((BigDecimal)this.minInclusive) >= 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value.compareTo((BigDecimal)this.minExclusive) > 0, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value.compareTo((BigDecimal)this.maxInclusive) <= 0, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value.compareTo((BigDecimal)this.maxExclusive) < 0, value, () -> "above maximum");
        }

        @Override
        public Handler<BigDecimal> derive(QName deriviativeName, List<Facet> facets) {
            IntegerHandler result = new IntegerHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class FloatHandler
    extends Handler<Float>
    implements DoubleSimpleTypeHandler {
        private FloatHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Float doParse(String text) {
            return Float.valueOf((float)this.doParseDouble(text));
        }

        @Override
        public double parseDouble(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            double parsed = this.doParseDouble(whiteSpaceProcessed);
            if (this.enumerations != null) {
                this.checkEnumerations(Float.valueOf((float)parsed));
            }
            if (this.minInclusive != null || this.minExclusive != null || this.maxInclusive != null || this.maxExclusive != null) {
                this.checkMinAndMaxValues(Float.valueOf((float)parsed));
            }
            return parsed;
        }

        private double doParseDouble(String text) {
            try {
                return Float.parseFloat(text);
            }
            catch (Exception e) {
                throw this.error(text);
            }
        }

        @Override
        public String toText(Float value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(double value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Float value) {
            this.checkParsedValue(v -> this.minInclusive == null || value.floatValue() >= ((Float)this.minInclusive).floatValue(), value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value.floatValue() > ((Float)this.minExclusive).floatValue(), value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value.floatValue() <= ((Float)this.maxInclusive).floatValue(), value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value.floatValue() < ((Float)this.maxExclusive).floatValue(), value, () -> "above maximum");
        }

        @Override
        public Handler<Float> derive(QName deriviativeName, List<Facet> facets) {
            FloatHandler result = new FloatHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class DoubleHandler
    extends Handler<Double>
    implements DoubleSimpleTypeHandler {
        private DoubleHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Double doParse(String text) {
            return this.doParseDouble(text);
        }

        @Override
        public double parseDouble(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            double parsed = this.doParseDouble(whiteSpaceProcessed);
            this.checkEnumerations(parsed);
            if (this.minInclusive != null || this.minExclusive != null || this.maxInclusive != null || this.maxExclusive != null) {
                this.checkMinAndMaxValues(parsed);
            }
            return parsed;
        }

        private double doParseDouble(String text) {
            try {
                return Double.parseDouble(text);
            }
            catch (Exception e) {
                throw this.error(text);
            }
        }

        @Override
        public String toText(Double value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(double value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Double value) {
            this.checkParsedValue(v -> this.minInclusive == null || value >= (double)((Double)this.minInclusive).longValue(), value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value > (double)((Double)this.minExclusive).longValue(), value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value <= (double)((Double)this.maxInclusive).longValue(), value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value < (double)((Double)this.maxExclusive).longValue(), value, () -> "above maximum");
        }

        @Override
        public Handler<Double> derive(QName deriviativeName, List<Facet> facets) {
            DoubleHandler result = new DoubleHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class ByteHandler
    extends Handler<Byte>
    implements LongSimpleTypeHandler {
        private ByteHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Byte doParse(String text) {
            return (byte)this.doParseLong(text);
        }

        @Override
        public long parseLong(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            long parsed = this.doParseLong(whiteSpaceProcessed);
            if (this.enumerations != null) {
                this.checkEnumerations((byte)parsed);
            }
            if (this.minInclusive != null || this.minExclusive != null || this.maxInclusive != null || this.maxExclusive != null) {
                this.checkMinAndMaxValues((byte)parsed);
            }
            return parsed;
        }

        private long doParseLong(String text) {
            try {
                return Byte.parseByte(text);
            }
            catch (Exception e) {
                throw this.error(text);
            }
        }

        @Override
        public String toText(Byte value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(long value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Byte value) {
            this.checkParsedValue(v -> this.minInclusive == null || value >= (Byte)this.minInclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value > (Byte)this.minExclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value <= (Byte)this.maxInclusive, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value < (Byte)this.maxExclusive, value, () -> "above maximum");
        }

        @Override
        public Handler<Byte> derive(QName deriviativeName, List<Facet> facets) {
            ByteHandler result = new ByteHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class ShortHandler
    extends Handler<Short>
    implements LongSimpleTypeHandler {
        private ShortHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Short doParse(String text) {
            return (short)this.doParseLong(text);
        }

        @Override
        public long parseLong(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            long parsed = this.doParseLong(whiteSpaceProcessed);
            if (this.enumerations != null) {
                this.checkEnumerations((short)parsed);
            }
            if (this.minInclusive != null || this.minExclusive != null || this.maxInclusive != null || this.maxExclusive != null) {
                this.checkMinAndMaxValues((short)parsed);
            }
            return parsed;
        }

        private long doParseLong(String text) {
            try {
                return Short.parseShort(text);
            }
            catch (Exception e) {
                throw this.error(text);
            }
        }

        @Override
        public String toText(Short value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(long value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Short value) {
            this.checkParsedValue(v -> this.minInclusive == null || value >= (Short)this.minInclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value > (Short)this.minExclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value <= (Short)this.maxInclusive, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value < (Short)this.maxExclusive, value, () -> "above maximum");
        }

        @Override
        public Handler<Short> derive(QName deriviativeName, List<Facet> facets) {
            ShortHandler result = new ShortHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class IntHandler
    extends Handler<Integer>
    implements LongSimpleTypeHandler {
        private IntHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Integer doParse(String text) {
            return (int)this.doParseLong(text);
        }

        @Override
        public long parseLong(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            long parsed = this.doParseLong(whiteSpaceProcessed);
            if (this.enumerations != null) {
                this.checkEnumerations((int)parsed);
            }
            if (this.minInclusive != null || this.minExclusive != null || this.maxInclusive != null || this.maxExclusive != null) {
                this.checkMinAndMaxValues((int)parsed);
            }
            return parsed;
        }

        private long doParseLong(String text) {
            try {
                return Integer.parseInt(text);
            }
            catch (Exception e) {
                throw this.error(text);
            }
        }

        @Override
        public String toText(Integer value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(long value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Integer value) {
            this.checkParsedValue(v -> this.minInclusive == null || value >= (Integer)this.minInclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value > (Integer)this.minExclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value <= (Integer)this.maxInclusive, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value < (Integer)this.maxExclusive, value, () -> "above maximum");
        }

        @Override
        public Handler<Integer> derive(QName deriviativeName, List<Facet> facets) {
            IntHandler result = new IntHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class LongHandler
    extends Handler<Long>
    implements LongSimpleTypeHandler {
        private LongHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Long doParse(String text) {
            return this.doParseLong(text);
        }

        @Override
        public long parseLong(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            long parsed = this.doParseLong(whiteSpaceProcessed);
            this.checkEnumerations(parsed);
            if (this.minInclusive != null || this.minExclusive != null || this.maxInclusive != null || this.maxExclusive != null) {
                this.checkMinAndMaxValues(parsed);
            }
            return parsed;
        }

        private long doParseLong(String text) {
            try {
                return Long.parseLong(text);
            }
            catch (Exception e) {
                throw this.error(text);
            }
        }

        @Override
        public String toText(Long value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(long value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Long value) {
            this.checkParsedValue(v -> this.minInclusive == null || value >= (Long)this.minInclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.minExclusive == null || value > (Long)this.minExclusive, value, () -> "below minimum");
            this.checkParsedValue(v -> this.maxInclusive == null || value <= (Long)this.maxInclusive, value, () -> "above maximum");
            this.checkParsedValue(v -> this.maxExclusive == null || value < (Long)this.maxExclusive, value, () -> "above maximum");
        }

        @Override
        public Handler<Long> derive(QName deriviativeName, List<Facet> facets) {
            LongHandler result = new LongHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class BooleanHandler
    extends Handler<Boolean>
    implements BooleanSimpleTypeHandler {
        private BooleanHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
        }

        @Override
        protected Boolean doParse(String text) {
            return this.doParseBoolean(text);
        }

        @Override
        public boolean parseBoolean(String text) {
            String whiteSpaceProcessed = this.doPreParse(text);
            boolean parsed = this.doParseBoolean(whiteSpaceProcessed);
            this.checkEnumerations(parsed);
            return parsed;
        }

        private boolean doParseBoolean(String text) {
            if (text.equals("true") || text.equals("1")) {
                return true;
            }
            if (text.equals("false") || text.equals("0")) {
                return false;
            }
            throw this.error(text);
        }

        @Override
        public String toText(Boolean value) {
            return String.valueOf(value);
        }

        @Override
        public String toText(boolean value) {
            return String.valueOf(value);
        }

        @Override
        void checkMinAndMaxValues(Boolean value) {
        }

        @Override
        public Handler<Boolean> derive(QName deriviativeName, List<Facet> facets) {
            BooleanHandler result = new BooleanHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class QNameHandler
    extends Handler<QName> {
        private SimpleTypeHandler<String> ncNameHandler;

        private QNameHandler(QName name) {
            super(name, XsdWhiteSpaceType.REPLACE);
            this.ncNameHandler = SimpleTypesContext.this.handler(BuiltInDataTypes.XS_NCNAME).derive(name, new Facet[0]);
        }

        @Override
        protected QName doParse(String text) {
            if (text.contains(":")) {
                String[] parts = text.split(":");
                if (parts.length != 2) {
                    throw this.error(text, () -> "should only contain one ':");
                }
                String prefix = this.ncNameHandler.parse(parts[0]);
                String localPart = this.ncNameHandler.parse(parts[1]);
                String uri = ((NamespaceContext)SimpleTypesContext.this.namespacesSupplier.get()).getNamespaceURI(prefix);
                if (uri == null || uri.equals("")) {
                    throw this.error(text, () -> "Prefix " + prefix + " unknown");
                }
                return new QName(uri, localPart, prefix);
            }
            String localPart = this.ncNameHandler.parse(text);
            String uri = ((NamespaceContext)SimpleTypesContext.this.namespacesSupplier.get()).getNamespaceURI("");
            return new QName(uri, localPart);
        }

        @Override
        public String toText(QName value) {
            String prefix = ((NamespaceContext)SimpleTypesContext.this.namespacesSupplier.get()).getPrefix(value.getNamespaceURI());
            return (prefix.isEmpty() ? "" : prefix + ":") + value.getLocalPart();
        }

        @Override
        void checkMinAndMaxValues(QName value) {
        }

        @Override
        public Handler<QName> derive(QName deriviativeName, List<Facet> facets) {
            QNameHandler result = new QNameHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private class StringHandler
    extends Handler<String> {
        private StringHandler(QName name) {
            super(name, XsdWhiteSpaceType.PRESERVE);
        }

        @Override
        protected String doParse(String text) {
            return text;
        }

        @Override
        public String toText(String value) {
            return value;
        }

        @Override
        void checkMinAndMaxValues(String value) {
        }

        @Override
        public Handler<String> derive(QName deriviativeName, List<Facet> facets) {
            StringHandler result = new StringHandler(deriviativeName);
            this.facets.forEach(result::addFacet);
            facets.forEach(result::addFacet);
            return result;
        }
    }

    private abstract class Handler<T>
    implements SimpleTypeHandler<T> {
        private final QName name;
        XsdWhiteSpaceType whiteSpaceType;
        final List<Facet> facets = Lists.mutable.empty();
        Set<T> enumerations;
        private List<Pattern> patterns;
        private Long length;
        private Long minLength;
        private Long maxLength;
        T minInclusive;
        T minExclusive;
        T maxInclusive;
        T maxExclusive;
        private Long totalDigits;
        private Long fractionDigits;

        private Handler(QName name) {
            this(name, XsdWhiteSpaceType.PRESERVE);
        }

        private Handler(QName name, XsdWhiteSpaceType whiteSpaceType) {
            this.name = name;
            this.whiteSpaceType = whiteSpaceType;
        }

        private Handler(QName name, Handler<T> base, List<Facet> facets) {
            this.whiteSpaceType = base.whiteSpaceType;
            this.name = name;
            base.facets.forEach(this::addFacet);
            facets.forEach(this::addFacet);
        }

        @Override
        public Handler<T> derive(QName deriviativeName, Facet ... facets) {
            return this.derive(deriviativeName, (List)Arrays.asList(facets));
        }

        @Override
        public abstract Handler<T> derive(QName var1, List<Facet> var2);

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public T parse(String text) {
            if (text == null) {
                return null;
            }
            String whiteSpaceProcessed = this.doPreParse(text);
            T parsed = this.doParse(whiteSpaceProcessed);
            this.checkEnumerations(parsed);
            this.checkMinAndMaxValues(parsed);
            return parsed;
        }

        protected String doPreParse(String text) {
            String whiteSpaceProcessed = text;
            if (this.whiteSpaceType != XsdWhiteSpaceType.PRESERVE) {
                whiteSpaceProcessed = whiteSpaceProcessed.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
            }
            if (this.whiteSpaceType == XsdWhiteSpaceType.COLLAPSE) {
                whiteSpaceProcessed = whiteSpaceProcessed.trim().replaceAll(" +", " ");
            }
            this.checkLength(whiteSpaceProcessed);
            this.checkPattern(whiteSpaceProcessed);
            this.checkDigits(whiteSpaceProcessed);
            return whiteSpaceProcessed;
        }

        abstract T doParse(String var1);

        void addFacet(Facet facet) {
            this.facets.add(facet);
            if (facet.getType() == FacetType.WHITESPACE) {
                this.whiteSpaceType = XsdWhiteSpaceType.valueOf(facet.getValue().toUpperCase());
                if (this.whiteSpaceType.ordinal() < this.whiteSpaceType.ordinal()) {
                    throw new IllegalArgumentException("Whitespace behaviour cannot be relaxed");
                }
            } else if (facet.getType() == FacetType.ENUMERATION) {
                if (this.enumerations == null) {
                    this.enumerations = new LinkedHashSet<T>();
                }
                try {
                    this.enumerations.add(this.doParse(facet.getValue()));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid value specified for enumeration: '" + facet.getValue() + "'");
                }
            } else if (facet.getType() == FacetType.PATTERN) {
                if (this.patterns == null) {
                    this.patterns = new ArrayList<Pattern>();
                }
                this.patterns.add(Pattern.compile(facet.getValue()));
            } else if (facet.getType() == FacetType.LENGTH) {
                this.length = Long.parseLong(facet.getValue());
            } else if (facet.getType() == FacetType.MIN_LENGTH) {
                this.minLength = Long.parseLong(facet.getValue());
            } else if (facet.getType() == FacetType.MAX_LENGTH) {
                this.maxLength = Long.parseLong(facet.getValue());
            } else if (facet.getType() == FacetType.MIN_INCLUSIVE) {
                T min = this.doParse(facet.getValue());
                if (this.minInclusive != null || this.minExclusive != null) {
                    throw new IllegalArgumentException("Minimum value cannot be changed");
                }
                this.minInclusive = min;
            } else if (facet.getType() == FacetType.MIN_EXCLUSIVE) {
                T min = this.doParse(facet.getValue());
                if (this.minInclusive != null || this.minExclusive != null) {
                    throw new IllegalArgumentException("Minimum value cannot be changed");
                }
                this.minExclusive = min;
            } else if (facet.getType() == FacetType.MAX_INCLUSIVE) {
                T max = this.doParse(facet.getValue());
                if (this.maxInclusive != null || this.maxExclusive != null) {
                    throw new IllegalArgumentException("Maximum value cannot be changed");
                }
                this.maxInclusive = max;
            } else if (facet.getType() == FacetType.MAX_EXCLUSIVE) {
                T max = this.doParse(facet.getValue());
                if (this.maxInclusive != null || this.maxExclusive != null) {
                    throw new IllegalArgumentException("Maximum value cannot be changed");
                }
                this.maxExclusive = max;
            } else if (facet.getType() == FacetType.TOTAL_DIGITS) {
                this.totalDigits = Long.parseLong(facet.getValue());
            } else if (facet.getType() == FacetType.FRACTION_DIGITS) {
                this.fractionDigits = Long.parseLong(facet.getValue());
            }
        }

        private void checkPattern(String text) {
            this.checkTextValue(t -> this.patterns == null || this.patterns.stream().allMatch(p -> p.matcher((CharSequence)t).matches()), text, () -> "does not match expected pattern");
        }

        void checkEnumerations(T value) {
            if (this.enumerations != null) {
                this.checkParsedValue(v -> this.enumerations.contains(v), value, () -> "expected one of: " + this.enumerations.stream().map(Object::toString).collect(Collectors.joining(",")));
            }
        }

        private void checkLength(String text) {
            this.checkTextValue(t -> this.length == null || (long)t.length() == this.length, text, () -> "expected exactly " + this.length + " characters");
            this.checkTextValue(t -> this.minLength == null || this.maxLength == null || (long)t.length() >= this.minLength && (long)t.length() <= this.maxLength, text, () -> "expected minimum of " + this.minLength + " characters and maximum of " + this.maxLength);
            this.checkTextValue(t -> this.minLength == null || (long)t.length() >= this.minLength, text, () -> "expected minimum of " + this.minLength + " characters");
            this.checkTextValue(t -> this.maxLength == null || (long)t.length() <= this.maxLength, text, () -> "expected maximum of " + this.maxLength + " characters");
        }

        private void checkDigits(String text) {
            if (this.totalDigits != null || this.fractionDigits != null) {
                int digits = 0;
                int fractional = 0;
                boolean decimalPointSeen = false;
                for (char ch : text.toCharArray()) {
                    if (ch == '.') {
                        decimalPointSeen = true;
                        continue;
                    }
                    if (!Character.isDigit(ch)) continue;
                    ++digits;
                    if (!decimalPointSeen) continue;
                    ++fractional;
                }
                if (this.totalDigits != null && (long)digits > this.totalDigits) {
                    throw this.error(text, () -> "more than " + this.totalDigits + " total digits");
                }
                if (this.fractionDigits != null && (long)fractional > this.fractionDigits) {
                    throw this.error(text, () -> "more than " + this.fractionDigits + " fraction digits");
                }
            }
        }

        abstract void checkMinAndMaxValues(T var1);

        private void checkTextValue(Predicate<String> predicate, String value, Supplier<String> extraMessage) {
            if (!predicate.test(value)) {
                throw this.error(value, extraMessage);
            }
        }

        void checkParsedValue(Predicate<T> predicate, T value, Supplier<String> extraMessage) {
            if (!predicate.test(value)) {
                throw this.error(this.toText(value), extraMessage);
            }
        }

        protected IllegalArgumentException error(String value) {
            return new IllegalArgumentException("Invalid " + this.typeName() + " value: '" + value + "'");
        }

        protected IllegalArgumentException error(String value, Supplier<String> extraMessage) {
            String extra = extraMessage.get();
            return new IllegalArgumentException("Invalid " + this.typeName() + " value: '" + value + "'" + (extra.isEmpty() ? "" : ", " + extra));
        }

        private String typeName() {
            return this.name.getLocalPart();
        }
    }
}

