/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.custom.ProductChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ProductChoiceChoice")
@ImplementedBy(value=Default.class)
public interface ProductChoiceChoice
extends Validator<ProductChoice> {
    public static final String NAME = "ProductChoiceChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements ProductChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProductChoice productChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ProductChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProductChoice productChoice) {
            ComparisonResult result = this.executeDataRule(productChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ProductChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductChoice", (RosettaPath)path, (String)ProductChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == ProductChoiceChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ProductChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductChoice", (RosettaPath)path, (String)ProductChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ProductChoice productChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)productChoice), Arrays.asList("Swaption", "FxVolatilitySwap", "FxVarianceSwap", "Swap", "VolatilitySwapTransactionSupplement", "DividendSwapTransactionSupplement", "GenericProduct", "EquityOptionTransactionSupplement", "BrokerEquityOption", "EquityForward", "EquityOption", "Fra", "BondOption", "CreditDefaultSwapOption", "DividendSwapOptionTransactionSupplement", "VarianceOptionTransactionSupplement", "FxDigitalOption", "FxOption", "CommodityBasketOption", "CommodityDigitalOption", "VarianceSwapTransactionSupplement", "CommoditySwaption", "FxForwardVolatilityAgreement", "CorrelationSwap", "VolatilitySwap", "VarianceSwap", "CommodityForward", "CommoditySwap", "CreditDefaultSwap", "CapFloor", "CommodityOption", "CommodityPerformanceSwap", "FxSingleLeg", "FxSwap", "SecurityLending", "BulletPayment", "EquitySwapTransactionSupplement", "ReturnSwap"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

