/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.custom.ExerciseChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExerciseChoiceChoice")
@ImplementedBy(value=Default.class)
public interface ExerciseChoiceChoice
extends Validator<ExerciseChoice> {
    public static final String NAME = "ExerciseChoiceChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements ExerciseChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExerciseChoice exerciseChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExerciseChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExerciseChoice exerciseChoice) {
            ComparisonResult result = this.executeDataRule(exerciseChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExerciseChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExerciseChoice", (RosettaPath)path, (String)ExerciseChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == ExerciseChoiceChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExerciseChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExerciseChoice", (RosettaPath)path, (String)ExerciseChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExerciseChoice exerciseChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)exerciseChoice), Arrays.asList("EuropeanExercise", "CommodityPhysicalAmericanExercise", "CommodityAmericanExercise", "FxAmericanExercise", "FxDigitalAmericanExercise", "AmericanExercise", "BermudaExercise", "EquityEuropeanExercise", "CommodityPhysicalEuropeanExercise", "FxEuropeanExercise", "CommodityEuropeanExercise", "EquityBermudaExercise", "EquityAmericanExercise"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

