/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.custom.AssetChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetChoiceChoice")
@ImplementedBy(value=Default.class)
public interface AssetChoiceChoice
extends Validator<AssetChoice> {
    public static final String NAME = "AssetChoiceChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements AssetChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetChoice assetChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetChoice assetChoice) {
            ComparisonResult result = this.executeDataRule(assetChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetChoice", (RosettaPath)path, (String)AssetChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == AssetChoiceChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetChoice", (RosettaPath)path, (String)AssetChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetChoice assetChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)assetChoice), Arrays.asList("Cash", "TermLoan", "DelayedDraw", "Revolver", "LetterOfCreditFacility", "Deal", "SimpleIRSwap", "MutualFund", "RateIndex", "Deposit", "Fx", "Loan", "ConvertibleBond", "Bond", "SimpleFra", "Option", "Warrant", "ExchangeTradedContract", "Index", "ExchangeTradedFund", "Equity", "Future", "Mortgage", "SimpleCreditDefaultSwap", "Commodity", "Security", "Basket"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

