/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.asset.Asset;
import fpml.custom.AssetChoice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToAssetChoiceDefault.class)
public abstract class ToAssetChoice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public AssetChoice evaluate(Asset asset) {
        AssetChoice assetChoice;
        AssetChoice.AssetChoiceBuilder assetChoiceBuilder = this.doEvaluate(asset);
        if (assetChoiceBuilder == null) {
            assetChoice = null;
        } else {
            assetChoice = assetChoiceBuilder.build();
            this.objectValidator.validate(AssetChoice.class, (RosettaModelObject)assetChoice);
        }
        return assetChoice;
    }

    protected abstract AssetChoice.AssetChoiceBuilder doEvaluate(Asset var1);

    public static class ToAssetChoiceDefault
    extends ToAssetChoice {
        @Override
        protected AssetChoice.AssetChoiceBuilder doEvaluate(Asset asset) {
            AssetChoice.AssetChoiceBuilder assetChoice = AssetChoice.builder();
            return this.assignOutput(assetChoice, asset);
        }

        protected AssetChoice.AssetChoiceBuilder assignOutput(AssetChoice.AssetChoiceBuilder assetChoice, Asset asset) {
            return Optional.ofNullable(assetChoice).map(o -> o.prune()).orElse(null);
        }
    }
}

