/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.PGPDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PGPDataTypeChoice")
@ImplementedBy(value=Default.class)
public interface PGPDataTypeChoice
extends Validator<PGPDataType> {
    public static final String NAME = "PGPDataTypeChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements PGPDataTypeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PGPDataType pGPDataType) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PGPDataTypeChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PGPDataType pGPDataType) {
            ComparisonResult result = this.executeDataRule(pGPDataType);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PGPDataTypeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PGPDataType", (RosettaPath)path, (String)PGPDataTypeChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PGPDataTypeChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PGPDataType", (RosettaPath)path, (String)PGPDataTypeChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PGPDataType pGPDataType) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)pGPDataType), Arrays.asList("pgpDataTypeSequence0", "pgpDataTypeSequence1"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

