/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.SettlementRateSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SettlementRateSourceChoice")
@ImplementedBy(value=Default.class)
public interface SettlementRateSourceChoice
extends Validator<SettlementRateSource> {
    public static final String NAME = "SettlementRateSourceChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements SettlementRateSourceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementRateSource settlementRateSource) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SettlementRateSourceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementRateSource settlementRateSource) {
            ComparisonResult result = this.executeDataRule(settlementRateSource);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SettlementRateSourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementRateSource", (RosettaPath)path, (String)SettlementRateSourceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SettlementRateSourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementRateSource", (RosettaPath)path, (String)SettlementRateSourceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SettlementRateSource settlementRateSource) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)settlementRateSource), Arrays.asList("informationSource", "cashSettlementReferenceBanks"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

