/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.PersonSequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PersonSequenceChoice")
@ImplementedBy(value=Default.class)
public interface PersonSequenceChoice
extends Validator<PersonSequence> {
    public static final String NAME = "PersonSequenceChoice";
    public static final String DEFINITION = "optional choice middleName, initial";

    public static class NoOp
    implements PersonSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PersonSequence personSequence) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PersonSequenceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PersonSequence personSequence) {
            ComparisonResult result = this.executeDataRule(personSequence);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PersonSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PersonSequence", (RosettaPath)path, (String)PersonSequenceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PersonSequenceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PersonSequence", (RosettaPath)path, (String)PersonSequenceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PersonSequence personSequence) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)personSequence), Arrays.asList("middleName", "initial"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

