/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.MultipleExercise;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="MultipleExerciseChoice")
@ImplementedBy(value=Default.class)
public interface MultipleExerciseChoice
extends Validator<MultipleExercise> {
    public static final String NAME = "MultipleExerciseChoice";
    public static final String DEFINITION = "optional choice maximumNotionalAmount, maximumNumberOfOptions";

    public static class NoOp
    implements MultipleExerciseChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MultipleExercise multipleExercise) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements MultipleExerciseChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, MultipleExercise multipleExercise) {
            ComparisonResult result = this.executeDataRule(multipleExercise);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)MultipleExerciseChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MultipleExercise", (RosettaPath)path, (String)MultipleExerciseChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)MultipleExerciseChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"MultipleExercise", (RosettaPath)path, (String)MultipleExerciseChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(MultipleExercise multipleExercise) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)multipleExercise), Arrays.asList("maximumNotionalAmount", "maximumNumberOfOptions"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

