/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.IdentifiedPayerReceiver;
import fpml.consolidated.shared.Schedule;
import fpml.consolidated.shared.Step;
import fpml.consolidated.shared.meta.StrikeScheduleMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="StrikeSchedule", builder=StrikeScheduleBuilderImpl.class, version="1.1.0")
@RuneDataType(value="StrikeSchedule", model="fpml", builder=StrikeScheduleBuilderImpl.class, version="1.1.0")
public interface StrikeSchedule
extends Schedule {
    public static final StrikeScheduleMeta metaData = new StrikeScheduleMeta();

    public IdentifiedPayerReceiver getBuyer();

    public IdentifiedPayerReceiver getSeller();

    @Override
    public StrikeSchedule build();

    @Override
    public StrikeScheduleBuilder toBuilder();

    public static StrikeScheduleBuilder builder() {
        return new StrikeScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends StrikeSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StrikeSchedule> getType() {
        return StrikeSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("step"), processor, Step.class, this.getStep(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyer"), processor, IdentifiedPayerReceiver.class, this.getBuyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("seller"), processor, IdentifiedPayerReceiver.class, this.getSeller(), new AttributeMeta[0]);
    }

    public static class StrikeScheduleBuilderImpl
    extends Schedule.ScheduleBuilderImpl
    implements StrikeScheduleBuilder {
        protected IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder buyer;
        protected IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder seller;

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getBuyer() {
            return this.buyer;
        }

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateBuyer() {
            IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder result = this.buyer != null ? this.buyer : (this.buyer = IdentifiedPayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getSeller() {
            return this.seller;
        }

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateSeller() {
            IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder result = this.seller != null ? this.seller : (this.seller = IdentifiedPayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public StrikeScheduleBuilder setInitialValue(BigDecimal _initialValue) {
            this.initialValue = _initialValue == null ? null : _initialValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public StrikeScheduleBuilder addStep(Step _step) {
            if (_step != null) {
                this.step.add(_step.toBuilder());
            }
            return this;
        }

        @Override
        public StrikeScheduleBuilder addStep(Step _step, int idx) {
            this.getIndex(this.step, idx, () -> _step.toBuilder());
            return this;
        }

        @Override
        public StrikeScheduleBuilder addStep(List<? extends Step> steps) {
            if (steps != null) {
                for (Step step : steps) {
                    this.step.add(step.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="step")
        public StrikeScheduleBuilder setStep(List<? extends Step> steps) {
            this.step = steps == null ? new ArrayList() : (List)steps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public StrikeScheduleBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public StrikeScheduleBuilder setBuyer(IdentifiedPayerReceiver _buyer) {
            this.buyer = _buyer == null ? null : _buyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public StrikeScheduleBuilder setSeller(IdentifiedPayerReceiver _seller) {
            this.seller = _seller == null ? null : _seller.toBuilder();
            return this;
        }

        @Override
        public StrikeSchedule build() {
            return new StrikeScheduleImpl(this);
        }

        @Override
        public StrikeScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public StrikeScheduleBuilder prune() {
            super.prune();
            if (this.buyer != null && !this.buyer.prune().hasData()) {
                this.buyer = null;
            }
            if (this.seller != null && !this.seller.prune().hasData()) {
                this.seller = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyer() != null && this.getBuyer().hasData()) {
                return true;
            }
            return this.getSeller() != null && this.getSeller().hasData();
        }

        @Override
        public StrikeScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            StrikeScheduleBuilder o = (StrikeScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyer(), (RosettaModelObjectBuilder)o.getBuyer(), this::setBuyer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeller(), (RosettaModelObjectBuilder)o.getSeller(), this::setSeller);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StrikeSchedule _that = (StrikeSchedule)this.getType().cast(o);
            if (!Objects.equals(this.buyer, _that.getBuyer())) {
                return false;
            }
            return Objects.equals(this.seller, _that.getSeller());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyer != null ? this.buyer.hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? this.seller.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StrikeScheduleBuilder {buyer=" + this.buyer + ", seller=" + this.seller + '}' + " " + super.toString();
        }
    }

    public static interface StrikeScheduleBuilder
    extends StrikeSchedule,
    Schedule.ScheduleBuilder {
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateBuyer();

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getBuyer();

        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getOrCreateSeller();

        @Override
        public IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder getSeller();

        @Override
        public StrikeScheduleBuilder setInitialValue(BigDecimal var1);

        @Override
        public StrikeScheduleBuilder addStep(Step var1);

        @Override
        public StrikeScheduleBuilder addStep(Step var1, int var2);

        @Override
        public StrikeScheduleBuilder addStep(List<? extends Step> var1);

        @Override
        public StrikeScheduleBuilder setStep(List<? extends Step> var1);

        @Override
        public StrikeScheduleBuilder setId(String var1);

        public StrikeScheduleBuilder setBuyer(IdentifiedPayerReceiver var1);

        public StrikeScheduleBuilder setSeller(IdentifiedPayerReceiver var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("step"), processor, Step.StepBuilder.class, this.getStep(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyer"), processor, IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder.class, this.getBuyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("seller"), processor, IdentifiedPayerReceiver.IdentifiedPayerReceiverBuilder.class, this.getSeller(), new AttributeMeta[0]);
        }

        @Override
        public StrikeScheduleBuilder prune();
    }

    public static class StrikeScheduleImpl
    extends Schedule.ScheduleImpl
    implements StrikeSchedule {
        private final IdentifiedPayerReceiver buyer;
        private final IdentifiedPayerReceiver seller;

        protected StrikeScheduleImpl(StrikeScheduleBuilder builder) {
            super(builder);
            this.buyer = Optional.ofNullable(builder.getBuyer()).map(f -> f.build()).orElse(null);
            this.seller = Optional.ofNullable(builder.getSeller()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyer")
        @RuneAttribute(value="buyer")
        public IdentifiedPayerReceiver getBuyer() {
            return this.buyer;
        }

        @Override
        @RosettaAttribute(value="seller")
        @RuneAttribute(value="seller")
        public IdentifiedPayerReceiver getSeller() {
            return this.seller;
        }

        @Override
        public StrikeSchedule build() {
            return this;
        }

        @Override
        public StrikeScheduleBuilder toBuilder() {
            StrikeScheduleBuilder builder = StrikeSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StrikeScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyer()).ifPresent(builder::setBuyer);
            Optional.ofNullable(this.getSeller()).ifPresent(builder::setSeller);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StrikeSchedule _that = (StrikeSchedule)this.getType().cast(o);
            if (!Objects.equals(this.buyer, _that.getBuyer())) {
                return false;
            }
            return Objects.equals(this.seller, _that.getSeller());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyer != null ? this.buyer.hashCode() : 0);
            _result = 31 * _result + (this.seller != null ? this.seller.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StrikeSchedule {buyer=" + this.buyer + ", seller=" + this.seller + '}' + " " + super.toString();
        }
    }
}

