/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.BusinessCentersOrReferenceModel;
import fpml.consolidated.shared.DateOffset;
import fpml.consolidated.shared.DateReference;
import fpml.consolidated.shared.meta.RelativeDateSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RelativeDateSequence", builder=RelativeDateSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RelativeDateSequence", model="fpml", builder=RelativeDateSequenceBuilderImpl.class, version="1.1.0")
public interface RelativeDateSequence
extends RosettaModelObject {
    public static final RelativeDateSequenceMeta metaData = new RelativeDateSequenceMeta();

    public DateReference getDateRelativeTo();

    public List<? extends DateOffset> getDateOffset();

    public BusinessCentersOrReferenceModel getBusinessCentersOrReferenceModel();

    public RelativeDateSequence build();

    public RelativeDateSequenceBuilder toBuilder();

    public static RelativeDateSequenceBuilder builder() {
        return new RelativeDateSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends RelativeDateSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RelativeDateSequence> getType() {
        return RelativeDateSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dateRelativeTo"), processor, DateReference.class, this.getDateRelativeTo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateOffset"), processor, DateOffset.class, this.getDateOffset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCentersOrReferenceModel"), processor, BusinessCentersOrReferenceModel.class, this.getBusinessCentersOrReferenceModel(), new AttributeMeta[0]);
    }

    public static class RelativeDateSequenceBuilderImpl
    implements RelativeDateSequenceBuilder {
        protected DateReference.DateReferenceBuilder dateRelativeTo;
        protected List<DateOffset.DateOffsetBuilder> dateOffset = new ArrayList<DateOffset.DateOffsetBuilder>();
        protected BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder businessCentersOrReferenceModel;

        @Override
        @RosettaAttribute(value="dateRelativeTo")
        @RuneAttribute(value="dateRelativeTo")
        public DateReference.DateReferenceBuilder getDateRelativeTo() {
            return this.dateRelativeTo;
        }

        @Override
        public DateReference.DateReferenceBuilder getOrCreateDateRelativeTo() {
            DateReference.DateReferenceBuilder result = this.dateRelativeTo != null ? this.dateRelativeTo : (this.dateRelativeTo = DateReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateOffset")
        @RuneAttribute(value="dateOffset")
        public List<? extends DateOffset.DateOffsetBuilder> getDateOffset() {
            return this.dateOffset;
        }

        @Override
        public DateOffset.DateOffsetBuilder getOrCreateDateOffset(int index) {
            if (this.dateOffset == null) {
                this.dateOffset = new ArrayList<DateOffset.DateOffsetBuilder>();
            }
            return (DateOffset.DateOffsetBuilder)this.getIndex(this.dateOffset, index, () -> {
                DateOffset.DateOffsetBuilder newDateOffset = DateOffset.builder();
                return newDateOffset;
            });
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getBusinessCentersOrReferenceModel() {
            return this.businessCentersOrReferenceModel;
        }

        @Override
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getOrCreateBusinessCentersOrReferenceModel() {
            BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder result = this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel : (this.businessCentersOrReferenceModel = BusinessCentersOrReferenceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dateRelativeTo")
        @RuneAttribute(value="dateRelativeTo")
        public RelativeDateSequenceBuilder setDateRelativeTo(DateReference _dateRelativeTo) {
            this.dateRelativeTo = _dateRelativeTo == null ? null : _dateRelativeTo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dateOffset")
        @RuneAttribute(value="dateOffset")
        public RelativeDateSequenceBuilder addDateOffset(DateOffset _dateOffset) {
            if (_dateOffset != null) {
                this.dateOffset.add(_dateOffset.toBuilder());
            }
            return this;
        }

        @Override
        public RelativeDateSequenceBuilder addDateOffset(DateOffset _dateOffset, int idx) {
            this.getIndex(this.dateOffset, idx, () -> _dateOffset.toBuilder());
            return this;
        }

        @Override
        public RelativeDateSequenceBuilder addDateOffset(List<? extends DateOffset> dateOffsets) {
            if (dateOffsets != null) {
                for (DateOffset dateOffset : dateOffsets) {
                    this.dateOffset.add(dateOffset.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dateOffset")
        public RelativeDateSequenceBuilder setDateOffset(List<? extends DateOffset> dateOffsets) {
            this.dateOffset = dateOffsets == null ? new ArrayList<DateOffset.DateOffsetBuilder>() : (List)dateOffsets.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public RelativeDateSequenceBuilder setBusinessCentersOrReferenceModel(BusinessCentersOrReferenceModel _businessCentersOrReferenceModel) {
            this.businessCentersOrReferenceModel = _businessCentersOrReferenceModel == null ? null : _businessCentersOrReferenceModel.toBuilder();
            return this;
        }

        @Override
        public RelativeDateSequence build() {
            return new RelativeDateSequenceImpl(this);
        }

        @Override
        public RelativeDateSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public RelativeDateSequenceBuilder prune() {
            if (this.dateRelativeTo != null && !this.dateRelativeTo.prune().hasData()) {
                this.dateRelativeTo = null;
            }
            this.dateOffset = this.dateOffset.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.businessCentersOrReferenceModel != null && !this.businessCentersOrReferenceModel.prune().hasData()) {
                this.businessCentersOrReferenceModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDateRelativeTo() != null && this.getDateRelativeTo().hasData()) {
                return true;
            }
            if (this.getDateOffset() != null && this.getDateOffset().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBusinessCentersOrReferenceModel() != null && this.getBusinessCentersOrReferenceModel().hasData();
        }

        public RelativeDateSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RelativeDateSequenceBuilder o = (RelativeDateSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateRelativeTo(), (RosettaModelObjectBuilder)o.getDateRelativeTo(), this::setDateRelativeTo);
            merger.mergeRosetta(this.getDateOffset(), o.getDateOffset(), this::getOrCreateDateOffset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCentersOrReferenceModel(), (RosettaModelObjectBuilder)o.getBusinessCentersOrReferenceModel(), this::setBusinessCentersOrReferenceModel);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RelativeDateSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.dateRelativeTo, _that.getDateRelativeTo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dateOffset, _that.getDateOffset())) {
                return false;
            }
            return Objects.equals(this.businessCentersOrReferenceModel, _that.getBusinessCentersOrReferenceModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateRelativeTo != null ? this.dateRelativeTo.hashCode() : 0);
            _result = 31 * _result + (this.dateOffset != null ? this.dateOffset.hashCode() : 0);
            _result = 31 * _result + (this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RelativeDateSequenceBuilder {dateRelativeTo=" + this.dateRelativeTo + ", dateOffset=" + this.dateOffset + ", businessCentersOrReferenceModel=" + this.businessCentersOrReferenceModel + '}';
        }
    }

    public static interface RelativeDateSequenceBuilder
    extends RelativeDateSequence,
    RosettaModelObjectBuilder {
        public DateReference.DateReferenceBuilder getOrCreateDateRelativeTo();

        @Override
        public DateReference.DateReferenceBuilder getDateRelativeTo();

        public DateOffset.DateOffsetBuilder getOrCreateDateOffset(int var1);

        public List<? extends DateOffset.DateOffsetBuilder> getDateOffset();

        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getOrCreateBusinessCentersOrReferenceModel();

        @Override
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getBusinessCentersOrReferenceModel();

        public RelativeDateSequenceBuilder setDateRelativeTo(DateReference var1);

        public RelativeDateSequenceBuilder addDateOffset(DateOffset var1);

        public RelativeDateSequenceBuilder addDateOffset(DateOffset var1, int var2);

        public RelativeDateSequenceBuilder addDateOffset(List<? extends DateOffset> var1);

        public RelativeDateSequenceBuilder setDateOffset(List<? extends DateOffset> var1);

        public RelativeDateSequenceBuilder setBusinessCentersOrReferenceModel(BusinessCentersOrReferenceModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dateRelativeTo"), processor, DateReference.DateReferenceBuilder.class, this.getDateRelativeTo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateOffset"), processor, DateOffset.DateOffsetBuilder.class, this.getDateOffset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCentersOrReferenceModel"), processor, BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder.class, this.getBusinessCentersOrReferenceModel(), new AttributeMeta[0]);
        }

        public RelativeDateSequenceBuilder prune();
    }

    public static class RelativeDateSequenceImpl
    implements RelativeDateSequence {
        private final DateReference dateRelativeTo;
        private final List<? extends DateOffset> dateOffset;
        private final BusinessCentersOrReferenceModel businessCentersOrReferenceModel;

        protected RelativeDateSequenceImpl(RelativeDateSequenceBuilder builder) {
            this.dateRelativeTo = Optional.ofNullable(builder.getDateRelativeTo()).map(f -> f.build()).orElse(null);
            this.dateOffset = Optional.ofNullable(builder.getDateOffset()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.businessCentersOrReferenceModel = Optional.ofNullable(builder.getBusinessCentersOrReferenceModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dateRelativeTo")
        @RuneAttribute(value="dateRelativeTo")
        public DateReference getDateRelativeTo() {
            return this.dateRelativeTo;
        }

        @Override
        @RosettaAttribute(value="dateOffset")
        @RuneAttribute(value="dateOffset")
        public List<? extends DateOffset> getDateOffset() {
            return this.dateOffset;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public BusinessCentersOrReferenceModel getBusinessCentersOrReferenceModel() {
            return this.businessCentersOrReferenceModel;
        }

        @Override
        public RelativeDateSequence build() {
            return this;
        }

        @Override
        public RelativeDateSequenceBuilder toBuilder() {
            RelativeDateSequenceBuilder builder = RelativeDateSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RelativeDateSequenceBuilder builder) {
            Optional.ofNullable(this.getDateRelativeTo()).ifPresent(builder::setDateRelativeTo);
            Optional.ofNullable(this.getDateOffset()).ifPresent(builder::setDateOffset);
            Optional.ofNullable(this.getBusinessCentersOrReferenceModel()).ifPresent(builder::setBusinessCentersOrReferenceModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RelativeDateSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.dateRelativeTo, _that.getDateRelativeTo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dateOffset, _that.getDateOffset())) {
                return false;
            }
            return Objects.equals(this.businessCentersOrReferenceModel, _that.getBusinessCentersOrReferenceModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dateRelativeTo != null ? this.dateRelativeTo.hashCode() : 0);
            _result = 31 * _result + (this.dateOffset != null ? this.dateOffset.hashCode() : 0);
            _result = 31 * _result + (this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RelativeDateSequence {dateRelativeTo=" + this.dateRelativeTo + ", dateOffset=" + this.dateOffset + ", businessCentersOrReferenceModel=" + this.businessCentersOrReferenceModel + '}';
        }
    }
}

