/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.AssetClass;
import fpml.consolidated.shared.EmbeddedOptionType;
import fpml.consolidated.shared.ProductId;
import fpml.consolidated.shared.ProductModelSequence;
import fpml.consolidated.shared.ProductType;
import fpml.consolidated.shared.meta.ProductModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ProductModel", builder=ProductModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ProductModel", model="fpml", builder=ProductModelBuilderImpl.class, version="1.1.0")
public interface ProductModel
extends RosettaModelObject {
    public static final ProductModelMeta metaData = new ProductModelMeta();

    public AssetClass getPrimaryAssetClass();

    public List<? extends AssetClass> getSecondaryAssetClass();

    public ProductModelSequence getProductModelSequence();

    public List<? extends ProductId> getProductId();

    public List<? extends EmbeddedOptionType> getEmbeddedOptionType();

    public List<? extends ProductType> getProductType();

    public List<? extends AssetClass> getAssetClass();

    public ProductModel build();

    public ProductModelBuilder toBuilder();

    public static ProductModelBuilder builder() {
        return new ProductModelBuilderImpl();
    }

    default public RosettaMetaData<? extends ProductModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProductModel> getType() {
        return ProductModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("secondaryAssetClass"), processor, AssetClass.class, this.getSecondaryAssetClass(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productModelSequence"), processor, ProductModelSequence.class, this.getProductModelSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productId"), processor, ProductId.class, this.getProductId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("embeddedOptionType"), processor, EmbeddedOptionType.class, this.getEmbeddedOptionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productType"), processor, ProductType.class, this.getProductType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetClass"), processor, AssetClass.class, this.getAssetClass(), new AttributeMeta[0]);
    }

    public static class ProductModelBuilderImpl
    implements ProductModelBuilder {
        protected AssetClass.AssetClassBuilder primaryAssetClass;
        protected List<AssetClass.AssetClassBuilder> secondaryAssetClass = new ArrayList<AssetClass.AssetClassBuilder>();
        protected ProductModelSequence.ProductModelSequenceBuilder productModelSequence;
        protected List<ProductId.ProductIdBuilder> productId = new ArrayList<ProductId.ProductIdBuilder>();
        protected List<EmbeddedOptionType.EmbeddedOptionTypeBuilder> embeddedOptionType = new ArrayList<EmbeddedOptionType.EmbeddedOptionTypeBuilder>();
        protected List<ProductType.ProductTypeBuilder> productType = new ArrayList<ProductType.ProductTypeBuilder>();
        protected List<AssetClass.AssetClassBuilder> assetClass = new ArrayList<AssetClass.AssetClassBuilder>();

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass.AssetClassBuilder getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass() {
            AssetClass.AssetClassBuilder result = this.primaryAssetClass != null ? this.primaryAssetClass : (this.primaryAssetClass = AssetClass.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public List<? extends AssetClass.AssetClassBuilder> getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreateSecondaryAssetClass(int index) {
            if (this.secondaryAssetClass == null) {
                this.secondaryAssetClass = new ArrayList<AssetClass.AssetClassBuilder>();
            }
            return (AssetClass.AssetClassBuilder)this.getIndex(this.secondaryAssetClass, index, () -> {
                AssetClass.AssetClassBuilder newSecondaryAssetClass = AssetClass.builder();
                return newSecondaryAssetClass;
            });
        }

        @Override
        @RosettaAttribute(value="productModelSequence")
        @RuneAttribute(value="productModelSequence")
        public ProductModelSequence.ProductModelSequenceBuilder getProductModelSequence() {
            return this.productModelSequence;
        }

        @Override
        public ProductModelSequence.ProductModelSequenceBuilder getOrCreateProductModelSequence() {
            ProductModelSequence.ProductModelSequenceBuilder result = this.productModelSequence != null ? this.productModelSequence : (this.productModelSequence = ProductModelSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public List<? extends ProductId.ProductIdBuilder> getProductId() {
            return this.productId;
        }

        @Override
        public ProductId.ProductIdBuilder getOrCreateProductId(int index) {
            if (this.productId == null) {
                this.productId = new ArrayList<ProductId.ProductIdBuilder>();
            }
            return (ProductId.ProductIdBuilder)this.getIndex(this.productId, index, () -> {
                ProductId.ProductIdBuilder newProductId = ProductId.builder();
                return newProductId;
            });
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public List<? extends EmbeddedOptionType.EmbeddedOptionTypeBuilder> getEmbeddedOptionType() {
            return this.embeddedOptionType;
        }

        @Override
        public EmbeddedOptionType.EmbeddedOptionTypeBuilder getOrCreateEmbeddedOptionType(int index) {
            if (this.embeddedOptionType == null) {
                this.embeddedOptionType = new ArrayList<EmbeddedOptionType.EmbeddedOptionTypeBuilder>();
            }
            return (EmbeddedOptionType.EmbeddedOptionTypeBuilder)this.getIndex(this.embeddedOptionType, index, () -> {
                EmbeddedOptionType.EmbeddedOptionTypeBuilder newEmbeddedOptionType = EmbeddedOptionType.builder();
                return newEmbeddedOptionType;
            });
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public List<? extends ProductType.ProductTypeBuilder> getProductType() {
            return this.productType;
        }

        @Override
        public ProductType.ProductTypeBuilder getOrCreateProductType(int index) {
            if (this.productType == null) {
                this.productType = new ArrayList<ProductType.ProductTypeBuilder>();
            }
            return (ProductType.ProductTypeBuilder)this.getIndex(this.productType, index, () -> {
                ProductType.ProductTypeBuilder newProductType = ProductType.builder();
                return newProductType;
            });
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public List<? extends AssetClass.AssetClassBuilder> getAssetClass() {
            return this.assetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreateAssetClass(int index) {
            if (this.assetClass == null) {
                this.assetClass = new ArrayList<AssetClass.AssetClassBuilder>();
            }
            return (AssetClass.AssetClassBuilder)this.getIndex(this.assetClass, index, () -> {
                AssetClass.AssetClassBuilder newAssetClass = AssetClass.builder();
                return newAssetClass;
            });
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public ProductModelBuilder setPrimaryAssetClass(AssetClass _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public ProductModelBuilder addSecondaryAssetClass(AssetClass _secondaryAssetClass) {
            if (_secondaryAssetClass != null) {
                this.secondaryAssetClass.add(_secondaryAssetClass.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelBuilder addSecondaryAssetClass(AssetClass _secondaryAssetClass, int idx) {
            this.getIndex(this.secondaryAssetClass, idx, () -> _secondaryAssetClass.toBuilder());
            return this;
        }

        @Override
        public ProductModelBuilder addSecondaryAssetClass(List<? extends AssetClass> secondaryAssetClasss) {
            if (secondaryAssetClasss != null) {
                for (AssetClass assetClass : secondaryAssetClasss) {
                    this.secondaryAssetClass.add(assetClass.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="secondaryAssetClass")
        public ProductModelBuilder setSecondaryAssetClass(List<? extends AssetClass> secondaryAssetClasss) {
            this.secondaryAssetClass = secondaryAssetClasss == null ? new ArrayList<AssetClass.AssetClassBuilder>() : (List)secondaryAssetClasss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productModelSequence")
        @RuneAttribute(value="productModelSequence")
        public ProductModelBuilder setProductModelSequence(ProductModelSequence _productModelSequence) {
            this.productModelSequence = _productModelSequence == null ? null : _productModelSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public ProductModelBuilder addProductId(ProductId _productId) {
            if (_productId != null) {
                this.productId.add(_productId.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelBuilder addProductId(ProductId _productId, int idx) {
            this.getIndex(this.productId, idx, () -> _productId.toBuilder());
            return this;
        }

        @Override
        public ProductModelBuilder addProductId(List<? extends ProductId> productIds) {
            if (productIds != null) {
                for (ProductId productId : productIds) {
                    this.productId.add(productId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productId")
        public ProductModelBuilder setProductId(List<? extends ProductId> productIds) {
            this.productId = productIds == null ? new ArrayList<ProductId.ProductIdBuilder>() : (List)productIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public ProductModelBuilder addEmbeddedOptionType(EmbeddedOptionType _embeddedOptionType) {
            if (_embeddedOptionType != null) {
                this.embeddedOptionType.add(_embeddedOptionType.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelBuilder addEmbeddedOptionType(EmbeddedOptionType _embeddedOptionType, int idx) {
            this.getIndex(this.embeddedOptionType, idx, () -> _embeddedOptionType.toBuilder());
            return this;
        }

        @Override
        public ProductModelBuilder addEmbeddedOptionType(List<? extends EmbeddedOptionType> embeddedOptionTypes) {
            if (embeddedOptionTypes != null) {
                for (EmbeddedOptionType embeddedOptionType : embeddedOptionTypes) {
                    this.embeddedOptionType.add(embeddedOptionType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="embeddedOptionType")
        public ProductModelBuilder setEmbeddedOptionType(List<? extends EmbeddedOptionType> embeddedOptionTypes) {
            this.embeddedOptionType = embeddedOptionTypes == null ? new ArrayList<EmbeddedOptionType.EmbeddedOptionTypeBuilder>() : (List)embeddedOptionTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public ProductModelBuilder addProductType(ProductType _productType) {
            if (_productType != null) {
                this.productType.add(_productType.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelBuilder addProductType(ProductType _productType, int idx) {
            this.getIndex(this.productType, idx, () -> _productType.toBuilder());
            return this;
        }

        @Override
        public ProductModelBuilder addProductType(List<? extends ProductType> productTypes) {
            if (productTypes != null) {
                for (ProductType productType : productTypes) {
                    this.productType.add(productType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productType")
        public ProductModelBuilder setProductType(List<? extends ProductType> productTypes) {
            this.productType = productTypes == null ? new ArrayList<ProductType.ProductTypeBuilder>() : (List)productTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public ProductModelBuilder addAssetClass(AssetClass _assetClass) {
            if (_assetClass != null) {
                this.assetClass.add(_assetClass.toBuilder());
            }
            return this;
        }

        @Override
        public ProductModelBuilder addAssetClass(AssetClass _assetClass, int idx) {
            this.getIndex(this.assetClass, idx, () -> _assetClass.toBuilder());
            return this;
        }

        @Override
        public ProductModelBuilder addAssetClass(List<? extends AssetClass> assetClasss) {
            if (assetClasss != null) {
                for (AssetClass assetClass : assetClasss) {
                    this.assetClass.add(assetClass.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assetClass")
        public ProductModelBuilder setAssetClass(List<? extends AssetClass> assetClasss) {
            this.assetClass = assetClasss == null ? new ArrayList<AssetClass.AssetClassBuilder>() : (List)assetClasss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ProductModel build() {
            return new ProductModelImpl(this);
        }

        @Override
        public ProductModelBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductModelBuilder prune() {
            if (this.primaryAssetClass != null && !this.primaryAssetClass.prune().hasData()) {
                this.primaryAssetClass = null;
            }
            this.secondaryAssetClass = this.secondaryAssetClass.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.productModelSequence != null && !this.productModelSequence.prune().hasData()) {
                this.productModelSequence = null;
            }
            this.productId = this.productId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.embeddedOptionType = this.embeddedOptionType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.productType = this.productType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.assetClass = this.assetClass.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPrimaryAssetClass() != null && this.getPrimaryAssetClass().hasData()) {
                return true;
            }
            if (this.getSecondaryAssetClass() != null && this.getSecondaryAssetClass().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProductModelSequence() != null && this.getProductModelSequence().hasData()) {
                return true;
            }
            if (this.getProductId() != null && this.getProductId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEmbeddedOptionType() != null && this.getEmbeddedOptionType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProductType() != null && this.getProductType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAssetClass() != null && this.getAssetClass().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ProductModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProductModelBuilder o = (ProductModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)o.getPrimaryAssetClass(), this::setPrimaryAssetClass);
            merger.mergeRosetta(this.getSecondaryAssetClass(), o.getSecondaryAssetClass(), this::getOrCreateSecondaryAssetClass);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProductModelSequence(), (RosettaModelObjectBuilder)o.getProductModelSequence(), this::setProductModelSequence);
            merger.mergeRosetta(this.getProductId(), o.getProductId(), this::getOrCreateProductId);
            merger.mergeRosetta(this.getEmbeddedOptionType(), o.getEmbeddedOptionType(), this::getOrCreateEmbeddedOptionType);
            merger.mergeRosetta(this.getProductType(), o.getProductType(), this::getOrCreateProductType);
            merger.mergeRosetta(this.getAssetClass(), o.getAssetClass(), this::getOrCreateAssetClass);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductModel _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!ListEquals.listEquals(this.secondaryAssetClass, _that.getSecondaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.productModelSequence, _that.getProductModelSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productId, _that.getProductId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.embeddedOptionType, _that.getEmbeddedOptionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productType, _that.getProductType())) {
                return false;
            }
            return ListEquals.listEquals(this.assetClass, _that.getAssetClass());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.productModelSequence != null ? this.productModelSequence.hashCode() : 0);
            _result = 31 * _result + (this.productId != null ? this.productId.hashCode() : 0);
            _result = 31 * _result + (this.embeddedOptionType != null ? this.embeddedOptionType.hashCode() : 0);
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductModelBuilder {primaryAssetClass=" + this.primaryAssetClass + ", secondaryAssetClass=" + this.secondaryAssetClass + ", productModelSequence=" + this.productModelSequence + ", productId=" + this.productId + ", embeddedOptionType=" + this.embeddedOptionType + ", productType=" + this.productType + ", assetClass=" + this.assetClass + '}';
        }
    }

    public static interface ProductModelBuilder
    extends ProductModel,
    RosettaModelObjectBuilder {
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass();

        @Override
        public AssetClass.AssetClassBuilder getPrimaryAssetClass();

        public AssetClass.AssetClassBuilder getOrCreateSecondaryAssetClass(int var1);

        public List<? extends AssetClass.AssetClassBuilder> getSecondaryAssetClass();

        public ProductModelSequence.ProductModelSequenceBuilder getOrCreateProductModelSequence();

        @Override
        public ProductModelSequence.ProductModelSequenceBuilder getProductModelSequence();

        public ProductId.ProductIdBuilder getOrCreateProductId(int var1);

        public List<? extends ProductId.ProductIdBuilder> getProductId();

        public EmbeddedOptionType.EmbeddedOptionTypeBuilder getOrCreateEmbeddedOptionType(int var1);

        public List<? extends EmbeddedOptionType.EmbeddedOptionTypeBuilder> getEmbeddedOptionType();

        public ProductType.ProductTypeBuilder getOrCreateProductType(int var1);

        public List<? extends ProductType.ProductTypeBuilder> getProductType();

        public AssetClass.AssetClassBuilder getOrCreateAssetClass(int var1);

        public List<? extends AssetClass.AssetClassBuilder> getAssetClass();

        public ProductModelBuilder setPrimaryAssetClass(AssetClass var1);

        public ProductModelBuilder addSecondaryAssetClass(AssetClass var1);

        public ProductModelBuilder addSecondaryAssetClass(AssetClass var1, int var2);

        public ProductModelBuilder addSecondaryAssetClass(List<? extends AssetClass> var1);

        public ProductModelBuilder setSecondaryAssetClass(List<? extends AssetClass> var1);

        public ProductModelBuilder setProductModelSequence(ProductModelSequence var1);

        public ProductModelBuilder addProductId(ProductId var1);

        public ProductModelBuilder addProductId(ProductId var1, int var2);

        public ProductModelBuilder addProductId(List<? extends ProductId> var1);

        public ProductModelBuilder setProductId(List<? extends ProductId> var1);

        public ProductModelBuilder addEmbeddedOptionType(EmbeddedOptionType var1);

        public ProductModelBuilder addEmbeddedOptionType(EmbeddedOptionType var1, int var2);

        public ProductModelBuilder addEmbeddedOptionType(List<? extends EmbeddedOptionType> var1);

        public ProductModelBuilder setEmbeddedOptionType(List<? extends EmbeddedOptionType> var1);

        public ProductModelBuilder addProductType(ProductType var1);

        public ProductModelBuilder addProductType(ProductType var1, int var2);

        public ProductModelBuilder addProductType(List<? extends ProductType> var1);

        public ProductModelBuilder setProductType(List<? extends ProductType> var1);

        public ProductModelBuilder addAssetClass(AssetClass var1);

        public ProductModelBuilder addAssetClass(AssetClass var1, int var2);

        public ProductModelBuilder addAssetClass(List<? extends AssetClass> var1);

        public ProductModelBuilder setAssetClass(List<? extends AssetClass> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.AssetClassBuilder.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("secondaryAssetClass"), processor, AssetClass.AssetClassBuilder.class, this.getSecondaryAssetClass(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productModelSequence"), processor, ProductModelSequence.ProductModelSequenceBuilder.class, this.getProductModelSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productId"), processor, ProductId.ProductIdBuilder.class, this.getProductId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("embeddedOptionType"), processor, EmbeddedOptionType.EmbeddedOptionTypeBuilder.class, this.getEmbeddedOptionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productType"), processor, ProductType.ProductTypeBuilder.class, this.getProductType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetClass"), processor, AssetClass.AssetClassBuilder.class, this.getAssetClass(), new AttributeMeta[0]);
        }

        public ProductModelBuilder prune();
    }

    public static class ProductModelImpl
    implements ProductModel {
        private final AssetClass primaryAssetClass;
        private final List<? extends AssetClass> secondaryAssetClass;
        private final ProductModelSequence productModelSequence;
        private final List<? extends ProductId> productId;
        private final List<? extends EmbeddedOptionType> embeddedOptionType;
        private final List<? extends ProductType> productType;
        private final List<? extends AssetClass> assetClass;

        protected ProductModelImpl(ProductModelBuilder builder) {
            this.primaryAssetClass = Optional.ofNullable(builder.getPrimaryAssetClass()).map(f -> f.build()).orElse(null);
            this.secondaryAssetClass = Optional.ofNullable(builder.getSecondaryAssetClass()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productModelSequence = Optional.ofNullable(builder.getProductModelSequence()).map(f -> f.build()).orElse(null);
            this.productId = Optional.ofNullable(builder.getProductId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.embeddedOptionType = Optional.ofNullable(builder.getEmbeddedOptionType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productType = Optional.ofNullable(builder.getProductType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.assetClass = Optional.ofNullable(builder.getAssetClass()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public List<? extends AssetClass> getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="productModelSequence")
        @RuneAttribute(value="productModelSequence")
        public ProductModelSequence getProductModelSequence() {
            return this.productModelSequence;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public List<? extends ProductId> getProductId() {
            return this.productId;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public List<? extends EmbeddedOptionType> getEmbeddedOptionType() {
            return this.embeddedOptionType;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public List<? extends ProductType> getProductType() {
            return this.productType;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public List<? extends AssetClass> getAssetClass() {
            return this.assetClass;
        }

        @Override
        public ProductModel build() {
            return this;
        }

        @Override
        public ProductModelBuilder toBuilder() {
            ProductModelBuilder builder = ProductModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductModelBuilder builder) {
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getSecondaryAssetClass()).ifPresent(builder::setSecondaryAssetClass);
            Optional.ofNullable(this.getProductModelSequence()).ifPresent(builder::setProductModelSequence);
            Optional.ofNullable(this.getProductId()).ifPresent(builder::setProductId);
            Optional.ofNullable(this.getEmbeddedOptionType()).ifPresent(builder::setEmbeddedOptionType);
            Optional.ofNullable(this.getProductType()).ifPresent(builder::setProductType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductModel _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!ListEquals.listEquals(this.secondaryAssetClass, _that.getSecondaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.productModelSequence, _that.getProductModelSequence())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productId, _that.getProductId())) {
                return false;
            }
            if (!ListEquals.listEquals(this.embeddedOptionType, _that.getEmbeddedOptionType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.productType, _that.getProductType())) {
                return false;
            }
            return ListEquals.listEquals(this.assetClass, _that.getAssetClass());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.productModelSequence != null ? this.productModelSequence.hashCode() : 0);
            _result = 31 * _result + (this.productId != null ? this.productId.hashCode() : 0);
            _result = 31 * _result + (this.embeddedOptionType != null ? this.embeddedOptionType.hashCode() : 0);
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? this.assetClass.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductModel {primaryAssetClass=" + this.primaryAssetClass + ", secondaryAssetClass=" + this.secondaryAssetClass + ", productModelSequence=" + this.productModelSequence + ", productId=" + this.productId + ", embeddedOptionType=" + this.embeddedOptionType + ", productType=" + this.productType + ", assetClass=" + this.assetClass + '}';
        }
    }
}

