/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.GrossCashflow;
import fpml.consolidated.shared.PaymentReference;
import fpml.consolidated.shared.SettlementInformation;
import fpml.consolidated.shared.meta.PaymentDetailsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PaymentDetails", builder=PaymentDetailsBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PaymentDetails", model="fpml", builder=PaymentDetailsBuilderImpl.class, version="1.1.0")
public interface PaymentDetails
extends RosettaModelObject {
    public static final PaymentDetailsMeta metaData = new PaymentDetailsMeta();

    public PaymentReference getPaymentReference();

    public List<? extends GrossCashflow> getGrossCashflow();

    public SettlementInformation getSettlementInformation();

    public PaymentDetails build();

    public PaymentDetailsBuilder toBuilder();

    public static PaymentDetailsBuilder builder() {
        return new PaymentDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentDetails> getType() {
        return PaymentDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("paymentReference"), processor, PaymentReference.class, this.getPaymentReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("grossCashflow"), processor, GrossCashflow.class, this.getGrossCashflow(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.class, this.getSettlementInformation(), new AttributeMeta[0]);
    }

    public static class PaymentDetailsBuilderImpl
    implements PaymentDetailsBuilder {
        protected PaymentReference.PaymentReferenceBuilder paymentReference;
        protected List<GrossCashflow.GrossCashflowBuilder> grossCashflow = new ArrayList<GrossCashflow.GrossCashflowBuilder>();
        protected SettlementInformation.SettlementInformationBuilder settlementInformation;

        @Override
        @RosettaAttribute(value="paymentReference", isRequired=true)
        @RuneAttribute(value="paymentReference", isRequired=true)
        public PaymentReference.PaymentReferenceBuilder getPaymentReference() {
            return this.paymentReference;
        }

        @Override
        public PaymentReference.PaymentReferenceBuilder getOrCreatePaymentReference() {
            PaymentReference.PaymentReferenceBuilder result = this.paymentReference != null ? this.paymentReference : (this.paymentReference = PaymentReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="grossCashflow", isRequired=true)
        @RuneAttribute(value="grossCashflow", isRequired=true)
        public List<? extends GrossCashflow.GrossCashflowBuilder> getGrossCashflow() {
            return this.grossCashflow;
        }

        @Override
        public GrossCashflow.GrossCashflowBuilder getOrCreateGrossCashflow(int index) {
            if (this.grossCashflow == null) {
                this.grossCashflow = new ArrayList<GrossCashflow.GrossCashflowBuilder>();
            }
            return (GrossCashflow.GrossCashflowBuilder)this.getIndex(this.grossCashflow, index, () -> {
                GrossCashflow.GrossCashflowBuilder newGrossCashflow = GrossCashflow.builder();
                return newGrossCashflow;
            });
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation() {
            SettlementInformation.SettlementInformationBuilder result = this.settlementInformation != null ? this.settlementInformation : (this.settlementInformation = SettlementInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentReference", isRequired=true)
        @RuneAttribute(value="paymentReference", isRequired=true)
        public PaymentDetailsBuilder setPaymentReference(PaymentReference _paymentReference) {
            this.paymentReference = _paymentReference == null ? null : _paymentReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="grossCashflow", isRequired=true)
        @RuneAttribute(value="grossCashflow", isRequired=true)
        public PaymentDetailsBuilder addGrossCashflow(GrossCashflow _grossCashflow) {
            if (_grossCashflow != null) {
                this.grossCashflow.add(_grossCashflow.toBuilder());
            }
            return this;
        }

        @Override
        public PaymentDetailsBuilder addGrossCashflow(GrossCashflow _grossCashflow, int idx) {
            this.getIndex(this.grossCashflow, idx, () -> _grossCashflow.toBuilder());
            return this;
        }

        @Override
        public PaymentDetailsBuilder addGrossCashflow(List<? extends GrossCashflow> grossCashflows) {
            if (grossCashflows != null) {
                for (GrossCashflow grossCashflow : grossCashflows) {
                    this.grossCashflow.add(grossCashflow.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="grossCashflow")
        public PaymentDetailsBuilder setGrossCashflow(List<? extends GrossCashflow> grossCashflows) {
            this.grossCashflow = grossCashflows == null ? new ArrayList<GrossCashflow.GrossCashflowBuilder>() : (List)grossCashflows.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public PaymentDetailsBuilder setSettlementInformation(SettlementInformation _settlementInformation) {
            this.settlementInformation = _settlementInformation == null ? null : _settlementInformation.toBuilder();
            return this;
        }

        @Override
        public PaymentDetails build() {
            return new PaymentDetailsImpl(this);
        }

        @Override
        public PaymentDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDetailsBuilder prune() {
            if (this.paymentReference != null && !this.paymentReference.prune().hasData()) {
                this.paymentReference = null;
            }
            this.grossCashflow = this.grossCashflow.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.settlementInformation != null && !this.settlementInformation.prune().hasData()) {
                this.settlementInformation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPaymentReference() != null && this.getPaymentReference().hasData()) {
                return true;
            }
            if (this.getGrossCashflow() != null && this.getGrossCashflow().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSettlementInformation() != null && this.getSettlementInformation().hasData();
        }

        public PaymentDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentDetailsBuilder o = (PaymentDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentReference(), (RosettaModelObjectBuilder)o.getPaymentReference(), this::setPaymentReference);
            merger.mergeRosetta(this.getGrossCashflow(), o.getGrossCashflow(), this::getOrCreateGrossCashflow);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementInformation(), (RosettaModelObjectBuilder)o.getSettlementInformation(), this::setSettlementInformation);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentReference, _that.getPaymentReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.grossCashflow, _that.getGrossCashflow())) {
                return false;
            }
            return Objects.equals(this.settlementInformation, _that.getSettlementInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentReference != null ? this.paymentReference.hashCode() : 0);
            _result = 31 * _result + (this.grossCashflow != null ? this.grossCashflow.hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDetailsBuilder {paymentReference=" + this.paymentReference + ", grossCashflow=" + this.grossCashflow + ", settlementInformation=" + this.settlementInformation + '}';
        }
    }

    public static interface PaymentDetailsBuilder
    extends PaymentDetails,
    RosettaModelObjectBuilder {
        public PaymentReference.PaymentReferenceBuilder getOrCreatePaymentReference();

        @Override
        public PaymentReference.PaymentReferenceBuilder getPaymentReference();

        public GrossCashflow.GrossCashflowBuilder getOrCreateGrossCashflow(int var1);

        public List<? extends GrossCashflow.GrossCashflowBuilder> getGrossCashflow();

        public SettlementInformation.SettlementInformationBuilder getOrCreateSettlementInformation();

        @Override
        public SettlementInformation.SettlementInformationBuilder getSettlementInformation();

        public PaymentDetailsBuilder setPaymentReference(PaymentReference var1);

        public PaymentDetailsBuilder addGrossCashflow(GrossCashflow var1);

        public PaymentDetailsBuilder addGrossCashflow(GrossCashflow var1, int var2);

        public PaymentDetailsBuilder addGrossCashflow(List<? extends GrossCashflow> var1);

        public PaymentDetailsBuilder setGrossCashflow(List<? extends GrossCashflow> var1);

        public PaymentDetailsBuilder setSettlementInformation(SettlementInformation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("paymentReference"), processor, PaymentReference.PaymentReferenceBuilder.class, this.getPaymentReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("grossCashflow"), processor, GrossCashflow.GrossCashflowBuilder.class, this.getGrossCashflow(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementInformation"), processor, SettlementInformation.SettlementInformationBuilder.class, this.getSettlementInformation(), new AttributeMeta[0]);
        }

        public PaymentDetailsBuilder prune();
    }

    public static class PaymentDetailsImpl
    implements PaymentDetails {
        private final PaymentReference paymentReference;
        private final List<? extends GrossCashflow> grossCashflow;
        private final SettlementInformation settlementInformation;

        protected PaymentDetailsImpl(PaymentDetailsBuilder builder) {
            this.paymentReference = Optional.ofNullable(builder.getPaymentReference()).map(f -> f.build()).orElse(null);
            this.grossCashflow = Optional.ofNullable(builder.getGrossCashflow()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementInformation = Optional.ofNullable(builder.getSettlementInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentReference", isRequired=true)
        @RuneAttribute(value="paymentReference", isRequired=true)
        public PaymentReference getPaymentReference() {
            return this.paymentReference;
        }

        @Override
        @RosettaAttribute(value="grossCashflow", isRequired=true)
        @RuneAttribute(value="grossCashflow", isRequired=true)
        public List<? extends GrossCashflow> getGrossCashflow() {
            return this.grossCashflow;
        }

        @Override
        @RosettaAttribute(value="settlementInformation")
        @RuneAttribute(value="settlementInformation")
        public SettlementInformation getSettlementInformation() {
            return this.settlementInformation;
        }

        @Override
        public PaymentDetails build() {
            return this;
        }

        @Override
        public PaymentDetailsBuilder toBuilder() {
            PaymentDetailsBuilder builder = PaymentDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDetailsBuilder builder) {
            Optional.ofNullable(this.getPaymentReference()).ifPresent(builder::setPaymentReference);
            Optional.ofNullable(this.getGrossCashflow()).ifPresent(builder::setGrossCashflow);
            Optional.ofNullable(this.getSettlementInformation()).ifPresent(builder::setSettlementInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.paymentReference, _that.getPaymentReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.grossCashflow, _that.getGrossCashflow())) {
                return false;
            }
            return Objects.equals(this.settlementInformation, _that.getSettlementInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.paymentReference != null ? this.paymentReference.hashCode() : 0);
            _result = 31 * _result + (this.grossCashflow != null ? this.grossCashflow.hashCode() : 0);
            _result = 31 * _result + (this.settlementInformation != null ? this.settlementInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentDetails {paymentReference=" + this.paymentReference + ", grossCashflow=" + this.grossCashflow + ", settlementInformation=" + this.settlementInformation + '}';
        }
    }
}

