/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.BusinessUnit;
import fpml.consolidated.shared.ContactInformation;
import fpml.consolidated.shared.PartyId;
import fpml.consolidated.shared.PartyInformationModel;
import fpml.consolidated.shared.PartyName;
import fpml.consolidated.shared.Person;
import fpml.consolidated.shared.meta.PartyModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartyModel", builder=PartyModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PartyModel", model="fpml", builder=PartyModelBuilderImpl.class, version="1.1.0")
public interface PartyModel
extends RosettaModelObject {
    public static final PartyModelMeta metaData = new PartyModelMeta();

    public List<? extends PartyId> getPartyId();

    public PartyName getPartyName();

    public PartyInformationModel getPartyInformationModel();

    public ContactInformation getContactInfo();

    public List<? extends BusinessUnit> getBusinessUnit();

    public List<? extends Person> getPerson();

    public PartyModel build();

    public PartyModelBuilder toBuilder();

    public static PartyModelBuilder builder() {
        return new PartyModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PartyModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartyModel> getType() {
        return PartyModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyId"), processor, PartyId.class, this.getPartyId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyName"), processor, PartyName.class, this.getPartyName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyInformationModel"), processor, PartyInformationModel.class, this.getPartyInformationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contactInfo"), processor, ContactInformation.class, this.getContactInfo(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.class, this.getBusinessUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("person"), processor, Person.class, this.getPerson(), new AttributeMeta[0]);
    }

    public static class PartyModelBuilderImpl
    implements PartyModelBuilder {
        protected List<PartyId.PartyIdBuilder> partyId = new ArrayList<PartyId.PartyIdBuilder>();
        protected PartyName.PartyNameBuilder partyName;
        protected PartyInformationModel.PartyInformationModelBuilder partyInformationModel;
        protected ContactInformation.ContactInformationBuilder contactInfo;
        protected List<BusinessUnit.BusinessUnitBuilder> businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
        protected List<Person.PersonBuilder> person = new ArrayList<Person.PersonBuilder>();

        @Override
        @RosettaAttribute(value="partyId", isRequired=true)
        @RuneAttribute(value="partyId", isRequired=true)
        public List<? extends PartyId.PartyIdBuilder> getPartyId() {
            return this.partyId;
        }

        @Override
        public PartyId.PartyIdBuilder getOrCreatePartyId(int index) {
            if (this.partyId == null) {
                this.partyId = new ArrayList<PartyId.PartyIdBuilder>();
            }
            return (PartyId.PartyIdBuilder)this.getIndex(this.partyId, index, () -> {
                PartyId.PartyIdBuilder newPartyId = PartyId.builder();
                return newPartyId;
            });
        }

        @Override
        @RosettaAttribute(value="partyName")
        @RuneAttribute(value="partyName")
        public PartyName.PartyNameBuilder getPartyName() {
            return this.partyName;
        }

        @Override
        public PartyName.PartyNameBuilder getOrCreatePartyName() {
            PartyName.PartyNameBuilder result = this.partyName != null ? this.partyName : (this.partyName = PartyName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyInformationModel")
        @RuneAttribute(value="partyInformationModel")
        public PartyInformationModel.PartyInformationModelBuilder getPartyInformationModel() {
            return this.partyInformationModel;
        }

        @Override
        public PartyInformationModel.PartyInformationModelBuilder getOrCreatePartyInformationModel() {
            PartyInformationModel.PartyInformationModelBuilder result = this.partyInformationModel != null ? this.partyInformationModel : (this.partyInformationModel = PartyInformationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public ContactInformation.ContactInformationBuilder getContactInfo() {
            return this.contactInfo;
        }

        @Override
        public ContactInformation.ContactInformationBuilder getOrCreateContactInfo() {
            ContactInformation.ContactInformationBuilder result = this.contactInfo != null ? this.contactInfo : (this.contactInfo = ContactInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int index) {
            if (this.businessUnit == null) {
                this.businessUnit = new ArrayList<BusinessUnit.BusinessUnitBuilder>();
            }
            return (BusinessUnit.BusinessUnitBuilder)this.getIndex(this.businessUnit, index, () -> {
                BusinessUnit.BusinessUnitBuilder newBusinessUnit = BusinessUnit.builder();
                return newBusinessUnit;
            });
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public List<? extends Person.PersonBuilder> getPerson() {
            return this.person;
        }

        @Override
        public Person.PersonBuilder getOrCreatePerson(int index) {
            if (this.person == null) {
                this.person = new ArrayList<Person.PersonBuilder>();
            }
            return (Person.PersonBuilder)this.getIndex(this.person, index, () -> {
                Person.PersonBuilder newPerson = Person.builder();
                return newPerson;
            });
        }

        @Override
        @RosettaAttribute(value="partyId", isRequired=true)
        @RuneAttribute(value="partyId", isRequired=true)
        public PartyModelBuilder addPartyId(PartyId _partyId) {
            if (_partyId != null) {
                this.partyId.add(_partyId.toBuilder());
            }
            return this;
        }

        @Override
        public PartyModelBuilder addPartyId(PartyId _partyId, int idx) {
            this.getIndex(this.partyId, idx, () -> _partyId.toBuilder());
            return this;
        }

        @Override
        public PartyModelBuilder addPartyId(List<? extends PartyId> partyIds) {
            if (partyIds != null) {
                for (PartyId partyId : partyIds) {
                    this.partyId.add(partyId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyId")
        public PartyModelBuilder setPartyId(List<? extends PartyId> partyIds) {
            this.partyId = partyIds == null ? new ArrayList<PartyId.PartyIdBuilder>() : (List)partyIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyName")
        @RuneAttribute(value="partyName")
        public PartyModelBuilder setPartyName(PartyName _partyName) {
            this.partyName = _partyName == null ? null : _partyName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyInformationModel")
        @RuneAttribute(value="partyInformationModel")
        public PartyModelBuilder setPartyInformationModel(PartyInformationModel _partyInformationModel) {
            this.partyInformationModel = _partyInformationModel == null ? null : _partyInformationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public PartyModelBuilder setContactInfo(ContactInformation _contactInfo) {
            this.contactInfo = _contactInfo == null ? null : _contactInfo.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public PartyModelBuilder addBusinessUnit(BusinessUnit _businessUnit) {
            if (_businessUnit != null) {
                this.businessUnit.add(_businessUnit.toBuilder());
            }
            return this;
        }

        @Override
        public PartyModelBuilder addBusinessUnit(BusinessUnit _businessUnit, int idx) {
            this.getIndex(this.businessUnit, idx, () -> _businessUnit.toBuilder());
            return this;
        }

        @Override
        public PartyModelBuilder addBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            if (businessUnits != null) {
                for (BusinessUnit businessUnit : businessUnits) {
                    this.businessUnit.add(businessUnit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="businessUnit")
        public PartyModelBuilder setBusinessUnit(List<? extends BusinessUnit> businessUnits) {
            this.businessUnit = businessUnits == null ? new ArrayList<BusinessUnit.BusinessUnitBuilder>() : (List)businessUnits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public PartyModelBuilder addPerson(Person _person) {
            if (_person != null) {
                this.person.add(_person.toBuilder());
            }
            return this;
        }

        @Override
        public PartyModelBuilder addPerson(Person _person, int idx) {
            this.getIndex(this.person, idx, () -> _person.toBuilder());
            return this;
        }

        @Override
        public PartyModelBuilder addPerson(List<? extends Person> persons) {
            if (persons != null) {
                for (Person person : persons) {
                    this.person.add(person.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="person")
        public PartyModelBuilder setPerson(List<? extends Person> persons) {
            this.person = persons == null ? new ArrayList<Person.PersonBuilder>() : (List)persons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartyModel build() {
            return new PartyModelImpl(this);
        }

        @Override
        public PartyModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PartyModelBuilder prune() {
            this.partyId = this.partyId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partyName != null && !this.partyName.prune().hasData()) {
                this.partyName = null;
            }
            if (this.partyInformationModel != null && !this.partyInformationModel.prune().hasData()) {
                this.partyInformationModel = null;
            }
            if (this.contactInfo != null && !this.contactInfo.prune().hasData()) {
                this.contactInfo = null;
            }
            this.businessUnit = this.businessUnit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.person = this.person.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyId() != null && this.getPartyId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyName() != null && this.getPartyName().hasData()) {
                return true;
            }
            if (this.getPartyInformationModel() != null && this.getPartyInformationModel().hasData()) {
                return true;
            }
            if (this.getContactInfo() != null && this.getContactInfo().hasData()) {
                return true;
            }
            if (this.getBusinessUnit() != null && this.getBusinessUnit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPerson() != null && this.getPerson().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartyModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartyModelBuilder o = (PartyModelBuilder)other;
            merger.mergeRosetta(this.getPartyId(), o.getPartyId(), this::getOrCreatePartyId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyName(), (RosettaModelObjectBuilder)o.getPartyName(), this::setPartyName);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyInformationModel(), (RosettaModelObjectBuilder)o.getPartyInformationModel(), this::setPartyInformationModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContactInfo(), (RosettaModelObjectBuilder)o.getContactInfo(), this::setContactInfo);
            merger.mergeRosetta(this.getBusinessUnit(), o.getBusinessUnit(), this::getOrCreateBusinessUnit);
            merger.mergeRosetta(this.getPerson(), o.getPerson(), this::getOrCreatePerson);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.partyId, _that.getPartyId())) {
                return false;
            }
            if (!Objects.equals(this.partyName, _that.getPartyName())) {
                return false;
            }
            if (!Objects.equals(this.partyInformationModel, _that.getPartyInformationModel())) {
                return false;
            }
            if (!Objects.equals(this.contactInfo, _that.getContactInfo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            return ListEquals.listEquals(this.person, _that.getPerson());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyId != null ? this.partyId.hashCode() : 0);
            _result = 31 * _result + (this.partyName != null ? this.partyName.hashCode() : 0);
            _result = 31 * _result + (this.partyInformationModel != null ? this.partyInformationModel.hashCode() : 0);
            _result = 31 * _result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyModelBuilder {partyId=" + this.partyId + ", partyName=" + this.partyName + ", partyInformationModel=" + this.partyInformationModel + ", contactInfo=" + this.contactInfo + ", businessUnit=" + this.businessUnit + ", person=" + this.person + '}';
        }
    }

    public static interface PartyModelBuilder
    extends PartyModel,
    RosettaModelObjectBuilder {
        public PartyId.PartyIdBuilder getOrCreatePartyId(int var1);

        public List<? extends PartyId.PartyIdBuilder> getPartyId();

        public PartyName.PartyNameBuilder getOrCreatePartyName();

        @Override
        public PartyName.PartyNameBuilder getPartyName();

        public PartyInformationModel.PartyInformationModelBuilder getOrCreatePartyInformationModel();

        @Override
        public PartyInformationModel.PartyInformationModelBuilder getPartyInformationModel();

        public ContactInformation.ContactInformationBuilder getOrCreateContactInfo();

        @Override
        public ContactInformation.ContactInformationBuilder getContactInfo();

        public BusinessUnit.BusinessUnitBuilder getOrCreateBusinessUnit(int var1);

        public List<? extends BusinessUnit.BusinessUnitBuilder> getBusinessUnit();

        public Person.PersonBuilder getOrCreatePerson(int var1);

        public List<? extends Person.PersonBuilder> getPerson();

        public PartyModelBuilder addPartyId(PartyId var1);

        public PartyModelBuilder addPartyId(PartyId var1, int var2);

        public PartyModelBuilder addPartyId(List<? extends PartyId> var1);

        public PartyModelBuilder setPartyId(List<? extends PartyId> var1);

        public PartyModelBuilder setPartyName(PartyName var1);

        public PartyModelBuilder setPartyInformationModel(PartyInformationModel var1);

        public PartyModelBuilder setContactInfo(ContactInformation var1);

        public PartyModelBuilder addBusinessUnit(BusinessUnit var1);

        public PartyModelBuilder addBusinessUnit(BusinessUnit var1, int var2);

        public PartyModelBuilder addBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyModelBuilder setBusinessUnit(List<? extends BusinessUnit> var1);

        public PartyModelBuilder addPerson(Person var1);

        public PartyModelBuilder addPerson(Person var1, int var2);

        public PartyModelBuilder addPerson(List<? extends Person> var1);

        public PartyModelBuilder setPerson(List<? extends Person> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyId"), processor, PartyId.PartyIdBuilder.class, this.getPartyId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyName"), processor, PartyName.PartyNameBuilder.class, this.getPartyName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyInformationModel"), processor, PartyInformationModel.PartyInformationModelBuilder.class, this.getPartyInformationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contactInfo"), processor, ContactInformation.ContactInformationBuilder.class, this.getContactInfo(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessUnit"), processor, BusinessUnit.BusinessUnitBuilder.class, this.getBusinessUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("person"), processor, Person.PersonBuilder.class, this.getPerson(), new AttributeMeta[0]);
        }

        public PartyModelBuilder prune();
    }

    public static class PartyModelImpl
    implements PartyModel {
        private final List<? extends PartyId> partyId;
        private final PartyName partyName;
        private final PartyInformationModel partyInformationModel;
        private final ContactInformation contactInfo;
        private final List<? extends BusinessUnit> businessUnit;
        private final List<? extends Person> person;

        protected PartyModelImpl(PartyModelBuilder builder) {
            this.partyId = Optional.ofNullable(builder.getPartyId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyName = Optional.ofNullable(builder.getPartyName()).map(f -> f.build()).orElse(null);
            this.partyInformationModel = Optional.ofNullable(builder.getPartyInformationModel()).map(f -> f.build()).orElse(null);
            this.contactInfo = Optional.ofNullable(builder.getContactInfo()).map(f -> f.build()).orElse(null);
            this.businessUnit = Optional.ofNullable(builder.getBusinessUnit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.person = Optional.ofNullable(builder.getPerson()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyId", isRequired=true)
        @RuneAttribute(value="partyId", isRequired=true)
        public List<? extends PartyId> getPartyId() {
            return this.partyId;
        }

        @Override
        @RosettaAttribute(value="partyName")
        @RuneAttribute(value="partyName")
        public PartyName getPartyName() {
            return this.partyName;
        }

        @Override
        @RosettaAttribute(value="partyInformationModel")
        @RuneAttribute(value="partyInformationModel")
        public PartyInformationModel getPartyInformationModel() {
            return this.partyInformationModel;
        }

        @Override
        @RosettaAttribute(value="contactInfo")
        @RuneAttribute(value="contactInfo")
        public ContactInformation getContactInfo() {
            return this.contactInfo;
        }

        @Override
        @RosettaAttribute(value="businessUnit")
        @RuneAttribute(value="businessUnit")
        public List<? extends BusinessUnit> getBusinessUnit() {
            return this.businessUnit;
        }

        @Override
        @RosettaAttribute(value="person")
        @RuneAttribute(value="person")
        public List<? extends Person> getPerson() {
            return this.person;
        }

        @Override
        public PartyModel build() {
            return this;
        }

        @Override
        public PartyModelBuilder toBuilder() {
            PartyModelBuilder builder = PartyModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartyModelBuilder builder) {
            Optional.ofNullable(this.getPartyId()).ifPresent(builder::setPartyId);
            Optional.ofNullable(this.getPartyName()).ifPresent(builder::setPartyName);
            Optional.ofNullable(this.getPartyInformationModel()).ifPresent(builder::setPartyInformationModel);
            Optional.ofNullable(this.getContactInfo()).ifPresent(builder::setContactInfo);
            Optional.ofNullable(this.getBusinessUnit()).ifPresent(builder::setBusinessUnit);
            Optional.ofNullable(this.getPerson()).ifPresent(builder::setPerson);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartyModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.partyId, _that.getPartyId())) {
                return false;
            }
            if (!Objects.equals(this.partyName, _that.getPartyName())) {
                return false;
            }
            if (!Objects.equals(this.partyInformationModel, _that.getPartyInformationModel())) {
                return false;
            }
            if (!Objects.equals(this.contactInfo, _that.getContactInfo())) {
                return false;
            }
            if (!ListEquals.listEquals(this.businessUnit, _that.getBusinessUnit())) {
                return false;
            }
            return ListEquals.listEquals(this.person, _that.getPerson());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyId != null ? this.partyId.hashCode() : 0);
            _result = 31 * _result + (this.partyName != null ? this.partyName.hashCode() : 0);
            _result = 31 * _result + (this.partyInformationModel != null ? this.partyInformationModel.hashCode() : 0);
            _result = 31 * _result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            _result = 31 * _result + (this.businessUnit != null ? this.businessUnit.hashCode() : 0);
            _result = 31 * _result + (this.person != null ? this.person.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartyModel {partyId=" + this.partyId + ", partyName=" + this.partyName + ", partyInformationModel=" + this.partyInformationModel + ", contactInfo=" + this.contactInfo + ", businessUnit=" + this.businessUnit + ", person=" + this.person + '}';
        }
    }
}

