/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.NotionalReference;
import fpml.consolidated.shared.meta.PartialExerciseModelMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartialExerciseModel", builder=PartialExerciseModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="PartialExerciseModel", model="fpml", builder=PartialExerciseModelBuilderImpl.class, version="1.1.0")
public interface PartialExerciseModel
extends RosettaModelObject {
    public static final PartialExerciseModelMeta metaData = new PartialExerciseModelMeta();

    public List<? extends NotionalReference> getNotionalReference();

    public BigDecimal getIntegralMultipleAmount();

    public BigDecimal getMinimumNotionalAmount();

    public BigDecimal getMinimumNumberOfOptions();

    public PartialExerciseModel build();

    public PartialExerciseModelBuilder toBuilder();

    public static PartialExerciseModelBuilder builder() {
        return new PartialExerciseModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PartialExerciseModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartialExerciseModel> getType() {
        return PartialExerciseModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalReference.class, this.getNotionalReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("integralMultipleAmount"), BigDecimal.class, (Object)this.getIntegralMultipleAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("minimumNotionalAmount"), BigDecimal.class, (Object)this.getMinimumNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("minimumNumberOfOptions"), BigDecimal.class, (Object)this.getMinimumNumberOfOptions(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PartialExerciseModelBuilderImpl
    implements PartialExerciseModelBuilder {
        protected List<NotionalReference.NotionalReferenceBuilder> notionalReference = new ArrayList<NotionalReference.NotionalReferenceBuilder>();
        protected BigDecimal integralMultipleAmount;
        protected BigDecimal minimumNotionalAmount;
        protected BigDecimal minimumNumberOfOptions;

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public List<? extends NotionalReference.NotionalReferenceBuilder> getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        public NotionalReference.NotionalReferenceBuilder getOrCreateNotionalReference(int index) {
            if (this.notionalReference == null) {
                this.notionalReference = new ArrayList<NotionalReference.NotionalReferenceBuilder>();
            }
            return (NotionalReference.NotionalReferenceBuilder)this.getIndex(this.notionalReference, index, () -> {
                NotionalReference.NotionalReferenceBuilder newNotionalReference = NotionalReference.builder();
                return newNotionalReference;
            });
        }

        @Override
        @RosettaAttribute(value="integralMultipleAmount")
        @RuneAttribute(value="integralMultipleAmount")
        public BigDecimal getIntegralMultipleAmount() {
            return this.integralMultipleAmount;
        }

        @Override
        @RosettaAttribute(value="minimumNotionalAmount")
        @RuneAttribute(value="minimumNotionalAmount")
        public BigDecimal getMinimumNotionalAmount() {
            return this.minimumNotionalAmount;
        }

        @Override
        @RosettaAttribute(value="minimumNumberOfOptions")
        @RuneAttribute(value="minimumNumberOfOptions")
        public BigDecimal getMinimumNumberOfOptions() {
            return this.minimumNumberOfOptions;
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public PartialExerciseModelBuilder addNotionalReference(NotionalReference _notionalReference) {
            if (_notionalReference != null) {
                this.notionalReference.add(_notionalReference.toBuilder());
            }
            return this;
        }

        @Override
        public PartialExerciseModelBuilder addNotionalReference(NotionalReference _notionalReference, int idx) {
            this.getIndex(this.notionalReference, idx, () -> _notionalReference.toBuilder());
            return this;
        }

        @Override
        public PartialExerciseModelBuilder addNotionalReference(List<? extends NotionalReference> notionalReferences) {
            if (notionalReferences != null) {
                for (NotionalReference notionalReference : notionalReferences) {
                    this.notionalReference.add(notionalReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalReference")
        public PartialExerciseModelBuilder setNotionalReference(List<? extends NotionalReference> notionalReferences) {
            this.notionalReference = notionalReferences == null ? new ArrayList<NotionalReference.NotionalReferenceBuilder>() : (List)notionalReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="integralMultipleAmount")
        @RuneAttribute(value="integralMultipleAmount")
        public PartialExerciseModelBuilder setIntegralMultipleAmount(BigDecimal _integralMultipleAmount) {
            this.integralMultipleAmount = _integralMultipleAmount == null ? null : _integralMultipleAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumNotionalAmount")
        @RuneAttribute(value="minimumNotionalAmount")
        public PartialExerciseModelBuilder setMinimumNotionalAmount(BigDecimal _minimumNotionalAmount) {
            this.minimumNotionalAmount = _minimumNotionalAmount == null ? null : _minimumNotionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumNumberOfOptions")
        @RuneAttribute(value="minimumNumberOfOptions")
        public PartialExerciseModelBuilder setMinimumNumberOfOptions(BigDecimal _minimumNumberOfOptions) {
            this.minimumNumberOfOptions = _minimumNumberOfOptions == null ? null : _minimumNumberOfOptions;
            return this;
        }

        @Override
        public PartialExerciseModel build() {
            return new PartialExerciseModelImpl(this);
        }

        @Override
        public PartialExerciseModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PartialExerciseModelBuilder prune() {
            this.notionalReference = this.notionalReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getNotionalReference() != null && this.getNotionalReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIntegralMultipleAmount() != null) {
                return true;
            }
            if (this.getMinimumNotionalAmount() != null) {
                return true;
            }
            return this.getMinimumNumberOfOptions() != null;
        }

        public PartialExerciseModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartialExerciseModelBuilder o = (PartialExerciseModelBuilder)other;
            merger.mergeRosetta(this.getNotionalReference(), o.getNotionalReference(), this::getOrCreateNotionalReference);
            merger.mergeBasic((Object)this.getIntegralMultipleAmount(), (Object)o.getIntegralMultipleAmount(), this::setIntegralMultipleAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMinimumNotionalAmount(), (Object)o.getMinimumNotionalAmount(), this::setMinimumNotionalAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMinimumNumberOfOptions(), (Object)o.getMinimumNumberOfOptions(), this::setMinimumNumberOfOptions, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartialExerciseModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.notionalReference, _that.getNotionalReference())) {
                return false;
            }
            if (!Objects.equals(this.integralMultipleAmount, _that.getIntegralMultipleAmount())) {
                return false;
            }
            if (!Objects.equals(this.minimumNotionalAmount, _that.getMinimumNotionalAmount())) {
                return false;
            }
            return Objects.equals(this.minimumNumberOfOptions, _that.getMinimumNumberOfOptions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            _result = 31 * _result + (this.integralMultipleAmount != null ? this.integralMultipleAmount.hashCode() : 0);
            _result = 31 * _result + (this.minimumNotionalAmount != null ? this.minimumNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.minimumNumberOfOptions != null ? this.minimumNumberOfOptions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartialExerciseModelBuilder {notionalReference=" + this.notionalReference + ", integralMultipleAmount=" + this.integralMultipleAmount + ", minimumNotionalAmount=" + this.minimumNotionalAmount + ", minimumNumberOfOptions=" + this.minimumNumberOfOptions + '}';
        }
    }

    public static interface PartialExerciseModelBuilder
    extends PartialExerciseModel,
    RosettaModelObjectBuilder {
        public NotionalReference.NotionalReferenceBuilder getOrCreateNotionalReference(int var1);

        public List<? extends NotionalReference.NotionalReferenceBuilder> getNotionalReference();

        public PartialExerciseModelBuilder addNotionalReference(NotionalReference var1);

        public PartialExerciseModelBuilder addNotionalReference(NotionalReference var1, int var2);

        public PartialExerciseModelBuilder addNotionalReference(List<? extends NotionalReference> var1);

        public PartialExerciseModelBuilder setNotionalReference(List<? extends NotionalReference> var1);

        public PartialExerciseModelBuilder setIntegralMultipleAmount(BigDecimal var1);

        public PartialExerciseModelBuilder setMinimumNotionalAmount(BigDecimal var1);

        public PartialExerciseModelBuilder setMinimumNumberOfOptions(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("notionalReference"), processor, NotionalReference.NotionalReferenceBuilder.class, this.getNotionalReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("integralMultipleAmount"), BigDecimal.class, (Object)this.getIntegralMultipleAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("minimumNotionalAmount"), BigDecimal.class, (Object)this.getMinimumNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("minimumNumberOfOptions"), BigDecimal.class, (Object)this.getMinimumNumberOfOptions(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PartialExerciseModelBuilder prune();
    }

    public static class PartialExerciseModelImpl
    implements PartialExerciseModel {
        private final List<? extends NotionalReference> notionalReference;
        private final BigDecimal integralMultipleAmount;
        private final BigDecimal minimumNotionalAmount;
        private final BigDecimal minimumNumberOfOptions;

        protected PartialExerciseModelImpl(PartialExerciseModelBuilder builder) {
            this.notionalReference = Optional.ofNullable(builder.getNotionalReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.integralMultipleAmount = builder.getIntegralMultipleAmount();
            this.minimumNotionalAmount = builder.getMinimumNotionalAmount();
            this.minimumNumberOfOptions = builder.getMinimumNumberOfOptions();
        }

        @Override
        @RosettaAttribute(value="notionalReference")
        @RuneAttribute(value="notionalReference")
        public List<? extends NotionalReference> getNotionalReference() {
            return this.notionalReference;
        }

        @Override
        @RosettaAttribute(value="integralMultipleAmount")
        @RuneAttribute(value="integralMultipleAmount")
        public BigDecimal getIntegralMultipleAmount() {
            return this.integralMultipleAmount;
        }

        @Override
        @RosettaAttribute(value="minimumNotionalAmount")
        @RuneAttribute(value="minimumNotionalAmount")
        public BigDecimal getMinimumNotionalAmount() {
            return this.minimumNotionalAmount;
        }

        @Override
        @RosettaAttribute(value="minimumNumberOfOptions")
        @RuneAttribute(value="minimumNumberOfOptions")
        public BigDecimal getMinimumNumberOfOptions() {
            return this.minimumNumberOfOptions;
        }

        @Override
        public PartialExerciseModel build() {
            return this;
        }

        @Override
        public PartialExerciseModelBuilder toBuilder() {
            PartialExerciseModelBuilder builder = PartialExerciseModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartialExerciseModelBuilder builder) {
            Optional.ofNullable(this.getNotionalReference()).ifPresent(builder::setNotionalReference);
            Optional.ofNullable(this.getIntegralMultipleAmount()).ifPresent(builder::setIntegralMultipleAmount);
            Optional.ofNullable(this.getMinimumNotionalAmount()).ifPresent(builder::setMinimumNotionalAmount);
            Optional.ofNullable(this.getMinimumNumberOfOptions()).ifPresent(builder::setMinimumNumberOfOptions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartialExerciseModel _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.notionalReference, _that.getNotionalReference())) {
                return false;
            }
            if (!Objects.equals(this.integralMultipleAmount, _that.getIntegralMultipleAmount())) {
                return false;
            }
            if (!Objects.equals(this.minimumNotionalAmount, _that.getMinimumNotionalAmount())) {
                return false;
            }
            return Objects.equals(this.minimumNumberOfOptions, _that.getMinimumNumberOfOptions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.notionalReference != null ? this.notionalReference.hashCode() : 0);
            _result = 31 * _result + (this.integralMultipleAmount != null ? this.integralMultipleAmount.hashCode() : 0);
            _result = 31 * _result + (this.minimumNotionalAmount != null ? this.minimumNotionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.minimumNumberOfOptions != null ? this.minimumNumberOfOptions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartialExerciseModel {notionalReference=" + this.notionalReference + ", integralMultipleAmount=" + this.integralMultipleAmount + ", minimumNotionalAmount=" + this.minimumNotionalAmount + ", minimumNumberOfOptions=" + this.minimumNumberOfOptions + '}';
        }
    }
}

