/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.EntityId;
import fpml.consolidated.shared.EntityName;
import fpml.consolidated.shared.meta.LegalEntitySequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegalEntitySequence", builder=LegalEntitySequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LegalEntitySequence", model="fpml", builder=LegalEntitySequenceBuilderImpl.class, version="1.1.0")
public interface LegalEntitySequence
extends RosettaModelObject {
    public static final LegalEntitySequenceMeta metaData = new LegalEntitySequenceMeta();

    public EntityName getEntityName();

    public List<? extends EntityId> getEntityId();

    public LegalEntitySequence build();

    public LegalEntitySequenceBuilder toBuilder();

    public static LegalEntitySequenceBuilder builder() {
        return new LegalEntitySequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends LegalEntitySequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegalEntitySequence> getType() {
        return LegalEntitySequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("entityName"), processor, EntityName.class, this.getEntityName(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("entityId"), processor, EntityId.class, this.getEntityId(), new AttributeMeta[0]);
    }

    public static class LegalEntitySequenceBuilderImpl
    implements LegalEntitySequenceBuilder {
        protected EntityName.EntityNameBuilder entityName;
        protected List<EntityId.EntityIdBuilder> entityId = new ArrayList<EntityId.EntityIdBuilder>();

        @Override
        @RosettaAttribute(value="entityName", isRequired=true)
        @RuneAttribute(value="entityName", isRequired=true)
        public EntityName.EntityNameBuilder getEntityName() {
            return this.entityName;
        }

        @Override
        public EntityName.EntityNameBuilder getOrCreateEntityName() {
            EntityName.EntityNameBuilder result = this.entityName != null ? this.entityName : (this.entityName = EntityName.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="entityId")
        @RuneAttribute(value="entityId")
        public List<? extends EntityId.EntityIdBuilder> getEntityId() {
            return this.entityId;
        }

        @Override
        public EntityId.EntityIdBuilder getOrCreateEntityId(int index) {
            if (this.entityId == null) {
                this.entityId = new ArrayList<EntityId.EntityIdBuilder>();
            }
            return (EntityId.EntityIdBuilder)this.getIndex(this.entityId, index, () -> {
                EntityId.EntityIdBuilder newEntityId = EntityId.builder();
                return newEntityId;
            });
        }

        @Override
        @RosettaAttribute(value="entityName", isRequired=true)
        @RuneAttribute(value="entityName", isRequired=true)
        public LegalEntitySequenceBuilder setEntityName(EntityName _entityName) {
            this.entityName = _entityName == null ? null : _entityName.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="entityId")
        @RuneAttribute(value="entityId")
        public LegalEntitySequenceBuilder addEntityId(EntityId _entityId) {
            if (_entityId != null) {
                this.entityId.add(_entityId.toBuilder());
            }
            return this;
        }

        @Override
        public LegalEntitySequenceBuilder addEntityId(EntityId _entityId, int idx) {
            this.getIndex(this.entityId, idx, () -> _entityId.toBuilder());
            return this;
        }

        @Override
        public LegalEntitySequenceBuilder addEntityId(List<? extends EntityId> entityIds) {
            if (entityIds != null) {
                for (EntityId entityId : entityIds) {
                    this.entityId.add(entityId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="entityId")
        public LegalEntitySequenceBuilder setEntityId(List<? extends EntityId> entityIds) {
            this.entityId = entityIds == null ? new ArrayList<EntityId.EntityIdBuilder>() : (List)entityIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalEntitySequence build() {
            return new LegalEntitySequenceImpl(this);
        }

        @Override
        public LegalEntitySequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalEntitySequenceBuilder prune() {
            if (this.entityName != null && !this.entityName.prune().hasData()) {
                this.entityName = null;
            }
            this.entityId = this.entityId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getEntityName() != null && this.getEntityName().hasData()) {
                return true;
            }
            return this.getEntityId() != null && this.getEntityId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LegalEntitySequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LegalEntitySequenceBuilder o = (LegalEntitySequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEntityName(), (RosettaModelObjectBuilder)o.getEntityName(), this::setEntityName);
            merger.mergeRosetta(this.getEntityId(), o.getEntityId(), this::getOrCreateEntityId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalEntitySequence _that = this.getType().cast(o);
            if (!Objects.equals(this.entityName, _that.getEntityName())) {
                return false;
            }
            return ListEquals.listEquals(this.entityId, _that.getEntityId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.entityName != null ? this.entityName.hashCode() : 0);
            _result = 31 * _result + (this.entityId != null ? this.entityId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalEntitySequenceBuilder {entityName=" + this.entityName + ", entityId=" + this.entityId + '}';
        }
    }

    public static interface LegalEntitySequenceBuilder
    extends LegalEntitySequence,
    RosettaModelObjectBuilder {
        public EntityName.EntityNameBuilder getOrCreateEntityName();

        @Override
        public EntityName.EntityNameBuilder getEntityName();

        public EntityId.EntityIdBuilder getOrCreateEntityId(int var1);

        public List<? extends EntityId.EntityIdBuilder> getEntityId();

        public LegalEntitySequenceBuilder setEntityName(EntityName var1);

        public LegalEntitySequenceBuilder addEntityId(EntityId var1);

        public LegalEntitySequenceBuilder addEntityId(EntityId var1, int var2);

        public LegalEntitySequenceBuilder addEntityId(List<? extends EntityId> var1);

        public LegalEntitySequenceBuilder setEntityId(List<? extends EntityId> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("entityName"), processor, EntityName.EntityNameBuilder.class, this.getEntityName(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("entityId"), processor, EntityId.EntityIdBuilder.class, this.getEntityId(), new AttributeMeta[0]);
        }

        public LegalEntitySequenceBuilder prune();
    }

    public static class LegalEntitySequenceImpl
    implements LegalEntitySequence {
        private final EntityName entityName;
        private final List<? extends EntityId> entityId;

        protected LegalEntitySequenceImpl(LegalEntitySequenceBuilder builder) {
            this.entityName = Optional.ofNullable(builder.getEntityName()).map(f -> f.build()).orElse(null);
            this.entityId = Optional.ofNullable(builder.getEntityId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="entityName", isRequired=true)
        @RuneAttribute(value="entityName", isRequired=true)
        public EntityName getEntityName() {
            return this.entityName;
        }

        @Override
        @RosettaAttribute(value="entityId")
        @RuneAttribute(value="entityId")
        public List<? extends EntityId> getEntityId() {
            return this.entityId;
        }

        @Override
        public LegalEntitySequence build() {
            return this;
        }

        @Override
        public LegalEntitySequenceBuilder toBuilder() {
            LegalEntitySequenceBuilder builder = LegalEntitySequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalEntitySequenceBuilder builder) {
            Optional.ofNullable(this.getEntityName()).ifPresent(builder::setEntityName);
            Optional.ofNullable(this.getEntityId()).ifPresent(builder::setEntityId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LegalEntitySequence _that = this.getType().cast(o);
            if (!Objects.equals(this.entityName, _that.getEntityName())) {
                return false;
            }
            return ListEquals.listEquals(this.entityId, _that.getEntityId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.entityName != null ? this.entityName.hashCode() : 0);
            _result = 31 * _result + (this.entityId != null ? this.entityId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LegalEntitySequence {entityName=" + this.entityName + ", entityId=" + this.entityId + '}';
        }
    }
}

