/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Formula;
import fpml.consolidated.shared.meta.FormulaComponentMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FormulaComponent", builder=FormulaComponentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FormulaComponent", model="fpml", builder=FormulaComponentBuilderImpl.class, version="1.1.0")
public interface FormulaComponent
extends RosettaModelObject {
    public static final FormulaComponentMeta metaData = new FormulaComponentMeta();

    public String getComponentDescription();

    public Formula getFormula();

    public String getName();

    public FormulaComponent build();

    public FormulaComponentBuilder toBuilder();

    public static FormulaComponentBuilder builder() {
        return new FormulaComponentBuilderImpl();
    }

    default public RosettaMetaData<? extends FormulaComponent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FormulaComponent> getType() {
        return FormulaComponent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("componentDescription"), String.class, (Object)this.getComponentDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("formula"), processor, Formula.class, this.getFormula(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FormulaComponentBuilderImpl
    implements FormulaComponentBuilder {
        protected String componentDescription;
        protected Formula.FormulaBuilder formula;
        protected String name;

        @Override
        @RosettaAttribute(value="componentDescription")
        @RuneAttribute(value="componentDescription")
        public String getComponentDescription() {
            return this.componentDescription;
        }

        @Override
        @RosettaAttribute(value="formula")
        @RuneAttribute(value="formula")
        public Formula.FormulaBuilder getFormula() {
            return this.formula;
        }

        @Override
        public Formula.FormulaBuilder getOrCreateFormula() {
            Formula.FormulaBuilder result = this.formula != null ? this.formula : (this.formula = Formula.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="componentDescription")
        @RuneAttribute(value="componentDescription")
        public FormulaComponentBuilder setComponentDescription(String _componentDescription) {
            this.componentDescription = _componentDescription == null ? null : _componentDescription;
            return this;
        }

        @Override
        @RosettaAttribute(value="formula")
        @RuneAttribute(value="formula")
        public FormulaComponentBuilder setFormula(Formula _formula) {
            this.formula = _formula == null ? null : _formula.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public FormulaComponentBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        public FormulaComponent build() {
            return new FormulaComponentImpl(this);
        }

        @Override
        public FormulaComponentBuilder toBuilder() {
            return this;
        }

        @Override
        public FormulaComponentBuilder prune() {
            if (this.formula != null && !this.formula.prune().hasData()) {
                this.formula = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getComponentDescription() != null) {
                return true;
            }
            if (this.getFormula() != null && this.getFormula().hasData()) {
                return true;
            }
            return this.getName() != null;
        }

        public FormulaComponentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FormulaComponentBuilder o = (FormulaComponentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFormula(), (RosettaModelObjectBuilder)o.getFormula(), this::setFormula);
            merger.mergeBasic((Object)this.getComponentDescription(), (Object)o.getComponentDescription(), this::setComponentDescription, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FormulaComponent _that = this.getType().cast(o);
            if (!Objects.equals(this.componentDescription, _that.getComponentDescription())) {
                return false;
            }
            if (!Objects.equals(this.formula, _that.getFormula())) {
                return false;
            }
            return Objects.equals(this.name, _that.getName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.componentDescription != null ? this.componentDescription.hashCode() : 0);
            _result = 31 * _result + (this.formula != null ? this.formula.hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FormulaComponentBuilder {componentDescription=" + this.componentDescription + ", formula=" + this.formula + ", name=" + this.name + '}';
        }
    }

    public static interface FormulaComponentBuilder
    extends FormulaComponent,
    RosettaModelObjectBuilder {
        public Formula.FormulaBuilder getOrCreateFormula();

        @Override
        public Formula.FormulaBuilder getFormula();

        public FormulaComponentBuilder setComponentDescription(String var1);

        public FormulaComponentBuilder setFormula(Formula var1);

        public FormulaComponentBuilder setName(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("componentDescription"), String.class, (Object)this.getComponentDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("formula"), processor, Formula.FormulaBuilder.class, this.getFormula(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FormulaComponentBuilder prune();
    }

    public static class FormulaComponentImpl
    implements FormulaComponent {
        private final String componentDescription;
        private final Formula formula;
        private final String name;

        protected FormulaComponentImpl(FormulaComponentBuilder builder) {
            this.componentDescription = builder.getComponentDescription();
            this.formula = Optional.ofNullable(builder.getFormula()).map(f -> f.build()).orElse(null);
            this.name = builder.getName();
        }

        @Override
        @RosettaAttribute(value="componentDescription")
        @RuneAttribute(value="componentDescription")
        public String getComponentDescription() {
            return this.componentDescription;
        }

        @Override
        @RosettaAttribute(value="formula")
        @RuneAttribute(value="formula")
        public Formula getFormula() {
            return this.formula;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        public FormulaComponent build() {
            return this;
        }

        @Override
        public FormulaComponentBuilder toBuilder() {
            FormulaComponentBuilder builder = FormulaComponent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FormulaComponentBuilder builder) {
            Optional.ofNullable(this.getComponentDescription()).ifPresent(builder::setComponentDescription);
            Optional.ofNullable(this.getFormula()).ifPresent(builder::setFormula);
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FormulaComponent _that = this.getType().cast(o);
            if (!Objects.equals(this.componentDescription, _that.getComponentDescription())) {
                return false;
            }
            if (!Objects.equals(this.formula, _that.getFormula())) {
                return false;
            }
            return Objects.equals(this.name, _that.getName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.componentDescription != null ? this.componentDescription.hashCode() : 0);
            _result = 31 * _result + (this.formula != null ? this.formula.hashCode() : 0);
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FormulaComponent {componentDescription=" + this.componentDescription + ", formula=" + this.formula + ", name=" + this.name + '}';
        }
    }
}

