/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.BrokerConfirmation;
import fpml.consolidated.shared.ContractualDefinitions;
import fpml.consolidated.shared.ContractualMatrix;
import fpml.consolidated.shared.ContractualTermsSupplement;
import fpml.consolidated.shared.CreditSupportAgreement;
import fpml.consolidated.shared.MasterAgreement;
import fpml.consolidated.shared.MasterConfirmation;
import fpml.consolidated.shared.OtherAgreement;
import fpml.consolidated.shared.Resource;
import fpml.consolidated.shared.meta.DocumentationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Documentation", builder=DocumentationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Documentation", model="fpml", builder=DocumentationBuilderImpl.class, version="1.1.0")
public interface Documentation
extends RosettaModelObject {
    public static final DocumentationMeta metaData = new DocumentationMeta();

    public MasterAgreement getMasterAgreement();

    public MasterConfirmation getMasterConfirmation();

    public BrokerConfirmation getBrokerConfirmation();

    public List<? extends ContractualDefinitions> getContractualDefinitions();

    public List<? extends ContractualTermsSupplement> getContractualTermsSupplement();

    public List<? extends ContractualMatrix> getContractualMatrix();

    public CreditSupportAgreement getCreditSupportAgreement();

    public List<? extends OtherAgreement> getOtherAgreement();

    public List<? extends Resource> getAttachment();

    public Documentation build();

    public DocumentationBuilder toBuilder();

    public static DocumentationBuilder builder() {
        return new DocumentationBuilderImpl();
    }

    default public RosettaMetaData<? extends Documentation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Documentation> getType() {
        return Documentation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("masterAgreement"), processor, MasterAgreement.class, this.getMasterAgreement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("masterConfirmation"), processor, MasterConfirmation.class, this.getMasterConfirmation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("brokerConfirmation"), processor, BrokerConfirmation.class, this.getBrokerConfirmation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractualDefinitions"), processor, ContractualDefinitions.class, this.getContractualDefinitions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractualTermsSupplement"), processor, ContractualTermsSupplement.class, this.getContractualTermsSupplement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractualMatrix"), processor, ContractualMatrix.class, this.getContractualMatrix(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportAgreement"), processor, CreditSupportAgreement.class, this.getCreditSupportAgreement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherAgreement"), processor, OtherAgreement.class, this.getOtherAgreement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("attachment"), processor, Resource.class, this.getAttachment(), new AttributeMeta[0]);
    }

    public static class DocumentationBuilderImpl
    implements DocumentationBuilder {
        protected MasterAgreement.MasterAgreementBuilder masterAgreement;
        protected MasterConfirmation.MasterConfirmationBuilder masterConfirmation;
        protected BrokerConfirmation.BrokerConfirmationBuilder brokerConfirmation;
        protected List<ContractualDefinitions.ContractualDefinitionsBuilder> contractualDefinitions = new ArrayList<ContractualDefinitions.ContractualDefinitionsBuilder>();
        protected List<ContractualTermsSupplement.ContractualTermsSupplementBuilder> contractualTermsSupplement = new ArrayList<ContractualTermsSupplement.ContractualTermsSupplementBuilder>();
        protected List<ContractualMatrix.ContractualMatrixBuilder> contractualMatrix = new ArrayList<ContractualMatrix.ContractualMatrixBuilder>();
        protected CreditSupportAgreement.CreditSupportAgreementBuilder creditSupportAgreement;
        protected List<OtherAgreement.OtherAgreementBuilder> otherAgreement = new ArrayList<OtherAgreement.OtherAgreementBuilder>();
        protected List<Resource.ResourceBuilder> attachment = new ArrayList<Resource.ResourceBuilder>();

        @Override
        @RosettaAttribute(value="masterAgreement")
        @RuneAttribute(value="masterAgreement")
        public MasterAgreement.MasterAgreementBuilder getMasterAgreement() {
            return this.masterAgreement;
        }

        @Override
        public MasterAgreement.MasterAgreementBuilder getOrCreateMasterAgreement() {
            MasterAgreement.MasterAgreementBuilder result = this.masterAgreement != null ? this.masterAgreement : (this.masterAgreement = MasterAgreement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="masterConfirmation")
        @RuneAttribute(value="masterConfirmation")
        public MasterConfirmation.MasterConfirmationBuilder getMasterConfirmation() {
            return this.masterConfirmation;
        }

        @Override
        public MasterConfirmation.MasterConfirmationBuilder getOrCreateMasterConfirmation() {
            MasterConfirmation.MasterConfirmationBuilder result = this.masterConfirmation != null ? this.masterConfirmation : (this.masterConfirmation = MasterConfirmation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="brokerConfirmation")
        @RuneAttribute(value="brokerConfirmation")
        public BrokerConfirmation.BrokerConfirmationBuilder getBrokerConfirmation() {
            return this.brokerConfirmation;
        }

        @Override
        public BrokerConfirmation.BrokerConfirmationBuilder getOrCreateBrokerConfirmation() {
            BrokerConfirmation.BrokerConfirmationBuilder result = this.brokerConfirmation != null ? this.brokerConfirmation : (this.brokerConfirmation = BrokerConfirmation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractualDefinitions")
        @RuneAttribute(value="contractualDefinitions")
        public List<? extends ContractualDefinitions.ContractualDefinitionsBuilder> getContractualDefinitions() {
            return this.contractualDefinitions;
        }

        @Override
        public ContractualDefinitions.ContractualDefinitionsBuilder getOrCreateContractualDefinitions(int index) {
            if (this.contractualDefinitions == null) {
                this.contractualDefinitions = new ArrayList<ContractualDefinitions.ContractualDefinitionsBuilder>();
            }
            return (ContractualDefinitions.ContractualDefinitionsBuilder)this.getIndex(this.contractualDefinitions, index, () -> {
                ContractualDefinitions.ContractualDefinitionsBuilder newContractualDefinitions = ContractualDefinitions.builder();
                return newContractualDefinitions;
            });
        }

        @Override
        @RosettaAttribute(value="contractualTermsSupplement")
        @RuneAttribute(value="contractualTermsSupplement")
        public List<? extends ContractualTermsSupplement.ContractualTermsSupplementBuilder> getContractualTermsSupplement() {
            return this.contractualTermsSupplement;
        }

        @Override
        public ContractualTermsSupplement.ContractualTermsSupplementBuilder getOrCreateContractualTermsSupplement(int index) {
            if (this.contractualTermsSupplement == null) {
                this.contractualTermsSupplement = new ArrayList<ContractualTermsSupplement.ContractualTermsSupplementBuilder>();
            }
            return (ContractualTermsSupplement.ContractualTermsSupplementBuilder)this.getIndex(this.contractualTermsSupplement, index, () -> {
                ContractualTermsSupplement.ContractualTermsSupplementBuilder newContractualTermsSupplement = ContractualTermsSupplement.builder();
                return newContractualTermsSupplement;
            });
        }

        @Override
        @RosettaAttribute(value="contractualMatrix")
        @RuneAttribute(value="contractualMatrix")
        public List<? extends ContractualMatrix.ContractualMatrixBuilder> getContractualMatrix() {
            return this.contractualMatrix;
        }

        @Override
        public ContractualMatrix.ContractualMatrixBuilder getOrCreateContractualMatrix(int index) {
            if (this.contractualMatrix == null) {
                this.contractualMatrix = new ArrayList<ContractualMatrix.ContractualMatrixBuilder>();
            }
            return (ContractualMatrix.ContractualMatrixBuilder)this.getIndex(this.contractualMatrix, index, () -> {
                ContractualMatrix.ContractualMatrixBuilder newContractualMatrix = ContractualMatrix.builder();
                return newContractualMatrix;
            });
        }

        @Override
        @RosettaAttribute(value="creditSupportAgreement")
        @RuneAttribute(value="creditSupportAgreement")
        public CreditSupportAgreement.CreditSupportAgreementBuilder getCreditSupportAgreement() {
            return this.creditSupportAgreement;
        }

        @Override
        public CreditSupportAgreement.CreditSupportAgreementBuilder getOrCreateCreditSupportAgreement() {
            CreditSupportAgreement.CreditSupportAgreementBuilder result = this.creditSupportAgreement != null ? this.creditSupportAgreement : (this.creditSupportAgreement = CreditSupportAgreement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherAgreement")
        @RuneAttribute(value="otherAgreement")
        public List<? extends OtherAgreement.OtherAgreementBuilder> getOtherAgreement() {
            return this.otherAgreement;
        }

        @Override
        public OtherAgreement.OtherAgreementBuilder getOrCreateOtherAgreement(int index) {
            if (this.otherAgreement == null) {
                this.otherAgreement = new ArrayList<OtherAgreement.OtherAgreementBuilder>();
            }
            return (OtherAgreement.OtherAgreementBuilder)this.getIndex(this.otherAgreement, index, () -> {
                OtherAgreement.OtherAgreementBuilder newOtherAgreement = OtherAgreement.builder();
                return newOtherAgreement;
            });
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public List<? extends Resource.ResourceBuilder> getAttachment() {
            return this.attachment;
        }

        @Override
        public Resource.ResourceBuilder getOrCreateAttachment(int index) {
            if (this.attachment == null) {
                this.attachment = new ArrayList<Resource.ResourceBuilder>();
            }
            return (Resource.ResourceBuilder)this.getIndex(this.attachment, index, () -> {
                Resource.ResourceBuilder newAttachment = Resource.builder();
                return newAttachment;
            });
        }

        @Override
        @RosettaAttribute(value="masterAgreement")
        @RuneAttribute(value="masterAgreement")
        public DocumentationBuilder setMasterAgreement(MasterAgreement _masterAgreement) {
            this.masterAgreement = _masterAgreement == null ? null : _masterAgreement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="masterConfirmation")
        @RuneAttribute(value="masterConfirmation")
        public DocumentationBuilder setMasterConfirmation(MasterConfirmation _masterConfirmation) {
            this.masterConfirmation = _masterConfirmation == null ? null : _masterConfirmation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerConfirmation")
        @RuneAttribute(value="brokerConfirmation")
        public DocumentationBuilder setBrokerConfirmation(BrokerConfirmation _brokerConfirmation) {
            this.brokerConfirmation = _brokerConfirmation == null ? null : _brokerConfirmation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractualDefinitions")
        @RuneAttribute(value="contractualDefinitions")
        public DocumentationBuilder addContractualDefinitions(ContractualDefinitions _contractualDefinitions) {
            if (_contractualDefinitions != null) {
                this.contractualDefinitions.add(_contractualDefinitions.toBuilder());
            }
            return this;
        }

        @Override
        public DocumentationBuilder addContractualDefinitions(ContractualDefinitions _contractualDefinitions, int idx) {
            this.getIndex(this.contractualDefinitions, idx, () -> _contractualDefinitions.toBuilder());
            return this;
        }

        @Override
        public DocumentationBuilder addContractualDefinitions(List<? extends ContractualDefinitions> contractualDefinitionss) {
            if (contractualDefinitionss != null) {
                for (ContractualDefinitions contractualDefinitions : contractualDefinitionss) {
                    this.contractualDefinitions.add(contractualDefinitions.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractualDefinitions")
        public DocumentationBuilder setContractualDefinitions(List<? extends ContractualDefinitions> contractualDefinitionss) {
            this.contractualDefinitions = contractualDefinitionss == null ? new ArrayList<ContractualDefinitions.ContractualDefinitionsBuilder>() : (List)contractualDefinitionss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="contractualTermsSupplement")
        @RuneAttribute(value="contractualTermsSupplement")
        public DocumentationBuilder addContractualTermsSupplement(ContractualTermsSupplement _contractualTermsSupplement) {
            if (_contractualTermsSupplement != null) {
                this.contractualTermsSupplement.add(_contractualTermsSupplement.toBuilder());
            }
            return this;
        }

        @Override
        public DocumentationBuilder addContractualTermsSupplement(ContractualTermsSupplement _contractualTermsSupplement, int idx) {
            this.getIndex(this.contractualTermsSupplement, idx, () -> _contractualTermsSupplement.toBuilder());
            return this;
        }

        @Override
        public DocumentationBuilder addContractualTermsSupplement(List<? extends ContractualTermsSupplement> contractualTermsSupplements) {
            if (contractualTermsSupplements != null) {
                for (ContractualTermsSupplement contractualTermsSupplement : contractualTermsSupplements) {
                    this.contractualTermsSupplement.add(contractualTermsSupplement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractualTermsSupplement")
        public DocumentationBuilder setContractualTermsSupplement(List<? extends ContractualTermsSupplement> contractualTermsSupplements) {
            this.contractualTermsSupplement = contractualTermsSupplements == null ? new ArrayList<ContractualTermsSupplement.ContractualTermsSupplementBuilder>() : (List)contractualTermsSupplements.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="contractualMatrix")
        @RuneAttribute(value="contractualMatrix")
        public DocumentationBuilder addContractualMatrix(ContractualMatrix _contractualMatrix) {
            if (_contractualMatrix != null) {
                this.contractualMatrix.add(_contractualMatrix.toBuilder());
            }
            return this;
        }

        @Override
        public DocumentationBuilder addContractualMatrix(ContractualMatrix _contractualMatrix, int idx) {
            this.getIndex(this.contractualMatrix, idx, () -> _contractualMatrix.toBuilder());
            return this;
        }

        @Override
        public DocumentationBuilder addContractualMatrix(List<? extends ContractualMatrix> contractualMatrixs) {
            if (contractualMatrixs != null) {
                for (ContractualMatrix contractualMatrix : contractualMatrixs) {
                    this.contractualMatrix.add(contractualMatrix.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractualMatrix")
        public DocumentationBuilder setContractualMatrix(List<? extends ContractualMatrix> contractualMatrixs) {
            this.contractualMatrix = contractualMatrixs == null ? new ArrayList<ContractualMatrix.ContractualMatrixBuilder>() : (List)contractualMatrixs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportAgreement")
        @RuneAttribute(value="creditSupportAgreement")
        public DocumentationBuilder setCreditSupportAgreement(CreditSupportAgreement _creditSupportAgreement) {
            this.creditSupportAgreement = _creditSupportAgreement == null ? null : _creditSupportAgreement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherAgreement")
        @RuneAttribute(value="otherAgreement")
        public DocumentationBuilder addOtherAgreement(OtherAgreement _otherAgreement) {
            if (_otherAgreement != null) {
                this.otherAgreement.add(_otherAgreement.toBuilder());
            }
            return this;
        }

        @Override
        public DocumentationBuilder addOtherAgreement(OtherAgreement _otherAgreement, int idx) {
            this.getIndex(this.otherAgreement, idx, () -> _otherAgreement.toBuilder());
            return this;
        }

        @Override
        public DocumentationBuilder addOtherAgreement(List<? extends OtherAgreement> otherAgreements) {
            if (otherAgreements != null) {
                for (OtherAgreement otherAgreement : otherAgreements) {
                    this.otherAgreement.add(otherAgreement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherAgreement")
        public DocumentationBuilder setOtherAgreement(List<? extends OtherAgreement> otherAgreements) {
            this.otherAgreement = otherAgreements == null ? new ArrayList<OtherAgreement.OtherAgreementBuilder>() : (List)otherAgreements.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public DocumentationBuilder addAttachment(Resource _attachment) {
            if (_attachment != null) {
                this.attachment.add(_attachment.toBuilder());
            }
            return this;
        }

        @Override
        public DocumentationBuilder addAttachment(Resource _attachment, int idx) {
            this.getIndex(this.attachment, idx, () -> _attachment.toBuilder());
            return this;
        }

        @Override
        public DocumentationBuilder addAttachment(List<? extends Resource> attachments) {
            if (attachments != null) {
                for (Resource resource : attachments) {
                    this.attachment.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="attachment")
        public DocumentationBuilder setAttachment(List<? extends Resource> attachments) {
            this.attachment = attachments == null ? new ArrayList<Resource.ResourceBuilder>() : (List)attachments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Documentation build() {
            return new DocumentationImpl(this);
        }

        @Override
        public DocumentationBuilder toBuilder() {
            return this;
        }

        @Override
        public DocumentationBuilder prune() {
            if (this.masterAgreement != null && !this.masterAgreement.prune().hasData()) {
                this.masterAgreement = null;
            }
            if (this.masterConfirmation != null && !this.masterConfirmation.prune().hasData()) {
                this.masterConfirmation = null;
            }
            if (this.brokerConfirmation != null && !this.brokerConfirmation.prune().hasData()) {
                this.brokerConfirmation = null;
            }
            this.contractualDefinitions = this.contractualDefinitions.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.contractualTermsSupplement = this.contractualTermsSupplement.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.contractualMatrix = this.contractualMatrix.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.creditSupportAgreement != null && !this.creditSupportAgreement.prune().hasData()) {
                this.creditSupportAgreement = null;
            }
            this.otherAgreement = this.otherAgreement.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.attachment = this.attachment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getMasterAgreement() != null && this.getMasterAgreement().hasData()) {
                return true;
            }
            if (this.getMasterConfirmation() != null && this.getMasterConfirmation().hasData()) {
                return true;
            }
            if (this.getBrokerConfirmation() != null && this.getBrokerConfirmation().hasData()) {
                return true;
            }
            if (this.getContractualDefinitions() != null && this.getContractualDefinitions().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getContractualTermsSupplement() != null && this.getContractualTermsSupplement().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getContractualMatrix() != null && this.getContractualMatrix().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCreditSupportAgreement() != null && this.getCreditSupportAgreement().hasData()) {
                return true;
            }
            if (this.getOtherAgreement() != null && this.getOtherAgreement().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAttachment() != null && this.getAttachment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public DocumentationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DocumentationBuilder o = (DocumentationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMasterAgreement(), (RosettaModelObjectBuilder)o.getMasterAgreement(), this::setMasterAgreement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMasterConfirmation(), (RosettaModelObjectBuilder)o.getMasterConfirmation(), this::setMasterConfirmation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBrokerConfirmation(), (RosettaModelObjectBuilder)o.getBrokerConfirmation(), this::setBrokerConfirmation);
            merger.mergeRosetta(this.getContractualDefinitions(), o.getContractualDefinitions(), this::getOrCreateContractualDefinitions);
            merger.mergeRosetta(this.getContractualTermsSupplement(), o.getContractualTermsSupplement(), this::getOrCreateContractualTermsSupplement);
            merger.mergeRosetta(this.getContractualMatrix(), o.getContractualMatrix(), this::getOrCreateContractualMatrix);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditSupportAgreement(), (RosettaModelObjectBuilder)o.getCreditSupportAgreement(), this::setCreditSupportAgreement);
            merger.mergeRosetta(this.getOtherAgreement(), o.getOtherAgreement(), this::getOrCreateOtherAgreement);
            merger.mergeRosetta(this.getAttachment(), o.getAttachment(), this::getOrCreateAttachment);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Documentation _that = this.getType().cast(o);
            if (!Objects.equals(this.masterAgreement, _that.getMasterAgreement())) {
                return false;
            }
            if (!Objects.equals(this.masterConfirmation, _that.getMasterConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.brokerConfirmation, _that.getBrokerConfirmation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualDefinitions, _that.getContractualDefinitions())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualTermsSupplement, _that.getContractualTermsSupplement())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualMatrix, _that.getContractualMatrix())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportAgreement, _that.getCreditSupportAgreement())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherAgreement, _that.getOtherAgreement())) {
                return false;
            }
            return ListEquals.listEquals(this.attachment, _that.getAttachment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.masterAgreement != null ? this.masterAgreement.hashCode() : 0);
            _result = 31 * _result + (this.masterConfirmation != null ? this.masterConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.brokerConfirmation != null ? this.brokerConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.contractualDefinitions != null ? this.contractualDefinitions.hashCode() : 0);
            _result = 31 * _result + (this.contractualTermsSupplement != null ? this.contractualTermsSupplement.hashCode() : 0);
            _result = 31 * _result + (this.contractualMatrix != null ? this.contractualMatrix.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportAgreement != null ? this.creditSupportAgreement.hashCode() : 0);
            _result = 31 * _result + (this.otherAgreement != null ? this.otherAgreement.hashCode() : 0);
            _result = 31 * _result + (this.attachment != null ? this.attachment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DocumentationBuilder {masterAgreement=" + this.masterAgreement + ", masterConfirmation=" + this.masterConfirmation + ", brokerConfirmation=" + this.brokerConfirmation + ", contractualDefinitions=" + this.contractualDefinitions + ", contractualTermsSupplement=" + this.contractualTermsSupplement + ", contractualMatrix=" + this.contractualMatrix + ", creditSupportAgreement=" + this.creditSupportAgreement + ", otherAgreement=" + this.otherAgreement + ", attachment=" + this.attachment + '}';
        }
    }

    public static interface DocumentationBuilder
    extends Documentation,
    RosettaModelObjectBuilder {
        public MasterAgreement.MasterAgreementBuilder getOrCreateMasterAgreement();

        @Override
        public MasterAgreement.MasterAgreementBuilder getMasterAgreement();

        public MasterConfirmation.MasterConfirmationBuilder getOrCreateMasterConfirmation();

        @Override
        public MasterConfirmation.MasterConfirmationBuilder getMasterConfirmation();

        public BrokerConfirmation.BrokerConfirmationBuilder getOrCreateBrokerConfirmation();

        @Override
        public BrokerConfirmation.BrokerConfirmationBuilder getBrokerConfirmation();

        public ContractualDefinitions.ContractualDefinitionsBuilder getOrCreateContractualDefinitions(int var1);

        public List<? extends ContractualDefinitions.ContractualDefinitionsBuilder> getContractualDefinitions();

        public ContractualTermsSupplement.ContractualTermsSupplementBuilder getOrCreateContractualTermsSupplement(int var1);

        public List<? extends ContractualTermsSupplement.ContractualTermsSupplementBuilder> getContractualTermsSupplement();

        public ContractualMatrix.ContractualMatrixBuilder getOrCreateContractualMatrix(int var1);

        public List<? extends ContractualMatrix.ContractualMatrixBuilder> getContractualMatrix();

        public CreditSupportAgreement.CreditSupportAgreementBuilder getOrCreateCreditSupportAgreement();

        @Override
        public CreditSupportAgreement.CreditSupportAgreementBuilder getCreditSupportAgreement();

        public OtherAgreement.OtherAgreementBuilder getOrCreateOtherAgreement(int var1);

        public List<? extends OtherAgreement.OtherAgreementBuilder> getOtherAgreement();

        public Resource.ResourceBuilder getOrCreateAttachment(int var1);

        public List<? extends Resource.ResourceBuilder> getAttachment();

        public DocumentationBuilder setMasterAgreement(MasterAgreement var1);

        public DocumentationBuilder setMasterConfirmation(MasterConfirmation var1);

        public DocumentationBuilder setBrokerConfirmation(BrokerConfirmation var1);

        public DocumentationBuilder addContractualDefinitions(ContractualDefinitions var1);

        public DocumentationBuilder addContractualDefinitions(ContractualDefinitions var1, int var2);

        public DocumentationBuilder addContractualDefinitions(List<? extends ContractualDefinitions> var1);

        public DocumentationBuilder setContractualDefinitions(List<? extends ContractualDefinitions> var1);

        public DocumentationBuilder addContractualTermsSupplement(ContractualTermsSupplement var1);

        public DocumentationBuilder addContractualTermsSupplement(ContractualTermsSupplement var1, int var2);

        public DocumentationBuilder addContractualTermsSupplement(List<? extends ContractualTermsSupplement> var1);

        public DocumentationBuilder setContractualTermsSupplement(List<? extends ContractualTermsSupplement> var1);

        public DocumentationBuilder addContractualMatrix(ContractualMatrix var1);

        public DocumentationBuilder addContractualMatrix(ContractualMatrix var1, int var2);

        public DocumentationBuilder addContractualMatrix(List<? extends ContractualMatrix> var1);

        public DocumentationBuilder setContractualMatrix(List<? extends ContractualMatrix> var1);

        public DocumentationBuilder setCreditSupportAgreement(CreditSupportAgreement var1);

        public DocumentationBuilder addOtherAgreement(OtherAgreement var1);

        public DocumentationBuilder addOtherAgreement(OtherAgreement var1, int var2);

        public DocumentationBuilder addOtherAgreement(List<? extends OtherAgreement> var1);

        public DocumentationBuilder setOtherAgreement(List<? extends OtherAgreement> var1);

        public DocumentationBuilder addAttachment(Resource var1);

        public DocumentationBuilder addAttachment(Resource var1, int var2);

        public DocumentationBuilder addAttachment(List<? extends Resource> var1);

        public DocumentationBuilder setAttachment(List<? extends Resource> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("masterAgreement"), processor, MasterAgreement.MasterAgreementBuilder.class, this.getMasterAgreement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("masterConfirmation"), processor, MasterConfirmation.MasterConfirmationBuilder.class, this.getMasterConfirmation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("brokerConfirmation"), processor, BrokerConfirmation.BrokerConfirmationBuilder.class, this.getBrokerConfirmation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractualDefinitions"), processor, ContractualDefinitions.ContractualDefinitionsBuilder.class, this.getContractualDefinitions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractualTermsSupplement"), processor, ContractualTermsSupplement.ContractualTermsSupplementBuilder.class, this.getContractualTermsSupplement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractualMatrix"), processor, ContractualMatrix.ContractualMatrixBuilder.class, this.getContractualMatrix(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportAgreement"), processor, CreditSupportAgreement.CreditSupportAgreementBuilder.class, this.getCreditSupportAgreement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherAgreement"), processor, OtherAgreement.OtherAgreementBuilder.class, this.getOtherAgreement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("attachment"), processor, Resource.ResourceBuilder.class, this.getAttachment(), new AttributeMeta[0]);
        }

        public DocumentationBuilder prune();
    }

    public static class DocumentationImpl
    implements Documentation {
        private final MasterAgreement masterAgreement;
        private final MasterConfirmation masterConfirmation;
        private final BrokerConfirmation brokerConfirmation;
        private final List<? extends ContractualDefinitions> contractualDefinitions;
        private final List<? extends ContractualTermsSupplement> contractualTermsSupplement;
        private final List<? extends ContractualMatrix> contractualMatrix;
        private final CreditSupportAgreement creditSupportAgreement;
        private final List<? extends OtherAgreement> otherAgreement;
        private final List<? extends Resource> attachment;

        protected DocumentationImpl(DocumentationBuilder builder) {
            this.masterAgreement = Optional.ofNullable(builder.getMasterAgreement()).map(f -> f.build()).orElse(null);
            this.masterConfirmation = Optional.ofNullable(builder.getMasterConfirmation()).map(f -> f.build()).orElse(null);
            this.brokerConfirmation = Optional.ofNullable(builder.getBrokerConfirmation()).map(f -> f.build()).orElse(null);
            this.contractualDefinitions = Optional.ofNullable(builder.getContractualDefinitions()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.contractualTermsSupplement = Optional.ofNullable(builder.getContractualTermsSupplement()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.contractualMatrix = Optional.ofNullable(builder.getContractualMatrix()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.creditSupportAgreement = Optional.ofNullable(builder.getCreditSupportAgreement()).map(f -> f.build()).orElse(null);
            this.otherAgreement = Optional.ofNullable(builder.getOtherAgreement()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.attachment = Optional.ofNullable(builder.getAttachment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="masterAgreement")
        @RuneAttribute(value="masterAgreement")
        public MasterAgreement getMasterAgreement() {
            return this.masterAgreement;
        }

        @Override
        @RosettaAttribute(value="masterConfirmation")
        @RuneAttribute(value="masterConfirmation")
        public MasterConfirmation getMasterConfirmation() {
            return this.masterConfirmation;
        }

        @Override
        @RosettaAttribute(value="brokerConfirmation")
        @RuneAttribute(value="brokerConfirmation")
        public BrokerConfirmation getBrokerConfirmation() {
            return this.brokerConfirmation;
        }

        @Override
        @RosettaAttribute(value="contractualDefinitions")
        @RuneAttribute(value="contractualDefinitions")
        public List<? extends ContractualDefinitions> getContractualDefinitions() {
            return this.contractualDefinitions;
        }

        @Override
        @RosettaAttribute(value="contractualTermsSupplement")
        @RuneAttribute(value="contractualTermsSupplement")
        public List<? extends ContractualTermsSupplement> getContractualTermsSupplement() {
            return this.contractualTermsSupplement;
        }

        @Override
        @RosettaAttribute(value="contractualMatrix")
        @RuneAttribute(value="contractualMatrix")
        public List<? extends ContractualMatrix> getContractualMatrix() {
            return this.contractualMatrix;
        }

        @Override
        @RosettaAttribute(value="creditSupportAgreement")
        @RuneAttribute(value="creditSupportAgreement")
        public CreditSupportAgreement getCreditSupportAgreement() {
            return this.creditSupportAgreement;
        }

        @Override
        @RosettaAttribute(value="otherAgreement")
        @RuneAttribute(value="otherAgreement")
        public List<? extends OtherAgreement> getOtherAgreement() {
            return this.otherAgreement;
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public List<? extends Resource> getAttachment() {
            return this.attachment;
        }

        @Override
        public Documentation build() {
            return this;
        }

        @Override
        public DocumentationBuilder toBuilder() {
            DocumentationBuilder builder = Documentation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DocumentationBuilder builder) {
            Optional.ofNullable(this.getMasterAgreement()).ifPresent(builder::setMasterAgreement);
            Optional.ofNullable(this.getMasterConfirmation()).ifPresent(builder::setMasterConfirmation);
            Optional.ofNullable(this.getBrokerConfirmation()).ifPresent(builder::setBrokerConfirmation);
            Optional.ofNullable(this.getContractualDefinitions()).ifPresent(builder::setContractualDefinitions);
            Optional.ofNullable(this.getContractualTermsSupplement()).ifPresent(builder::setContractualTermsSupplement);
            Optional.ofNullable(this.getContractualMatrix()).ifPresent(builder::setContractualMatrix);
            Optional.ofNullable(this.getCreditSupportAgreement()).ifPresent(builder::setCreditSupportAgreement);
            Optional.ofNullable(this.getOtherAgreement()).ifPresent(builder::setOtherAgreement);
            Optional.ofNullable(this.getAttachment()).ifPresent(builder::setAttachment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Documentation _that = this.getType().cast(o);
            if (!Objects.equals(this.masterAgreement, _that.getMasterAgreement())) {
                return false;
            }
            if (!Objects.equals(this.masterConfirmation, _that.getMasterConfirmation())) {
                return false;
            }
            if (!Objects.equals(this.brokerConfirmation, _that.getBrokerConfirmation())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualDefinitions, _that.getContractualDefinitions())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualTermsSupplement, _that.getContractualTermsSupplement())) {
                return false;
            }
            if (!ListEquals.listEquals(this.contractualMatrix, _that.getContractualMatrix())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportAgreement, _that.getCreditSupportAgreement())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otherAgreement, _that.getOtherAgreement())) {
                return false;
            }
            return ListEquals.listEquals(this.attachment, _that.getAttachment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.masterAgreement != null ? this.masterAgreement.hashCode() : 0);
            _result = 31 * _result + (this.masterConfirmation != null ? this.masterConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.brokerConfirmation != null ? this.brokerConfirmation.hashCode() : 0);
            _result = 31 * _result + (this.contractualDefinitions != null ? this.contractualDefinitions.hashCode() : 0);
            _result = 31 * _result + (this.contractualTermsSupplement != null ? this.contractualTermsSupplement.hashCode() : 0);
            _result = 31 * _result + (this.contractualMatrix != null ? this.contractualMatrix.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportAgreement != null ? this.creditSupportAgreement.hashCode() : 0);
            _result = 31 * _result + (this.otherAgreement != null ? this.otherAgreement.hashCode() : 0);
            _result = 31 * _result + (this.attachment != null ? this.attachment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Documentation {masterAgreement=" + this.masterAgreement + ", masterConfirmation=" + this.masterConfirmation + ", brokerConfirmation=" + this.brokerConfirmation + ", contractualDefinitions=" + this.contractualDefinitions + ", contractualTermsSupplement=" + this.contractualTermsSupplement + ", contractualMatrix=" + this.contractualMatrix + ", creditSupportAgreement=" + this.creditSupportAgreement + ", otherAgreement=" + this.otherAgreement + ", attachment=" + this.attachment + '}';
        }
    }
}

