/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.IndependentAmount;
import fpml.consolidated.shared.meta.CollateralMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Collateral", builder=CollateralBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Collateral", model="fpml", builder=CollateralBuilderImpl.class, version="1.1.0")
public interface Collateral
extends RosettaModelObject {
    public static final CollateralMeta metaData = new CollateralMeta();

    public List<? extends IndependentAmount> getIndependentAmount();

    public Collateral build();

    public CollateralBuilder toBuilder();

    public static CollateralBuilder builder() {
        return new CollateralBuilderImpl();
    }

    default public RosettaMetaData<? extends Collateral> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Collateral> getType() {
        return Collateral.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("independentAmount"), processor, IndependentAmount.class, this.getIndependentAmount(), new AttributeMeta[0]);
    }

    public static class CollateralBuilderImpl
    implements CollateralBuilder {
        protected List<IndependentAmount.IndependentAmountBuilder> independentAmount = new ArrayList<IndependentAmount.IndependentAmountBuilder>();

        @Override
        @RosettaAttribute(value="independentAmount")
        @RuneAttribute(value="independentAmount")
        public List<? extends IndependentAmount.IndependentAmountBuilder> getIndependentAmount() {
            return this.independentAmount;
        }

        @Override
        public IndependentAmount.IndependentAmountBuilder getOrCreateIndependentAmount(int index) {
            if (this.independentAmount == null) {
                this.independentAmount = new ArrayList<IndependentAmount.IndependentAmountBuilder>();
            }
            return (IndependentAmount.IndependentAmountBuilder)this.getIndex(this.independentAmount, index, () -> {
                IndependentAmount.IndependentAmountBuilder newIndependentAmount = IndependentAmount.builder();
                return newIndependentAmount;
            });
        }

        @Override
        @RosettaAttribute(value="independentAmount")
        @RuneAttribute(value="independentAmount")
        public CollateralBuilder addIndependentAmount(IndependentAmount _independentAmount) {
            if (_independentAmount != null) {
                this.independentAmount.add(_independentAmount.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralBuilder addIndependentAmount(IndependentAmount _independentAmount, int idx) {
            this.getIndex(this.independentAmount, idx, () -> _independentAmount.toBuilder());
            return this;
        }

        @Override
        public CollateralBuilder addIndependentAmount(List<? extends IndependentAmount> independentAmounts) {
            if (independentAmounts != null) {
                for (IndependentAmount independentAmount : independentAmounts) {
                    this.independentAmount.add(independentAmount.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="independentAmount")
        public CollateralBuilder setIndependentAmount(List<? extends IndependentAmount> independentAmounts) {
            this.independentAmount = independentAmounts == null ? new ArrayList<IndependentAmount.IndependentAmountBuilder>() : (List)independentAmounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Collateral build() {
            return new CollateralImpl(this);
        }

        @Override
        public CollateralBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralBuilder prune() {
            this.independentAmount = this.independentAmount.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getIndependentAmount() != null && this.getIndependentAmount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CollateralBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralBuilder o = (CollateralBuilder)other;
            merger.mergeRosetta(this.getIndependentAmount(), o.getIndependentAmount(), this::getOrCreateIndependentAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Collateral _that = this.getType().cast(o);
            return ListEquals.listEquals(this.independentAmount, _that.getIndependentAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.independentAmount != null ? this.independentAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralBuilder {independentAmount=" + this.independentAmount + '}';
        }
    }

    public static interface CollateralBuilder
    extends Collateral,
    RosettaModelObjectBuilder {
        public IndependentAmount.IndependentAmountBuilder getOrCreateIndependentAmount(int var1);

        public List<? extends IndependentAmount.IndependentAmountBuilder> getIndependentAmount();

        public CollateralBuilder addIndependentAmount(IndependentAmount var1);

        public CollateralBuilder addIndependentAmount(IndependentAmount var1, int var2);

        public CollateralBuilder addIndependentAmount(List<? extends IndependentAmount> var1);

        public CollateralBuilder setIndependentAmount(List<? extends IndependentAmount> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("independentAmount"), processor, IndependentAmount.IndependentAmountBuilder.class, this.getIndependentAmount(), new AttributeMeta[0]);
        }

        public CollateralBuilder prune();
    }

    public static class CollateralImpl
    implements Collateral {
        private final List<? extends IndependentAmount> independentAmount;

        protected CollateralImpl(CollateralBuilder builder) {
            this.independentAmount = Optional.ofNullable(builder.getIndependentAmount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="independentAmount")
        @RuneAttribute(value="independentAmount")
        public List<? extends IndependentAmount> getIndependentAmount() {
            return this.independentAmount;
        }

        @Override
        public Collateral build() {
            return this;
        }

        @Override
        public CollateralBuilder toBuilder() {
            CollateralBuilder builder = Collateral.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralBuilder builder) {
            Optional.ofNullable(this.getIndependentAmount()).ifPresent(builder::setIndependentAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Collateral _that = this.getType().cast(o);
            return ListEquals.listEquals(this.independentAmount, _that.getIndependentAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.independentAmount != null ? this.independentAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Collateral {independentAmount=" + this.independentAmount + '}';
        }
    }
}

