/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Schedule;
import fpml.consolidated.shared.Step;
import fpml.consolidated.shared.meta.AmountScheduleMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AmountSchedule", builder=AmountScheduleBuilderImpl.class, version="1.1.0")
@RuneDataType(value="AmountSchedule", model="fpml", builder=AmountScheduleBuilderImpl.class, version="1.1.0")
public interface AmountSchedule
extends Schedule {
    public static final AmountScheduleMeta metaData = new AmountScheduleMeta();

    public Currency getCurrency();

    @Override
    public AmountSchedule build();

    @Override
    public AmountScheduleBuilder toBuilder();

    public static AmountScheduleBuilder builder() {
        return new AmountScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends AmountSchedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AmountSchedule> getType() {
        return AmountSchedule.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("step"), processor, Step.class, this.getStep(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class AmountScheduleBuilderImpl
    extends Schedule.ScheduleBuilderImpl
    implements AmountScheduleBuilder {
        protected Currency.CurrencyBuilder currency;

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="initialValue", isRequired=true)
        @RuneAttribute(value="initialValue", isRequired=true)
        public AmountScheduleBuilder setInitialValue(BigDecimal _initialValue) {
            this.initialValue = _initialValue == null ? null : _initialValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="step")
        @RuneAttribute(value="step")
        public AmountScheduleBuilder addStep(Step _step) {
            if (_step != null) {
                this.step.add(_step.toBuilder());
            }
            return this;
        }

        @Override
        public AmountScheduleBuilder addStep(Step _step, int idx) {
            this.getIndex(this.step, idx, () -> _step.toBuilder());
            return this;
        }

        @Override
        public AmountScheduleBuilder addStep(List<? extends Step> steps) {
            if (steps != null) {
                for (Step step : steps) {
                    this.step.add(step.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="step")
        public AmountScheduleBuilder setStep(List<? extends Step> steps) {
            this.step = steps == null ? new ArrayList() : (List)steps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public AmountScheduleBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public AmountScheduleBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        public AmountSchedule build() {
            return new AmountScheduleImpl(this);
        }

        @Override
        public AmountScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public AmountScheduleBuilder prune() {
            super.prune();
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getCurrency() != null && this.getCurrency().hasData();
        }

        @Override
        public AmountScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AmountScheduleBuilder o = (AmountScheduleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AmountSchedule _that = (AmountSchedule)this.getType().cast(o);
            return Objects.equals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AmountScheduleBuilder {currency=" + this.currency + '}' + " " + super.toString();
        }
    }

    public static interface AmountScheduleBuilder
    extends AmountSchedule,
    Schedule.ScheduleBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        @Override
        public AmountScheduleBuilder setInitialValue(BigDecimal var1);

        @Override
        public AmountScheduleBuilder addStep(Step var1);

        @Override
        public AmountScheduleBuilder addStep(Step var1, int var2);

        @Override
        public AmountScheduleBuilder addStep(List<? extends Step> var1);

        @Override
        public AmountScheduleBuilder setStep(List<? extends Step> var1);

        @Override
        public AmountScheduleBuilder setId(String var1);

        public AmountScheduleBuilder setCurrency(Currency var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("initialValue"), BigDecimal.class, (Object)this.getInitialValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("step"), processor, Step.StepBuilder.class, this.getStep(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        @Override
        public AmountScheduleBuilder prune();
    }

    public static class AmountScheduleImpl
    extends Schedule.ScheduleImpl
    implements AmountSchedule {
        private final Currency currency;

        protected AmountScheduleImpl(AmountScheduleBuilder builder) {
            super(builder);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        public AmountSchedule build() {
            return this;
        }

        @Override
        public AmountScheduleBuilder toBuilder() {
            AmountScheduleBuilder builder = AmountSchedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AmountScheduleBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AmountSchedule _that = (AmountSchedule)this.getType().cast(o);
            return Objects.equals(this.currency, _that.getCurrency());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AmountSchedule {currency=" + this.currency + '}' + " " + super.toString();
        }
    }
}

