/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.CountryCode;
import fpml.consolidated.shared.StreetAddress;
import fpml.consolidated.shared.meta.AddressMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Address", builder=AddressBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Address", model="fpml", builder=AddressBuilderImpl.class, version="1.1.0")
public interface Address
extends RosettaModelObject {
    public static final AddressMeta metaData = new AddressMeta();

    public StreetAddress getStreetAddress();

    public String getCity();

    public String getState();

    public CountryCode getCountry();

    public String getPostalCode();

    public Address build();

    public AddressBuilder toBuilder();

    public static AddressBuilder builder() {
        return new AddressBuilderImpl();
    }

    default public RosettaMetaData<? extends Address> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Address> getType() {
        return Address.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("streetAddress"), processor, StreetAddress.class, this.getStreetAddress(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("city"), String.class, (Object)this.getCity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("state"), String.class, (Object)this.getState(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("country"), processor, CountryCode.class, this.getCountry(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("postalCode"), String.class, (Object)this.getPostalCode(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AddressBuilderImpl
    implements AddressBuilder {
        protected StreetAddress.StreetAddressBuilder streetAddress;
        protected String city;
        protected String state;
        protected CountryCode.CountryCodeBuilder country;
        protected String postalCode;

        @Override
        @RosettaAttribute(value="streetAddress")
        @RuneAttribute(value="streetAddress")
        public StreetAddress.StreetAddressBuilder getStreetAddress() {
            return this.streetAddress;
        }

        @Override
        public StreetAddress.StreetAddressBuilder getOrCreateStreetAddress() {
            StreetAddress.StreetAddressBuilder result = this.streetAddress != null ? this.streetAddress : (this.streetAddress = StreetAddress.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="city")
        @RuneAttribute(value="city")
        public String getCity() {
            return this.city;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public String getState() {
            return this.state;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode.CountryCodeBuilder getCountry() {
            return this.country;
        }

        @Override
        public CountryCode.CountryCodeBuilder getOrCreateCountry() {
            CountryCode.CountryCodeBuilder result = this.country != null ? this.country : (this.country = CountryCode.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postalCode")
        @RuneAttribute(value="postalCode")
        public String getPostalCode() {
            return this.postalCode;
        }

        @Override
        @RosettaAttribute(value="streetAddress")
        @RuneAttribute(value="streetAddress")
        public AddressBuilder setStreetAddress(StreetAddress _streetAddress) {
            this.streetAddress = _streetAddress == null ? null : _streetAddress.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="city")
        @RuneAttribute(value="city")
        public AddressBuilder setCity(String _city) {
            this.city = _city == null ? null : _city;
            return this;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public AddressBuilder setState(String _state) {
            this.state = _state == null ? null : _state;
            return this;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public AddressBuilder setCountry(CountryCode _country) {
            this.country = _country == null ? null : _country.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postalCode")
        @RuneAttribute(value="postalCode")
        public AddressBuilder setPostalCode(String _postalCode) {
            this.postalCode = _postalCode == null ? null : _postalCode;
            return this;
        }

        @Override
        public Address build() {
            return new AddressImpl(this);
        }

        @Override
        public AddressBuilder toBuilder() {
            return this;
        }

        @Override
        public AddressBuilder prune() {
            if (this.streetAddress != null && !this.streetAddress.prune().hasData()) {
                this.streetAddress = null;
            }
            if (this.country != null && !this.country.prune().hasData()) {
                this.country = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStreetAddress() != null && this.getStreetAddress().hasData()) {
                return true;
            }
            if (this.getCity() != null) {
                return true;
            }
            if (this.getState() != null) {
                return true;
            }
            if (this.getCountry() != null && this.getCountry().hasData()) {
                return true;
            }
            return this.getPostalCode() != null;
        }

        public AddressBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AddressBuilder o = (AddressBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStreetAddress(), (RosettaModelObjectBuilder)o.getStreetAddress(), this::setStreetAddress);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCountry(), (RosettaModelObjectBuilder)o.getCountry(), this::setCountry);
            merger.mergeBasic((Object)this.getCity(), (Object)o.getCity(), this::setCity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getState(), (Object)o.getState(), this::setState, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPostalCode(), (Object)o.getPostalCode(), this::setPostalCode, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Address _that = this.getType().cast(o);
            if (!Objects.equals(this.streetAddress, _that.getStreetAddress())) {
                return false;
            }
            if (!Objects.equals(this.city, _that.getCity())) {
                return false;
            }
            if (!Objects.equals(this.state, _that.getState())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.postalCode, _that.getPostalCode());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.streetAddress != null ? this.streetAddress.hashCode() : 0);
            _result = 31 * _result + (this.city != null ? this.city.hashCode() : 0);
            _result = 31 * _result + (this.state != null ? this.state.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AddressBuilder {streetAddress=" + this.streetAddress + ", city=" + this.city + ", state=" + this.state + ", country=" + this.country + ", postalCode=" + this.postalCode + '}';
        }
    }

    public static interface AddressBuilder
    extends Address,
    RosettaModelObjectBuilder {
        public StreetAddress.StreetAddressBuilder getOrCreateStreetAddress();

        @Override
        public StreetAddress.StreetAddressBuilder getStreetAddress();

        public CountryCode.CountryCodeBuilder getOrCreateCountry();

        @Override
        public CountryCode.CountryCodeBuilder getCountry();

        public AddressBuilder setStreetAddress(StreetAddress var1);

        public AddressBuilder setCity(String var1);

        public AddressBuilder setState(String var1);

        public AddressBuilder setCountry(CountryCode var1);

        public AddressBuilder setPostalCode(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("streetAddress"), processor, StreetAddress.StreetAddressBuilder.class, this.getStreetAddress(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("city"), String.class, (Object)this.getCity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("state"), String.class, (Object)this.getState(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("country"), processor, CountryCode.CountryCodeBuilder.class, this.getCountry(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("postalCode"), String.class, (Object)this.getPostalCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AddressBuilder prune();
    }

    public static class AddressImpl
    implements Address {
        private final StreetAddress streetAddress;
        private final String city;
        private final String state;
        private final CountryCode country;
        private final String postalCode;

        protected AddressImpl(AddressBuilder builder) {
            this.streetAddress = Optional.ofNullable(builder.getStreetAddress()).map(f -> f.build()).orElse(null);
            this.city = builder.getCity();
            this.state = builder.getState();
            this.country = Optional.ofNullable(builder.getCountry()).map(f -> f.build()).orElse(null);
            this.postalCode = builder.getPostalCode();
        }

        @Override
        @RosettaAttribute(value="streetAddress")
        @RuneAttribute(value="streetAddress")
        public StreetAddress getStreetAddress() {
            return this.streetAddress;
        }

        @Override
        @RosettaAttribute(value="city")
        @RuneAttribute(value="city")
        public String getCity() {
            return this.city;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public String getState() {
            return this.state;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public CountryCode getCountry() {
            return this.country;
        }

        @Override
        @RosettaAttribute(value="postalCode")
        @RuneAttribute(value="postalCode")
        public String getPostalCode() {
            return this.postalCode;
        }

        @Override
        public Address build() {
            return this;
        }

        @Override
        public AddressBuilder toBuilder() {
            AddressBuilder builder = Address.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AddressBuilder builder) {
            Optional.ofNullable(this.getStreetAddress()).ifPresent(builder::setStreetAddress);
            Optional.ofNullable(this.getCity()).ifPresent(builder::setCity);
            Optional.ofNullable(this.getState()).ifPresent(builder::setState);
            Optional.ofNullable(this.getCountry()).ifPresent(builder::setCountry);
            Optional.ofNullable(this.getPostalCode()).ifPresent(builder::setPostalCode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Address _that = this.getType().cast(o);
            if (!Objects.equals(this.streetAddress, _that.getStreetAddress())) {
                return false;
            }
            if (!Objects.equals(this.city, _that.getCity())) {
                return false;
            }
            if (!Objects.equals(this.state, _that.getState())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.postalCode, _that.getPostalCode());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.streetAddress != null ? this.streetAddress.hashCode() : 0);
            _result = 31 * _result + (this.city != null ? this.city.hashCode() : 0);
            _result = 31 * _result + (this.state != null ? this.state.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Address {streetAddress=" + this.streetAddress + ", city=" + this.city + ", state=" + this.state + ", country=" + this.country + ", postalCode=" + this.postalCode + '}';
        }
    }
}

