/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.sec.lending;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.sec.lending.SecLendFeeCalculation;
import fpml.consolidated.sec.lending.SecLendRebateCalculation;
import fpml.consolidated.sec.lending.meta.SecurityLendingSequence1Meta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SecurityLendingSequence1", builder=SecurityLendingSequence1BuilderImpl.class, version="1.1.0")
@RuneDataType(value="SecurityLendingSequence1", model="fpml", builder=SecurityLendingSequence1BuilderImpl.class, version="1.1.0")
public interface SecurityLendingSequence1
extends RosettaModelObject {
    public static final SecurityLendingSequence1Meta metaData = new SecurityLendingSequence1Meta();

    public SecLendFeeCalculation getFee();

    public SecLendRebateCalculation getRebate();

    public SecurityLendingSequence1 build();

    public SecurityLendingSequence1Builder toBuilder();

    public static SecurityLendingSequence1Builder builder() {
        return new SecurityLendingSequence1BuilderImpl();
    }

    default public RosettaMetaData<? extends SecurityLendingSequence1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SecurityLendingSequence1> getType() {
        return SecurityLendingSequence1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fee"), processor, SecLendFeeCalculation.class, this.getFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rebate"), processor, SecLendRebateCalculation.class, this.getRebate(), new AttributeMeta[0]);
    }

    public static class SecurityLendingSequence1BuilderImpl
    implements SecurityLendingSequence1Builder {
        protected SecLendFeeCalculation.SecLendFeeCalculationBuilder fee;
        protected SecLendRebateCalculation.SecLendRebateCalculationBuilder rebate;

        @Override
        @RosettaAttribute(value="fee", isRequired=true)
        @RuneAttribute(value="fee", isRequired=true)
        public SecLendFeeCalculation.SecLendFeeCalculationBuilder getFee() {
            return this.fee;
        }

        @Override
        public SecLendFeeCalculation.SecLendFeeCalculationBuilder getOrCreateFee() {
            SecLendFeeCalculation.SecLendFeeCalculationBuilder result = this.fee != null ? this.fee : (this.fee = SecLendFeeCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rebate")
        @RuneAttribute(value="rebate")
        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getRebate() {
            return this.rebate;
        }

        @Override
        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getOrCreateRebate() {
            SecLendRebateCalculation.SecLendRebateCalculationBuilder result = this.rebate != null ? this.rebate : (this.rebate = SecLendRebateCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fee", isRequired=true)
        @RuneAttribute(value="fee", isRequired=true)
        public SecurityLendingSequence1Builder setFee(SecLendFeeCalculation _fee) {
            this.fee = _fee == null ? null : _fee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rebate")
        @RuneAttribute(value="rebate")
        public SecurityLendingSequence1Builder setRebate(SecLendRebateCalculation _rebate) {
            this.rebate = _rebate == null ? null : _rebate.toBuilder();
            return this;
        }

        @Override
        public SecurityLendingSequence1 build() {
            return new SecurityLendingSequence1Impl(this);
        }

        @Override
        public SecurityLendingSequence1Builder toBuilder() {
            return this;
        }

        @Override
        public SecurityLendingSequence1Builder prune() {
            if (this.fee != null && !this.fee.prune().hasData()) {
                this.fee = null;
            }
            if (this.rebate != null && !this.rebate.prune().hasData()) {
                this.rebate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFee() != null && this.getFee().hasData()) {
                return true;
            }
            return this.getRebate() != null && this.getRebate().hasData();
        }

        public SecurityLendingSequence1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SecurityLendingSequence1Builder o = (SecurityLendingSequence1Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFee(), (RosettaModelObjectBuilder)o.getFee(), this::setFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRebate(), (RosettaModelObjectBuilder)o.getRebate(), this::setRebate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityLendingSequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.fee, _that.getFee())) {
                return false;
            }
            return Objects.equals(this.rebate, _that.getRebate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fee != null ? this.fee.hashCode() : 0);
            _result = 31 * _result + (this.rebate != null ? this.rebate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityLendingSequence1Builder {fee=" + this.fee + ", rebate=" + this.rebate + '}';
        }
    }

    public static interface SecurityLendingSequence1Builder
    extends SecurityLendingSequence1,
    RosettaModelObjectBuilder {
        public SecLendFeeCalculation.SecLendFeeCalculationBuilder getOrCreateFee();

        @Override
        public SecLendFeeCalculation.SecLendFeeCalculationBuilder getFee();

        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getOrCreateRebate();

        @Override
        public SecLendRebateCalculation.SecLendRebateCalculationBuilder getRebate();

        public SecurityLendingSequence1Builder setFee(SecLendFeeCalculation var1);

        public SecurityLendingSequence1Builder setRebate(SecLendRebateCalculation var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fee"), processor, SecLendFeeCalculation.SecLendFeeCalculationBuilder.class, this.getFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rebate"), processor, SecLendRebateCalculation.SecLendRebateCalculationBuilder.class, this.getRebate(), new AttributeMeta[0]);
        }

        public SecurityLendingSequence1Builder prune();
    }

    public static class SecurityLendingSequence1Impl
    implements SecurityLendingSequence1 {
        private final SecLendFeeCalculation fee;
        private final SecLendRebateCalculation rebate;

        protected SecurityLendingSequence1Impl(SecurityLendingSequence1Builder builder) {
            this.fee = Optional.ofNullable(builder.getFee()).map(f -> f.build()).orElse(null);
            this.rebate = Optional.ofNullable(builder.getRebate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fee", isRequired=true)
        @RuneAttribute(value="fee", isRequired=true)
        public SecLendFeeCalculation getFee() {
            return this.fee;
        }

        @Override
        @RosettaAttribute(value="rebate")
        @RuneAttribute(value="rebate")
        public SecLendRebateCalculation getRebate() {
            return this.rebate;
        }

        @Override
        public SecurityLendingSequence1 build() {
            return this;
        }

        @Override
        public SecurityLendingSequence1Builder toBuilder() {
            SecurityLendingSequence1Builder builder = SecurityLendingSequence1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityLendingSequence1Builder builder) {
            Optional.ofNullable(this.getFee()).ifPresent(builder::setFee);
            Optional.ofNullable(this.getRebate()).ifPresent(builder::setRebate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityLendingSequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.fee, _that.getFee())) {
                return false;
            }
            return Objects.equals(this.rebate, _that.getRebate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fee != null ? this.fee.hashCode() : 0);
            _result = 31 * _result + (this.rebate != null ? this.rebate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityLendingSequence1 {fee=" + this.fee + ", rebate=" + this.rebate + '}';
        }
    }
}

