/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.riskdef;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.Asset;
import fpml.consolidated.riskdef.meta.InstrumentSetSequenceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InstrumentSetSequence", builder=InstrumentSetSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="InstrumentSetSequence", model="fpml", builder=InstrumentSetSequenceBuilderImpl.class, version="1.1.0")
public interface InstrumentSetSequence
extends RosettaModelObject {
    public static final InstrumentSetSequenceMeta metaData = new InstrumentSetSequenceMeta();

    public Asset getUnderlyingAsset();

    public Asset getCurveInstrument();

    public InstrumentSetSequence build();

    public InstrumentSetSequenceBuilder toBuilder();

    public static InstrumentSetSequenceBuilder builder() {
        return new InstrumentSetSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends InstrumentSetSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InstrumentSetSequence> getType() {
        return InstrumentSetSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("curveInstrument"), processor, Asset.class, this.getCurveInstrument(), new AttributeMeta[0]);
    }

    public static class InstrumentSetSequenceBuilderImpl
    implements InstrumentSetSequenceBuilder {
        protected Asset.AssetBuilder underlyingAsset;
        protected Asset.AssetBuilder curveInstrument;

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public Asset.AssetBuilder getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        public Asset.AssetBuilder getOrCreateUnderlyingAsset() {
            Asset.AssetBuilder result = this.underlyingAsset != null ? this.underlyingAsset : (this.underlyingAsset = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="curveInstrument")
        @RuneAttribute(value="curveInstrument")
        public Asset.AssetBuilder getCurveInstrument() {
            return this.curveInstrument;
        }

        @Override
        public Asset.AssetBuilder getOrCreateCurveInstrument() {
            Asset.AssetBuilder result = this.curveInstrument != null ? this.curveInstrument : (this.curveInstrument = Asset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public InstrumentSetSequenceBuilder setUnderlyingAsset(Asset _underlyingAsset) {
            this.underlyingAsset = _underlyingAsset == null ? null : _underlyingAsset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="curveInstrument")
        @RuneAttribute(value="curveInstrument")
        public InstrumentSetSequenceBuilder setCurveInstrument(Asset _curveInstrument) {
            this.curveInstrument = _curveInstrument == null ? null : _curveInstrument.toBuilder();
            return this;
        }

        @Override
        public InstrumentSetSequence build() {
            return new InstrumentSetSequenceImpl(this);
        }

        @Override
        public InstrumentSetSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public InstrumentSetSequenceBuilder prune() {
            if (this.underlyingAsset != null && !this.underlyingAsset.prune().hasData()) {
                this.underlyingAsset = null;
            }
            if (this.curveInstrument != null && !this.curveInstrument.prune().hasData()) {
                this.curveInstrument = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnderlyingAsset() != null && this.getUnderlyingAsset().hasData()) {
                return true;
            }
            return this.getCurveInstrument() != null && this.getCurveInstrument().hasData();
        }

        public InstrumentSetSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InstrumentSetSequenceBuilder o = (InstrumentSetSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyingAsset(), (RosettaModelObjectBuilder)o.getUnderlyingAsset(), this::setUnderlyingAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurveInstrument(), (RosettaModelObjectBuilder)o.getCurveInstrument(), this::setCurveInstrument);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InstrumentSetSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            return Objects.equals(this.curveInstrument, _that.getCurveInstrument());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.curveInstrument != null ? this.curveInstrument.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InstrumentSetSequenceBuilder {underlyingAsset=" + this.underlyingAsset + ", curveInstrument=" + this.curveInstrument + '}';
        }
    }

    public static interface InstrumentSetSequenceBuilder
    extends InstrumentSetSequence,
    RosettaModelObjectBuilder {
        public Asset.AssetBuilder getOrCreateUnderlyingAsset();

        @Override
        public Asset.AssetBuilder getUnderlyingAsset();

        public Asset.AssetBuilder getOrCreateCurveInstrument();

        @Override
        public Asset.AssetBuilder getCurveInstrument();

        public InstrumentSetSequenceBuilder setUnderlyingAsset(Asset var1);

        public InstrumentSetSequenceBuilder setCurveInstrument(Asset var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("underlyingAsset"), processor, Asset.AssetBuilder.class, this.getUnderlyingAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("curveInstrument"), processor, Asset.AssetBuilder.class, this.getCurveInstrument(), new AttributeMeta[0]);
        }

        public InstrumentSetSequenceBuilder prune();
    }

    public static class InstrumentSetSequenceImpl
    implements InstrumentSetSequence {
        private final Asset underlyingAsset;
        private final Asset curveInstrument;

        protected InstrumentSetSequenceImpl(InstrumentSetSequenceBuilder builder) {
            this.underlyingAsset = Optional.ofNullable(builder.getUnderlyingAsset()).map(f -> f.build()).orElse(null);
            this.curveInstrument = Optional.ofNullable(builder.getCurveInstrument()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="underlyingAsset")
        @RuneAttribute(value="underlyingAsset")
        public Asset getUnderlyingAsset() {
            return this.underlyingAsset;
        }

        @Override
        @RosettaAttribute(value="curveInstrument")
        @RuneAttribute(value="curveInstrument")
        public Asset getCurveInstrument() {
            return this.curveInstrument;
        }

        @Override
        public InstrumentSetSequence build() {
            return this;
        }

        @Override
        public InstrumentSetSequenceBuilder toBuilder() {
            InstrumentSetSequenceBuilder builder = InstrumentSetSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InstrumentSetSequenceBuilder builder) {
            Optional.ofNullable(this.getUnderlyingAsset()).ifPresent(builder::setUnderlyingAsset);
            Optional.ofNullable(this.getCurveInstrument()).ifPresent(builder::setCurveInstrument);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InstrumentSetSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.underlyingAsset, _that.getUnderlyingAsset())) {
                return false;
            }
            return Objects.equals(this.curveInstrument, _that.getCurveInstrument());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.underlyingAsset != null ? this.underlyingAsset.hashCode() : 0);
            _result = 31 * _result + (this.curveInstrument != null ? this.curveInstrument.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InstrumentSetSequence {underlyingAsset=" + this.underlyingAsset + ", curveInstrument=" + this.curveInstrument + '}';
        }
    }
}

