/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.recordkeeping.processes.NonpublicExecutionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="NonpublicExecutionReportChoice")
@ImplementedBy(value=Default.class)
public interface NonpublicExecutionReportChoice
extends Validator<NonpublicExecutionReport> {
    public static final String NAME = "NonpublicExecutionReportChoice";
    public static final String DEFINITION = "optional choice nonpublicExecutionReportSequence, postTradeEventsBaseModel , changeEventsBaseModel , optionsEventsBaseModel , additionalEvent";

    public static class NoOp
    implements NonpublicExecutionReportChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonpublicExecutionReport nonpublicExecutionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements NonpublicExecutionReportChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, NonpublicExecutionReport nonpublicExecutionReport) {
            ComparisonResult result = this.executeDataRule(nonpublicExecutionReport);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)NonpublicExecutionReportChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonpublicExecutionReport", (RosettaPath)path, (String)NonpublicExecutionReportChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)NonpublicExecutionReportChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"NonpublicExecutionReport", (RosettaPath)path, (String)NonpublicExecutionReportChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(NonpublicExecutionReport nonpublicExecutionReport) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)nonpublicExecutionReport), Arrays.asList("nonpublicExecutionReportSequence", "postTradeEventsBaseModel", "changeEventsBaseModel", "optionsEventsBaseModel", "additionalEvent"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

