/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.AllocationReportingStatus;
import fpml.consolidated.doc.ConfirmationMethod;
import fpml.consolidated.doc.EndUserExceptionDeclaration;
import fpml.consolidated.doc.ExecutionType;
import fpml.consolidated.doc.ExecutionVenueType;
import fpml.consolidated.doc.ReportingBoolean;
import fpml.consolidated.doc.TradeCategory;
import fpml.consolidated.doc.VerificationMethod;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassification;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassificationPart45_2019Sequence;
import fpml.consolidated.recordkeeping.processes.ReportingRoleAndPurposeModel;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryClassificationPart45_2019Meta;
import fpml.consolidated.shared.ActionType;
import fpml.consolidated.shared.CollateralizationType;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.RegulatoryBuyerAndSellerModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryClassificationPart45_2019", builder=RegulatoryClassificationPart45_2019BuilderImpl.class, version="1.1.0")
@RuneDataType(value="RegulatoryClassificationPart45_2019", model="fpml", builder=RegulatoryClassificationPart45_2019BuilderImpl.class, version="1.1.0")
public interface RegulatoryClassificationPart45_2019
extends RegulatoryClassification {
    public static final RegulatoryClassificationPart45_2019Meta metaData = new RegulatoryClassificationPart45_2019Meta();

    public List<String> getSupervisoryBody();

    public ReportingRoleAndPurposeModel getReportingRoleAndPurposeModel();

    public RegulatoryBuyerAndSellerModel getRegulatoryBuyerAndSellerModel();

    public ReportingBoolean getMandatorilyClearable();

    public RegulatoryClassificationPart45_2019Sequence getRegulatoryClassificationPart45_2019Sequence();

    public EndUserExceptionDeclaration getEndUserExceptionDeclaration();

    public Boolean getLargeSizeTrade();

    public ExecutionType getExecutionType();

    public ExecutionVenueType getExecutionVenueType();

    public VerificationMethod getVerificationMethod();

    public ConfirmationMethod getConfirmationMethod();

    public CollateralizationType getCollateralizationType();

    public String getReportingPartyOrganizationType();

    public String getCounterPartyOrganizationType();

    public Boolean getCounterPartyIsUsPerson();

    public AllocationReportingStatus getAllocationStatus();

    public TradeCategory getClientAccountType();

    public PartyReference getInterAffiliateClearingExemptionParty();

    public List<String> getReportingPartyClearingExemption();

    public List<String> getCounterPartyClearingExemption();

    public List<String> getCollateralTypeAllowed();

    public Boolean getCollateralPortfolioContainsNonReportableComponents();

    public Boolean getPackageContainsNonReportableComponents();

    public String getSpecialEntityType();

    public ActionType getActionType();

    public String getEventType();

    public Boolean getTradeExecutionRequirementIndicator();

    public ZonedDateTime getLastFloatingReferenceResetDate();

    public ZonedDateTime getNextFloatingReferenceResetDate();

    @Override
    public RegulatoryClassificationPart45_2019 build();

    @Override
    public RegulatoryClassificationPart45_2019Builder toBuilder();

    public static RegulatoryClassificationPart45_2019Builder builder() {
        return new RegulatoryClassificationPart45_2019BuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryClassificationPart45_2019> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryClassificationPart45_2019> getType() {
        return RegulatoryClassificationPart45_2019.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("supervisoryBody"), String.class, this.getSupervisoryBody(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRoleAndPurposeModel"), processor, ReportingRoleAndPurposeModel.class, this.getReportingRoleAndPurposeModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulatoryBuyerAndSellerModel"), processor, RegulatoryBuyerAndSellerModel.class, this.getRegulatoryBuyerAndSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("mandatorilyClearable"), processor, ReportingBoolean.class, this.getMandatorilyClearable(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulatoryClassificationPart45_2019Sequence"), processor, RegulatoryClassificationPart45_2019Sequence.class, this.getRegulatoryClassificationPart45_2019Sequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("endUserExceptionDeclaration"), processor, EndUserExceptionDeclaration.class, this.getEndUserExceptionDeclaration(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionType"), processor, ExecutionType.class, this.getExecutionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.class, this.getExecutionVenueType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("verificationMethod"), processor, VerificationMethod.class, this.getVerificationMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("confirmationMethod"), processor, ConfirmationMethod.class, this.getConfirmationMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralizationType"), processor, CollateralizationType.class, this.getCollateralizationType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingPartyOrganizationType"), String.class, (Object)this.getReportingPartyOrganizationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterPartyOrganizationType"), String.class, (Object)this.getCounterPartyOrganizationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterPartyIsUsPerson"), Boolean.class, (Object)this.getCounterPartyIsUsPerson(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationStatus"), processor, AllocationReportingStatus.class, this.getAllocationStatus(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clientAccountType"), processor, TradeCategory.class, this.getClientAccountType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interAffiliateClearingExemptionParty"), processor, PartyReference.class, this.getInterAffiliateClearingExemptionParty(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingPartyClearingExemption"), String.class, this.getReportingPartyClearingExemption(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterPartyClearingExemption"), String.class, this.getCounterPartyClearingExemption(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTypeAllowed"), String.class, this.getCollateralTypeAllowed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioContainsNonReportableComponents"), Boolean.class, (Object)this.getCollateralPortfolioContainsNonReportableComponents(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageContainsNonReportableComponents"), Boolean.class, (Object)this.getPackageContainsNonReportableComponents(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specialEntityType"), String.class, (Object)this.getSpecialEntityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("actionType"), processor, ActionType.class, this.getActionType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeExecutionRequirementIndicator"), Boolean.class, (Object)this.getTradeExecutionRequirementIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDate"), ZonedDateTime.class, (Object)this.getLastFloatingReferenceResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), ZonedDateTime.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class RegulatoryClassificationPart45_2019BuilderImpl
    extends RegulatoryClassification.RegulatoryClassificationBuilderImpl
    implements RegulatoryClassificationPart45_2019Builder {
        protected List<String> supervisoryBody = new ArrayList<String>();
        protected ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder reportingRoleAndPurposeModel;
        protected RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder regulatoryBuyerAndSellerModel;
        protected ReportingBoolean.ReportingBooleanBuilder mandatorilyClearable;
        protected RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder regulatoryClassificationPart45_2019Sequence;
        protected EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder endUserExceptionDeclaration;
        protected Boolean largeSizeTrade;
        protected ExecutionType.ExecutionTypeBuilder executionType;
        protected ExecutionVenueType.ExecutionVenueTypeBuilder executionVenueType;
        protected VerificationMethod.VerificationMethodBuilder verificationMethod;
        protected ConfirmationMethod.ConfirmationMethodBuilder confirmationMethod;
        protected CollateralizationType.CollateralizationTypeBuilder collateralizationType;
        protected String reportingPartyOrganizationType;
        protected String counterPartyOrganizationType;
        protected Boolean counterPartyIsUsPerson;
        protected AllocationReportingStatus.AllocationReportingStatusBuilder allocationStatus;
        protected TradeCategory.TradeCategoryBuilder clientAccountType;
        protected PartyReference.PartyReferenceBuilder interAffiliateClearingExemptionParty;
        protected List<String> reportingPartyClearingExemption = new ArrayList<String>();
        protected List<String> counterPartyClearingExemption = new ArrayList<String>();
        protected List<String> collateralTypeAllowed = new ArrayList<String>();
        protected Boolean collateralPortfolioContainsNonReportableComponents;
        protected Boolean packageContainsNonReportableComponents;
        protected String specialEntityType;
        protected ActionType.ActionTypeBuilder actionType;
        protected String eventType;
        protected Boolean tradeExecutionRequirementIndicator;
        protected ZonedDateTime lastFloatingReferenceResetDate;
        protected ZonedDateTime nextFloatingReferenceResetDate;

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public List<String> getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getReportingRoleAndPurposeModel() {
            return this.reportingRoleAndPurposeModel;
        }

        @Override
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getOrCreateReportingRoleAndPurposeModel() {
            ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder result = this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel : (this.reportingRoleAndPurposeModel = ReportingRoleAndPurposeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regulatoryBuyerAndSellerModel")
        @RuneAttribute(value="regulatoryBuyerAndSellerModel")
        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getRegulatoryBuyerAndSellerModel() {
            return this.regulatoryBuyerAndSellerModel;
        }

        @Override
        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getOrCreateRegulatoryBuyerAndSellerModel() {
            RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder result = this.regulatoryBuyerAndSellerModel != null ? this.regulatoryBuyerAndSellerModel : (this.regulatoryBuyerAndSellerModel = RegulatoryBuyerAndSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public ReportingBoolean.ReportingBooleanBuilder getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        public ReportingBoolean.ReportingBooleanBuilder getOrCreateMandatorilyClearable() {
            ReportingBoolean.ReportingBooleanBuilder result = this.mandatorilyClearable != null ? this.mandatorilyClearable : (this.mandatorilyClearable = ReportingBoolean.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regulatoryClassificationPart45_2019Sequence")
        @RuneAttribute(value="regulatoryClassificationPart45_2019Sequence")
        public RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder getRegulatoryClassificationPart45_2019Sequence() {
            return this.regulatoryClassificationPart45_2019Sequence;
        }

        @Override
        public RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder getOrCreateRegulatoryClassificationPart45_2019Sequence() {
            RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder result = this.regulatoryClassificationPart45_2019Sequence != null ? this.regulatoryClassificationPart45_2019Sequence : (this.regulatoryClassificationPart45_2019Sequence = RegulatoryClassificationPart45_2019Sequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="endUserExceptionDeclaration")
        @RuneAttribute(value="endUserExceptionDeclaration")
        public EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder getEndUserExceptionDeclaration() {
            return this.endUserExceptionDeclaration;
        }

        @Override
        public EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder getOrCreateEndUserExceptionDeclaration() {
            EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder result = this.endUserExceptionDeclaration != null ? this.endUserExceptionDeclaration : (this.endUserExceptionDeclaration = EndUserExceptionDeclaration.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public Boolean getLargeSizeTrade() {
            return this.largeSizeTrade;
        }

        @Override
        @RosettaAttribute(value="executionType")
        @RuneAttribute(value="executionType")
        public ExecutionType.ExecutionTypeBuilder getExecutionType() {
            return this.executionType;
        }

        @Override
        public ExecutionType.ExecutionTypeBuilder getOrCreateExecutionType() {
            ExecutionType.ExecutionTypeBuilder result = this.executionType != null ? this.executionType : (this.executionType = ExecutionType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType() {
            ExecutionVenueType.ExecutionVenueTypeBuilder result = this.executionVenueType != null ? this.executionVenueType : (this.executionVenueType = ExecutionVenueType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="verificationMethod")
        @RuneAttribute(value="verificationMethod")
        public VerificationMethod.VerificationMethodBuilder getVerificationMethod() {
            return this.verificationMethod;
        }

        @Override
        public VerificationMethod.VerificationMethodBuilder getOrCreateVerificationMethod() {
            VerificationMethod.VerificationMethodBuilder result = this.verificationMethod != null ? this.verificationMethod : (this.verificationMethod = VerificationMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ConfirmationMethod.ConfirmationMethodBuilder getConfirmationMethod() {
            return this.confirmationMethod;
        }

        @Override
        public ConfirmationMethod.ConfirmationMethodBuilder getOrCreateConfirmationMethod() {
            ConfirmationMethod.ConfirmationMethodBuilder result = this.confirmationMethod != null ? this.confirmationMethod : (this.confirmationMethod = ConfirmationMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public CollateralizationType.CollateralizationTypeBuilder getCollateralizationType() {
            return this.collateralizationType;
        }

        @Override
        public CollateralizationType.CollateralizationTypeBuilder getOrCreateCollateralizationType() {
            CollateralizationType.CollateralizationTypeBuilder result = this.collateralizationType != null ? this.collateralizationType : (this.collateralizationType = CollateralizationType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingPartyOrganizationType")
        @RuneAttribute(value="reportingPartyOrganizationType")
        public String getReportingPartyOrganizationType() {
            return this.reportingPartyOrganizationType;
        }

        @Override
        @RosettaAttribute(value="counterPartyOrganizationType")
        @RuneAttribute(value="counterPartyOrganizationType")
        public String getCounterPartyOrganizationType() {
            return this.counterPartyOrganizationType;
        }

        @Override
        @RosettaAttribute(value="counterPartyIsUsPerson")
        @RuneAttribute(value="counterPartyIsUsPerson")
        public Boolean getCounterPartyIsUsPerson() {
            return this.counterPartyIsUsPerson;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public AllocationReportingStatus.AllocationReportingStatusBuilder getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        public AllocationReportingStatus.AllocationReportingStatusBuilder getOrCreateAllocationStatus() {
            AllocationReportingStatus.AllocationReportingStatusBuilder result = this.allocationStatus != null ? this.allocationStatus : (this.allocationStatus = AllocationReportingStatus.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clientAccountType")
        @RuneAttribute(value="clientAccountType")
        public TradeCategory.TradeCategoryBuilder getClientAccountType() {
            return this.clientAccountType;
        }

        @Override
        public TradeCategory.TradeCategoryBuilder getOrCreateClientAccountType() {
            TradeCategory.TradeCategoryBuilder result = this.clientAccountType != null ? this.clientAccountType : (this.clientAccountType = TradeCategory.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interAffiliateClearingExemptionParty")
        @RuneAttribute(value="interAffiliateClearingExemptionParty")
        public PartyReference.PartyReferenceBuilder getInterAffiliateClearingExemptionParty() {
            return this.interAffiliateClearingExemptionParty;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateInterAffiliateClearingExemptionParty() {
            PartyReference.PartyReferenceBuilder result = this.interAffiliateClearingExemptionParty != null ? this.interAffiliateClearingExemptionParty : (this.interAffiliateClearingExemptionParty = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingPartyClearingExemption")
        @RuneAttribute(value="reportingPartyClearingExemption")
        public List<String> getReportingPartyClearingExemption() {
            return this.reportingPartyClearingExemption;
        }

        @Override
        @RosettaAttribute(value="counterPartyClearingExemption")
        @RuneAttribute(value="counterPartyClearingExemption")
        public List<String> getCounterPartyClearingExemption() {
            return this.counterPartyClearingExemption;
        }

        @Override
        @RosettaAttribute(value="collateralTypeAllowed")
        @RuneAttribute(value="collateralTypeAllowed")
        public List<String> getCollateralTypeAllowed() {
            return this.collateralTypeAllowed;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioContainsNonReportableComponents")
        @RuneAttribute(value="collateralPortfolioContainsNonReportableComponents")
        public Boolean getCollateralPortfolioContainsNonReportableComponents() {
            return this.collateralPortfolioContainsNonReportableComponents;
        }

        @Override
        @RosettaAttribute(value="packageContainsNonReportableComponents")
        @RuneAttribute(value="packageContainsNonReportableComponents")
        public Boolean getPackageContainsNonReportableComponents() {
            return this.packageContainsNonReportableComponents;
        }

        @Override
        @RosettaAttribute(value="specialEntityType")
        @RuneAttribute(value="specialEntityType")
        public String getSpecialEntityType() {
            return this.specialEntityType;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public ActionType.ActionTypeBuilder getActionType() {
            return this.actionType;
        }

        @Override
        public ActionType.ActionTypeBuilder getOrCreateActionType() {
            ActionType.ActionTypeBuilder result = this.actionType != null ? this.actionType : (this.actionType = ActionType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="tradeExecutionRequirementIndicator")
        @RuneAttribute(value="tradeExecutionRequirementIndicator")
        public Boolean getTradeExecutionRequirementIndicator() {
            return this.tradeExecutionRequirementIndicator;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDate")
        @RuneAttribute(value="lastFloatingReferenceResetDate")
        public ZonedDateTime getLastFloatingReferenceResetDate() {
            return this.lastFloatingReferenceResetDate;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public ZonedDateTime getNextFloatingReferenceResetDate() {
            return this.nextFloatingReferenceResetDate;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public RegulatoryClassificationPart45_2019Builder addSupervisoryBody(String _supervisoryBody) {
            if (_supervisoryBody != null) {
                this.supervisoryBody.add(_supervisoryBody);
            }
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addSupervisoryBody(String _supervisoryBody, int idx) {
            this.getIndex(this.supervisoryBody, idx, () -> _supervisoryBody);
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addSupervisoryBody(List<String> supervisoryBodys) {
            if (supervisoryBodys != null) {
                for (String toAdd : supervisoryBodys) {
                    this.supervisoryBody.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="supervisoryBody")
        public RegulatoryClassificationPart45_2019Builder setSupervisoryBody(List<String> supervisoryBodys) {
            this.supervisoryBody = supervisoryBodys == null ? new ArrayList<String>() : (List)supervisoryBodys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public RegulatoryClassificationPart45_2019Builder setReportingRoleAndPurposeModel(ReportingRoleAndPurposeModel _reportingRoleAndPurposeModel) {
            this.reportingRoleAndPurposeModel = _reportingRoleAndPurposeModel == null ? null : _reportingRoleAndPurposeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regulatoryBuyerAndSellerModel")
        @RuneAttribute(value="regulatoryBuyerAndSellerModel")
        public RegulatoryClassificationPart45_2019Builder setRegulatoryBuyerAndSellerModel(RegulatoryBuyerAndSellerModel _regulatoryBuyerAndSellerModel) {
            this.regulatoryBuyerAndSellerModel = _regulatoryBuyerAndSellerModel == null ? null : _regulatoryBuyerAndSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public RegulatoryClassificationPart45_2019Builder setMandatorilyClearable(ReportingBoolean _mandatorilyClearable) {
            this.mandatorilyClearable = _mandatorilyClearable == null ? null : _mandatorilyClearable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regulatoryClassificationPart45_2019Sequence")
        @RuneAttribute(value="regulatoryClassificationPart45_2019Sequence")
        public RegulatoryClassificationPart45_2019Builder setRegulatoryClassificationPart45_2019Sequence(RegulatoryClassificationPart45_2019Sequence _regulatoryClassificationPart45_2019Sequence) {
            this.regulatoryClassificationPart45_2019Sequence = _regulatoryClassificationPart45_2019Sequence == null ? null : _regulatoryClassificationPart45_2019Sequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="endUserExceptionDeclaration")
        @RuneAttribute(value="endUserExceptionDeclaration")
        public RegulatoryClassificationPart45_2019Builder setEndUserExceptionDeclaration(EndUserExceptionDeclaration _endUserExceptionDeclaration) {
            this.endUserExceptionDeclaration = _endUserExceptionDeclaration == null ? null : _endUserExceptionDeclaration.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public RegulatoryClassificationPart45_2019Builder setLargeSizeTrade(Boolean _largeSizeTrade) {
            this.largeSizeTrade = _largeSizeTrade == null ? null : _largeSizeTrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionType")
        @RuneAttribute(value="executionType")
        public RegulatoryClassificationPart45_2019Builder setExecutionType(ExecutionType _executionType) {
            this.executionType = _executionType == null ? null : _executionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public RegulatoryClassificationPart45_2019Builder setExecutionVenueType(ExecutionVenueType _executionVenueType) {
            this.executionVenueType = _executionVenueType == null ? null : _executionVenueType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="verificationMethod")
        @RuneAttribute(value="verificationMethod")
        public RegulatoryClassificationPart45_2019Builder setVerificationMethod(VerificationMethod _verificationMethod) {
            this.verificationMethod = _verificationMethod == null ? null : _verificationMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public RegulatoryClassificationPart45_2019Builder setConfirmationMethod(ConfirmationMethod _confirmationMethod) {
            this.confirmationMethod = _confirmationMethod == null ? null : _confirmationMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public RegulatoryClassificationPart45_2019Builder setCollateralizationType(CollateralizationType _collateralizationType) {
            this.collateralizationType = _collateralizationType == null ? null : _collateralizationType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingPartyOrganizationType")
        @RuneAttribute(value="reportingPartyOrganizationType")
        public RegulatoryClassificationPart45_2019Builder setReportingPartyOrganizationType(String _reportingPartyOrganizationType) {
            this.reportingPartyOrganizationType = _reportingPartyOrganizationType == null ? null : _reportingPartyOrganizationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterPartyOrganizationType")
        @RuneAttribute(value="counterPartyOrganizationType")
        public RegulatoryClassificationPart45_2019Builder setCounterPartyOrganizationType(String _counterPartyOrganizationType) {
            this.counterPartyOrganizationType = _counterPartyOrganizationType == null ? null : _counterPartyOrganizationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterPartyIsUsPerson")
        @RuneAttribute(value="counterPartyIsUsPerson")
        public RegulatoryClassificationPart45_2019Builder setCounterPartyIsUsPerson(Boolean _counterPartyIsUsPerson) {
            this.counterPartyIsUsPerson = _counterPartyIsUsPerson == null ? null : _counterPartyIsUsPerson;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public RegulatoryClassificationPart45_2019Builder setAllocationStatus(AllocationReportingStatus _allocationStatus) {
            this.allocationStatus = _allocationStatus == null ? null : _allocationStatus.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clientAccountType")
        @RuneAttribute(value="clientAccountType")
        public RegulatoryClassificationPart45_2019Builder setClientAccountType(TradeCategory _clientAccountType) {
            this.clientAccountType = _clientAccountType == null ? null : _clientAccountType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interAffiliateClearingExemptionParty")
        @RuneAttribute(value="interAffiliateClearingExemptionParty")
        public RegulatoryClassificationPart45_2019Builder setInterAffiliateClearingExemptionParty(PartyReference _interAffiliateClearingExemptionParty) {
            this.interAffiliateClearingExemptionParty = _interAffiliateClearingExemptionParty == null ? null : _interAffiliateClearingExemptionParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingPartyClearingExemption")
        @RuneAttribute(value="reportingPartyClearingExemption")
        public RegulatoryClassificationPart45_2019Builder addReportingPartyClearingExemption(String _reportingPartyClearingExemption) {
            if (_reportingPartyClearingExemption != null) {
                this.reportingPartyClearingExemption.add(_reportingPartyClearingExemption);
            }
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addReportingPartyClearingExemption(String _reportingPartyClearingExemption, int idx) {
            this.getIndex(this.reportingPartyClearingExemption, idx, () -> _reportingPartyClearingExemption);
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addReportingPartyClearingExemption(List<String> reportingPartyClearingExemptions) {
            if (reportingPartyClearingExemptions != null) {
                for (String toAdd : reportingPartyClearingExemptions) {
                    this.reportingPartyClearingExemption.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reportingPartyClearingExemption")
        public RegulatoryClassificationPart45_2019Builder setReportingPartyClearingExemption(List<String> reportingPartyClearingExemptions) {
            this.reportingPartyClearingExemption = reportingPartyClearingExemptions == null ? new ArrayList<String>() : (List)reportingPartyClearingExemptions.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterPartyClearingExemption")
        @RuneAttribute(value="counterPartyClearingExemption")
        public RegulatoryClassificationPart45_2019Builder addCounterPartyClearingExemption(String _counterPartyClearingExemption) {
            if (_counterPartyClearingExemption != null) {
                this.counterPartyClearingExemption.add(_counterPartyClearingExemption);
            }
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addCounterPartyClearingExemption(String _counterPartyClearingExemption, int idx) {
            this.getIndex(this.counterPartyClearingExemption, idx, () -> _counterPartyClearingExemption);
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addCounterPartyClearingExemption(List<String> counterPartyClearingExemptions) {
            if (counterPartyClearingExemptions != null) {
                for (String toAdd : counterPartyClearingExemptions) {
                    this.counterPartyClearingExemption.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="counterPartyClearingExemption")
        public RegulatoryClassificationPart45_2019Builder setCounterPartyClearingExemption(List<String> counterPartyClearingExemptions) {
            this.counterPartyClearingExemption = counterPartyClearingExemptions == null ? new ArrayList<String>() : (List)counterPartyClearingExemptions.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTypeAllowed")
        @RuneAttribute(value="collateralTypeAllowed")
        public RegulatoryClassificationPart45_2019Builder addCollateralTypeAllowed(String _collateralTypeAllowed) {
            if (_collateralTypeAllowed != null) {
                this.collateralTypeAllowed.add(_collateralTypeAllowed);
            }
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addCollateralTypeAllowed(String _collateralTypeAllowed, int idx) {
            this.getIndex(this.collateralTypeAllowed, idx, () -> _collateralTypeAllowed);
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder addCollateralTypeAllowed(List<String> collateralTypeAlloweds) {
            if (collateralTypeAlloweds != null) {
                for (String toAdd : collateralTypeAlloweds) {
                    this.collateralTypeAllowed.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralTypeAllowed")
        public RegulatoryClassificationPart45_2019Builder setCollateralTypeAllowed(List<String> collateralTypeAlloweds) {
            this.collateralTypeAllowed = collateralTypeAlloweds == null ? new ArrayList<String>() : (List)collateralTypeAlloweds.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioContainsNonReportableComponents")
        @RuneAttribute(value="collateralPortfolioContainsNonReportableComponents")
        public RegulatoryClassificationPart45_2019Builder setCollateralPortfolioContainsNonReportableComponents(Boolean _collateralPortfolioContainsNonReportableComponents) {
            this.collateralPortfolioContainsNonReportableComponents = _collateralPortfolioContainsNonReportableComponents == null ? null : _collateralPortfolioContainsNonReportableComponents;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageContainsNonReportableComponents")
        @RuneAttribute(value="packageContainsNonReportableComponents")
        public RegulatoryClassificationPart45_2019Builder setPackageContainsNonReportableComponents(Boolean _packageContainsNonReportableComponents) {
            this.packageContainsNonReportableComponents = _packageContainsNonReportableComponents == null ? null : _packageContainsNonReportableComponents;
            return this;
        }

        @Override
        @RosettaAttribute(value="specialEntityType")
        @RuneAttribute(value="specialEntityType")
        public RegulatoryClassificationPart45_2019Builder setSpecialEntityType(String _specialEntityType) {
            this.specialEntityType = _specialEntityType == null ? null : _specialEntityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public RegulatoryClassificationPart45_2019Builder setActionType(ActionType _actionType) {
            this.actionType = _actionType == null ? null : _actionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public RegulatoryClassificationPart45_2019Builder setEventType(String _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeExecutionRequirementIndicator")
        @RuneAttribute(value="tradeExecutionRequirementIndicator")
        public RegulatoryClassificationPart45_2019Builder setTradeExecutionRequirementIndicator(Boolean _tradeExecutionRequirementIndicator) {
            this.tradeExecutionRequirementIndicator = _tradeExecutionRequirementIndicator == null ? null : _tradeExecutionRequirementIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDate")
        @RuneAttribute(value="lastFloatingReferenceResetDate")
        public RegulatoryClassificationPart45_2019Builder setLastFloatingReferenceResetDate(ZonedDateTime _lastFloatingReferenceResetDate) {
            this.lastFloatingReferenceResetDate = _lastFloatingReferenceResetDate == null ? null : _lastFloatingReferenceResetDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public RegulatoryClassificationPart45_2019Builder setNextFloatingReferenceResetDate(ZonedDateTime _nextFloatingReferenceResetDate) {
            this.nextFloatingReferenceResetDate = _nextFloatingReferenceResetDate == null ? null : _nextFloatingReferenceResetDate;
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019 build() {
            return new RegulatoryClassificationPart45_2019Impl(this);
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder prune() {
            super.prune();
            if (this.reportingRoleAndPurposeModel != null && !this.reportingRoleAndPurposeModel.prune().hasData()) {
                this.reportingRoleAndPurposeModel = null;
            }
            if (this.regulatoryBuyerAndSellerModel != null && !this.regulatoryBuyerAndSellerModel.prune().hasData()) {
                this.regulatoryBuyerAndSellerModel = null;
            }
            if (this.mandatorilyClearable != null && !this.mandatorilyClearable.prune().hasData()) {
                this.mandatorilyClearable = null;
            }
            if (this.regulatoryClassificationPart45_2019Sequence != null && !this.regulatoryClassificationPart45_2019Sequence.prune().hasData()) {
                this.regulatoryClassificationPart45_2019Sequence = null;
            }
            if (this.endUserExceptionDeclaration != null && !this.endUserExceptionDeclaration.prune().hasData()) {
                this.endUserExceptionDeclaration = null;
            }
            if (this.executionType != null && !this.executionType.prune().hasData()) {
                this.executionType = null;
            }
            if (this.executionVenueType != null && !this.executionVenueType.prune().hasData()) {
                this.executionVenueType = null;
            }
            if (this.verificationMethod != null && !this.verificationMethod.prune().hasData()) {
                this.verificationMethod = null;
            }
            if (this.confirmationMethod != null && !this.confirmationMethod.prune().hasData()) {
                this.confirmationMethod = null;
            }
            if (this.collateralizationType != null && !this.collateralizationType.prune().hasData()) {
                this.collateralizationType = null;
            }
            if (this.allocationStatus != null && !this.allocationStatus.prune().hasData()) {
                this.allocationStatus = null;
            }
            if (this.clientAccountType != null && !this.clientAccountType.prune().hasData()) {
                this.clientAccountType = null;
            }
            if (this.interAffiliateClearingExemptionParty != null && !this.interAffiliateClearingExemptionParty.prune().hasData()) {
                this.interAffiliateClearingExemptionParty = null;
            }
            if (this.actionType != null && !this.actionType.prune().hasData()) {
                this.actionType = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSupervisoryBody() != null && !this.getSupervisoryBody().isEmpty()) {
                return true;
            }
            if (this.getReportingRoleAndPurposeModel() != null && this.getReportingRoleAndPurposeModel().hasData()) {
                return true;
            }
            if (this.getRegulatoryBuyerAndSellerModel() != null && this.getRegulatoryBuyerAndSellerModel().hasData()) {
                return true;
            }
            if (this.getMandatorilyClearable() != null && this.getMandatorilyClearable().hasData()) {
                return true;
            }
            if (this.getRegulatoryClassificationPart45_2019Sequence() != null && this.getRegulatoryClassificationPart45_2019Sequence().hasData()) {
                return true;
            }
            if (this.getEndUserExceptionDeclaration() != null && this.getEndUserExceptionDeclaration().hasData()) {
                return true;
            }
            if (this.getLargeSizeTrade() != null) {
                return true;
            }
            if (this.getExecutionType() != null && this.getExecutionType().hasData()) {
                return true;
            }
            if (this.getExecutionVenueType() != null && this.getExecutionVenueType().hasData()) {
                return true;
            }
            if (this.getVerificationMethod() != null && this.getVerificationMethod().hasData()) {
                return true;
            }
            if (this.getConfirmationMethod() != null && this.getConfirmationMethod().hasData()) {
                return true;
            }
            if (this.getCollateralizationType() != null && this.getCollateralizationType().hasData()) {
                return true;
            }
            if (this.getReportingPartyOrganizationType() != null) {
                return true;
            }
            if (this.getCounterPartyOrganizationType() != null) {
                return true;
            }
            if (this.getCounterPartyIsUsPerson() != null) {
                return true;
            }
            if (this.getAllocationStatus() != null && this.getAllocationStatus().hasData()) {
                return true;
            }
            if (this.getClientAccountType() != null && this.getClientAccountType().hasData()) {
                return true;
            }
            if (this.getInterAffiliateClearingExemptionParty() != null && this.getInterAffiliateClearingExemptionParty().hasData()) {
                return true;
            }
            if (this.getReportingPartyClearingExemption() != null && !this.getReportingPartyClearingExemption().isEmpty()) {
                return true;
            }
            if (this.getCounterPartyClearingExemption() != null && !this.getCounterPartyClearingExemption().isEmpty()) {
                return true;
            }
            if (this.getCollateralTypeAllowed() != null && !this.getCollateralTypeAllowed().isEmpty()) {
                return true;
            }
            if (this.getCollateralPortfolioContainsNonReportableComponents() != null) {
                return true;
            }
            if (this.getPackageContainsNonReportableComponents() != null) {
                return true;
            }
            if (this.getSpecialEntityType() != null) {
                return true;
            }
            if (this.getActionType() != null && this.getActionType().hasData()) {
                return true;
            }
            if (this.getEventType() != null) {
                return true;
            }
            if (this.getTradeExecutionRequirementIndicator() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceResetDate() != null) {
                return true;
            }
            return this.getNextFloatingReferenceResetDate() != null;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryClassificationPart45_2019Builder o = (RegulatoryClassificationPart45_2019Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingRoleAndPurposeModel(), (RosettaModelObjectBuilder)o.getReportingRoleAndPurposeModel(), this::setReportingRoleAndPurposeModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulatoryBuyerAndSellerModel(), (RosettaModelObjectBuilder)o.getRegulatoryBuyerAndSellerModel(), this::setRegulatoryBuyerAndSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMandatorilyClearable(), (RosettaModelObjectBuilder)o.getMandatorilyClearable(), this::setMandatorilyClearable);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulatoryClassificationPart45_2019Sequence(), (RosettaModelObjectBuilder)o.getRegulatoryClassificationPart45_2019Sequence(), this::setRegulatoryClassificationPart45_2019Sequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEndUserExceptionDeclaration(), (RosettaModelObjectBuilder)o.getEndUserExceptionDeclaration(), this::setEndUserExceptionDeclaration);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionType(), (RosettaModelObjectBuilder)o.getExecutionType(), this::setExecutionType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExecutionVenueType(), (RosettaModelObjectBuilder)o.getExecutionVenueType(), this::setExecutionVenueType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVerificationMethod(), (RosettaModelObjectBuilder)o.getVerificationMethod(), this::setVerificationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConfirmationMethod(), (RosettaModelObjectBuilder)o.getConfirmationMethod(), this::setConfirmationMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralizationType(), (RosettaModelObjectBuilder)o.getCollateralizationType(), this::setCollateralizationType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAllocationStatus(), (RosettaModelObjectBuilder)o.getAllocationStatus(), this::setAllocationStatus);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClientAccountType(), (RosettaModelObjectBuilder)o.getClientAccountType(), this::setClientAccountType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterAffiliateClearingExemptionParty(), (RosettaModelObjectBuilder)o.getInterAffiliateClearingExemptionParty(), this::setInterAffiliateClearingExemptionParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getActionType(), (RosettaModelObjectBuilder)o.getActionType(), this::setActionType);
            merger.mergeBasic(this.getSupervisoryBody(), o.getSupervisoryBody(), this::addSupervisoryBody);
            merger.mergeBasic((Object)this.getLargeSizeTrade(), (Object)o.getLargeSizeTrade(), this::setLargeSizeTrade, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingPartyOrganizationType(), (Object)o.getReportingPartyOrganizationType(), this::setReportingPartyOrganizationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterPartyOrganizationType(), (Object)o.getCounterPartyOrganizationType(), this::setCounterPartyOrganizationType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterPartyIsUsPerson(), (Object)o.getCounterPartyIsUsPerson(), this::setCounterPartyIsUsPerson, new AttributeMeta[0]);
            merger.mergeBasic(this.getReportingPartyClearingExemption(), o.getReportingPartyClearingExemption(), this::addReportingPartyClearingExemption);
            merger.mergeBasic(this.getCounterPartyClearingExemption(), o.getCounterPartyClearingExemption(), this::addCounterPartyClearingExemption);
            merger.mergeBasic(this.getCollateralTypeAllowed(), o.getCollateralTypeAllowed(), this::addCollateralTypeAllowed);
            merger.mergeBasic((Object)this.getCollateralPortfolioContainsNonReportableComponents(), (Object)o.getCollateralPortfolioContainsNonReportableComponents(), this::setCollateralPortfolioContainsNonReportableComponents, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPackageContainsNonReportableComponents(), (Object)o.getPackageContainsNonReportableComponents(), this::setPackageContainsNonReportableComponents, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpecialEntityType(), (Object)o.getSpecialEntityType(), this::setSpecialEntityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventType(), (Object)o.getEventType(), this::setEventType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeExecutionRequirementIndicator(), (Object)o.getTradeExecutionRequirementIndicator(), this::setTradeExecutionRequirementIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceResetDate(), (Object)o.getLastFloatingReferenceResetDate(), this::setLastFloatingReferenceResetDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDate(), (Object)o.getNextFloatingReferenceResetDate(), this::setNextFloatingReferenceResetDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryClassificationPart45_2019 _that = (RegulatoryClassificationPart45_2019)this.getType().cast(o);
            if (!ListEquals.listEquals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingRoleAndPurposeModel, _that.getReportingRoleAndPurposeModel())) {
                return false;
            }
            if (!Objects.equals(this.regulatoryBuyerAndSellerModel, _that.getRegulatoryBuyerAndSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.mandatorilyClearable, _that.getMandatorilyClearable())) {
                return false;
            }
            if (!Objects.equals(this.regulatoryClassificationPart45_2019Sequence, _that.getRegulatoryClassificationPart45_2019Sequence())) {
                return false;
            }
            if (!Objects.equals(this.endUserExceptionDeclaration, _that.getEndUserExceptionDeclaration())) {
                return false;
            }
            if (!Objects.equals(this.largeSizeTrade, _that.getLargeSizeTrade())) {
                return false;
            }
            if (!Objects.equals(this.executionType, _that.getExecutionType())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueType, _that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.verificationMethod, _that.getVerificationMethod())) {
                return false;
            }
            if (!Objects.equals(this.confirmationMethod, _that.getConfirmationMethod())) {
                return false;
            }
            if (!Objects.equals(this.collateralizationType, _that.getCollateralizationType())) {
                return false;
            }
            if (!Objects.equals(this.reportingPartyOrganizationType, _that.getReportingPartyOrganizationType())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyOrganizationType, _that.getCounterPartyOrganizationType())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyIsUsPerson, _that.getCounterPartyIsUsPerson())) {
                return false;
            }
            if (!Objects.equals(this.allocationStatus, _that.getAllocationStatus())) {
                return false;
            }
            if (!Objects.equals(this.clientAccountType, _that.getClientAccountType())) {
                return false;
            }
            if (!Objects.equals(this.interAffiliateClearingExemptionParty, _that.getInterAffiliateClearingExemptionParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingPartyClearingExemption, _that.getReportingPartyClearingExemption())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterPartyClearingExemption, _that.getCounterPartyClearingExemption())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralTypeAllowed, _that.getCollateralTypeAllowed())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioContainsNonReportableComponents, _that.getCollateralPortfolioContainsNonReportableComponents())) {
                return false;
            }
            if (!Objects.equals(this.packageContainsNonReportableComponents, _that.getPackageContainsNonReportableComponents())) {
                return false;
            }
            if (!Objects.equals(this.specialEntityType, _that.getSpecialEntityType())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.tradeExecutionRequirementIndicator, _that.getTradeExecutionRequirementIndicator())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDate, _that.getLastFloatingReferenceResetDate())) {
                return false;
            }
            return Objects.equals(this.nextFloatingReferenceResetDate, _that.getNextFloatingReferenceResetDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryBuyerAndSellerModel != null ? this.regulatoryBuyerAndSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? this.mandatorilyClearable.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryClassificationPart45_2019Sequence != null ? this.regulatoryClassificationPart45_2019Sequence.hashCode() : 0);
            _result = 31 * _result + (this.endUserExceptionDeclaration != null ? this.endUserExceptionDeclaration.hashCode() : 0);
            _result = 31 * _result + (this.largeSizeTrade != null ? this.largeSizeTrade.hashCode() : 0);
            _result = 31 * _result + (this.executionType != null ? this.executionType.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            _result = 31 * _result + (this.verificationMethod != null ? this.verificationMethod.hashCode() : 0);
            _result = 31 * _result + (this.confirmationMethod != null ? this.confirmationMethod.hashCode() : 0);
            _result = 31 * _result + (this.collateralizationType != null ? this.collateralizationType.hashCode() : 0);
            _result = 31 * _result + (this.reportingPartyOrganizationType != null ? this.reportingPartyOrganizationType.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyOrganizationType != null ? this.counterPartyOrganizationType.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyIsUsPerson != null ? this.counterPartyIsUsPerson.hashCode() : 0);
            _result = 31 * _result + (this.allocationStatus != null ? this.allocationStatus.hashCode() : 0);
            _result = 31 * _result + (this.clientAccountType != null ? this.clientAccountType.hashCode() : 0);
            _result = 31 * _result + (this.interAffiliateClearingExemptionParty != null ? this.interAffiliateClearingExemptionParty.hashCode() : 0);
            _result = 31 * _result + (this.reportingPartyClearingExemption != null ? this.reportingPartyClearingExemption.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyClearingExemption != null ? this.counterPartyClearingExemption.hashCode() : 0);
            _result = 31 * _result + (this.collateralTypeAllowed != null ? this.collateralTypeAllowed.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioContainsNonReportableComponents != null ? this.collateralPortfolioContainsNonReportableComponents.hashCode() : 0);
            _result = 31 * _result + (this.packageContainsNonReportableComponents != null ? this.packageContainsNonReportableComponents.hashCode() : 0);
            _result = 31 * _result + (this.specialEntityType != null ? this.specialEntityType.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.tradeExecutionRequirementIndicator != null ? this.tradeExecutionRequirementIndicator.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDate != null ? this.lastFloatingReferenceResetDate.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDate != null ? this.nextFloatingReferenceResetDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryClassificationPart45_2019Builder {supervisoryBody=" + this.supervisoryBody + ", reportingRoleAndPurposeModel=" + this.reportingRoleAndPurposeModel + ", regulatoryBuyerAndSellerModel=" + this.regulatoryBuyerAndSellerModel + ", mandatorilyClearable=" + this.mandatorilyClearable + ", regulatoryClassificationPart45_2019Sequence=" + this.regulatoryClassificationPart45_2019Sequence + ", endUserExceptionDeclaration=" + this.endUserExceptionDeclaration + ", largeSizeTrade=" + this.largeSizeTrade + ", executionType=" + this.executionType + ", executionVenueType=" + this.executionVenueType + ", verificationMethod=" + this.verificationMethod + ", confirmationMethod=" + this.confirmationMethod + ", collateralizationType=" + this.collateralizationType + ", reportingPartyOrganizationType=" + this.reportingPartyOrganizationType + ", counterPartyOrganizationType=" + this.counterPartyOrganizationType + ", counterPartyIsUsPerson=" + this.counterPartyIsUsPerson + ", allocationStatus=" + this.allocationStatus + ", clientAccountType=" + this.clientAccountType + ", interAffiliateClearingExemptionParty=" + this.interAffiliateClearingExemptionParty + ", reportingPartyClearingExemption=" + this.reportingPartyClearingExemption + ", counterPartyClearingExemption=" + this.counterPartyClearingExemption + ", collateralTypeAllowed=" + this.collateralTypeAllowed + ", collateralPortfolioContainsNonReportableComponents=" + this.collateralPortfolioContainsNonReportableComponents + ", packageContainsNonReportableComponents=" + this.packageContainsNonReportableComponents + ", specialEntityType=" + this.specialEntityType + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", tradeExecutionRequirementIndicator=" + this.tradeExecutionRequirementIndicator + ", lastFloatingReferenceResetDate=" + this.lastFloatingReferenceResetDate + ", nextFloatingReferenceResetDate=" + this.nextFloatingReferenceResetDate + '}' + " " + super.toString();
        }
    }

    public static interface RegulatoryClassificationPart45_2019Builder
    extends RegulatoryClassificationPart45_2019,
    RegulatoryClassification.RegulatoryClassificationBuilder {
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getOrCreateReportingRoleAndPurposeModel();

        @Override
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getReportingRoleAndPurposeModel();

        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getOrCreateRegulatoryBuyerAndSellerModel();

        @Override
        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getRegulatoryBuyerAndSellerModel();

        public ReportingBoolean.ReportingBooleanBuilder getOrCreateMandatorilyClearable();

        @Override
        public ReportingBoolean.ReportingBooleanBuilder getMandatorilyClearable();

        public RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder getOrCreateRegulatoryClassificationPart45_2019Sequence();

        @Override
        public RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder getRegulatoryClassificationPart45_2019Sequence();

        public EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder getOrCreateEndUserExceptionDeclaration();

        @Override
        public EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder getEndUserExceptionDeclaration();

        public ExecutionType.ExecutionTypeBuilder getOrCreateExecutionType();

        @Override
        public ExecutionType.ExecutionTypeBuilder getExecutionType();

        public ExecutionVenueType.ExecutionVenueTypeBuilder getOrCreateExecutionVenueType();

        @Override
        public ExecutionVenueType.ExecutionVenueTypeBuilder getExecutionVenueType();

        public VerificationMethod.VerificationMethodBuilder getOrCreateVerificationMethod();

        @Override
        public VerificationMethod.VerificationMethodBuilder getVerificationMethod();

        public ConfirmationMethod.ConfirmationMethodBuilder getOrCreateConfirmationMethod();

        @Override
        public ConfirmationMethod.ConfirmationMethodBuilder getConfirmationMethod();

        public CollateralizationType.CollateralizationTypeBuilder getOrCreateCollateralizationType();

        @Override
        public CollateralizationType.CollateralizationTypeBuilder getCollateralizationType();

        public AllocationReportingStatus.AllocationReportingStatusBuilder getOrCreateAllocationStatus();

        @Override
        public AllocationReportingStatus.AllocationReportingStatusBuilder getAllocationStatus();

        public TradeCategory.TradeCategoryBuilder getOrCreateClientAccountType();

        @Override
        public TradeCategory.TradeCategoryBuilder getClientAccountType();

        public PartyReference.PartyReferenceBuilder getOrCreateInterAffiliateClearingExemptionParty();

        @Override
        public PartyReference.PartyReferenceBuilder getInterAffiliateClearingExemptionParty();

        public ActionType.ActionTypeBuilder getOrCreateActionType();

        @Override
        public ActionType.ActionTypeBuilder getActionType();

        public RegulatoryClassificationPart45_2019Builder addSupervisoryBody(String var1);

        public RegulatoryClassificationPart45_2019Builder addSupervisoryBody(String var1, int var2);

        public RegulatoryClassificationPart45_2019Builder addSupervisoryBody(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder setSupervisoryBody(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder setReportingRoleAndPurposeModel(ReportingRoleAndPurposeModel var1);

        public RegulatoryClassificationPart45_2019Builder setRegulatoryBuyerAndSellerModel(RegulatoryBuyerAndSellerModel var1);

        public RegulatoryClassificationPart45_2019Builder setMandatorilyClearable(ReportingBoolean var1);

        public RegulatoryClassificationPart45_2019Builder setRegulatoryClassificationPart45_2019Sequence(RegulatoryClassificationPart45_2019Sequence var1);

        public RegulatoryClassificationPart45_2019Builder setEndUserExceptionDeclaration(EndUserExceptionDeclaration var1);

        public RegulatoryClassificationPart45_2019Builder setLargeSizeTrade(Boolean var1);

        public RegulatoryClassificationPart45_2019Builder setExecutionType(ExecutionType var1);

        public RegulatoryClassificationPart45_2019Builder setExecutionVenueType(ExecutionVenueType var1);

        public RegulatoryClassificationPart45_2019Builder setVerificationMethod(VerificationMethod var1);

        public RegulatoryClassificationPart45_2019Builder setConfirmationMethod(ConfirmationMethod var1);

        public RegulatoryClassificationPart45_2019Builder setCollateralizationType(CollateralizationType var1);

        public RegulatoryClassificationPart45_2019Builder setReportingPartyOrganizationType(String var1);

        public RegulatoryClassificationPart45_2019Builder setCounterPartyOrganizationType(String var1);

        public RegulatoryClassificationPart45_2019Builder setCounterPartyIsUsPerson(Boolean var1);

        public RegulatoryClassificationPart45_2019Builder setAllocationStatus(AllocationReportingStatus var1);

        public RegulatoryClassificationPart45_2019Builder setClientAccountType(TradeCategory var1);

        public RegulatoryClassificationPart45_2019Builder setInterAffiliateClearingExemptionParty(PartyReference var1);

        public RegulatoryClassificationPart45_2019Builder addReportingPartyClearingExemption(String var1);

        public RegulatoryClassificationPart45_2019Builder addReportingPartyClearingExemption(String var1, int var2);

        public RegulatoryClassificationPart45_2019Builder addReportingPartyClearingExemption(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder setReportingPartyClearingExemption(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder addCounterPartyClearingExemption(String var1);

        public RegulatoryClassificationPart45_2019Builder addCounterPartyClearingExemption(String var1, int var2);

        public RegulatoryClassificationPart45_2019Builder addCounterPartyClearingExemption(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder setCounterPartyClearingExemption(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder addCollateralTypeAllowed(String var1);

        public RegulatoryClassificationPart45_2019Builder addCollateralTypeAllowed(String var1, int var2);

        public RegulatoryClassificationPart45_2019Builder addCollateralTypeAllowed(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder setCollateralTypeAllowed(List<String> var1);

        public RegulatoryClassificationPart45_2019Builder setCollateralPortfolioContainsNonReportableComponents(Boolean var1);

        public RegulatoryClassificationPart45_2019Builder setPackageContainsNonReportableComponents(Boolean var1);

        public RegulatoryClassificationPart45_2019Builder setSpecialEntityType(String var1);

        public RegulatoryClassificationPart45_2019Builder setActionType(ActionType var1);

        public RegulatoryClassificationPart45_2019Builder setEventType(String var1);

        public RegulatoryClassificationPart45_2019Builder setTradeExecutionRequirementIndicator(Boolean var1);

        public RegulatoryClassificationPart45_2019Builder setLastFloatingReferenceResetDate(ZonedDateTime var1);

        public RegulatoryClassificationPart45_2019Builder setNextFloatingReferenceResetDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("supervisoryBody"), String.class, this.getSupervisoryBody(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRoleAndPurposeModel"), processor, ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder.class, this.getReportingRoleAndPurposeModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulatoryBuyerAndSellerModel"), processor, RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder.class, this.getRegulatoryBuyerAndSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("mandatorilyClearable"), processor, ReportingBoolean.ReportingBooleanBuilder.class, this.getMandatorilyClearable(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulatoryClassificationPart45_2019Sequence"), processor, RegulatoryClassificationPart45_2019Sequence.RegulatoryClassificationPart45_2019SequenceBuilder.class, this.getRegulatoryClassificationPart45_2019Sequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("endUserExceptionDeclaration"), processor, EndUserExceptionDeclaration.EndUserExceptionDeclarationBuilder.class, this.getEndUserExceptionDeclaration(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionType"), processor, ExecutionType.ExecutionTypeBuilder.class, this.getExecutionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("executionVenueType"), processor, ExecutionVenueType.ExecutionVenueTypeBuilder.class, this.getExecutionVenueType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("verificationMethod"), processor, VerificationMethod.VerificationMethodBuilder.class, this.getVerificationMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("confirmationMethod"), processor, ConfirmationMethod.ConfirmationMethodBuilder.class, this.getConfirmationMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralizationType"), processor, CollateralizationType.CollateralizationTypeBuilder.class, this.getCollateralizationType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingPartyOrganizationType"), String.class, (Object)this.getReportingPartyOrganizationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterPartyOrganizationType"), String.class, (Object)this.getCounterPartyOrganizationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterPartyIsUsPerson"), Boolean.class, (Object)this.getCounterPartyIsUsPerson(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationStatus"), processor, AllocationReportingStatus.AllocationReportingStatusBuilder.class, this.getAllocationStatus(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clientAccountType"), processor, TradeCategory.TradeCategoryBuilder.class, this.getClientAccountType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interAffiliateClearingExemptionParty"), processor, PartyReference.PartyReferenceBuilder.class, this.getInterAffiliateClearingExemptionParty(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingPartyClearingExemption"), String.class, this.getReportingPartyClearingExemption(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterPartyClearingExemption"), String.class, this.getCounterPartyClearingExemption(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTypeAllowed"), String.class, this.getCollateralTypeAllowed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioContainsNonReportableComponents"), Boolean.class, (Object)this.getCollateralPortfolioContainsNonReportableComponents(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageContainsNonReportableComponents"), Boolean.class, (Object)this.getPackageContainsNonReportableComponents(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specialEntityType"), String.class, (Object)this.getSpecialEntityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("actionType"), processor, ActionType.ActionTypeBuilder.class, this.getActionType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), String.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeExecutionRequirementIndicator"), Boolean.class, (Object)this.getTradeExecutionRequirementIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDate"), ZonedDateTime.class, (Object)this.getLastFloatingReferenceResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), ZonedDateTime.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder prune();
    }

    public static class RegulatoryClassificationPart45_2019Impl
    extends RegulatoryClassification.RegulatoryClassificationImpl
    implements RegulatoryClassificationPart45_2019 {
        private final List<String> supervisoryBody;
        private final ReportingRoleAndPurposeModel reportingRoleAndPurposeModel;
        private final RegulatoryBuyerAndSellerModel regulatoryBuyerAndSellerModel;
        private final ReportingBoolean mandatorilyClearable;
        private final RegulatoryClassificationPart45_2019Sequence regulatoryClassificationPart45_2019Sequence;
        private final EndUserExceptionDeclaration endUserExceptionDeclaration;
        private final Boolean largeSizeTrade;
        private final ExecutionType executionType;
        private final ExecutionVenueType executionVenueType;
        private final VerificationMethod verificationMethod;
        private final ConfirmationMethod confirmationMethod;
        private final CollateralizationType collateralizationType;
        private final String reportingPartyOrganizationType;
        private final String counterPartyOrganizationType;
        private final Boolean counterPartyIsUsPerson;
        private final AllocationReportingStatus allocationStatus;
        private final TradeCategory clientAccountType;
        private final PartyReference interAffiliateClearingExemptionParty;
        private final List<String> reportingPartyClearingExemption;
        private final List<String> counterPartyClearingExemption;
        private final List<String> collateralTypeAllowed;
        private final Boolean collateralPortfolioContainsNonReportableComponents;
        private final Boolean packageContainsNonReportableComponents;
        private final String specialEntityType;
        private final ActionType actionType;
        private final String eventType;
        private final Boolean tradeExecutionRequirementIndicator;
        private final ZonedDateTime lastFloatingReferenceResetDate;
        private final ZonedDateTime nextFloatingReferenceResetDate;

        protected RegulatoryClassificationPart45_2019Impl(RegulatoryClassificationPart45_2019Builder builder) {
            super(builder);
            this.supervisoryBody = Optional.ofNullable(builder.getSupervisoryBody()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.reportingRoleAndPurposeModel = Optional.ofNullable(builder.getReportingRoleAndPurposeModel()).map(f -> f.build()).orElse(null);
            this.regulatoryBuyerAndSellerModel = Optional.ofNullable(builder.getRegulatoryBuyerAndSellerModel()).map(f -> f.build()).orElse(null);
            this.mandatorilyClearable = Optional.ofNullable(builder.getMandatorilyClearable()).map(f -> f.build()).orElse(null);
            this.regulatoryClassificationPart45_2019Sequence = Optional.ofNullable(builder.getRegulatoryClassificationPart45_2019Sequence()).map(f -> f.build()).orElse(null);
            this.endUserExceptionDeclaration = Optional.ofNullable(builder.getEndUserExceptionDeclaration()).map(f -> f.build()).orElse(null);
            this.largeSizeTrade = builder.getLargeSizeTrade();
            this.executionType = Optional.ofNullable(builder.getExecutionType()).map(f -> f.build()).orElse(null);
            this.executionVenueType = Optional.ofNullable(builder.getExecutionVenueType()).map(f -> f.build()).orElse(null);
            this.verificationMethod = Optional.ofNullable(builder.getVerificationMethod()).map(f -> f.build()).orElse(null);
            this.confirmationMethod = Optional.ofNullable(builder.getConfirmationMethod()).map(f -> f.build()).orElse(null);
            this.collateralizationType = Optional.ofNullable(builder.getCollateralizationType()).map(f -> f.build()).orElse(null);
            this.reportingPartyOrganizationType = builder.getReportingPartyOrganizationType();
            this.counterPartyOrganizationType = builder.getCounterPartyOrganizationType();
            this.counterPartyIsUsPerson = builder.getCounterPartyIsUsPerson();
            this.allocationStatus = Optional.ofNullable(builder.getAllocationStatus()).map(f -> f.build()).orElse(null);
            this.clientAccountType = Optional.ofNullable(builder.getClientAccountType()).map(f -> f.build()).orElse(null);
            this.interAffiliateClearingExemptionParty = Optional.ofNullable(builder.getInterAffiliateClearingExemptionParty()).map(f -> f.build()).orElse(null);
            this.reportingPartyClearingExemption = Optional.ofNullable(builder.getReportingPartyClearingExemption()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.counterPartyClearingExemption = Optional.ofNullable(builder.getCounterPartyClearingExemption()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.collateralTypeAllowed = Optional.ofNullable(builder.getCollateralTypeAllowed()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.collateralPortfolioContainsNonReportableComponents = builder.getCollateralPortfolioContainsNonReportableComponents();
            this.packageContainsNonReportableComponents = builder.getPackageContainsNonReportableComponents();
            this.specialEntityType = builder.getSpecialEntityType();
            this.actionType = Optional.ofNullable(builder.getActionType()).map(f -> f.build()).orElse(null);
            this.eventType = builder.getEventType();
            this.tradeExecutionRequirementIndicator = builder.getTradeExecutionRequirementIndicator();
            this.lastFloatingReferenceResetDate = builder.getLastFloatingReferenceResetDate();
            this.nextFloatingReferenceResetDate = builder.getNextFloatingReferenceResetDate();
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public List<String> getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public ReportingRoleAndPurposeModel getReportingRoleAndPurposeModel() {
            return this.reportingRoleAndPurposeModel;
        }

        @Override
        @RosettaAttribute(value="regulatoryBuyerAndSellerModel")
        @RuneAttribute(value="regulatoryBuyerAndSellerModel")
        public RegulatoryBuyerAndSellerModel getRegulatoryBuyerAndSellerModel() {
            return this.regulatoryBuyerAndSellerModel;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public ReportingBoolean getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="regulatoryClassificationPart45_2019Sequence")
        @RuneAttribute(value="regulatoryClassificationPart45_2019Sequence")
        public RegulatoryClassificationPart45_2019Sequence getRegulatoryClassificationPart45_2019Sequence() {
            return this.regulatoryClassificationPart45_2019Sequence;
        }

        @Override
        @RosettaAttribute(value="endUserExceptionDeclaration")
        @RuneAttribute(value="endUserExceptionDeclaration")
        public EndUserExceptionDeclaration getEndUserExceptionDeclaration() {
            return this.endUserExceptionDeclaration;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public Boolean getLargeSizeTrade() {
            return this.largeSizeTrade;
        }

        @Override
        @RosettaAttribute(value="executionType")
        @RuneAttribute(value="executionType")
        public ExecutionType getExecutionType() {
            return this.executionType;
        }

        @Override
        @RosettaAttribute(value="executionVenueType")
        @RuneAttribute(value="executionVenueType")
        public ExecutionVenueType getExecutionVenueType() {
            return this.executionVenueType;
        }

        @Override
        @RosettaAttribute(value="verificationMethod")
        @RuneAttribute(value="verificationMethod")
        public VerificationMethod getVerificationMethod() {
            return this.verificationMethod;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ConfirmationMethod getConfirmationMethod() {
            return this.confirmationMethod;
        }

        @Override
        @RosettaAttribute(value="collateralizationType")
        @RuneAttribute(value="collateralizationType")
        public CollateralizationType getCollateralizationType() {
            return this.collateralizationType;
        }

        @Override
        @RosettaAttribute(value="reportingPartyOrganizationType")
        @RuneAttribute(value="reportingPartyOrganizationType")
        public String getReportingPartyOrganizationType() {
            return this.reportingPartyOrganizationType;
        }

        @Override
        @RosettaAttribute(value="counterPartyOrganizationType")
        @RuneAttribute(value="counterPartyOrganizationType")
        public String getCounterPartyOrganizationType() {
            return this.counterPartyOrganizationType;
        }

        @Override
        @RosettaAttribute(value="counterPartyIsUsPerson")
        @RuneAttribute(value="counterPartyIsUsPerson")
        public Boolean getCounterPartyIsUsPerson() {
            return this.counterPartyIsUsPerson;
        }

        @Override
        @RosettaAttribute(value="allocationStatus")
        @RuneAttribute(value="allocationStatus")
        public AllocationReportingStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        @RosettaAttribute(value="clientAccountType")
        @RuneAttribute(value="clientAccountType")
        public TradeCategory getClientAccountType() {
            return this.clientAccountType;
        }

        @Override
        @RosettaAttribute(value="interAffiliateClearingExemptionParty")
        @RuneAttribute(value="interAffiliateClearingExemptionParty")
        public PartyReference getInterAffiliateClearingExemptionParty() {
            return this.interAffiliateClearingExemptionParty;
        }

        @Override
        @RosettaAttribute(value="reportingPartyClearingExemption")
        @RuneAttribute(value="reportingPartyClearingExemption")
        public List<String> getReportingPartyClearingExemption() {
            return this.reportingPartyClearingExemption;
        }

        @Override
        @RosettaAttribute(value="counterPartyClearingExemption")
        @RuneAttribute(value="counterPartyClearingExemption")
        public List<String> getCounterPartyClearingExemption() {
            return this.counterPartyClearingExemption;
        }

        @Override
        @RosettaAttribute(value="collateralTypeAllowed")
        @RuneAttribute(value="collateralTypeAllowed")
        public List<String> getCollateralTypeAllowed() {
            return this.collateralTypeAllowed;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioContainsNonReportableComponents")
        @RuneAttribute(value="collateralPortfolioContainsNonReportableComponents")
        public Boolean getCollateralPortfolioContainsNonReportableComponents() {
            return this.collateralPortfolioContainsNonReportableComponents;
        }

        @Override
        @RosettaAttribute(value="packageContainsNonReportableComponents")
        @RuneAttribute(value="packageContainsNonReportableComponents")
        public Boolean getPackageContainsNonReportableComponents() {
            return this.packageContainsNonReportableComponents;
        }

        @Override
        @RosettaAttribute(value="specialEntityType")
        @RuneAttribute(value="specialEntityType")
        public String getSpecialEntityType() {
            return this.specialEntityType;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public ActionType getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public String getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="tradeExecutionRequirementIndicator")
        @RuneAttribute(value="tradeExecutionRequirementIndicator")
        public Boolean getTradeExecutionRequirementIndicator() {
            return this.tradeExecutionRequirementIndicator;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDate")
        @RuneAttribute(value="lastFloatingReferenceResetDate")
        public ZonedDateTime getLastFloatingReferenceResetDate() {
            return this.lastFloatingReferenceResetDate;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public ZonedDateTime getNextFloatingReferenceResetDate() {
            return this.nextFloatingReferenceResetDate;
        }

        @Override
        public RegulatoryClassificationPart45_2019 build() {
            return this;
        }

        @Override
        public RegulatoryClassificationPart45_2019Builder toBuilder() {
            RegulatoryClassificationPart45_2019Builder builder = RegulatoryClassificationPart45_2019.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryClassificationPart45_2019Builder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getReportingRoleAndPurposeModel()).ifPresent(builder::setReportingRoleAndPurposeModel);
            Optional.ofNullable(this.getRegulatoryBuyerAndSellerModel()).ifPresent(builder::setRegulatoryBuyerAndSellerModel);
            Optional.ofNullable(this.getMandatorilyClearable()).ifPresent(builder::setMandatorilyClearable);
            Optional.ofNullable(this.getRegulatoryClassificationPart45_2019Sequence()).ifPresent(builder::setRegulatoryClassificationPart45_2019Sequence);
            Optional.ofNullable(this.getEndUserExceptionDeclaration()).ifPresent(builder::setEndUserExceptionDeclaration);
            Optional.ofNullable(this.getLargeSizeTrade()).ifPresent(builder::setLargeSizeTrade);
            Optional.ofNullable(this.getExecutionType()).ifPresent(builder::setExecutionType);
            Optional.ofNullable(this.getExecutionVenueType()).ifPresent(builder::setExecutionVenueType);
            Optional.ofNullable(this.getVerificationMethod()).ifPresent(builder::setVerificationMethod);
            Optional.ofNullable(this.getConfirmationMethod()).ifPresent(builder::setConfirmationMethod);
            Optional.ofNullable(this.getCollateralizationType()).ifPresent(builder::setCollateralizationType);
            Optional.ofNullable(this.getReportingPartyOrganizationType()).ifPresent(builder::setReportingPartyOrganizationType);
            Optional.ofNullable(this.getCounterPartyOrganizationType()).ifPresent(builder::setCounterPartyOrganizationType);
            Optional.ofNullable(this.getCounterPartyIsUsPerson()).ifPresent(builder::setCounterPartyIsUsPerson);
            Optional.ofNullable(this.getAllocationStatus()).ifPresent(builder::setAllocationStatus);
            Optional.ofNullable(this.getClientAccountType()).ifPresent(builder::setClientAccountType);
            Optional.ofNullable(this.getInterAffiliateClearingExemptionParty()).ifPresent(builder::setInterAffiliateClearingExemptionParty);
            Optional.ofNullable(this.getReportingPartyClearingExemption()).ifPresent(builder::setReportingPartyClearingExemption);
            Optional.ofNullable(this.getCounterPartyClearingExemption()).ifPresent(builder::setCounterPartyClearingExemption);
            Optional.ofNullable(this.getCollateralTypeAllowed()).ifPresent(builder::setCollateralTypeAllowed);
            Optional.ofNullable(this.getCollateralPortfolioContainsNonReportableComponents()).ifPresent(builder::setCollateralPortfolioContainsNonReportableComponents);
            Optional.ofNullable(this.getPackageContainsNonReportableComponents()).ifPresent(builder::setPackageContainsNonReportableComponents);
            Optional.ofNullable(this.getSpecialEntityType()).ifPresent(builder::setSpecialEntityType);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getTradeExecutionRequirementIndicator()).ifPresent(builder::setTradeExecutionRequirementIndicator);
            Optional.ofNullable(this.getLastFloatingReferenceResetDate()).ifPresent(builder::setLastFloatingReferenceResetDate);
            Optional.ofNullable(this.getNextFloatingReferenceResetDate()).ifPresent(builder::setNextFloatingReferenceResetDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryClassificationPart45_2019 _that = (RegulatoryClassificationPart45_2019)this.getType().cast(o);
            if (!ListEquals.listEquals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingRoleAndPurposeModel, _that.getReportingRoleAndPurposeModel())) {
                return false;
            }
            if (!Objects.equals(this.regulatoryBuyerAndSellerModel, _that.getRegulatoryBuyerAndSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.mandatorilyClearable, _that.getMandatorilyClearable())) {
                return false;
            }
            if (!Objects.equals(this.regulatoryClassificationPart45_2019Sequence, _that.getRegulatoryClassificationPart45_2019Sequence())) {
                return false;
            }
            if (!Objects.equals(this.endUserExceptionDeclaration, _that.getEndUserExceptionDeclaration())) {
                return false;
            }
            if (!Objects.equals(this.largeSizeTrade, _that.getLargeSizeTrade())) {
                return false;
            }
            if (!Objects.equals(this.executionType, _that.getExecutionType())) {
                return false;
            }
            if (!Objects.equals(this.executionVenueType, _that.getExecutionVenueType())) {
                return false;
            }
            if (!Objects.equals(this.verificationMethod, _that.getVerificationMethod())) {
                return false;
            }
            if (!Objects.equals(this.confirmationMethod, _that.getConfirmationMethod())) {
                return false;
            }
            if (!Objects.equals(this.collateralizationType, _that.getCollateralizationType())) {
                return false;
            }
            if (!Objects.equals(this.reportingPartyOrganizationType, _that.getReportingPartyOrganizationType())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyOrganizationType, _that.getCounterPartyOrganizationType())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyIsUsPerson, _that.getCounterPartyIsUsPerson())) {
                return false;
            }
            if (!Objects.equals(this.allocationStatus, _that.getAllocationStatus())) {
                return false;
            }
            if (!Objects.equals(this.clientAccountType, _that.getClientAccountType())) {
                return false;
            }
            if (!Objects.equals(this.interAffiliateClearingExemptionParty, _that.getInterAffiliateClearingExemptionParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.reportingPartyClearingExemption, _that.getReportingPartyClearingExemption())) {
                return false;
            }
            if (!ListEquals.listEquals(this.counterPartyClearingExemption, _that.getCounterPartyClearingExemption())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralTypeAllowed, _that.getCollateralTypeAllowed())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioContainsNonReportableComponents, _that.getCollateralPortfolioContainsNonReportableComponents())) {
                return false;
            }
            if (!Objects.equals(this.packageContainsNonReportableComponents, _that.getPackageContainsNonReportableComponents())) {
                return false;
            }
            if (!Objects.equals(this.specialEntityType, _that.getSpecialEntityType())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.tradeExecutionRequirementIndicator, _that.getTradeExecutionRequirementIndicator())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDate, _that.getLastFloatingReferenceResetDate())) {
                return false;
            }
            return Objects.equals(this.nextFloatingReferenceResetDate, _that.getNextFloatingReferenceResetDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryBuyerAndSellerModel != null ? this.regulatoryBuyerAndSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? this.mandatorilyClearable.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryClassificationPart45_2019Sequence != null ? this.regulatoryClassificationPart45_2019Sequence.hashCode() : 0);
            _result = 31 * _result + (this.endUserExceptionDeclaration != null ? this.endUserExceptionDeclaration.hashCode() : 0);
            _result = 31 * _result + (this.largeSizeTrade != null ? this.largeSizeTrade.hashCode() : 0);
            _result = 31 * _result + (this.executionType != null ? this.executionType.hashCode() : 0);
            _result = 31 * _result + (this.executionVenueType != null ? this.executionVenueType.hashCode() : 0);
            _result = 31 * _result + (this.verificationMethod != null ? this.verificationMethod.hashCode() : 0);
            _result = 31 * _result + (this.confirmationMethod != null ? this.confirmationMethod.hashCode() : 0);
            _result = 31 * _result + (this.collateralizationType != null ? this.collateralizationType.hashCode() : 0);
            _result = 31 * _result + (this.reportingPartyOrganizationType != null ? this.reportingPartyOrganizationType.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyOrganizationType != null ? this.counterPartyOrganizationType.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyIsUsPerson != null ? this.counterPartyIsUsPerson.hashCode() : 0);
            _result = 31 * _result + (this.allocationStatus != null ? this.allocationStatus.hashCode() : 0);
            _result = 31 * _result + (this.clientAccountType != null ? this.clientAccountType.hashCode() : 0);
            _result = 31 * _result + (this.interAffiliateClearingExemptionParty != null ? this.interAffiliateClearingExemptionParty.hashCode() : 0);
            _result = 31 * _result + (this.reportingPartyClearingExemption != null ? this.reportingPartyClearingExemption.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyClearingExemption != null ? this.counterPartyClearingExemption.hashCode() : 0);
            _result = 31 * _result + (this.collateralTypeAllowed != null ? this.collateralTypeAllowed.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioContainsNonReportableComponents != null ? this.collateralPortfolioContainsNonReportableComponents.hashCode() : 0);
            _result = 31 * _result + (this.packageContainsNonReportableComponents != null ? this.packageContainsNonReportableComponents.hashCode() : 0);
            _result = 31 * _result + (this.specialEntityType != null ? this.specialEntityType.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.tradeExecutionRequirementIndicator != null ? this.tradeExecutionRequirementIndicator.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDate != null ? this.lastFloatingReferenceResetDate.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDate != null ? this.nextFloatingReferenceResetDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryClassificationPart45_2019 {supervisoryBody=" + this.supervisoryBody + ", reportingRoleAndPurposeModel=" + this.reportingRoleAndPurposeModel + ", regulatoryBuyerAndSellerModel=" + this.regulatoryBuyerAndSellerModel + ", mandatorilyClearable=" + this.mandatorilyClearable + ", regulatoryClassificationPart45_2019Sequence=" + this.regulatoryClassificationPart45_2019Sequence + ", endUserExceptionDeclaration=" + this.endUserExceptionDeclaration + ", largeSizeTrade=" + this.largeSizeTrade + ", executionType=" + this.executionType + ", executionVenueType=" + this.executionVenueType + ", verificationMethod=" + this.verificationMethod + ", confirmationMethod=" + this.confirmationMethod + ", collateralizationType=" + this.collateralizationType + ", reportingPartyOrganizationType=" + this.reportingPartyOrganizationType + ", counterPartyOrganizationType=" + this.counterPartyOrganizationType + ", counterPartyIsUsPerson=" + this.counterPartyIsUsPerson + ", allocationStatus=" + this.allocationStatus + ", clientAccountType=" + this.clientAccountType + ", interAffiliateClearingExemptionParty=" + this.interAffiliateClearingExemptionParty + ", reportingPartyClearingExemption=" + this.reportingPartyClearingExemption + ", counterPartyClearingExemption=" + this.counterPartyClearingExemption + ", collateralTypeAllowed=" + this.collateralTypeAllowed + ", collateralPortfolioContainsNonReportableComponents=" + this.collateralPortfolioContainsNonReportableComponents + ", packageContainsNonReportableComponents=" + this.packageContainsNonReportableComponents + ", specialEntityType=" + this.specialEntityType + ", actionType=" + this.actionType + ", eventType=" + this.eventType + ", tradeExecutionRequirementIndicator=" + this.tradeExecutionRequirementIndicator + ", lastFloatingReferenceResetDate=" + this.lastFloatingReferenceResetDate + ", nextFloatingReferenceResetDate=" + this.nextFloatingReferenceResetDate + '}' + " " + super.toString();
        }
    }
}

