/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.option.shared.meta.PremiumMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentDiscountingModel;
import fpml.consolidated.shared.PremiumModel;
import fpml.consolidated.shared.SimplePayment;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Premium", builder=PremiumBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Premium", model="fpml", builder=PremiumBuilderImpl.class, version="1.1.0")
public interface Premium
extends SimplePayment {
    public static final PremiumMeta metaData = new PremiumMeta();

    public PremiumModel getPremiumModel();

    public PaymentDiscountingModel getPaymentDiscountingModel();

    @Override
    public Premium build();

    @Override
    public PremiumBuilder toBuilder();

    public static PremiumBuilder builder() {
        return new PremiumBuilderImpl();
    }

    default public RosettaMetaData<? extends Premium> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Premium> getType() {
        return Premium.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premiumModel"), processor, PremiumModel.class, this.getPremiumModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDiscountingModel"), processor, PaymentDiscountingModel.class, this.getPaymentDiscountingModel(), new AttributeMeta[0]);
    }

    public static class PremiumBuilderImpl
    extends SimplePayment.SimplePaymentBuilderImpl
    implements PremiumBuilder {
        protected PremiumModel.PremiumModelBuilder premiumModel;
        protected PaymentDiscountingModel.PaymentDiscountingModelBuilder paymentDiscountingModel;

        @Override
        @RosettaAttribute(value="premiumModel")
        @RuneAttribute(value="premiumModel")
        public PremiumModel.PremiumModelBuilder getPremiumModel() {
            return this.premiumModel;
        }

        @Override
        public PremiumModel.PremiumModelBuilder getOrCreatePremiumModel() {
            PremiumModel.PremiumModelBuilder result = this.premiumModel != null ? this.premiumModel : (this.premiumModel = PremiumModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDiscountingModel")
        @RuneAttribute(value="paymentDiscountingModel")
        public PaymentDiscountingModel.PaymentDiscountingModelBuilder getPaymentDiscountingModel() {
            return this.paymentDiscountingModel;
        }

        @Override
        public PaymentDiscountingModel.PaymentDiscountingModelBuilder getOrCreatePaymentDiscountingModel() {
            PaymentDiscountingModel.PaymentDiscountingModelBuilder result = this.paymentDiscountingModel != null ? this.paymentDiscountingModel : (this.paymentDiscountingModel = PaymentDiscountingModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PremiumBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PremiumBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public PremiumBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public PremiumBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premiumModel")
        @RuneAttribute(value="premiumModel")
        public PremiumBuilder setPremiumModel(PremiumModel _premiumModel) {
            this.premiumModel = _premiumModel == null ? null : _premiumModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDiscountingModel")
        @RuneAttribute(value="paymentDiscountingModel")
        public PremiumBuilder setPaymentDiscountingModel(PaymentDiscountingModel _paymentDiscountingModel) {
            this.paymentDiscountingModel = _paymentDiscountingModel == null ? null : _paymentDiscountingModel.toBuilder();
            return this;
        }

        @Override
        public Premium build() {
            return new PremiumImpl(this);
        }

        @Override
        public PremiumBuilder toBuilder() {
            return this;
        }

        @Override
        public PremiumBuilder prune() {
            super.prune();
            if (this.premiumModel != null && !this.premiumModel.prune().hasData()) {
                this.premiumModel = null;
            }
            if (this.paymentDiscountingModel != null && !this.paymentDiscountingModel.prune().hasData()) {
                this.paymentDiscountingModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPremiumModel() != null && this.getPremiumModel().hasData()) {
                return true;
            }
            return this.getPaymentDiscountingModel() != null && this.getPaymentDiscountingModel().hasData();
        }

        @Override
        public PremiumBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PremiumBuilder o = (PremiumBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremiumModel(), (RosettaModelObjectBuilder)o.getPremiumModel(), this::setPremiumModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDiscountingModel(), (RosettaModelObjectBuilder)o.getPaymentDiscountingModel(), this::setPaymentDiscountingModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Premium _that = (Premium)this.getType().cast(o);
            if (!Objects.equals(this.premiumModel, _that.getPremiumModel())) {
                return false;
            }
            return Objects.equals(this.paymentDiscountingModel, _that.getPaymentDiscountingModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.premiumModel != null ? this.premiumModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentDiscountingModel != null ? this.paymentDiscountingModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PremiumBuilder {premiumModel=" + this.premiumModel + ", paymentDiscountingModel=" + this.paymentDiscountingModel + '}' + " " + super.toString();
        }
    }

    public static interface PremiumBuilder
    extends Premium,
    SimplePayment.SimplePaymentBuilder {
        public PremiumModel.PremiumModelBuilder getOrCreatePremiumModel();

        @Override
        public PremiumModel.PremiumModelBuilder getPremiumModel();

        public PaymentDiscountingModel.PaymentDiscountingModelBuilder getOrCreatePaymentDiscountingModel();

        @Override
        public PaymentDiscountingModel.PaymentDiscountingModelBuilder getPaymentDiscountingModel();

        @Override
        public PremiumBuilder setId(String var1);

        @Override
        public PremiumBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public PremiumBuilder setPaymentAmount(NonNegativeMoney var1);

        @Override
        public PremiumBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public PremiumBuilder setPremiumModel(PremiumModel var1);

        public PremiumBuilder setPaymentDiscountingModel(PaymentDiscountingModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premiumModel"), processor, PremiumModel.PremiumModelBuilder.class, this.getPremiumModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDiscountingModel"), processor, PaymentDiscountingModel.PaymentDiscountingModelBuilder.class, this.getPaymentDiscountingModel(), new AttributeMeta[0]);
        }

        @Override
        public PremiumBuilder prune();
    }

    public static class PremiumImpl
    extends SimplePayment.SimplePaymentImpl
    implements Premium {
        private final PremiumModel premiumModel;
        private final PaymentDiscountingModel paymentDiscountingModel;

        protected PremiumImpl(PremiumBuilder builder) {
            super(builder);
            this.premiumModel = Optional.ofNullable(builder.getPremiumModel()).map(f -> f.build()).orElse(null);
            this.paymentDiscountingModel = Optional.ofNullable(builder.getPaymentDiscountingModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="premiumModel")
        @RuneAttribute(value="premiumModel")
        public PremiumModel getPremiumModel() {
            return this.premiumModel;
        }

        @Override
        @RosettaAttribute(value="paymentDiscountingModel")
        @RuneAttribute(value="paymentDiscountingModel")
        public PaymentDiscountingModel getPaymentDiscountingModel() {
            return this.paymentDiscountingModel;
        }

        @Override
        public Premium build() {
            return this;
        }

        @Override
        public PremiumBuilder toBuilder() {
            PremiumBuilder builder = Premium.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PremiumBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPremiumModel()).ifPresent(builder::setPremiumModel);
            Optional.ofNullable(this.getPaymentDiscountingModel()).ifPresent(builder::setPaymentDiscountingModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Premium _that = (Premium)this.getType().cast(o);
            if (!Objects.equals(this.premiumModel, _that.getPremiumModel())) {
                return false;
            }
            return Objects.equals(this.paymentDiscountingModel, _that.getPaymentDiscountingModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.premiumModel != null ? this.premiumModel.hashCode() : 0);
            _result = 31 * _result + (this.paymentDiscountingModel != null ? this.paymentDiscountingModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Premium {premiumModel=" + this.premiumModel + ", paymentDiscountingModel=" + this.paymentDiscountingModel + '}' + " " + super.toString();
        }
    }
}

