/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.AssetReference;
import fpml.consolidated.mktenv.YieldCurveReference;
import fpml.consolidated.mktenv.meta.VolatilityRepresentationMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.PricingStructure;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VolatilityRepresentation", builder=VolatilityRepresentationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="VolatilityRepresentation", model="fpml", builder=VolatilityRepresentationBuilderImpl.class, version="1.1.0")
public interface VolatilityRepresentation
extends PricingStructure {
    public static final VolatilityRepresentationMeta metaData = new VolatilityRepresentationMeta();

    public AssetReference getAsset();

    public YieldCurveReference getYieldCurveReference();

    @Override
    public VolatilityRepresentation build();

    @Override
    public VolatilityRepresentationBuilder toBuilder();

    public static VolatilityRepresentationBuilder builder() {
        return new VolatilityRepresentationBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilityRepresentation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilityRepresentation> getType() {
        return VolatilityRepresentation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asset"), processor, AssetReference.class, this.getAsset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("yieldCurveReference"), processor, YieldCurveReference.class, this.getYieldCurveReference(), new AttributeMeta[0]);
    }

    public static class VolatilityRepresentationBuilderImpl
    extends PricingStructure.PricingStructureBuilderImpl
    implements VolatilityRepresentationBuilder {
        protected AssetReference.AssetReferenceBuilder asset;
        protected YieldCurveReference.YieldCurveReferenceBuilder yieldCurveReference;

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public AssetReference.AssetReferenceBuilder getAsset() {
            return this.asset;
        }

        @Override
        public AssetReference.AssetReferenceBuilder getOrCreateAsset() {
            AssetReference.AssetReferenceBuilder result = this.asset != null ? this.asset : (this.asset = AssetReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="yieldCurveReference")
        @RuneAttribute(value="yieldCurveReference")
        public YieldCurveReference.YieldCurveReferenceBuilder getYieldCurveReference() {
            return this.yieldCurveReference;
        }

        @Override
        public YieldCurveReference.YieldCurveReferenceBuilder getOrCreateYieldCurveReference() {
            YieldCurveReference.YieldCurveReferenceBuilder result = this.yieldCurveReference != null ? this.yieldCurveReference : (this.yieldCurveReference = YieldCurveReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public VolatilityRepresentationBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public VolatilityRepresentationBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VolatilityRepresentationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public VolatilityRepresentationBuilder setAsset(AssetReference _asset) {
            this.asset = _asset == null ? null : _asset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="yieldCurveReference")
        @RuneAttribute(value="yieldCurveReference")
        public VolatilityRepresentationBuilder setYieldCurveReference(YieldCurveReference _yieldCurveReference) {
            this.yieldCurveReference = _yieldCurveReference == null ? null : _yieldCurveReference.toBuilder();
            return this;
        }

        @Override
        public VolatilityRepresentation build() {
            return new VolatilityRepresentationImpl(this);
        }

        @Override
        public VolatilityRepresentationBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityRepresentationBuilder prune() {
            super.prune();
            if (this.asset != null && !this.asset.prune().hasData()) {
                this.asset = null;
            }
            if (this.yieldCurveReference != null && !this.yieldCurveReference.prune().hasData()) {
                this.yieldCurveReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAsset() != null && this.getAsset().hasData()) {
                return true;
            }
            return this.getYieldCurveReference() != null && this.getYieldCurveReference().hasData();
        }

        @Override
        public VolatilityRepresentationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityRepresentationBuilder o = (VolatilityRepresentationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsset(), (RosettaModelObjectBuilder)o.getAsset(), this::setAsset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getYieldCurveReference(), (RosettaModelObjectBuilder)o.getYieldCurveReference(), this::setYieldCurveReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityRepresentation _that = (VolatilityRepresentation)this.getType().cast(o);
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            return Objects.equals(this.yieldCurveReference, _that.getYieldCurveReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.yieldCurveReference != null ? this.yieldCurveReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityRepresentationBuilder {asset=" + this.asset + ", yieldCurveReference=" + this.yieldCurveReference + '}' + " " + super.toString();
        }
    }

    public static interface VolatilityRepresentationBuilder
    extends VolatilityRepresentation,
    PricingStructure.PricingStructureBuilder {
        public AssetReference.AssetReferenceBuilder getOrCreateAsset();

        @Override
        public AssetReference.AssetReferenceBuilder getAsset();

        public YieldCurveReference.YieldCurveReferenceBuilder getOrCreateYieldCurveReference();

        @Override
        public YieldCurveReference.YieldCurveReferenceBuilder getYieldCurveReference();

        @Override
        public VolatilityRepresentationBuilder setName(String var1);

        @Override
        public VolatilityRepresentationBuilder setCurrency(Currency var1);

        @Override
        public VolatilityRepresentationBuilder setId(String var1);

        public VolatilityRepresentationBuilder setAsset(AssetReference var1);

        public VolatilityRepresentationBuilder setYieldCurveReference(YieldCurveReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asset"), processor, AssetReference.AssetReferenceBuilder.class, this.getAsset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("yieldCurveReference"), processor, YieldCurveReference.YieldCurveReferenceBuilder.class, this.getYieldCurveReference(), new AttributeMeta[0]);
        }

        @Override
        public VolatilityRepresentationBuilder prune();
    }

    public static class VolatilityRepresentationImpl
    extends PricingStructure.PricingStructureImpl
    implements VolatilityRepresentation {
        private final AssetReference asset;
        private final YieldCurveReference yieldCurveReference;

        protected VolatilityRepresentationImpl(VolatilityRepresentationBuilder builder) {
            super(builder);
            this.asset = Optional.ofNullable(builder.getAsset()).map(f -> f.build()).orElse(null);
            this.yieldCurveReference = Optional.ofNullable(builder.getYieldCurveReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="asset")
        @RuneAttribute(value="asset")
        public AssetReference getAsset() {
            return this.asset;
        }

        @Override
        @RosettaAttribute(value="yieldCurveReference")
        @RuneAttribute(value="yieldCurveReference")
        public YieldCurveReference getYieldCurveReference() {
            return this.yieldCurveReference;
        }

        @Override
        public VolatilityRepresentation build() {
            return this;
        }

        @Override
        public VolatilityRepresentationBuilder toBuilder() {
            VolatilityRepresentationBuilder builder = VolatilityRepresentation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityRepresentationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAsset()).ifPresent(builder::setAsset);
            Optional.ofNullable(this.getYieldCurveReference()).ifPresent(builder::setYieldCurveReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityRepresentation _that = (VolatilityRepresentation)this.getType().cast(o);
            if (!Objects.equals(this.asset, _that.getAsset())) {
                return false;
            }
            return Objects.equals(this.yieldCurveReference, _that.getYieldCurveReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.asset != null ? this.asset.hashCode() : 0);
            _result = 31 * _result + (this.yieldCurveReference != null ? this.yieldCurveReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityRepresentation {asset=" + this.asset + ", yieldCurveReference=" + this.yieldCurveReference + '}' + " " + super.toString();
        }
    }
}

