/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.PriceQuoteUnits;
import fpml.consolidated.mktenv.ParametricAdjustmentPoint;
import fpml.consolidated.mktenv.meta.ParametricAdjustmentMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ParametricAdjustment", builder=ParametricAdjustmentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ParametricAdjustment", model="fpml", builder=ParametricAdjustmentBuilderImpl.class, version="1.1.0")
public interface ParametricAdjustment
extends RosettaModelObject {
    public static final ParametricAdjustmentMeta metaData = new ParametricAdjustmentMeta();

    public String getName();

    public PriceQuoteUnits getInputUnits();

    public List<? extends ParametricAdjustmentPoint> getDatapoint();

    public ParametricAdjustment build();

    public ParametricAdjustmentBuilder toBuilder();

    public static ParametricAdjustmentBuilder builder() {
        return new ParametricAdjustmentBuilderImpl();
    }

    default public RosettaMetaData<? extends ParametricAdjustment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ParametricAdjustment> getType() {
        return ParametricAdjustment.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("inputUnits"), processor, PriceQuoteUnits.class, this.getInputUnits(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datapoint"), processor, ParametricAdjustmentPoint.class, this.getDatapoint(), new AttributeMeta[0]);
    }

    public static class ParametricAdjustmentBuilderImpl
    implements ParametricAdjustmentBuilder {
        protected String name;
        protected PriceQuoteUnits.PriceQuoteUnitsBuilder inputUnits;
        protected List<ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder> datapoint = new ArrayList<ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder>();

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="inputUnits")
        @RuneAttribute(value="inputUnits")
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getInputUnits() {
            return this.inputUnits;
        }

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateInputUnits() {
            PriceQuoteUnits.PriceQuoteUnitsBuilder result = this.inputUnits != null ? this.inputUnits : (this.inputUnits = PriceQuoteUnits.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="datapoint")
        @RuneAttribute(value="datapoint")
        public List<? extends ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder> getDatapoint() {
            return this.datapoint;
        }

        @Override
        public ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder getOrCreateDatapoint(int index) {
            if (this.datapoint == null) {
                this.datapoint = new ArrayList<ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder>();
            }
            return (ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder)this.getIndex(this.datapoint, index, () -> {
                ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder newDatapoint = ParametricAdjustmentPoint.builder();
                return newDatapoint;
            });
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public ParametricAdjustmentBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="inputUnits")
        @RuneAttribute(value="inputUnits")
        public ParametricAdjustmentBuilder setInputUnits(PriceQuoteUnits _inputUnits) {
            this.inputUnits = _inputUnits == null ? null : _inputUnits.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="datapoint")
        @RuneAttribute(value="datapoint")
        public ParametricAdjustmentBuilder addDatapoint(ParametricAdjustmentPoint _datapoint) {
            if (_datapoint != null) {
                this.datapoint.add(_datapoint.toBuilder());
            }
            return this;
        }

        @Override
        public ParametricAdjustmentBuilder addDatapoint(ParametricAdjustmentPoint _datapoint, int idx) {
            this.getIndex(this.datapoint, idx, () -> _datapoint.toBuilder());
            return this;
        }

        @Override
        public ParametricAdjustmentBuilder addDatapoint(List<? extends ParametricAdjustmentPoint> datapoints) {
            if (datapoints != null) {
                for (ParametricAdjustmentPoint parametricAdjustmentPoint : datapoints) {
                    this.datapoint.add(parametricAdjustmentPoint.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="datapoint")
        public ParametricAdjustmentBuilder setDatapoint(List<? extends ParametricAdjustmentPoint> datapoints) {
            this.datapoint = datapoints == null ? new ArrayList<ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder>() : (List)datapoints.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ParametricAdjustment build() {
            return new ParametricAdjustmentImpl(this);
        }

        @Override
        public ParametricAdjustmentBuilder toBuilder() {
            return this;
        }

        @Override
        public ParametricAdjustmentBuilder prune() {
            if (this.inputUnits != null && !this.inputUnits.prune().hasData()) {
                this.inputUnits = null;
            }
            this.datapoint = this.datapoint.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getInputUnits() != null && this.getInputUnits().hasData()) {
                return true;
            }
            return this.getDatapoint() != null && this.getDatapoint().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ParametricAdjustmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ParametricAdjustmentBuilder o = (ParametricAdjustmentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInputUnits(), (RosettaModelObjectBuilder)o.getInputUnits(), this::setInputUnits);
            merger.mergeRosetta(this.getDatapoint(), o.getDatapoint(), this::getOrCreateDatapoint);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ParametricAdjustment _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.inputUnits, _that.getInputUnits())) {
                return false;
            }
            return ListEquals.listEquals(this.datapoint, _that.getDatapoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.inputUnits != null ? this.inputUnits.hashCode() : 0);
            _result = 31 * _result + (this.datapoint != null ? this.datapoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ParametricAdjustmentBuilder {name=" + this.name + ", inputUnits=" + this.inputUnits + ", datapoint=" + this.datapoint + '}';
        }
    }

    public static interface ParametricAdjustmentBuilder
    extends ParametricAdjustment,
    RosettaModelObjectBuilder {
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getOrCreateInputUnits();

        @Override
        public PriceQuoteUnits.PriceQuoteUnitsBuilder getInputUnits();

        public ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder getOrCreateDatapoint(int var1);

        public List<? extends ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder> getDatapoint();

        public ParametricAdjustmentBuilder setName(String var1);

        public ParametricAdjustmentBuilder setInputUnits(PriceQuoteUnits var1);

        public ParametricAdjustmentBuilder addDatapoint(ParametricAdjustmentPoint var1);

        public ParametricAdjustmentBuilder addDatapoint(ParametricAdjustmentPoint var1, int var2);

        public ParametricAdjustmentBuilder addDatapoint(List<? extends ParametricAdjustmentPoint> var1);

        public ParametricAdjustmentBuilder setDatapoint(List<? extends ParametricAdjustmentPoint> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("inputUnits"), processor, PriceQuoteUnits.PriceQuoteUnitsBuilder.class, this.getInputUnits(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datapoint"), processor, ParametricAdjustmentPoint.ParametricAdjustmentPointBuilder.class, this.getDatapoint(), new AttributeMeta[0]);
        }

        public ParametricAdjustmentBuilder prune();
    }

    public static class ParametricAdjustmentImpl
    implements ParametricAdjustment {
        private final String name;
        private final PriceQuoteUnits inputUnits;
        private final List<? extends ParametricAdjustmentPoint> datapoint;

        protected ParametricAdjustmentImpl(ParametricAdjustmentBuilder builder) {
            this.name = builder.getName();
            this.inputUnits = Optional.ofNullable(builder.getInputUnits()).map(f -> f.build()).orElse(null);
            this.datapoint = Optional.ofNullable(builder.getDatapoint()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="inputUnits")
        @RuneAttribute(value="inputUnits")
        public PriceQuoteUnits getInputUnits() {
            return this.inputUnits;
        }

        @Override
        @RosettaAttribute(value="datapoint")
        @RuneAttribute(value="datapoint")
        public List<? extends ParametricAdjustmentPoint> getDatapoint() {
            return this.datapoint;
        }

        @Override
        public ParametricAdjustment build() {
            return this;
        }

        @Override
        public ParametricAdjustmentBuilder toBuilder() {
            ParametricAdjustmentBuilder builder = ParametricAdjustment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ParametricAdjustmentBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getInputUnits()).ifPresent(builder::setInputUnits);
            Optional.ofNullable(this.getDatapoint()).ifPresent(builder::setDatapoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ParametricAdjustment _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.inputUnits, _that.getInputUnits())) {
                return false;
            }
            return ListEquals.listEquals(this.datapoint, _that.getDatapoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.inputUnits != null ? this.inputUnits.hashCode() : 0);
            _result = 31 * _result + (this.datapoint != null ? this.datapoint.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ParametricAdjustment {name=" + this.name + ", inputUnits=" + this.inputUnits + ", datapoint=" + this.datapoint + '}';
        }
    }
}

