/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.QuotationCharacteristicsModel;
import fpml.consolidated.mktenv.PricingStructurePoint;
import fpml.consolidated.mktenv.meta.MultiDimensionalPricingDataMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MultiDimensionalPricingData", builder=MultiDimensionalPricingDataBuilderImpl.class, version="1.1.0")
@RuneDataType(value="MultiDimensionalPricingData", model="fpml", builder=MultiDimensionalPricingDataBuilderImpl.class, version="1.1.0")
public interface MultiDimensionalPricingData
extends RosettaModelObject {
    public static final MultiDimensionalPricingDataMeta metaData = new MultiDimensionalPricingDataMeta();

    public QuotationCharacteristicsModel getQuotationCharacteristicsModel();

    public List<? extends PricingStructurePoint> getPoint();

    public MultiDimensionalPricingData build();

    public MultiDimensionalPricingDataBuilder toBuilder();

    public static MultiDimensionalPricingDataBuilder builder() {
        return new MultiDimensionalPricingDataBuilderImpl();
    }

    default public RosettaMetaData<? extends MultiDimensionalPricingData> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MultiDimensionalPricingData> getType() {
        return MultiDimensionalPricingData.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quotationCharacteristicsModel"), processor, QuotationCharacteristicsModel.class, this.getQuotationCharacteristicsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("point"), processor, PricingStructurePoint.class, this.getPoint(), new AttributeMeta[0]);
    }

    public static class MultiDimensionalPricingDataBuilderImpl
    implements MultiDimensionalPricingDataBuilder {
        protected QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder quotationCharacteristicsModel;
        protected List<PricingStructurePoint.PricingStructurePointBuilder> point = new ArrayList<PricingStructurePoint.PricingStructurePointBuilder>();

        @Override
        @RosettaAttribute(value="quotationCharacteristicsModel")
        @RuneAttribute(value="quotationCharacteristicsModel")
        public QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder getQuotationCharacteristicsModel() {
            return this.quotationCharacteristicsModel;
        }

        @Override
        public QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder getOrCreateQuotationCharacteristicsModel() {
            QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder result = this.quotationCharacteristicsModel != null ? this.quotationCharacteristicsModel : (this.quotationCharacteristicsModel = QuotationCharacteristicsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="point")
        @RuneAttribute(value="point")
        public List<? extends PricingStructurePoint.PricingStructurePointBuilder> getPoint() {
            return this.point;
        }

        @Override
        public PricingStructurePoint.PricingStructurePointBuilder getOrCreatePoint(int index) {
            if (this.point == null) {
                this.point = new ArrayList<PricingStructurePoint.PricingStructurePointBuilder>();
            }
            return (PricingStructurePoint.PricingStructurePointBuilder)this.getIndex(this.point, index, () -> {
                PricingStructurePoint.PricingStructurePointBuilder newPoint = PricingStructurePoint.builder();
                return newPoint;
            });
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristicsModel")
        @RuneAttribute(value="quotationCharacteristicsModel")
        public MultiDimensionalPricingDataBuilder setQuotationCharacteristicsModel(QuotationCharacteristicsModel _quotationCharacteristicsModel) {
            this.quotationCharacteristicsModel = _quotationCharacteristicsModel == null ? null : _quotationCharacteristicsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="point")
        @RuneAttribute(value="point")
        public MultiDimensionalPricingDataBuilder addPoint(PricingStructurePoint _point) {
            if (_point != null) {
                this.point.add(_point.toBuilder());
            }
            return this;
        }

        @Override
        public MultiDimensionalPricingDataBuilder addPoint(PricingStructurePoint _point, int idx) {
            this.getIndex(this.point, idx, () -> _point.toBuilder());
            return this;
        }

        @Override
        public MultiDimensionalPricingDataBuilder addPoint(List<? extends PricingStructurePoint> points) {
            if (points != null) {
                for (PricingStructurePoint pricingStructurePoint : points) {
                    this.point.add(pricingStructurePoint.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="point")
        public MultiDimensionalPricingDataBuilder setPoint(List<? extends PricingStructurePoint> points) {
            this.point = points == null ? new ArrayList<PricingStructurePoint.PricingStructurePointBuilder>() : (List)points.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MultiDimensionalPricingData build() {
            return new MultiDimensionalPricingDataImpl(this);
        }

        @Override
        public MultiDimensionalPricingDataBuilder toBuilder() {
            return this;
        }

        @Override
        public MultiDimensionalPricingDataBuilder prune() {
            if (this.quotationCharacteristicsModel != null && !this.quotationCharacteristicsModel.prune().hasData()) {
                this.quotationCharacteristicsModel = null;
            }
            this.point = this.point.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getQuotationCharacteristicsModel() != null && this.getQuotationCharacteristicsModel().hasData()) {
                return true;
            }
            return this.getPoint() != null && this.getPoint().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MultiDimensionalPricingDataBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MultiDimensionalPricingDataBuilder o = (MultiDimensionalPricingDataBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotationCharacteristicsModel(), (RosettaModelObjectBuilder)o.getQuotationCharacteristicsModel(), this::setQuotationCharacteristicsModel);
            merger.mergeRosetta(this.getPoint(), o.getPoint(), this::getOrCreatePoint);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MultiDimensionalPricingData _that = this.getType().cast(o);
            if (!Objects.equals(this.quotationCharacteristicsModel, _that.getQuotationCharacteristicsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.point, _that.getPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotationCharacteristicsModel != null ? this.quotationCharacteristicsModel.hashCode() : 0);
            _result = 31 * _result + (this.point != null ? this.point.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MultiDimensionalPricingDataBuilder {quotationCharacteristicsModel=" + this.quotationCharacteristicsModel + ", point=" + this.point + '}';
        }
    }

    public static interface MultiDimensionalPricingDataBuilder
    extends MultiDimensionalPricingData,
    RosettaModelObjectBuilder {
        public QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder getOrCreateQuotationCharacteristicsModel();

        @Override
        public QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder getQuotationCharacteristicsModel();

        public PricingStructurePoint.PricingStructurePointBuilder getOrCreatePoint(int var1);

        public List<? extends PricingStructurePoint.PricingStructurePointBuilder> getPoint();

        public MultiDimensionalPricingDataBuilder setQuotationCharacteristicsModel(QuotationCharacteristicsModel var1);

        public MultiDimensionalPricingDataBuilder addPoint(PricingStructurePoint var1);

        public MultiDimensionalPricingDataBuilder addPoint(PricingStructurePoint var1, int var2);

        public MultiDimensionalPricingDataBuilder addPoint(List<? extends PricingStructurePoint> var1);

        public MultiDimensionalPricingDataBuilder setPoint(List<? extends PricingStructurePoint> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quotationCharacteristicsModel"), processor, QuotationCharacteristicsModel.QuotationCharacteristicsModelBuilder.class, this.getQuotationCharacteristicsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("point"), processor, PricingStructurePoint.PricingStructurePointBuilder.class, this.getPoint(), new AttributeMeta[0]);
        }

        public MultiDimensionalPricingDataBuilder prune();
    }

    public static class MultiDimensionalPricingDataImpl
    implements MultiDimensionalPricingData {
        private final QuotationCharacteristicsModel quotationCharacteristicsModel;
        private final List<? extends PricingStructurePoint> point;

        protected MultiDimensionalPricingDataImpl(MultiDimensionalPricingDataBuilder builder) {
            this.quotationCharacteristicsModel = Optional.ofNullable(builder.getQuotationCharacteristicsModel()).map(f -> f.build()).orElse(null);
            this.point = Optional.ofNullable(builder.getPoint()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotationCharacteristicsModel")
        @RuneAttribute(value="quotationCharacteristicsModel")
        public QuotationCharacteristicsModel getQuotationCharacteristicsModel() {
            return this.quotationCharacteristicsModel;
        }

        @Override
        @RosettaAttribute(value="point")
        @RuneAttribute(value="point")
        public List<? extends PricingStructurePoint> getPoint() {
            return this.point;
        }

        @Override
        public MultiDimensionalPricingData build() {
            return this;
        }

        @Override
        public MultiDimensionalPricingDataBuilder toBuilder() {
            MultiDimensionalPricingDataBuilder builder = MultiDimensionalPricingData.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MultiDimensionalPricingDataBuilder builder) {
            Optional.ofNullable(this.getQuotationCharacteristicsModel()).ifPresent(builder::setQuotationCharacteristicsModel);
            Optional.ofNullable(this.getPoint()).ifPresent(builder::setPoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MultiDimensionalPricingData _that = this.getType().cast(o);
            if (!Objects.equals(this.quotationCharacteristicsModel, _that.getQuotationCharacteristicsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.point, _that.getPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quotationCharacteristicsModel != null ? this.quotationCharacteristicsModel.hashCode() : 0);
            _result = 31 * _result + (this.point != null ? this.point.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MultiDimensionalPricingData {quotationCharacteristicsModel=" + this.quotationCharacteristicsModel + ", point=" + this.point + '}';
        }
    }
}

