/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractTradingAccrual;
import fpml.consolidated.loan.AccrualPeriod;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.meta.LoanTradingLoanContractAccrualMeta;
import fpml.consolidated.shared.Money;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradingLoanContractAccrual", builder=LoanTradingLoanContractAccrualBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanTradingLoanContractAccrual", model="fpml", builder=LoanTradingLoanContractAccrualBuilderImpl.class, version="1.1.0")
public interface LoanTradingLoanContractAccrual
extends AbstractTradingAccrual {
    public static final LoanTradingLoanContractAccrualMeta metaData = new LoanTradingLoanContractAccrualMeta();

    public LoanContractReference getLoanContractReference();

    @Override
    public LoanTradingLoanContractAccrual build();

    @Override
    public LoanTradingLoanContractAccrualBuilder toBuilder();

    public static LoanTradingLoanContractAccrualBuilder builder() {
        return new LoanTradingLoanContractAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingLoanContractAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingLoanContractAccrual> getType() {
        return LoanTradingLoanContractAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualPeriod"), processor, AccrualPeriod.class, this.getAccrualPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
    }

    public static class LoanTradingLoanContractAccrualBuilderImpl
    extends AbstractTradingAccrual.AbstractTradingAccrualBuilderImpl
    implements LoanTradingLoanContractAccrualBuilder {
        protected LoanContractReference.LoanContractReferenceBuilder loanContractReference;

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanContractReference.LoanContractReferenceBuilder getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference() {
            LoanContractReference.LoanContractReferenceBuilder result = this.loanContractReference != null ? this.loanContractReference : (this.loanContractReference = LoanContractReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradingLoanContractAccrualBuilder setAmount(Money _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualPeriod")
        @RuneAttribute(value="accrualPeriod")
        public LoanTradingLoanContractAccrualBuilder addAccrualPeriod(AccrualPeriod _accrualPeriod) {
            if (_accrualPeriod != null) {
                this.accrualPeriod.add(_accrualPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder addAccrualPeriod(AccrualPeriod _accrualPeriod, int idx) {
            this.getIndex(this.accrualPeriod, idx, () -> _accrualPeriod.toBuilder());
            return this;
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder addAccrualPeriod(List<? extends AccrualPeriod> accrualPeriods) {
            if (accrualPeriods != null) {
                for (AccrualPeriod accrualPeriod : accrualPeriods) {
                    this.accrualPeriod.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualPeriod")
        public LoanTradingLoanContractAccrualBuilder setAccrualPeriod(List<? extends AccrualPeriod> accrualPeriods) {
            this.accrualPeriod = accrualPeriods == null ? new ArrayList() : (List)accrualPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanTradingLoanContractAccrualBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        public LoanTradingLoanContractAccrual build() {
            return new LoanTradingLoanContractAccrualImpl(this);
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder prune() {
            super.prune();
            if (this.loanContractReference != null && !this.loanContractReference.prune().hasData()) {
                this.loanContractReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getLoanContractReference() != null && this.getLoanContractReference().hasData();
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradingLoanContractAccrualBuilder o = (LoanTradingLoanContractAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanContractReference(), (RosettaModelObjectBuilder)o.getLoanContractReference(), this::setLoanContractReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradingLoanContractAccrual _that = (LoanTradingLoanContractAccrual)this.getType().cast(o);
            return Objects.equals(this.loanContractReference, _that.getLoanContractReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradingLoanContractAccrualBuilder {loanContractReference=" + this.loanContractReference + '}' + " " + super.toString();
        }
    }

    public static interface LoanTradingLoanContractAccrualBuilder
    extends LoanTradingLoanContractAccrual,
    AbstractTradingAccrual.AbstractTradingAccrualBuilder {
        public LoanContractReference.LoanContractReferenceBuilder getOrCreateLoanContractReference();

        @Override
        public LoanContractReference.LoanContractReferenceBuilder getLoanContractReference();

        @Override
        public LoanTradingLoanContractAccrualBuilder setAmount(Money var1);

        @Override
        public LoanTradingLoanContractAccrualBuilder addAccrualPeriod(AccrualPeriod var1);

        @Override
        public LoanTradingLoanContractAccrualBuilder addAccrualPeriod(AccrualPeriod var1, int var2);

        @Override
        public LoanTradingLoanContractAccrualBuilder addAccrualPeriod(List<? extends AccrualPeriod> var1);

        @Override
        public LoanTradingLoanContractAccrualBuilder setAccrualPeriod(List<? extends AccrualPeriod> var1);

        public LoanTradingLoanContractAccrualBuilder setLoanContractReference(LoanContractReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualPeriod"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getAccrualPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, this.getLoanContractReference(), new AttributeMeta[0]);
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder prune();
    }

    public static class LoanTradingLoanContractAccrualImpl
    extends AbstractTradingAccrual.AbstractTradingAccrualImpl
    implements LoanTradingLoanContractAccrual {
        private final LoanContractReference loanContractReference;

        protected LoanTradingLoanContractAccrualImpl(LoanTradingLoanContractAccrualBuilder builder) {
            super(builder);
            this.loanContractReference = Optional.ofNullable(builder.getLoanContractReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanContractReference getLoanContractReference() {
            return this.loanContractReference;
        }

        @Override
        public LoanTradingLoanContractAccrual build() {
            return this;
        }

        @Override
        public LoanTradingLoanContractAccrualBuilder toBuilder() {
            LoanTradingLoanContractAccrualBuilder builder = LoanTradingLoanContractAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingLoanContractAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanContractReference()).ifPresent(builder::setLoanContractReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradingLoanContractAccrual _that = (LoanTradingLoanContractAccrual)this.getType().cast(o);
            return Objects.equals(this.loanContractReference, _that.getLoanContractReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanContractReference != null ? this.loanContractReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradingLoanContractAccrual {loanContractReference=" + this.loanContractReference + '}' + " " + super.toString();
        }
    }
}

