/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.AbstractLoanTradeEvent;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanTradeReference;
import fpml.consolidated.loan.meta.LoanTradeEventMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradeEvent", builder=LoanTradeEventBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanTradeEvent", model="fpml", builder=LoanTradeEventBuilderImpl.class, version="1.1.0")
public interface LoanTradeEvent
extends AbstractLoanTradeEvent {
    public static final LoanTradeEventMeta metaData = new LoanTradeEventMeta();

    @Override
    public LoanTradeEvent build();

    @Override
    public LoanTradeEventBuilder toBuilder();

    public static LoanTradeEventBuilder builder() {
        return new LoanTradeEventBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradeEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradeEvent> getType() {
        return LoanTradeEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.class, this.getLoanTradeReference(), new AttributeMeta[0]);
    }

    public static class LoanTradeEventBuilderImpl
    extends AbstractLoanTradeEvent.AbstractLoanTradeEventBuilderImpl
    implements LoanTradeEventBuilder {
        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanTradeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LoanTradeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LoanTradeEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LoanTradeEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanTradeEventBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeReference", isRequired=true)
        @RuneAttribute(value="loanTradeReference", isRequired=true)
        public LoanTradeEventBuilder setLoanTradeReference(LoanTradeReference _loanTradeReference) {
            this.loanTradeReference = _loanTradeReference == null ? null : _loanTradeReference.toBuilder();
            return this;
        }

        @Override
        public LoanTradeEvent build() {
            return new LoanTradeEventImpl(this);
        }

        @Override
        public LoanTradeEventBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradeEventBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public LoanTradeEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradeEventBuilder o = (LoanTradeEventBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeEventBuilder {} " + super.toString();
        }
    }

    public static interface LoanTradeEventBuilder
    extends LoanTradeEvent,
    AbstractLoanTradeEvent.AbstractLoanTradeEventBuilder {
        @Override
        public LoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LoanTradeEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LoanTradeEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanTradeEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanTradeEventBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LoanTradeEventBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LoanTradeEventBuilder setComment(String var1);

        @Override
        public LoanTradeEventBuilder setLoanTradeReference(LoanTradeReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.LoanTradeReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanTradeReference(), new AttributeMeta[0]);
        }

        @Override
        public LoanTradeEventBuilder prune();
    }

    public static class LoanTradeEventImpl
    extends AbstractLoanTradeEvent.AbstractLoanTradeEventImpl
    implements LoanTradeEvent {
        protected LoanTradeEventImpl(LoanTradeEventBuilder builder) {
            super(builder);
        }

        @Override
        public LoanTradeEvent build() {
            return this;
        }

        @Override
        public LoanTradeEventBuilder toBuilder() {
            LoanTradeEventBuilder builder = LoanTradeEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradeEventBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeEvent {} " + super.toString();
        }
    }
}

