/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractLoanPartyProfileStatement;
import fpml.consolidated.loan.PartyProfile;
import fpml.consolidated.loan.meta.LoanPartyProfileStatementMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanPartyProfileStatement", builder=LoanPartyProfileStatementBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanPartyProfileStatement", model="fpml", builder=LoanPartyProfileStatementBuilderImpl.class, version="1.1.0")
public interface LoanPartyProfileStatement
extends AbstractLoanPartyProfileStatement {
    public static final LoanPartyProfileStatementMeta metaData = new LoanPartyProfileStatementMeta();

    public PartyProfile getPartyProfile();

    public List<? extends Party> getParty();

    @Override
    public LoanPartyProfileStatement build();

    @Override
    public LoanPartyProfileStatementBuilder toBuilder();

    public static LoanPartyProfileStatementBuilder builder() {
        return new LoanPartyProfileStatementBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanPartyProfileStatement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanPartyProfileStatement> getType() {
        return LoanPartyProfileStatement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyProfile"), processor, PartyProfile.class, this.getPartyProfile(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LoanPartyProfileStatementBuilderImpl
    extends AbstractLoanPartyProfileStatement.AbstractLoanPartyProfileStatementBuilderImpl
    implements LoanPartyProfileStatementBuilder {
        protected PartyProfile.PartyProfileBuilder partyProfile;
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="partyProfile", isRequired=true)
        @RuneAttribute(value="partyProfile", isRequired=true)
        public PartyProfile.PartyProfileBuilder getPartyProfile() {
            return this.partyProfile;
        }

        @Override
        public PartyProfile.PartyProfileBuilder getOrCreatePartyProfile() {
            PartyProfile.PartyProfileBuilder result = this.partyProfile != null ? this.partyProfile : (this.partyProfile = PartyProfile.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanPartyProfileStatementBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanPartyProfileStatementBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanPartyProfileStatementBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanPartyProfileStatementBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanPartyProfileStatementBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LoanPartyProfileStatementBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanPartyProfileStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanPartyProfileStatementBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comments")
        @RuneAttribute(value="comments")
        public LoanPartyProfileStatementBuilder setComments(String _comments) {
            this.comments = _comments == null ? null : _comments;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyProfile", isRequired=true)
        @RuneAttribute(value="partyProfile", isRequired=true)
        public LoanPartyProfileStatementBuilder setPartyProfile(PartyProfile _partyProfile) {
            this.partyProfile = _partyProfile == null ? null : _partyProfile.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public LoanPartyProfileStatementBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LoanPartyProfileStatementBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LoanPartyProfileStatementBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LoanPartyProfileStatementBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanPartyProfileStatement build() {
            return new LoanPartyProfileStatementImpl(this);
        }

        @Override
        public LoanPartyProfileStatementBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanPartyProfileStatementBuilder prune() {
            super.prune();
            if (this.partyProfile != null && !this.partyProfile.prune().hasData()) {
                this.partyProfile = null;
            }
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPartyProfile() != null && this.getPartyProfile().hasData()) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanPartyProfileStatementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanPartyProfileStatementBuilder o = (LoanPartyProfileStatementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyProfile(), (RosettaModelObjectBuilder)o.getPartyProfile(), this::setPartyProfile);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanPartyProfileStatement _that = (LoanPartyProfileStatement)this.getType().cast(o);
            if (!Objects.equals(this.partyProfile, _that.getPartyProfile())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.partyProfile != null ? this.partyProfile.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanPartyProfileStatementBuilder {partyProfile=" + this.partyProfile + ", party=" + this.party + '}' + " " + super.toString();
        }
    }

    public static interface LoanPartyProfileStatementBuilder
    extends LoanPartyProfileStatement,
    AbstractLoanPartyProfileStatement.AbstractLoanPartyProfileStatementBuilder {
        public PartyProfile.PartyProfileBuilder getOrCreatePartyProfile();

        @Override
        public PartyProfile.PartyProfileBuilder getPartyProfile();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LoanPartyProfileStatementBuilder setFpmlVersion(String var1);

        @Override
        public LoanPartyProfileStatementBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanPartyProfileStatementBuilder setActualBuild(Integer var1);

        @Override
        public LoanPartyProfileStatementBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanPartyProfileStatementBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanPartyProfileStatementBuilder setIsCorrection(Boolean var1);

        @Override
        public LoanPartyProfileStatementBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanPartyProfileStatementBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LoanPartyProfileStatementBuilder setComments(String var1);

        public LoanPartyProfileStatementBuilder setPartyProfile(PartyProfile var1);

        public LoanPartyProfileStatementBuilder addParty(Party var1);

        public LoanPartyProfileStatementBuilder addParty(Party var1, int var2);

        public LoanPartyProfileStatementBuilder addParty(List<? extends Party> var1);

        public LoanPartyProfileStatementBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comments"), String.class, (Object)this.getComments(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyProfile"), processor, PartyProfile.PartyProfileBuilder.class, this.getPartyProfile(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LoanPartyProfileStatementBuilder prune();
    }

    public static class LoanPartyProfileStatementImpl
    extends AbstractLoanPartyProfileStatement.AbstractLoanPartyProfileStatementImpl
    implements LoanPartyProfileStatement {
        private final PartyProfile partyProfile;
        private final List<? extends Party> party;

        protected LoanPartyProfileStatementImpl(LoanPartyProfileStatementBuilder builder) {
            super(builder);
            this.partyProfile = Optional.ofNullable(builder.getPartyProfile()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyProfile", isRequired=true)
        @RuneAttribute(value="partyProfile", isRequired=true)
        public PartyProfile getPartyProfile() {
            return this.partyProfile;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LoanPartyProfileStatement build() {
            return this;
        }

        @Override
        public LoanPartyProfileStatementBuilder toBuilder() {
            LoanPartyProfileStatementBuilder builder = LoanPartyProfileStatement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanPartyProfileStatementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPartyProfile()).ifPresent(builder::setPartyProfile);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanPartyProfileStatement _that = (LoanPartyProfileStatement)this.getType().cast(o);
            if (!Objects.equals(this.partyProfile, _that.getPartyProfile())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.partyProfile != null ? this.partyProfile.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanPartyProfileStatement {partyProfile=" + this.partyProfile + ", party=" + this.party + '}' + " " + super.toString();
        }
    }
}

