/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LoanLegalStructureBeforeChoice;
import fpml.consolidated.loan.meta.LoanLegalStructureBeforeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanLegalStructureBefore", builder=LoanLegalStructureBeforeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanLegalStructureBefore", model="fpml", builder=LoanLegalStructureBeforeBuilderImpl.class, version="1.1.0")
public interface LoanLegalStructureBefore
extends RosettaModelObject {
    public static final LoanLegalStructureBeforeMeta metaData = new LoanLegalStructureBeforeMeta();

    public DealReference getDealReference();

    public List<? extends FacilityReference> getFacilityReference();

    public List<? extends LoanLegalStructureBeforeChoice> getLoanLegalStructureBeforeChoice();

    public LoanLegalStructureBefore build();

    public LoanLegalStructureBeforeBuilder toBuilder();

    public static LoanLegalStructureBeforeBuilder builder() {
        return new LoanLegalStructureBeforeBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanLegalStructureBefore> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanLegalStructureBefore> getType() {
        return LoanLegalStructureBefore.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanLegalStructureBeforeChoice"), processor, LoanLegalStructureBeforeChoice.class, this.getLoanLegalStructureBeforeChoice(), new AttributeMeta[0]);
    }

    public static class LoanLegalStructureBeforeBuilderImpl
    implements LoanLegalStructureBeforeBuilder {
        protected DealReference.DealReferenceBuilder dealReference;
        protected List<FacilityReference.FacilityReferenceBuilder> facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();
        protected List<LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder> loanLegalStructureBeforeChoice = new ArrayList<LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder>();

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference.DealReferenceBuilder getDealReference() {
            return this.dealReference;
        }

        @Override
        public DealReference.DealReferenceBuilder getOrCreateDealReference() {
            DealReference.DealReferenceBuilder result = this.dealReference != null ? this.dealReference : (this.dealReference = DealReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int index) {
            if (this.facilityReference == null) {
                this.facilityReference = new ArrayList<FacilityReference.FacilityReferenceBuilder>();
            }
            return (FacilityReference.FacilityReferenceBuilder)this.getIndex(this.facilityReference, index, () -> {
                FacilityReference.FacilityReferenceBuilder newFacilityReference = FacilityReference.builder();
                return newFacilityReference;
            });
        }

        @Override
        @RosettaAttribute(value="loanLegalStructureBeforeChoice")
        @RuneAttribute(value="loanLegalStructureBeforeChoice")
        public List<? extends LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder> getLoanLegalStructureBeforeChoice() {
            return this.loanLegalStructureBeforeChoice;
        }

        @Override
        public LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder getOrCreateLoanLegalStructureBeforeChoice(int index) {
            if (this.loanLegalStructureBeforeChoice == null) {
                this.loanLegalStructureBeforeChoice = new ArrayList<LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder>();
            }
            return (LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder)this.getIndex(this.loanLegalStructureBeforeChoice, index, () -> {
                LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder newLoanLegalStructureBeforeChoice = LoanLegalStructureBeforeChoice.builder();
                return newLoanLegalStructureBeforeChoice;
            });
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public LoanLegalStructureBeforeBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanLegalStructureBeforeBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalStructureBeforeBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public LoanLegalStructureBeforeBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public LoanLegalStructureBeforeBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList<FacilityReference.FacilityReferenceBuilder>() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanLegalStructureBeforeChoice")
        @RuneAttribute(value="loanLegalStructureBeforeChoice")
        public LoanLegalStructureBeforeBuilder addLoanLegalStructureBeforeChoice(LoanLegalStructureBeforeChoice _loanLegalStructureBeforeChoice) {
            if (_loanLegalStructureBeforeChoice != null) {
                this.loanLegalStructureBeforeChoice.add(_loanLegalStructureBeforeChoice.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalStructureBeforeBuilder addLoanLegalStructureBeforeChoice(LoanLegalStructureBeforeChoice _loanLegalStructureBeforeChoice, int idx) {
            this.getIndex(this.loanLegalStructureBeforeChoice, idx, () -> _loanLegalStructureBeforeChoice.toBuilder());
            return this;
        }

        @Override
        public LoanLegalStructureBeforeBuilder addLoanLegalStructureBeforeChoice(List<? extends LoanLegalStructureBeforeChoice> loanLegalStructureBeforeChoices) {
            if (loanLegalStructureBeforeChoices != null) {
                for (LoanLegalStructureBeforeChoice loanLegalStructureBeforeChoice : loanLegalStructureBeforeChoices) {
                    this.loanLegalStructureBeforeChoice.add(loanLegalStructureBeforeChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanLegalStructureBeforeChoice")
        public LoanLegalStructureBeforeBuilder setLoanLegalStructureBeforeChoice(List<? extends LoanLegalStructureBeforeChoice> loanLegalStructureBeforeChoices) {
            this.loanLegalStructureBeforeChoice = loanLegalStructureBeforeChoices == null ? new ArrayList<LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder>() : (List)loanLegalStructureBeforeChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanLegalStructureBefore build() {
            return new LoanLegalStructureBeforeImpl(this);
        }

        @Override
        public LoanLegalStructureBeforeBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanLegalStructureBeforeBuilder prune() {
            if (this.dealReference != null && !this.dealReference.prune().hasData()) {
                this.dealReference = null;
            }
            this.facilityReference = this.facilityReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.loanLegalStructureBeforeChoice = this.loanLegalStructureBeforeChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDealReference() != null && this.getDealReference().hasData()) {
                return true;
            }
            if (this.getFacilityReference() != null && this.getFacilityReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getLoanLegalStructureBeforeChoice() != null && this.getLoanLegalStructureBeforeChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanLegalStructureBeforeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanLegalStructureBeforeBuilder o = (LoanLegalStructureBeforeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealReference(), (RosettaModelObjectBuilder)o.getDealReference(), this::setDealReference);
            merger.mergeRosetta(this.getFacilityReference(), o.getFacilityReference(), this::getOrCreateFacilityReference);
            merger.mergeRosetta(this.getLoanLegalStructureBeforeChoice(), o.getLoanLegalStructureBeforeChoice(), this::getOrCreateLoanLegalStructureBeforeChoice);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanLegalStructureBefore _that = this.getType().cast(o);
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            return ListEquals.listEquals(this.loanLegalStructureBeforeChoice, _that.getLoanLegalStructureBeforeChoice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalStructureBeforeChoice != null ? this.loanLegalStructureBeforeChoice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanLegalStructureBeforeBuilder {dealReference=" + this.dealReference + ", facilityReference=" + this.facilityReference + ", loanLegalStructureBeforeChoice=" + this.loanLegalStructureBeforeChoice + '}';
        }
    }

    public static interface LoanLegalStructureBeforeBuilder
    extends LoanLegalStructureBefore,
    RosettaModelObjectBuilder {
        public DealReference.DealReferenceBuilder getOrCreateDealReference();

        @Override
        public DealReference.DealReferenceBuilder getDealReference();

        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference(int var1);

        public List<? extends FacilityReference.FacilityReferenceBuilder> getFacilityReference();

        public LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder getOrCreateLoanLegalStructureBeforeChoice(int var1);

        public List<? extends LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder> getLoanLegalStructureBeforeChoice();

        public LoanLegalStructureBeforeBuilder setDealReference(DealReference var1);

        public LoanLegalStructureBeforeBuilder addFacilityReference(FacilityReference var1);

        public LoanLegalStructureBeforeBuilder addFacilityReference(FacilityReference var1, int var2);

        public LoanLegalStructureBeforeBuilder addFacilityReference(List<? extends FacilityReference> var1);

        public LoanLegalStructureBeforeBuilder setFacilityReference(List<? extends FacilityReference> var1);

        public LoanLegalStructureBeforeBuilder addLoanLegalStructureBeforeChoice(LoanLegalStructureBeforeChoice var1);

        public LoanLegalStructureBeforeBuilder addLoanLegalStructureBeforeChoice(LoanLegalStructureBeforeChoice var1, int var2);

        public LoanLegalStructureBeforeBuilder addLoanLegalStructureBeforeChoice(List<? extends LoanLegalStructureBeforeChoice> var1);

        public LoanLegalStructureBeforeBuilder setLoanLegalStructureBeforeChoice(List<? extends LoanLegalStructureBeforeChoice> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanLegalStructureBeforeChoice"), processor, LoanLegalStructureBeforeChoice.LoanLegalStructureBeforeChoiceBuilder.class, this.getLoanLegalStructureBeforeChoice(), new AttributeMeta[0]);
        }

        public LoanLegalStructureBeforeBuilder prune();
    }

    public static class LoanLegalStructureBeforeImpl
    implements LoanLegalStructureBefore {
        private final DealReference dealReference;
        private final List<? extends FacilityReference> facilityReference;
        private final List<? extends LoanLegalStructureBeforeChoice> loanLegalStructureBeforeChoice;

        protected LoanLegalStructureBeforeImpl(LoanLegalStructureBeforeBuilder builder) {
            this.dealReference = Optional.ofNullable(builder.getDealReference()).map(f -> f.build()).orElse(null);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.loanLegalStructureBeforeChoice = Optional.ofNullable(builder.getLoanLegalStructureBeforeChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference getDealReference() {
            return this.dealReference;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public List<? extends FacilityReference> getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        @RosettaAttribute(value="loanLegalStructureBeforeChoice")
        @RuneAttribute(value="loanLegalStructureBeforeChoice")
        public List<? extends LoanLegalStructureBeforeChoice> getLoanLegalStructureBeforeChoice() {
            return this.loanLegalStructureBeforeChoice;
        }

        @Override
        public LoanLegalStructureBefore build() {
            return this;
        }

        @Override
        public LoanLegalStructureBeforeBuilder toBuilder() {
            LoanLegalStructureBeforeBuilder builder = LoanLegalStructureBefore.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanLegalStructureBeforeBuilder builder) {
            Optional.ofNullable(this.getDealReference()).ifPresent(builder::setDealReference);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
            Optional.ofNullable(this.getLoanLegalStructureBeforeChoice()).ifPresent(builder::setLoanLegalStructureBeforeChoice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanLegalStructureBefore _that = this.getType().cast(o);
            if (!Objects.equals(this.dealReference, _that.getDealReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            return ListEquals.listEquals(this.loanLegalStructureBeforeChoice, _that.getLoanLegalStructureBeforeChoice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalStructureBeforeChoice != null ? this.loanLegalStructureBeforeChoice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanLegalStructureBefore {dealReference=" + this.dealReference + ", facilityReference=" + this.facilityReference + ", loanLegalStructureBeforeChoice=" + this.loanLegalStructureBeforeChoice + '}';
        }
    }
}

