/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractLoanLegalAction;
import fpml.consolidated.loan.ActionApproval;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LegalActionId;
import fpml.consolidated.loan.LoanLegalActionDetails;
import fpml.consolidated.loan.LoanLegalActionSequence;
import fpml.consolidated.loan.VersionedLegalActionId;
import fpml.consolidated.loan.meta.LoanLegalActionMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanLegalAction", builder=LoanLegalActionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanLegalAction", model="fpml", builder=LoanLegalActionBuilderImpl.class, version="1.1.0")
public interface LoanLegalAction
extends AbstractLoanLegalAction {
    public static final LoanLegalActionMeta metaData = new LoanLegalActionMeta();

    public ActionApproval getApproval();

    public LoanLegalActionSequence getLoanLegalActionSequence();

    @Override
    public LoanLegalAction build();

    @Override
    public LoanLegalActionBuilder toBuilder();

    public static LoanLegalActionBuilder builder() {
        return new LoanLegalActionBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanLegalAction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanLegalAction> getType() {
        return LoanLegalAction.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionId"), processor, LegalActionId.class, this.getLegalActionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedLegalActionId"), processor, VersionedLegalActionId.class, this.getVersionedLegalActionId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("actionDetails"), processor, LoanLegalActionDetails.class, this.getActionDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approval"), processor, ActionApproval.class, this.getApproval(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanLegalActionSequence"), processor, LoanLegalActionSequence.class, this.getLoanLegalActionSequence(), new AttributeMeta[0]);
    }

    public static class LoanLegalActionBuilderImpl
    extends AbstractLoanLegalAction.AbstractLoanLegalActionBuilderImpl
    implements LoanLegalActionBuilder {
        protected ActionApproval.ActionApprovalBuilder approval;
        protected LoanLegalActionSequence.LoanLegalActionSequenceBuilder loanLegalActionSequence;

        @Override
        @RosettaAttribute(value="approval", isRequired=true)
        @RuneAttribute(value="approval", isRequired=true)
        public ActionApproval.ActionApprovalBuilder getApproval() {
            return this.approval;
        }

        @Override
        public ActionApproval.ActionApprovalBuilder getOrCreateApproval() {
            ActionApproval.ActionApprovalBuilder result = this.approval != null ? this.approval : (this.approval = ActionApproval.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionSequence")
        @RuneAttribute(value="loanLegalActionSequence")
        public LoanLegalActionSequence.LoanLegalActionSequenceBuilder getLoanLegalActionSequence() {
            return this.loanLegalActionSequence;
        }

        @Override
        public LoanLegalActionSequence.LoanLegalActionSequenceBuilder getOrCreateLoanLegalActionSequence() {
            LoanLegalActionSequence.LoanLegalActionSequenceBuilder result = this.loanLegalActionSequence != null ? this.loanLegalActionSequence : (this.loanLegalActionSequence = LoanLegalActionSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public LoanLegalActionBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanLegalActionBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionId")
        @RuneAttribute(value="legalActionId")
        public LoanLegalActionBuilder addLegalActionId(LegalActionId _legalActionId) {
            if (_legalActionId != null) {
                this.legalActionId.add(_legalActionId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionBuilder addLegalActionId(LegalActionId _legalActionId, int idx) {
            this.getIndex(this.legalActionId, idx, () -> _legalActionId.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionBuilder addLegalActionId(List<? extends LegalActionId> legalActionIds) {
            if (legalActionIds != null) {
                for (LegalActionId legalActionId : legalActionIds) {
                    this.legalActionId.add(legalActionId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legalActionId")
        public LoanLegalActionBuilder setLegalActionId(List<? extends LegalActionId> legalActionIds) {
            this.legalActionId = legalActionIds == null ? new ArrayList() : (List)legalActionIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedLegalActionId")
        @RuneAttribute(value="versionedLegalActionId")
        public LoanLegalActionBuilder addVersionedLegalActionId(VersionedLegalActionId _versionedLegalActionId) {
            if (_versionedLegalActionId != null) {
                this.versionedLegalActionId.add(_versionedLegalActionId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionBuilder addVersionedLegalActionId(VersionedLegalActionId _versionedLegalActionId, int idx) {
            this.getIndex(this.versionedLegalActionId, idx, () -> _versionedLegalActionId.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionBuilder addVersionedLegalActionId(List<? extends VersionedLegalActionId> versionedLegalActionIds) {
            if (versionedLegalActionIds != null) {
                for (VersionedLegalActionId versionedLegalActionId : versionedLegalActionIds) {
                    this.versionedLegalActionId.add(versionedLegalActionId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedLegalActionId")
        public LoanLegalActionBuilder setVersionedLegalActionId(List<? extends VersionedLegalActionId> versionedLegalActionIds) {
            this.versionedLegalActionId = versionedLegalActionIds == null ? new ArrayList() : (List)versionedLegalActionIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanLegalActionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionDetails", isRequired=true)
        @RuneAttribute(value="actionDetails", isRequired=true)
        public LoanLegalActionBuilder setActionDetails(LoanLegalActionDetails _actionDetails) {
            this.actionDetails = _actionDetails == null ? null : _actionDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public LoanLegalActionBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference")
        @RuneAttribute(value="facilityReference")
        public LoanLegalActionBuilder addFacilityReference(FacilityReference _facilityReference) {
            if (_facilityReference != null) {
                this.facilityReference.add(_facilityReference.toBuilder());
            }
            return this;
        }

        @Override
        public LoanLegalActionBuilder addFacilityReference(FacilityReference _facilityReference, int idx) {
            this.getIndex(this.facilityReference, idx, () -> _facilityReference.toBuilder());
            return this;
        }

        @Override
        public LoanLegalActionBuilder addFacilityReference(List<? extends FacilityReference> facilityReferences) {
            if (facilityReferences != null) {
                for (FacilityReference facilityReference : facilityReferences) {
                    this.facilityReference.add(facilityReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="facilityReference")
        public LoanLegalActionBuilder setFacilityReference(List<? extends FacilityReference> facilityReferences) {
            this.facilityReference = facilityReferences == null ? new ArrayList() : (List)facilityReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="approval", isRequired=true)
        @RuneAttribute(value="approval", isRequired=true)
        public LoanLegalActionBuilder setApproval(ActionApproval _approval) {
            this.approval = _approval == null ? null : _approval.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionSequence")
        @RuneAttribute(value="loanLegalActionSequence")
        public LoanLegalActionBuilder setLoanLegalActionSequence(LoanLegalActionSequence _loanLegalActionSequence) {
            this.loanLegalActionSequence = _loanLegalActionSequence == null ? null : _loanLegalActionSequence.toBuilder();
            return this;
        }

        @Override
        public LoanLegalAction build() {
            return new LoanLegalActionImpl(this);
        }

        @Override
        public LoanLegalActionBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanLegalActionBuilder prune() {
            super.prune();
            if (this.approval != null && !this.approval.prune().hasData()) {
                this.approval = null;
            }
            if (this.loanLegalActionSequence != null && !this.loanLegalActionSequence.prune().hasData()) {
                this.loanLegalActionSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getApproval() != null && this.getApproval().hasData()) {
                return true;
            }
            return this.getLoanLegalActionSequence() != null && this.getLoanLegalActionSequence().hasData();
        }

        @Override
        public LoanLegalActionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanLegalActionBuilder o = (LoanLegalActionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApproval(), (RosettaModelObjectBuilder)o.getApproval(), this::setApproval);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanLegalActionSequence(), (RosettaModelObjectBuilder)o.getLoanLegalActionSequence(), this::setLoanLegalActionSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalAction _that = (LoanLegalAction)this.getType().cast(o);
            if (!Objects.equals(this.approval, _that.getApproval())) {
                return false;
            }
            return Objects.equals(this.loanLegalActionSequence, _that.getLoanLegalActionSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.approval != null ? this.approval.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalActionSequence != null ? this.loanLegalActionSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalActionBuilder {approval=" + this.approval + ", loanLegalActionSequence=" + this.loanLegalActionSequence + '}' + " " + super.toString();
        }
    }

    public static interface LoanLegalActionBuilder
    extends LoanLegalAction,
    AbstractLoanLegalAction.AbstractLoanLegalActionBuilder {
        public ActionApproval.ActionApprovalBuilder getOrCreateApproval();

        @Override
        public ActionApproval.ActionApprovalBuilder getApproval();

        public LoanLegalActionSequence.LoanLegalActionSequenceBuilder getOrCreateLoanLegalActionSequence();

        @Override
        public LoanLegalActionSequence.LoanLegalActionSequenceBuilder getLoanLegalActionSequence();

        @Override
        public LoanLegalActionBuilder setName(String var1);

        @Override
        public LoanLegalActionBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanLegalActionBuilder addLegalActionId(LegalActionId var1);

        @Override
        public LoanLegalActionBuilder addLegalActionId(LegalActionId var1, int var2);

        @Override
        public LoanLegalActionBuilder addLegalActionId(List<? extends LegalActionId> var1);

        @Override
        public LoanLegalActionBuilder setLegalActionId(List<? extends LegalActionId> var1);

        @Override
        public LoanLegalActionBuilder addVersionedLegalActionId(VersionedLegalActionId var1);

        @Override
        public LoanLegalActionBuilder addVersionedLegalActionId(VersionedLegalActionId var1, int var2);

        @Override
        public LoanLegalActionBuilder addVersionedLegalActionId(List<? extends VersionedLegalActionId> var1);

        @Override
        public LoanLegalActionBuilder setVersionedLegalActionId(List<? extends VersionedLegalActionId> var1);

        @Override
        public LoanLegalActionBuilder setId(String var1);

        @Override
        public LoanLegalActionBuilder setActionDetails(LoanLegalActionDetails var1);

        @Override
        public LoanLegalActionBuilder setDealReference(DealReference var1);

        @Override
        public LoanLegalActionBuilder addFacilityReference(FacilityReference var1);

        @Override
        public LoanLegalActionBuilder addFacilityReference(FacilityReference var1, int var2);

        @Override
        public LoanLegalActionBuilder addFacilityReference(List<? extends FacilityReference> var1);

        @Override
        public LoanLegalActionBuilder setFacilityReference(List<? extends FacilityReference> var1);

        public LoanLegalActionBuilder setApproval(ActionApproval var1);

        public LoanLegalActionBuilder setLoanLegalActionSequence(LoanLegalActionSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionId"), processor, LegalActionId.LegalActionIdBuilder.class, this.getLegalActionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedLegalActionId"), processor, VersionedLegalActionId.VersionedLegalActionIdBuilder.class, this.getVersionedLegalActionId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("actionDetails"), processor, LoanLegalActionDetails.LoanLegalActionDetailsBuilder.class, (RosettaModelObjectBuilder)this.getActionDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDealReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approval"), processor, ActionApproval.ActionApprovalBuilder.class, this.getApproval(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanLegalActionSequence"), processor, LoanLegalActionSequence.LoanLegalActionSequenceBuilder.class, this.getLoanLegalActionSequence(), new AttributeMeta[0]);
        }

        @Override
        public LoanLegalActionBuilder prune();
    }

    public static class LoanLegalActionImpl
    extends AbstractLoanLegalAction.AbstractLoanLegalActionImpl
    implements LoanLegalAction {
        private final ActionApproval approval;
        private final LoanLegalActionSequence loanLegalActionSequence;

        protected LoanLegalActionImpl(LoanLegalActionBuilder builder) {
            super(builder);
            this.approval = Optional.ofNullable(builder.getApproval()).map(f -> f.build()).orElse(null);
            this.loanLegalActionSequence = Optional.ofNullable(builder.getLoanLegalActionSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="approval", isRequired=true)
        @RuneAttribute(value="approval", isRequired=true)
        public ActionApproval getApproval() {
            return this.approval;
        }

        @Override
        @RosettaAttribute(value="loanLegalActionSequence")
        @RuneAttribute(value="loanLegalActionSequence")
        public LoanLegalActionSequence getLoanLegalActionSequence() {
            return this.loanLegalActionSequence;
        }

        @Override
        public LoanLegalAction build() {
            return this;
        }

        @Override
        public LoanLegalActionBuilder toBuilder() {
            LoanLegalActionBuilder builder = LoanLegalAction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanLegalActionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getApproval()).ifPresent(builder::setApproval);
            Optional.ofNullable(this.getLoanLegalActionSequence()).ifPresent(builder::setLoanLegalActionSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanLegalAction _that = (LoanLegalAction)this.getType().cast(o);
            if (!Objects.equals(this.approval, _that.getApproval())) {
                return false;
            }
            return Objects.equals(this.loanLegalActionSequence, _that.getLoanLegalActionSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.approval != null ? this.approval.hashCode() : 0);
            _result = 31 * _result + (this.loanLegalActionSequence != null ? this.loanLegalActionSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanLegalAction {approval=" + this.approval + ", loanLegalActionSequence=" + this.loanLegalActionSequence + '}' + " " + super.toString();
        }
    }
}

