/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.FinancialMetric;
import fpml.consolidated.loan.meta.LoanCovenantObligationMetricCalculationDetailsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanCovenantObligationMetricCalculationDetails", builder=LoanCovenantObligationMetricCalculationDetailsBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanCovenantObligationMetricCalculationDetails", model="fpml", builder=LoanCovenantObligationMetricCalculationDetailsBuilderImpl.class, version="1.1.0")
public interface LoanCovenantObligationMetricCalculationDetails
extends RosettaModelObject {
    public static final LoanCovenantObligationMetricCalculationDetailsMeta metaData = new LoanCovenantObligationMetricCalculationDetailsMeta();

    public List<? extends FinancialMetric> getNumeratorType();

    public List<? extends FinancialMetric> getDenominatorType();

    public LoanCovenantObligationMetricCalculationDetails build();

    public LoanCovenantObligationMetricCalculationDetailsBuilder toBuilder();

    public static LoanCovenantObligationMetricCalculationDetailsBuilder builder() {
        return new LoanCovenantObligationMetricCalculationDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanCovenantObligationMetricCalculationDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanCovenantObligationMetricCalculationDetails> getType() {
        return LoanCovenantObligationMetricCalculationDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("numeratorType"), processor, FinancialMetric.class, this.getNumeratorType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("denominatorType"), processor, FinancialMetric.class, this.getDenominatorType(), new AttributeMeta[0]);
    }

    public static class LoanCovenantObligationMetricCalculationDetailsBuilderImpl
    implements LoanCovenantObligationMetricCalculationDetailsBuilder {
        protected List<FinancialMetric.FinancialMetricBuilder> numeratorType = new ArrayList<FinancialMetric.FinancialMetricBuilder>();
        protected List<FinancialMetric.FinancialMetricBuilder> denominatorType = new ArrayList<FinancialMetric.FinancialMetricBuilder>();

        @Override
        @RosettaAttribute(value="numeratorType", isRequired=true)
        @RuneAttribute(value="numeratorType", isRequired=true)
        public List<? extends FinancialMetric.FinancialMetricBuilder> getNumeratorType() {
            return this.numeratorType;
        }

        @Override
        public FinancialMetric.FinancialMetricBuilder getOrCreateNumeratorType(int index) {
            if (this.numeratorType == null) {
                this.numeratorType = new ArrayList<FinancialMetric.FinancialMetricBuilder>();
            }
            return (FinancialMetric.FinancialMetricBuilder)this.getIndex(this.numeratorType, index, () -> {
                FinancialMetric.FinancialMetricBuilder newNumeratorType = FinancialMetric.builder();
                return newNumeratorType;
            });
        }

        @Override
        @RosettaAttribute(value="denominatorType", isRequired=true)
        @RuneAttribute(value="denominatorType", isRequired=true)
        public List<? extends FinancialMetric.FinancialMetricBuilder> getDenominatorType() {
            return this.denominatorType;
        }

        @Override
        public FinancialMetric.FinancialMetricBuilder getOrCreateDenominatorType(int index) {
            if (this.denominatorType == null) {
                this.denominatorType = new ArrayList<FinancialMetric.FinancialMetricBuilder>();
            }
            return (FinancialMetric.FinancialMetricBuilder)this.getIndex(this.denominatorType, index, () -> {
                FinancialMetric.FinancialMetricBuilder newDenominatorType = FinancialMetric.builder();
                return newDenominatorType;
            });
        }

        @Override
        @RosettaAttribute(value="numeratorType", isRequired=true)
        @RuneAttribute(value="numeratorType", isRequired=true)
        public LoanCovenantObligationMetricCalculationDetailsBuilder addNumeratorType(FinancialMetric _numeratorType) {
            if (_numeratorType != null) {
                this.numeratorType.add(_numeratorType.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder addNumeratorType(FinancialMetric _numeratorType, int idx) {
            this.getIndex(this.numeratorType, idx, () -> _numeratorType.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder addNumeratorType(List<? extends FinancialMetric> numeratorTypes) {
            if (numeratorTypes != null) {
                for (FinancialMetric financialMetric : numeratorTypes) {
                    this.numeratorType.add(financialMetric.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="numeratorType")
        public LoanCovenantObligationMetricCalculationDetailsBuilder setNumeratorType(List<? extends FinancialMetric> numeratorTypes) {
            this.numeratorType = numeratorTypes == null ? new ArrayList<FinancialMetric.FinancialMetricBuilder>() : (List)numeratorTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="denominatorType", isRequired=true)
        @RuneAttribute(value="denominatorType", isRequired=true)
        public LoanCovenantObligationMetricCalculationDetailsBuilder addDenominatorType(FinancialMetric _denominatorType) {
            if (_denominatorType != null) {
                this.denominatorType.add(_denominatorType.toBuilder());
            }
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder addDenominatorType(FinancialMetric _denominatorType, int idx) {
            this.getIndex(this.denominatorType, idx, () -> _denominatorType.toBuilder());
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder addDenominatorType(List<? extends FinancialMetric> denominatorTypes) {
            if (denominatorTypes != null) {
                for (FinancialMetric financialMetric : denominatorTypes) {
                    this.denominatorType.add(financialMetric.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="denominatorType")
        public LoanCovenantObligationMetricCalculationDetailsBuilder setDenominatorType(List<? extends FinancialMetric> denominatorTypes) {
            this.denominatorType = denominatorTypes == null ? new ArrayList<FinancialMetric.FinancialMetricBuilder>() : (List)denominatorTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetails build() {
            return new LoanCovenantObligationMetricCalculationDetailsImpl(this);
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder prune() {
            this.numeratorType = this.numeratorType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.denominatorType = this.denominatorType.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getNumeratorType() != null && this.getNumeratorType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDenominatorType() != null && this.getDenominatorType().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanCovenantObligationMetricCalculationDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanCovenantObligationMetricCalculationDetailsBuilder o = (LoanCovenantObligationMetricCalculationDetailsBuilder)other;
            merger.mergeRosetta(this.getNumeratorType(), o.getNumeratorType(), this::getOrCreateNumeratorType);
            merger.mergeRosetta(this.getDenominatorType(), o.getDenominatorType(), this::getOrCreateDenominatorType);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanCovenantObligationMetricCalculationDetails _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.numeratorType, _that.getNumeratorType())) {
                return false;
            }
            return ListEquals.listEquals(this.denominatorType, _that.getDenominatorType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.numeratorType != null ? this.numeratorType.hashCode() : 0);
            _result = 31 * _result + (this.denominatorType != null ? this.denominatorType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanCovenantObligationMetricCalculationDetailsBuilder {numeratorType=" + this.numeratorType + ", denominatorType=" + this.denominatorType + '}';
        }
    }

    public static interface LoanCovenantObligationMetricCalculationDetailsBuilder
    extends LoanCovenantObligationMetricCalculationDetails,
    RosettaModelObjectBuilder {
        public FinancialMetric.FinancialMetricBuilder getOrCreateNumeratorType(int var1);

        public List<? extends FinancialMetric.FinancialMetricBuilder> getNumeratorType();

        public FinancialMetric.FinancialMetricBuilder getOrCreateDenominatorType(int var1);

        public List<? extends FinancialMetric.FinancialMetricBuilder> getDenominatorType();

        public LoanCovenantObligationMetricCalculationDetailsBuilder addNumeratorType(FinancialMetric var1);

        public LoanCovenantObligationMetricCalculationDetailsBuilder addNumeratorType(FinancialMetric var1, int var2);

        public LoanCovenantObligationMetricCalculationDetailsBuilder addNumeratorType(List<? extends FinancialMetric> var1);

        public LoanCovenantObligationMetricCalculationDetailsBuilder setNumeratorType(List<? extends FinancialMetric> var1);

        public LoanCovenantObligationMetricCalculationDetailsBuilder addDenominatorType(FinancialMetric var1);

        public LoanCovenantObligationMetricCalculationDetailsBuilder addDenominatorType(FinancialMetric var1, int var2);

        public LoanCovenantObligationMetricCalculationDetailsBuilder addDenominatorType(List<? extends FinancialMetric> var1);

        public LoanCovenantObligationMetricCalculationDetailsBuilder setDenominatorType(List<? extends FinancialMetric> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("numeratorType"), processor, FinancialMetric.FinancialMetricBuilder.class, this.getNumeratorType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("denominatorType"), processor, FinancialMetric.FinancialMetricBuilder.class, this.getDenominatorType(), new AttributeMeta[0]);
        }

        public LoanCovenantObligationMetricCalculationDetailsBuilder prune();
    }

    public static class LoanCovenantObligationMetricCalculationDetailsImpl
    implements LoanCovenantObligationMetricCalculationDetails {
        private final List<? extends FinancialMetric> numeratorType;
        private final List<? extends FinancialMetric> denominatorType;

        protected LoanCovenantObligationMetricCalculationDetailsImpl(LoanCovenantObligationMetricCalculationDetailsBuilder builder) {
            this.numeratorType = Optional.ofNullable(builder.getNumeratorType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.denominatorType = Optional.ofNullable(builder.getDenominatorType()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="numeratorType", isRequired=true)
        @RuneAttribute(value="numeratorType", isRequired=true)
        public List<? extends FinancialMetric> getNumeratorType() {
            return this.numeratorType;
        }

        @Override
        @RosettaAttribute(value="denominatorType", isRequired=true)
        @RuneAttribute(value="denominatorType", isRequired=true)
        public List<? extends FinancialMetric> getDenominatorType() {
            return this.denominatorType;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetails build() {
            return this;
        }

        @Override
        public LoanCovenantObligationMetricCalculationDetailsBuilder toBuilder() {
            LoanCovenantObligationMetricCalculationDetailsBuilder builder = LoanCovenantObligationMetricCalculationDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanCovenantObligationMetricCalculationDetailsBuilder builder) {
            Optional.ofNullable(this.getNumeratorType()).ifPresent(builder::setNumeratorType);
            Optional.ofNullable(this.getDenominatorType()).ifPresent(builder::setDenominatorType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanCovenantObligationMetricCalculationDetails _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.numeratorType, _that.getNumeratorType())) {
                return false;
            }
            return ListEquals.listEquals(this.denominatorType, _that.getDenominatorType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.numeratorType != null ? this.numeratorType.hashCode() : 0);
            _result = 31 * _result + (this.denominatorType != null ? this.denominatorType.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanCovenantObligationMetricCalculationDetails {numeratorType=" + this.numeratorType + ", denominatorType=" + this.denominatorType + '}';
        }
    }
}

