/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.LoanContractBaseRateSetMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanContractBaseRateSet", builder=LoanContractBaseRateSetBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanContractBaseRateSet", model="fpml", builder=LoanContractBaseRateSetBuilderImpl.class, version="1.1.0")
public interface LoanContractBaseRateSet
extends AbstractLoanContractEvent {
    public static final LoanContractBaseRateSetMeta metaData = new LoanContractBaseRateSetMeta();

    public ZonedDateTime getFixingDate();

    public BigDecimal getRate();

    public BigDecimal getSpreadAdjustment();

    @Override
    public LoanContractBaseRateSet build();

    @Override
    public LoanContractBaseRateSetBuilder toBuilder();

    public static LoanContractBaseRateSetBuilder builder() {
        return new LoanContractBaseRateSetBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanContractBaseRateSet> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanContractBaseRateSet> getType() {
        return LoanContractBaseRateSet.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadAdjustment"), BigDecimal.class, (Object)this.getSpreadAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LoanContractBaseRateSetBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements LoanContractBaseRateSetBuilder {
        protected ZonedDateTime fixingDate;
        protected BigDecimal rate;
        protected BigDecimal spreadAdjustment;

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public BigDecimal getSpreadAdjustment() {
            return this.spreadAdjustment;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LoanContractBaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractBaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanContractBaseRateSetBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LoanContractBaseRateSetBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LoanContractBaseRateSetBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LoanContractBaseRateSetBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanContractBaseRateSetBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LoanContractBaseRateSetBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LoanContractBaseRateSetBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LoanContractBaseRateSetBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LoanContractBaseRateSetBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public LoanContractBaseRateSetBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public LoanContractBaseRateSetBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public LoanContractBaseRateSetBuilder setSpreadAdjustment(BigDecimal _spreadAdjustment) {
            this.spreadAdjustment = _spreadAdjustment == null ? null : _spreadAdjustment;
            return this;
        }

        @Override
        public LoanContractBaseRateSet build() {
            return new LoanContractBaseRateSetImpl(this);
        }

        @Override
        public LoanContractBaseRateSetBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanContractBaseRateSetBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFixingDate() != null) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            return this.getSpreadAdjustment() != null;
        }

        @Override
        public LoanContractBaseRateSetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanContractBaseRateSetBuilder o = (LoanContractBaseRateSetBuilder)other;
            merger.mergeBasic((Object)this.getFixingDate(), (Object)o.getFixingDate(), this::setFixingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpreadAdjustment(), (Object)o.getSpreadAdjustment(), this::setSpreadAdjustment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractBaseRateSet _that = (LoanContractBaseRateSet)this.getType().cast(o);
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.spreadAdjustment, _that.getSpreadAdjustment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.spreadAdjustment != null ? this.spreadAdjustment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractBaseRateSetBuilder {fixingDate=" + this.fixingDate + ", rate=" + this.rate + ", spreadAdjustment=" + this.spreadAdjustment + '}' + " " + super.toString();
        }
    }

    public static interface LoanContractBaseRateSetBuilder
    extends LoanContractBaseRateSet,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        @Override
        public LoanContractBaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LoanContractBaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LoanContractBaseRateSetBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanContractBaseRateSetBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanContractBaseRateSetBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LoanContractBaseRateSetBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LoanContractBaseRateSetBuilder setComment(String var1);

        @Override
        public LoanContractBaseRateSetBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LoanContractBaseRateSetBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LoanContractBaseRateSetBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LoanContractBaseRateSetBuilder setLoanContractReference(LoanContractReference var1);

        public LoanContractBaseRateSetBuilder setFixingDate(ZonedDateTime var1);

        public LoanContractBaseRateSetBuilder setRate(BigDecimal var1);

        public LoanContractBaseRateSetBuilder setSpreadAdjustment(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadAdjustment"), BigDecimal.class, (Object)this.getSpreadAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LoanContractBaseRateSetBuilder prune();
    }

    public static class LoanContractBaseRateSetImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements LoanContractBaseRateSet {
        private final ZonedDateTime fixingDate;
        private final BigDecimal rate;
        private final BigDecimal spreadAdjustment;

        protected LoanContractBaseRateSetImpl(LoanContractBaseRateSetBuilder builder) {
            super(builder);
            this.fixingDate = builder.getFixingDate();
            this.rate = builder.getRate();
            this.spreadAdjustment = builder.getSpreadAdjustment();
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public BigDecimal getSpreadAdjustment() {
            return this.spreadAdjustment;
        }

        @Override
        public LoanContractBaseRateSet build() {
            return this;
        }

        @Override
        public LoanContractBaseRateSetBuilder toBuilder() {
            LoanContractBaseRateSetBuilder builder = LoanContractBaseRateSet.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanContractBaseRateSetBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getSpreadAdjustment()).ifPresent(builder::setSpreadAdjustment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContractBaseRateSet _that = (LoanContractBaseRateSet)this.getType().cast(o);
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.spreadAdjustment, _that.getSpreadAdjustment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.spreadAdjustment != null ? this.spreadAdjustment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractBaseRateSet {fixingDate=" + this.fixingDate + ", rate=" + this.rate + ", spreadAdjustment=" + this.spreadAdjustment + '}' + " " + super.toString();
        }
    }
}

