/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.TradeIdentifierSequence;
import fpml.consolidated.loan.LoanAllocationPartiesModel;
import fpml.consolidated.loan.LoanAllocationSummary;
import fpml.consolidated.loan.LoanTradeReference;
import fpml.consolidated.loan.SimpleBuyerSellerModel;
import fpml.consolidated.loan.meta.LoanAllocationTypeMeta;
import fpml.consolidated.shared.IssuerTradeIdModel;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanAllocationType", builder=LoanAllocationTypeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanAllocationType", model="fpml", builder=LoanAllocationTypeBuilderImpl.class, version="1.1.0")
public interface LoanAllocationType
extends LoanAllocationSummary {
    public static final LoanAllocationTypeMeta metaData = new LoanAllocationTypeMeta();

    public LoanAllocationPartiesModel getLoanAllocationPartiesModel();

    public SimpleBuyerSellerModel getSimpleBuyerSellerModel();

    @Override
    public LoanAllocationType build();

    @Override
    public LoanAllocationTypeBuilder toBuilder();

    public static LoanAllocationTypeBuilder builder() {
        return new LoanAllocationTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanAllocationType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanAllocationType> getType() {
        return LoanAllocationType.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.class, this.getIssuerTradeIdModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.class, this.getTradeIdentifierSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.class, this.getLoanTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanAllocationPartiesModel"), processor, LoanAllocationPartiesModel.class, this.getLoanAllocationPartiesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simpleBuyerSellerModel"), processor, SimpleBuyerSellerModel.class, this.getSimpleBuyerSellerModel(), new AttributeMeta[0]);
    }

    public static class LoanAllocationTypeBuilderImpl
    extends LoanAllocationSummary.LoanAllocationSummaryBuilderImpl
    implements LoanAllocationTypeBuilder {
        protected LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder loanAllocationPartiesModel;
        protected SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder simpleBuyerSellerModel;

        @Override
        @RosettaAttribute(value="loanAllocationPartiesModel", isRequired=true)
        @RuneAttribute(value="loanAllocationPartiesModel", isRequired=true)
        public LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder getLoanAllocationPartiesModel() {
            return this.loanAllocationPartiesModel;
        }

        @Override
        public LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder getOrCreateLoanAllocationPartiesModel() {
            LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder result = this.loanAllocationPartiesModel != null ? this.loanAllocationPartiesModel : (this.loanAllocationPartiesModel = LoanAllocationPartiesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="simpleBuyerSellerModel")
        @RuneAttribute(value="simpleBuyerSellerModel")
        public SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder getSimpleBuyerSellerModel() {
            return this.simpleBuyerSellerModel;
        }

        @Override
        public SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder getOrCreateSimpleBuyerSellerModel() {
            SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder result = this.simpleBuyerSellerModel != null ? this.simpleBuyerSellerModel : (this.simpleBuyerSellerModel = SimpleBuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerTradeIdModel")
        @RuneAttribute(value="issuerTradeIdModel")
        public LoanAllocationTypeBuilder setIssuerTradeIdModel(IssuerTradeIdModel _issuerTradeIdModel) {
            this.issuerTradeIdModel = _issuerTradeIdModel == null ? null : _issuerTradeIdModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierSequence")
        @RuneAttribute(value="tradeIdentifierSequence")
        public LoanAllocationTypeBuilder setTradeIdentifierSequence(TradeIdentifierSequence _tradeIdentifierSequence) {
            this.tradeIdentifierSequence = _tradeIdentifierSequence == null ? null : _tradeIdentifierSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanAllocationTypeBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeReference", isRequired=true)
        @RuneAttribute(value="loanTradeReference", isRequired=true)
        public LoanAllocationTypeBuilder setLoanTradeReference(LoanTradeReference _loanTradeReference) {
            this.loanTradeReference = _loanTradeReference == null ? null : _loanTradeReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanAllocationTypeBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanAllocationTypeBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanAllocationPartiesModel", isRequired=true)
        @RuneAttribute(value="loanAllocationPartiesModel", isRequired=true)
        public LoanAllocationTypeBuilder setLoanAllocationPartiesModel(LoanAllocationPartiesModel _loanAllocationPartiesModel) {
            this.loanAllocationPartiesModel = _loanAllocationPartiesModel == null ? null : _loanAllocationPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="simpleBuyerSellerModel")
        @RuneAttribute(value="simpleBuyerSellerModel")
        public LoanAllocationTypeBuilder setSimpleBuyerSellerModel(SimpleBuyerSellerModel _simpleBuyerSellerModel) {
            this.simpleBuyerSellerModel = _simpleBuyerSellerModel == null ? null : _simpleBuyerSellerModel.toBuilder();
            return this;
        }

        @Override
        public LoanAllocationType build() {
            return new LoanAllocationTypeImpl(this);
        }

        @Override
        public LoanAllocationTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanAllocationTypeBuilder prune() {
            super.prune();
            if (this.loanAllocationPartiesModel != null && !this.loanAllocationPartiesModel.prune().hasData()) {
                this.loanAllocationPartiesModel = null;
            }
            if (this.simpleBuyerSellerModel != null && !this.simpleBuyerSellerModel.prune().hasData()) {
                this.simpleBuyerSellerModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanAllocationPartiesModel() != null && this.getLoanAllocationPartiesModel().hasData()) {
                return true;
            }
            return this.getSimpleBuyerSellerModel() != null && this.getSimpleBuyerSellerModel().hasData();
        }

        @Override
        public LoanAllocationTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanAllocationTypeBuilder o = (LoanAllocationTypeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanAllocationPartiesModel(), (RosettaModelObjectBuilder)o.getLoanAllocationPartiesModel(), this::setLoanAllocationPartiesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimpleBuyerSellerModel(), (RosettaModelObjectBuilder)o.getSimpleBuyerSellerModel(), this::setSimpleBuyerSellerModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationType _that = (LoanAllocationType)this.getType().cast(o);
            if (!Objects.equals(this.loanAllocationPartiesModel, _that.getLoanAllocationPartiesModel())) {
                return false;
            }
            return Objects.equals(this.simpleBuyerSellerModel, _that.getSimpleBuyerSellerModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanAllocationPartiesModel != null ? this.loanAllocationPartiesModel.hashCode() : 0);
            _result = 31 * _result + (this.simpleBuyerSellerModel != null ? this.simpleBuyerSellerModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationTypeBuilder {loanAllocationPartiesModel=" + this.loanAllocationPartiesModel + ", simpleBuyerSellerModel=" + this.simpleBuyerSellerModel + '}' + " " + super.toString();
        }
    }

    public static interface LoanAllocationTypeBuilder
    extends LoanAllocationType,
    LoanAllocationSummary.LoanAllocationSummaryBuilder {
        public LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder getOrCreateLoanAllocationPartiesModel();

        @Override
        public LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder getLoanAllocationPartiesModel();

        public SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder getOrCreateSimpleBuyerSellerModel();

        @Override
        public SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder getSimpleBuyerSellerModel();

        @Override
        public LoanAllocationTypeBuilder setIssuerTradeIdModel(IssuerTradeIdModel var1);

        @Override
        public LoanAllocationTypeBuilder setTradeIdentifierSequence(TradeIdentifierSequence var1);

        @Override
        public LoanAllocationTypeBuilder setId(String var1);

        @Override
        public LoanAllocationTypeBuilder setLoanTradeReference(LoanTradeReference var1);

        @Override
        public LoanAllocationTypeBuilder setAmount(NonNegativeMoney var1);

        @Override
        public LoanAllocationTypeBuilder setComment(String var1);

        public LoanAllocationTypeBuilder setLoanAllocationPartiesModel(LoanAllocationPartiesModel var1);

        public LoanAllocationTypeBuilder setSimpleBuyerSellerModel(SimpleBuyerSellerModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.IssuerTradeIdModelBuilder.class, (RosettaModelObjectBuilder)this.getIssuerTradeIdModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.TradeIdentifierSequenceBuilder.class, (RosettaModelObjectBuilder)this.getTradeIdentifierSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeReference"), processor, LoanTradeReference.LoanTradeReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanAllocationPartiesModel"), processor, LoanAllocationPartiesModel.LoanAllocationPartiesModelBuilder.class, this.getLoanAllocationPartiesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simpleBuyerSellerModel"), processor, SimpleBuyerSellerModel.SimpleBuyerSellerModelBuilder.class, this.getSimpleBuyerSellerModel(), new AttributeMeta[0]);
        }

        @Override
        public LoanAllocationTypeBuilder prune();
    }

    public static class LoanAllocationTypeImpl
    extends LoanAllocationSummary.LoanAllocationSummaryImpl
    implements LoanAllocationType {
        private final LoanAllocationPartiesModel loanAllocationPartiesModel;
        private final SimpleBuyerSellerModel simpleBuyerSellerModel;

        protected LoanAllocationTypeImpl(LoanAllocationTypeBuilder builder) {
            super(builder);
            this.loanAllocationPartiesModel = Optional.ofNullable(builder.getLoanAllocationPartiesModel()).map(f -> f.build()).orElse(null);
            this.simpleBuyerSellerModel = Optional.ofNullable(builder.getSimpleBuyerSellerModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanAllocationPartiesModel", isRequired=true)
        @RuneAttribute(value="loanAllocationPartiesModel", isRequired=true)
        public LoanAllocationPartiesModel getLoanAllocationPartiesModel() {
            return this.loanAllocationPartiesModel;
        }

        @Override
        @RosettaAttribute(value="simpleBuyerSellerModel")
        @RuneAttribute(value="simpleBuyerSellerModel")
        public SimpleBuyerSellerModel getSimpleBuyerSellerModel() {
            return this.simpleBuyerSellerModel;
        }

        @Override
        public LoanAllocationType build() {
            return this;
        }

        @Override
        public LoanAllocationTypeBuilder toBuilder() {
            LoanAllocationTypeBuilder builder = LoanAllocationType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanAllocationTypeBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanAllocationPartiesModel()).ifPresent(builder::setLoanAllocationPartiesModel);
            Optional.ofNullable(this.getSimpleBuyerSellerModel()).ifPresent(builder::setSimpleBuyerSellerModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationType _that = (LoanAllocationType)this.getType().cast(o);
            if (!Objects.equals(this.loanAllocationPartiesModel, _that.getLoanAllocationPartiesModel())) {
                return false;
            }
            return Objects.equals(this.simpleBuyerSellerModel, _that.getSimpleBuyerSellerModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanAllocationPartiesModel != null ? this.loanAllocationPartiesModel.hashCode() : 0);
            _result = 31 * _result + (this.simpleBuyerSellerModel != null ? this.simpleBuyerSellerModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationType {loanAllocationPartiesModel=" + this.loanAllocationPartiesModel + ", simpleBuyerSellerModel=" + this.simpleBuyerSellerModel + '}' + " " + super.toString();
        }
    }
}

