/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ContractId;
import fpml.consolidated.doc.VersionedContractId;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LcType;
import fpml.consolidated.loan.LetterOfCreditRolesModel;
import fpml.consolidated.loan.LoanContractIdentifier;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LetterOfCreditSummaryMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LetterOfCreditSummary", builder=LetterOfCreditSummaryBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LetterOfCreditSummary", model="fpml", builder=LetterOfCreditSummaryBuilderImpl.class, version="1.1.0")
public interface LetterOfCreditSummary
extends LoanContractIdentifier {
    public static final LetterOfCreditSummaryMeta metaData = new LetterOfCreditSummaryMeta();

    public LcType _getType();

    public ZonedDateTime getEffectiveDate();

    public LetterOfCreditRolesModel getLetterOfCreditRolesModel();

    public MoneyWithParticipantShare getAmount();

    @Override
    public LetterOfCreditSummary build();

    @Override
    public LetterOfCreditSummaryBuilder toBuilder();

    public static LetterOfCreditSummaryBuilder builder() {
        return new LetterOfCreditSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends LetterOfCreditSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LetterOfCreditSummary> getType() {
        return LetterOfCreditSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractId"), processor, ContractId.class, this.getContractId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.class, this.getVersionedContractId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("type"), processor, LcType.class, this._getType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditRolesModel"), processor, LetterOfCreditRolesModel.class, this.getLetterOfCreditRolesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class LetterOfCreditSummaryBuilderImpl
    extends LoanContractIdentifier.LoanContractIdentifierBuilderImpl
    implements LetterOfCreditSummaryBuilder {
        protected LcType.LcTypeBuilder type;
        protected ZonedDateTime effectiveDate;
        protected LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder letterOfCreditRolesModel;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LcType.LcTypeBuilder _getType() {
            return this.type;
        }

        @Override
        public LcType.LcTypeBuilder getOrCreateType() {
            LcType.LcTypeBuilder result = this.type != null ? this.type : (this.type = LcType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditRolesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditRolesModel", isRequired=true)
        public LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder getLetterOfCreditRolesModel() {
            return this.letterOfCreditRolesModel;
        }

        @Override
        public LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder getOrCreateLetterOfCreditRolesModel() {
            LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder result = this.letterOfCreditRolesModel != null ? this.letterOfCreditRolesModel : (this.letterOfCreditRolesModel = LetterOfCreditRolesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LetterOfCreditSummaryBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public LetterOfCreditSummaryBuilder addContractId(ContractId _contractId) {
            if (_contractId != null) {
                this.contractId.add(_contractId.toBuilder());
            }
            return this;
        }

        @Override
        public LetterOfCreditSummaryBuilder addContractId(ContractId _contractId, int idx) {
            this.getIndex(this.contractId, idx, () -> _contractId.toBuilder());
            return this;
        }

        @Override
        public LetterOfCreditSummaryBuilder addContractId(List<? extends ContractId> contractIds) {
            if (contractIds != null) {
                for (ContractId contractId : contractIds) {
                    this.contractId.add(contractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractId")
        public LetterOfCreditSummaryBuilder setContractId(List<? extends ContractId> contractIds) {
            this.contractId = contractIds == null ? new ArrayList() : (List)contractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public LetterOfCreditSummaryBuilder addVersionedContractId(VersionedContractId _versionedContractId) {
            if (_versionedContractId != null) {
                this.versionedContractId.add(_versionedContractId.toBuilder());
            }
            return this;
        }

        @Override
        public LetterOfCreditSummaryBuilder addVersionedContractId(VersionedContractId _versionedContractId, int idx) {
            this.getIndex(this.versionedContractId, idx, () -> _versionedContractId.toBuilder());
            return this;
        }

        @Override
        public LetterOfCreditSummaryBuilder addVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            if (versionedContractIds != null) {
                for (VersionedContractId versionedContractId : versionedContractIds) {
                    this.versionedContractId.add(versionedContractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedContractId")
        public LetterOfCreditSummaryBuilder setVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            this.versionedContractId = versionedContractIds == null ? new ArrayList() : (List)versionedContractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LetterOfCreditSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LetterOfCreditSummaryBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LetterOfCreditSummaryBuilder setType(LcType _type) {
            this.type = _type == null ? null : _type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LetterOfCreditSummaryBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditRolesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditRolesModel", isRequired=true)
        public LetterOfCreditSummaryBuilder setLetterOfCreditRolesModel(LetterOfCreditRolesModel _letterOfCreditRolesModel) {
            this.letterOfCreditRolesModel = _letterOfCreditRolesModel == null ? null : _letterOfCreditRolesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LetterOfCreditSummaryBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        public LetterOfCreditSummary build() {
            return new LetterOfCreditSummaryImpl(this);
        }

        @Override
        public LetterOfCreditSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public LetterOfCreditSummaryBuilder prune() {
            super.prune();
            if (this.type != null && !this.type.prune().hasData()) {
                this.type = null;
            }
            if (this.letterOfCreditRolesModel != null && !this.letterOfCreditRolesModel.prune().hasData()) {
                this.letterOfCreditRolesModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this._getType() != null && this._getType().hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getLetterOfCreditRolesModel() != null && this.getLetterOfCreditRolesModel().hasData()) {
                return true;
            }
            return this.getAmount() != null && this.getAmount().hasData();
        }

        @Override
        public LetterOfCreditSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LetterOfCreditSummaryBuilder o = (LetterOfCreditSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this._getType(), (RosettaModelObjectBuilder)o._getType(), this::setType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLetterOfCreditRolesModel(), (RosettaModelObjectBuilder)o.getLetterOfCreditRolesModel(), this::setLetterOfCreditRolesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LetterOfCreditSummary _that = (LetterOfCreditSummary)this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditRolesModel, _that.getLetterOfCreditRolesModel())) {
                return false;
            }
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditRolesModel != null ? this.letterOfCreditRolesModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LetterOfCreditSummaryBuilder {type=" + this.type + ", effectiveDate=" + this.effectiveDate + ", letterOfCreditRolesModel=" + this.letterOfCreditRolesModel + ", amount=" + this.amount + '}' + " " + super.toString();
        }
    }

    public static interface LetterOfCreditSummaryBuilder
    extends LetterOfCreditSummary,
    LoanContractIdentifier.LoanContractIdentifierBuilder {
        public LcType.LcTypeBuilder getOrCreateType();

        @Override
        public LcType.LcTypeBuilder _getType();

        public LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder getOrCreateLetterOfCreditRolesModel();

        @Override
        public LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder getLetterOfCreditRolesModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        @Override
        public LetterOfCreditSummaryBuilder setPartyReference(PartyReference var1);

        @Override
        public LetterOfCreditSummaryBuilder addContractId(ContractId var1);

        @Override
        public LetterOfCreditSummaryBuilder addContractId(ContractId var1, int var2);

        @Override
        public LetterOfCreditSummaryBuilder addContractId(List<? extends ContractId> var1);

        @Override
        public LetterOfCreditSummaryBuilder setContractId(List<? extends ContractId> var1);

        @Override
        public LetterOfCreditSummaryBuilder addVersionedContractId(VersionedContractId var1);

        @Override
        public LetterOfCreditSummaryBuilder addVersionedContractId(VersionedContractId var1, int var2);

        @Override
        public LetterOfCreditSummaryBuilder addVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LetterOfCreditSummaryBuilder setVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LetterOfCreditSummaryBuilder setId(String var1);

        @Override
        public LetterOfCreditSummaryBuilder setFacilityReference(FacilityReference var1);

        public LetterOfCreditSummaryBuilder setType(LcType var1);

        public LetterOfCreditSummaryBuilder setEffectiveDate(ZonedDateTime var1);

        public LetterOfCreditSummaryBuilder setLetterOfCreditRolesModel(LetterOfCreditRolesModel var1);

        public LetterOfCreditSummaryBuilder setAmount(MoneyWithParticipantShare var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractId"), processor, ContractId.ContractIdBuilder.class, this.getContractId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.VersionedContractIdBuilder.class, this.getVersionedContractId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("type"), processor, LcType.LcTypeBuilder.class, this._getType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditRolesModel"), processor, LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder.class, this.getLetterOfCreditRolesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        @Override
        public LetterOfCreditSummaryBuilder prune();
    }

    public static class LetterOfCreditSummaryImpl
    extends LoanContractIdentifier.LoanContractIdentifierImpl
    implements LetterOfCreditSummary {
        private final LcType type;
        private final ZonedDateTime effectiveDate;
        private final LetterOfCreditRolesModel letterOfCreditRolesModel;
        private final MoneyWithParticipantShare amount;

        protected LetterOfCreditSummaryImpl(LetterOfCreditSummaryBuilder builder) {
            super(builder);
            this.type = Optional.ofNullable(builder._getType()).map(f -> f.build()).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.letterOfCreditRolesModel = Optional.ofNullable(builder.getLetterOfCreditRolesModel()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LcType _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditRolesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditRolesModel", isRequired=true)
        public LetterOfCreditRolesModel getLetterOfCreditRolesModel() {
            return this.letterOfCreditRolesModel;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        public LetterOfCreditSummary build() {
            return this;
        }

        @Override
        public LetterOfCreditSummaryBuilder toBuilder() {
            LetterOfCreditSummaryBuilder builder = LetterOfCreditSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LetterOfCreditSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this._getType()).ifPresent(builder::setType);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getLetterOfCreditRolesModel()).ifPresent(builder::setLetterOfCreditRolesModel);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LetterOfCreditSummary _that = (LetterOfCreditSummary)this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditRolesModel, _that.getLetterOfCreditRolesModel())) {
                return false;
            }
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditRolesModel != null ? this.letterOfCreditRolesModel.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LetterOfCreditSummary {type=" + this.type + ", effectiveDate=" + this.effectiveDate + ", letterOfCreditRolesModel=" + this.letterOfCreditRolesModel + ", amount=" + this.amount + '}' + " " + super.toString();
        }
    }
}

