/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLcEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LetterOfCreditReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.LcRenewalMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LcRenewal", builder=LcRenewalBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LcRenewal", model="fpml", builder=LcRenewalBuilderImpl.class, version="1.1.0")
public interface LcRenewal
extends AbstractLcEvent {
    public static final LcRenewalMeta metaData = new LcRenewalMeta();

    public ZonedDateTime getFinalExpiryDate();

    public ZonedDateTime getMaturityDate();

    @Override
    public LcRenewal build();

    @Override
    public LcRenewalBuilder toBuilder();

    public static LcRenewalBuilder builder() {
        return new LcRenewalBuilderImpl();
    }

    default public RosettaMetaData<? extends LcRenewal> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcRenewal> getType() {
        return LcRenewal.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalExpiryDate"), ZonedDateTime.class, (Object)this.getFinalExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LcRenewalBuilderImpl
    extends AbstractLcEvent.AbstractLcEventBuilderImpl
    implements LcRenewalBuilder {
        protected ZonedDateTime finalExpiryDate;
        protected ZonedDateTime maturityDate;

        @Override
        @RosettaAttribute(value="finalExpiryDate", isRequired=true)
        @RuneAttribute(value="finalExpiryDate", isRequired=true)
        public ZonedDateTime getFinalExpiryDate() {
            return this.finalExpiryDate;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LcRenewalBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LcRenewalBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LcRenewalBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LcRenewalBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LcRenewalBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LcRenewalBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LcRenewalBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LcRenewalBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LcRenewalBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LcRenewalBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public LcRenewalBuilder setLetterOfCreditReference(LetterOfCreditReference _letterOfCreditReference) {
            this.letterOfCreditReference = _letterOfCreditReference == null ? null : _letterOfCreditReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate", isRequired=true)
        @RuneAttribute(value="finalExpiryDate", isRequired=true)
        public LcRenewalBuilder setFinalExpiryDate(ZonedDateTime _finalExpiryDate) {
            this.finalExpiryDate = _finalExpiryDate == null ? null : _finalExpiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public LcRenewalBuilder setMaturityDate(ZonedDateTime _maturityDate) {
            this.maturityDate = _maturityDate == null ? null : _maturityDate;
            return this;
        }

        @Override
        public LcRenewal build() {
            return new LcRenewalImpl(this);
        }

        @Override
        public LcRenewalBuilder toBuilder() {
            return this;
        }

        @Override
        public LcRenewalBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFinalExpiryDate() != null) {
                return true;
            }
            return this.getMaturityDate() != null;
        }

        @Override
        public LcRenewalBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcRenewalBuilder o = (LcRenewalBuilder)other;
            merger.mergeBasic((Object)this.getFinalExpiryDate(), (Object)o.getFinalExpiryDate(), this::setFinalExpiryDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDate(), (Object)o.getMaturityDate(), this::setMaturityDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcRenewal _that = (LcRenewal)this.getType().cast(o);
            if (!Objects.equals(this.finalExpiryDate, _that.getFinalExpiryDate())) {
                return false;
            }
            return Objects.equals(this.maturityDate, _that.getMaturityDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.finalExpiryDate != null ? this.finalExpiryDate.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcRenewalBuilder {finalExpiryDate=" + this.finalExpiryDate + ", maturityDate=" + this.maturityDate + '}' + " " + super.toString();
        }
    }

    public static interface LcRenewalBuilder
    extends LcRenewal,
    AbstractLcEvent.AbstractLcEventBuilder {
        @Override
        public LcRenewalBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LcRenewalBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LcRenewalBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcRenewalBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcRenewalBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LcRenewalBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LcRenewalBuilder setComment(String var1);

        @Override
        public LcRenewalBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LcRenewalBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LcRenewalBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LcRenewalBuilder setLetterOfCreditReference(LetterOfCreditReference var1);

        public LcRenewalBuilder setFinalExpiryDate(ZonedDateTime var1);

        public LcRenewalBuilder setMaturityDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.LetterOfCreditReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLetterOfCreditReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalExpiryDate"), ZonedDateTime.class, (Object)this.getFinalExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LcRenewalBuilder prune();
    }

    public static class LcRenewalImpl
    extends AbstractLcEvent.AbstractLcEventImpl
    implements LcRenewal {
        private final ZonedDateTime finalExpiryDate;
        private final ZonedDateTime maturityDate;

        protected LcRenewalImpl(LcRenewalBuilder builder) {
            super(builder);
            this.finalExpiryDate = builder.getFinalExpiryDate();
            this.maturityDate = builder.getMaturityDate();
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate", isRequired=true)
        @RuneAttribute(value="finalExpiryDate", isRequired=true)
        public ZonedDateTime getFinalExpiryDate() {
            return this.finalExpiryDate;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        public LcRenewal build() {
            return this;
        }

        @Override
        public LcRenewalBuilder toBuilder() {
            LcRenewalBuilder builder = LcRenewal.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcRenewalBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFinalExpiryDate()).ifPresent(builder::setFinalExpiryDate);
            Optional.ofNullable(this.getMaturityDate()).ifPresent(builder::setMaturityDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcRenewal _that = (LcRenewal)this.getType().cast(o);
            if (!Objects.equals(this.finalExpiryDate, _that.getFinalExpiryDate())) {
                return false;
            }
            return Objects.equals(this.maturityDate, _that.getMaturityDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.finalExpiryDate != null ? this.finalExpiryDate.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcRenewal {finalExpiryDate=" + this.finalExpiryDate + ", maturityDate=" + this.maturityDate + '}' + " " + super.toString();
        }
    }
}

