/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLcEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.Adjustment;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LetterOfCreditReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LcAdjustmentMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LcAdjustment", builder=LcAdjustmentBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LcAdjustment", model="fpml", builder=LcAdjustmentBuilderImpl.class, version="1.1.0")
public interface LcAdjustment
extends AbstractLcEvent {
    public static final LcAdjustmentMeta metaData = new LcAdjustmentMeta();

    public Adjustment getAdjustment();

    public MoneyWithParticipantShare getAmount();

    public Boolean getRelatedBorrowing();

    @Override
    public LcAdjustment build();

    @Override
    public LcAdjustmentBuilder toBuilder();

    public static LcAdjustmentBuilder builder() {
        return new LcAdjustmentBuilderImpl();
    }

    default public RosettaMetaData<? extends LcAdjustment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LcAdjustment> getType() {
        return LcAdjustment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.class, this.getLetterOfCreditReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustment"), processor, Adjustment.class, this.getAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("relatedBorrowing"), Boolean.class, (Object)this.getRelatedBorrowing(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LcAdjustmentBuilderImpl
    extends AbstractLcEvent.AbstractLcEventBuilderImpl
    implements LcAdjustmentBuilder {
        protected Adjustment.AdjustmentBuilder adjustment;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected Boolean relatedBorrowing;

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public Adjustment.AdjustmentBuilder getAdjustment() {
            return this.adjustment;
        }

        @Override
        public Adjustment.AdjustmentBuilder getOrCreateAdjustment() {
            Adjustment.AdjustmentBuilder result = this.adjustment != null ? this.adjustment : (this.adjustment = Adjustment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedBorrowing", isRequired=true)
        @RuneAttribute(value="relatedBorrowing", isRequired=true)
        public Boolean getRelatedBorrowing() {
            return this.relatedBorrowing;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LcAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LcAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LcAdjustmentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LcAdjustmentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LcAdjustmentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LcAdjustmentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LcAdjustmentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LcAdjustmentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LcAdjustmentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LcAdjustmentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditReference", isRequired=true)
        @RuneAttribute(value="letterOfCreditReference", isRequired=true)
        public LcAdjustmentBuilder setLetterOfCreditReference(LetterOfCreditReference _letterOfCreditReference) {
            this.letterOfCreditReference = _letterOfCreditReference == null ? null : _letterOfCreditReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public LcAdjustmentBuilder setAdjustment(Adjustment _adjustment) {
            this.adjustment = _adjustment == null ? null : _adjustment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LcAdjustmentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedBorrowing", isRequired=true)
        @RuneAttribute(value="relatedBorrowing", isRequired=true)
        public LcAdjustmentBuilder setRelatedBorrowing(Boolean _relatedBorrowing) {
            this.relatedBorrowing = _relatedBorrowing == null ? null : _relatedBorrowing;
            return this;
        }

        @Override
        public LcAdjustment build() {
            return new LcAdjustmentImpl(this);
        }

        @Override
        public LcAdjustmentBuilder toBuilder() {
            return this;
        }

        @Override
        public LcAdjustmentBuilder prune() {
            super.prune();
            if (this.adjustment != null && !this.adjustment.prune().hasData()) {
                this.adjustment = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAdjustment() != null && this.getAdjustment().hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getRelatedBorrowing() != null;
        }

        @Override
        public LcAdjustmentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LcAdjustmentBuilder o = (LcAdjustmentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustment(), (RosettaModelObjectBuilder)o.getAdjustment(), this::setAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getRelatedBorrowing(), (Object)o.getRelatedBorrowing(), this::setRelatedBorrowing, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcAdjustment _that = (LcAdjustment)this.getType().cast(o);
            if (!Objects.equals(this.adjustment, _that.getAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.relatedBorrowing, _that.getRelatedBorrowing());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.relatedBorrowing != null ? this.relatedBorrowing.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcAdjustmentBuilder {adjustment=" + this.adjustment + ", amount=" + this.amount + ", relatedBorrowing=" + this.relatedBorrowing + '}' + " " + super.toString();
        }
    }

    public static interface LcAdjustmentBuilder
    extends LcAdjustment,
    AbstractLcEvent.AbstractLcEventBuilder {
        public Adjustment.AdjustmentBuilder getOrCreateAdjustment();

        @Override
        public Adjustment.AdjustmentBuilder getAdjustment();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        @Override
        public LcAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LcAdjustmentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LcAdjustmentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcAdjustmentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LcAdjustmentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LcAdjustmentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LcAdjustmentBuilder setComment(String var1);

        @Override
        public LcAdjustmentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LcAdjustmentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LcAdjustmentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LcAdjustmentBuilder setLetterOfCreditReference(LetterOfCreditReference var1);

        public LcAdjustmentBuilder setAdjustment(Adjustment var1);

        public LcAdjustmentBuilder setAmount(MoneyWithParticipantShare var1);

        public LcAdjustmentBuilder setRelatedBorrowing(Boolean var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditReference"), processor, LetterOfCreditReference.LetterOfCreditReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLetterOfCreditReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustment"), processor, Adjustment.AdjustmentBuilder.class, this.getAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("relatedBorrowing"), Boolean.class, (Object)this.getRelatedBorrowing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LcAdjustmentBuilder prune();
    }

    public static class LcAdjustmentImpl
    extends AbstractLcEvent.AbstractLcEventImpl
    implements LcAdjustment {
        private final Adjustment adjustment;
        private final MoneyWithParticipantShare amount;
        private final Boolean relatedBorrowing;

        protected LcAdjustmentImpl(LcAdjustmentBuilder builder) {
            super(builder);
            this.adjustment = Optional.ofNullable(builder.getAdjustment()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.relatedBorrowing = builder.getRelatedBorrowing();
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public Adjustment getAdjustment() {
            return this.adjustment;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="relatedBorrowing", isRequired=true)
        @RuneAttribute(value="relatedBorrowing", isRequired=true)
        public Boolean getRelatedBorrowing() {
            return this.relatedBorrowing;
        }

        @Override
        public LcAdjustment build() {
            return this;
        }

        @Override
        public LcAdjustmentBuilder toBuilder() {
            LcAdjustmentBuilder builder = LcAdjustment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LcAdjustmentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAdjustment()).ifPresent(builder::setAdjustment);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getRelatedBorrowing()).ifPresent(builder::setRelatedBorrowing);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LcAdjustment _that = (LcAdjustment)this.getType().cast(o);
            if (!Objects.equals(this.adjustment, _that.getAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.relatedBorrowing, _that.getRelatedBorrowing());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.relatedBorrowing != null ? this.relatedBorrowing.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LcAdjustment {adjustment=" + this.adjustment + ", amount=" + this.amount + ", relatedBorrowing=" + this.relatedBorrowing + '}' + " " + super.toString();
        }
    }
}

