/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.meta.FacilityRolesModelMeta;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityRolesModel", builder=FacilityRolesModelBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FacilityRolesModel", model="fpml", builder=FacilityRolesModelBuilderImpl.class, version="1.1.0")
public interface FacilityRolesModel
extends RosettaModelObject {
    public static final FacilityRolesModelMeta metaData = new FacilityRolesModelMeta();

    public PartyReference getBorrowerPartyReference();

    public List<? extends PartyReference> getCoBorrowerPartyReference();

    public PartyReference getAgentPartyReference();

    public List<? extends PartyReference> getLcIssuingBankPartyReference();

    public List<? extends PartyReference> getGuarantorPartyReference();

    public FacilityRolesModel build();

    public FacilityRolesModelBuilder toBuilder();

    public static FacilityRolesModelBuilder builder() {
        return new FacilityRolesModelBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityRolesModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityRolesModel> getType() {
        return FacilityRolesModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("borrowerPartyReference"), processor, PartyReference.class, this.getBorrowerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("coBorrowerPartyReference"), processor, PartyReference.class, this.getCoBorrowerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agentPartyReference"), processor, PartyReference.class, this.getAgentPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lcIssuingBankPartyReference"), processor, PartyReference.class, this.getLcIssuingBankPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("guarantorPartyReference"), processor, PartyReference.class, this.getGuarantorPartyReference(), new AttributeMeta[0]);
    }

    public static class FacilityRolesModelBuilderImpl
    implements FacilityRolesModelBuilder {
        protected PartyReference.PartyReferenceBuilder borrowerPartyReference;
        protected List<PartyReference.PartyReferenceBuilder> coBorrowerPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected PartyReference.PartyReferenceBuilder agentPartyReference;
        protected List<PartyReference.PartyReferenceBuilder> lcIssuingBankPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
        protected List<PartyReference.PartyReferenceBuilder> guarantorPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();

        @Override
        @RosettaAttribute(value="borrowerPartyReference", isRequired=true)
        @RuneAttribute(value="borrowerPartyReference", isRequired=true)
        public PartyReference.PartyReferenceBuilder getBorrowerPartyReference() {
            return this.borrowerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateBorrowerPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.borrowerPartyReference != null ? this.borrowerPartyReference : (this.borrowerPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="coBorrowerPartyReference")
        @RuneAttribute(value="coBorrowerPartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getCoBorrowerPartyReference() {
            return this.coBorrowerPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateCoBorrowerPartyReference(int index) {
            if (this.coBorrowerPartyReference == null) {
                this.coBorrowerPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.coBorrowerPartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newCoBorrowerPartyReference = PartyReference.builder();
                return newCoBorrowerPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="agentPartyReference")
        @RuneAttribute(value="agentPartyReference")
        public PartyReference.PartyReferenceBuilder getAgentPartyReference() {
            return this.agentPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateAgentPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.agentPartyReference != null ? this.agentPartyReference : (this.agentPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lcIssuingBankPartyReference")
        @RuneAttribute(value="lcIssuingBankPartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getLcIssuingBankPartyReference() {
            return this.lcIssuingBankPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateLcIssuingBankPartyReference(int index) {
            if (this.lcIssuingBankPartyReference == null) {
                this.lcIssuingBankPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.lcIssuingBankPartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newLcIssuingBankPartyReference = PartyReference.builder();
                return newLcIssuingBankPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public List<? extends PartyReference.PartyReferenceBuilder> getGuarantorPartyReference() {
            return this.guarantorPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateGuarantorPartyReference(int index) {
            if (this.guarantorPartyReference == null) {
                this.guarantorPartyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.guarantorPartyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newGuarantorPartyReference = PartyReference.builder();
                return newGuarantorPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="borrowerPartyReference", isRequired=true)
        @RuneAttribute(value="borrowerPartyReference", isRequired=true)
        public FacilityRolesModelBuilder setBorrowerPartyReference(PartyReference _borrowerPartyReference) {
            this.borrowerPartyReference = _borrowerPartyReference == null ? null : _borrowerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="coBorrowerPartyReference")
        @RuneAttribute(value="coBorrowerPartyReference")
        public FacilityRolesModelBuilder addCoBorrowerPartyReference(PartyReference _coBorrowerPartyReference) {
            if (_coBorrowerPartyReference != null) {
                this.coBorrowerPartyReference.add(_coBorrowerPartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityRolesModelBuilder addCoBorrowerPartyReference(PartyReference _coBorrowerPartyReference, int idx) {
            this.getIndex(this.coBorrowerPartyReference, idx, () -> _coBorrowerPartyReference.toBuilder());
            return this;
        }

        @Override
        public FacilityRolesModelBuilder addCoBorrowerPartyReference(List<? extends PartyReference> coBorrowerPartyReferences) {
            if (coBorrowerPartyReferences != null) {
                for (PartyReference partyReference : coBorrowerPartyReferences) {
                    this.coBorrowerPartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="coBorrowerPartyReference")
        public FacilityRolesModelBuilder setCoBorrowerPartyReference(List<? extends PartyReference> coBorrowerPartyReferences) {
            this.coBorrowerPartyReference = coBorrowerPartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)coBorrowerPartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="agentPartyReference")
        @RuneAttribute(value="agentPartyReference")
        public FacilityRolesModelBuilder setAgentPartyReference(PartyReference _agentPartyReference) {
            this.agentPartyReference = _agentPartyReference == null ? null : _agentPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lcIssuingBankPartyReference")
        @RuneAttribute(value="lcIssuingBankPartyReference")
        public FacilityRolesModelBuilder addLcIssuingBankPartyReference(PartyReference _lcIssuingBankPartyReference) {
            if (_lcIssuingBankPartyReference != null) {
                this.lcIssuingBankPartyReference.add(_lcIssuingBankPartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityRolesModelBuilder addLcIssuingBankPartyReference(PartyReference _lcIssuingBankPartyReference, int idx) {
            this.getIndex(this.lcIssuingBankPartyReference, idx, () -> _lcIssuingBankPartyReference.toBuilder());
            return this;
        }

        @Override
        public FacilityRolesModelBuilder addLcIssuingBankPartyReference(List<? extends PartyReference> lcIssuingBankPartyReferences) {
            if (lcIssuingBankPartyReferences != null) {
                for (PartyReference partyReference : lcIssuingBankPartyReferences) {
                    this.lcIssuingBankPartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="lcIssuingBankPartyReference")
        public FacilityRolesModelBuilder setLcIssuingBankPartyReference(List<? extends PartyReference> lcIssuingBankPartyReferences) {
            this.lcIssuingBankPartyReference = lcIssuingBankPartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)lcIssuingBankPartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public FacilityRolesModelBuilder addGuarantorPartyReference(PartyReference _guarantorPartyReference) {
            if (_guarantorPartyReference != null) {
                this.guarantorPartyReference.add(_guarantorPartyReference.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityRolesModelBuilder addGuarantorPartyReference(PartyReference _guarantorPartyReference, int idx) {
            this.getIndex(this.guarantorPartyReference, idx, () -> _guarantorPartyReference.toBuilder());
            return this;
        }

        @Override
        public FacilityRolesModelBuilder addGuarantorPartyReference(List<? extends PartyReference> guarantorPartyReferences) {
            if (guarantorPartyReferences != null) {
                for (PartyReference partyReference : guarantorPartyReferences) {
                    this.guarantorPartyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="guarantorPartyReference")
        public FacilityRolesModelBuilder setGuarantorPartyReference(List<? extends PartyReference> guarantorPartyReferences) {
            this.guarantorPartyReference = guarantorPartyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)guarantorPartyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FacilityRolesModel build() {
            return new FacilityRolesModelImpl(this);
        }

        @Override
        public FacilityRolesModelBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityRolesModelBuilder prune() {
            if (this.borrowerPartyReference != null && !this.borrowerPartyReference.prune().hasData()) {
                this.borrowerPartyReference = null;
            }
            this.coBorrowerPartyReference = this.coBorrowerPartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.agentPartyReference != null && !this.agentPartyReference.prune().hasData()) {
                this.agentPartyReference = null;
            }
            this.lcIssuingBankPartyReference = this.lcIssuingBankPartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.guarantorPartyReference = this.guarantorPartyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getBorrowerPartyReference() != null && this.getBorrowerPartyReference().hasData()) {
                return true;
            }
            if (this.getCoBorrowerPartyReference() != null && this.getCoBorrowerPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAgentPartyReference() != null && this.getAgentPartyReference().hasData()) {
                return true;
            }
            if (this.getLcIssuingBankPartyReference() != null && this.getLcIssuingBankPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getGuarantorPartyReference() != null && this.getGuarantorPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FacilityRolesModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FacilityRolesModelBuilder o = (FacilityRolesModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBorrowerPartyReference(), (RosettaModelObjectBuilder)o.getBorrowerPartyReference(), this::setBorrowerPartyReference);
            merger.mergeRosetta(this.getCoBorrowerPartyReference(), o.getCoBorrowerPartyReference(), this::getOrCreateCoBorrowerPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgentPartyReference(), (RosettaModelObjectBuilder)o.getAgentPartyReference(), this::setAgentPartyReference);
            merger.mergeRosetta(this.getLcIssuingBankPartyReference(), o.getLcIssuingBankPartyReference(), this::getOrCreateLcIssuingBankPartyReference);
            merger.mergeRosetta(this.getGuarantorPartyReference(), o.getGuarantorPartyReference(), this::getOrCreateGuarantorPartyReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityRolesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.borrowerPartyReference, _that.getBorrowerPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.coBorrowerPartyReference, _that.getCoBorrowerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.agentPartyReference, _that.getAgentPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.lcIssuingBankPartyReference, _that.getLcIssuingBankPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.guarantorPartyReference, _that.getGuarantorPartyReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.borrowerPartyReference != null ? this.borrowerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.coBorrowerPartyReference != null ? this.coBorrowerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.agentPartyReference != null ? this.agentPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.lcIssuingBankPartyReference != null ? this.lcIssuingBankPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.guarantorPartyReference != null ? this.guarantorPartyReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityRolesModelBuilder {borrowerPartyReference=" + this.borrowerPartyReference + ", coBorrowerPartyReference=" + this.coBorrowerPartyReference + ", agentPartyReference=" + this.agentPartyReference + ", lcIssuingBankPartyReference=" + this.lcIssuingBankPartyReference + ", guarantorPartyReference=" + this.guarantorPartyReference + '}';
        }
    }

    public static interface FacilityRolesModelBuilder
    extends FacilityRolesModel,
    RosettaModelObjectBuilder {
        public PartyReference.PartyReferenceBuilder getOrCreateBorrowerPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getBorrowerPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateCoBorrowerPartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getCoBorrowerPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateAgentPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getAgentPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateLcIssuingBankPartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getLcIssuingBankPartyReference();

        public PartyReference.PartyReferenceBuilder getOrCreateGuarantorPartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getGuarantorPartyReference();

        public FacilityRolesModelBuilder setBorrowerPartyReference(PartyReference var1);

        public FacilityRolesModelBuilder addCoBorrowerPartyReference(PartyReference var1);

        public FacilityRolesModelBuilder addCoBorrowerPartyReference(PartyReference var1, int var2);

        public FacilityRolesModelBuilder addCoBorrowerPartyReference(List<? extends PartyReference> var1);

        public FacilityRolesModelBuilder setCoBorrowerPartyReference(List<? extends PartyReference> var1);

        public FacilityRolesModelBuilder setAgentPartyReference(PartyReference var1);

        public FacilityRolesModelBuilder addLcIssuingBankPartyReference(PartyReference var1);

        public FacilityRolesModelBuilder addLcIssuingBankPartyReference(PartyReference var1, int var2);

        public FacilityRolesModelBuilder addLcIssuingBankPartyReference(List<? extends PartyReference> var1);

        public FacilityRolesModelBuilder setLcIssuingBankPartyReference(List<? extends PartyReference> var1);

        public FacilityRolesModelBuilder addGuarantorPartyReference(PartyReference var1);

        public FacilityRolesModelBuilder addGuarantorPartyReference(PartyReference var1, int var2);

        public FacilityRolesModelBuilder addGuarantorPartyReference(List<? extends PartyReference> var1);

        public FacilityRolesModelBuilder setGuarantorPartyReference(List<? extends PartyReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("borrowerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getBorrowerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("coBorrowerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getCoBorrowerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agentPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getAgentPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lcIssuingBankPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getLcIssuingBankPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("guarantorPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getGuarantorPartyReference(), new AttributeMeta[0]);
        }

        public FacilityRolesModelBuilder prune();
    }

    public static class FacilityRolesModelImpl
    implements FacilityRolesModel {
        private final PartyReference borrowerPartyReference;
        private final List<? extends PartyReference> coBorrowerPartyReference;
        private final PartyReference agentPartyReference;
        private final List<? extends PartyReference> lcIssuingBankPartyReference;
        private final List<? extends PartyReference> guarantorPartyReference;

        protected FacilityRolesModelImpl(FacilityRolesModelBuilder builder) {
            this.borrowerPartyReference = Optional.ofNullable(builder.getBorrowerPartyReference()).map(f -> f.build()).orElse(null);
            this.coBorrowerPartyReference = Optional.ofNullable(builder.getCoBorrowerPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.agentPartyReference = Optional.ofNullable(builder.getAgentPartyReference()).map(f -> f.build()).orElse(null);
            this.lcIssuingBankPartyReference = Optional.ofNullable(builder.getLcIssuingBankPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.guarantorPartyReference = Optional.ofNullable(builder.getGuarantorPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="borrowerPartyReference", isRequired=true)
        @RuneAttribute(value="borrowerPartyReference", isRequired=true)
        public PartyReference getBorrowerPartyReference() {
            return this.borrowerPartyReference;
        }

        @Override
        @RosettaAttribute(value="coBorrowerPartyReference")
        @RuneAttribute(value="coBorrowerPartyReference")
        public List<? extends PartyReference> getCoBorrowerPartyReference() {
            return this.coBorrowerPartyReference;
        }

        @Override
        @RosettaAttribute(value="agentPartyReference")
        @RuneAttribute(value="agentPartyReference")
        public PartyReference getAgentPartyReference() {
            return this.agentPartyReference;
        }

        @Override
        @RosettaAttribute(value="lcIssuingBankPartyReference")
        @RuneAttribute(value="lcIssuingBankPartyReference")
        public List<? extends PartyReference> getLcIssuingBankPartyReference() {
            return this.lcIssuingBankPartyReference;
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public List<? extends PartyReference> getGuarantorPartyReference() {
            return this.guarantorPartyReference;
        }

        @Override
        public FacilityRolesModel build() {
            return this;
        }

        @Override
        public FacilityRolesModelBuilder toBuilder() {
            FacilityRolesModelBuilder builder = FacilityRolesModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityRolesModelBuilder builder) {
            Optional.ofNullable(this.getBorrowerPartyReference()).ifPresent(builder::setBorrowerPartyReference);
            Optional.ofNullable(this.getCoBorrowerPartyReference()).ifPresent(builder::setCoBorrowerPartyReference);
            Optional.ofNullable(this.getAgentPartyReference()).ifPresent(builder::setAgentPartyReference);
            Optional.ofNullable(this.getLcIssuingBankPartyReference()).ifPresent(builder::setLcIssuingBankPartyReference);
            Optional.ofNullable(this.getGuarantorPartyReference()).ifPresent(builder::setGuarantorPartyReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityRolesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.borrowerPartyReference, _that.getBorrowerPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.coBorrowerPartyReference, _that.getCoBorrowerPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.agentPartyReference, _that.getAgentPartyReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.lcIssuingBankPartyReference, _that.getLcIssuingBankPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.guarantorPartyReference, _that.getGuarantorPartyReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.borrowerPartyReference != null ? this.borrowerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.coBorrowerPartyReference != null ? this.coBorrowerPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.agentPartyReference != null ? this.agentPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.lcIssuingBankPartyReference != null ? this.lcIssuingBankPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.guarantorPartyReference != null ? this.guarantorPartyReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityRolesModel {borrowerPartyReference=" + this.borrowerPartyReference + ", coBorrowerPartyReference=" + this.coBorrowerPartyReference + ", agentPartyReference=" + this.agentPartyReference + ", lcIssuingBankPartyReference=" + this.lcIssuingBankPartyReference + ", guarantorPartyReference=" + this.guarantorPartyReference + '}';
        }
    }
}

