/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.DealReference;
import fpml.consolidated.loan.IdentifiedAssetWithParty;
import fpml.consolidated.loan.meta.FacilityIdentifierMeta;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityIdentifier", builder=FacilityIdentifierBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FacilityIdentifier", model="fpml", builder=FacilityIdentifierBuilderImpl.class, version="1.1.0")
public interface FacilityIdentifier
extends IdentifiedAssetWithParty {
    public static final FacilityIdentifierMeta metaData = new FacilityIdentifierMeta();

    public DealReference getDealReference();

    @Override
    public FacilityIdentifier build();

    @Override
    public FacilityIdentifierBuilder toBuilder();

    public static FacilityIdentifierBuilder builder() {
        return new FacilityIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityIdentifier> getType() {
        return FacilityIdentifier.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.class, this.getDealReference(), new AttributeMeta[0]);
    }

    public static class FacilityIdentifierBuilderImpl
    extends IdentifiedAssetWithParty.IdentifiedAssetWithPartyBuilderImpl
    implements FacilityIdentifierBuilder {
        protected DealReference.DealReferenceBuilder dealReference;

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference.DealReferenceBuilder getDealReference() {
            return this.dealReference;
        }

        @Override
        public DealReference.DealReferenceBuilder getOrCreateDealReference() {
            DealReference.DealReferenceBuilder result = this.dealReference != null ? this.dealReference : (this.dealReference = DealReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FacilityIdentifierBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public FacilityIdentifierBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public FacilityIdentifierBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityIdentifierBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public FacilityIdentifierBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public FacilityIdentifierBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public FacilityIdentifierBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public FacilityIdentifierBuilder setDealReference(DealReference _dealReference) {
            this.dealReference = _dealReference == null ? null : _dealReference.toBuilder();
            return this;
        }

        @Override
        public FacilityIdentifier build() {
            return new FacilityIdentifierImpl(this);
        }

        @Override
        public FacilityIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityIdentifierBuilder prune() {
            super.prune();
            if (this.dealReference != null && !this.dealReference.prune().hasData()) {
                this.dealReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getDealReference() != null && this.getDealReference().hasData();
        }

        @Override
        public FacilityIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FacilityIdentifierBuilder o = (FacilityIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealReference(), (RosettaModelObjectBuilder)o.getDealReference(), this::setDealReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityIdentifier _that = (FacilityIdentifier)this.getType().cast(o);
            return Objects.equals(this.dealReference, _that.getDealReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityIdentifierBuilder {dealReference=" + this.dealReference + '}' + " " + super.toString();
        }
    }

    public static interface FacilityIdentifierBuilder
    extends FacilityIdentifier,
    IdentifiedAssetWithParty.IdentifiedAssetWithPartyBuilder {
        public DealReference.DealReferenceBuilder getOrCreateDealReference();

        @Override
        public DealReference.DealReferenceBuilder getDealReference();

        @Override
        public FacilityIdentifierBuilder setId(String var1);

        @Override
        public FacilityIdentifierBuilder setPartyReference(PartyReference var1);

        @Override
        public FacilityIdentifierBuilder addInstrumentId(InstrumentId var1);

        @Override
        public FacilityIdentifierBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public FacilityIdentifierBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FacilityIdentifierBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FacilityIdentifierBuilder setDescription(String var1);

        public FacilityIdentifierBuilder setDealReference(DealReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealReference"), processor, DealReference.DealReferenceBuilder.class, this.getDealReference(), new AttributeMeta[0]);
        }

        @Override
        public FacilityIdentifierBuilder prune();
    }

    public static class FacilityIdentifierImpl
    extends IdentifiedAssetWithParty.IdentifiedAssetWithPartyImpl
    implements FacilityIdentifier {
        private final DealReference dealReference;

        protected FacilityIdentifierImpl(FacilityIdentifierBuilder builder) {
            super(builder);
            this.dealReference = Optional.ofNullable(builder.getDealReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealReference")
        @RuneAttribute(value="dealReference")
        public DealReference getDealReference() {
            return this.dealReference;
        }

        @Override
        public FacilityIdentifier build() {
            return this;
        }

        @Override
        public FacilityIdentifierBuilder toBuilder() {
            FacilityIdentifierBuilder builder = FacilityIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityIdentifierBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDealReference()).ifPresent(builder::setDealReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityIdentifier _that = (FacilityIdentifier)this.getType().cast(o);
            return Objects.equals(this.dealReference, _that.getDealReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealReference != null ? this.dealReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityIdentifier {dealReference=" + this.dealReference + '}' + " " + super.toString();
        }
    }
}

