/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.meta.EvergreenOptionMeta;
import fpml.consolidated.shared.Period;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EvergreenOption", builder=EvergreenOptionBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EvergreenOption", model="fpml", builder=EvergreenOptionBuilderImpl.class, version="1.1.0")
public interface EvergreenOption
extends RosettaModelObject {
    public static final EvergreenOptionMeta metaData = new EvergreenOptionMeta();

    public Period getNonRenewalNoticePeriod();

    public Period getExtensionPeriod();

    public EvergreenOption build();

    public EvergreenOptionBuilder toBuilder();

    public static EvergreenOptionBuilder builder() {
        return new EvergreenOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends EvergreenOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EvergreenOption> getType() {
        return EvergreenOption.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("nonRenewalNoticePeriod"), processor, Period.class, this.getNonRenewalNoticePeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extensionPeriod"), processor, Period.class, this.getExtensionPeriod(), new AttributeMeta[0]);
    }

    public static class EvergreenOptionBuilderImpl
    implements EvergreenOptionBuilder {
        protected Period.PeriodBuilder nonRenewalNoticePeriod;
        protected Period.PeriodBuilder extensionPeriod;

        @Override
        @RosettaAttribute(value="nonRenewalNoticePeriod")
        @RuneAttribute(value="nonRenewalNoticePeriod")
        public Period.PeriodBuilder getNonRenewalNoticePeriod() {
            return this.nonRenewalNoticePeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateNonRenewalNoticePeriod() {
            Period.PeriodBuilder result = this.nonRenewalNoticePeriod != null ? this.nonRenewalNoticePeriod : (this.nonRenewalNoticePeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="extensionPeriod", isRequired=true)
        @RuneAttribute(value="extensionPeriod", isRequired=true)
        public Period.PeriodBuilder getExtensionPeriod() {
            return this.extensionPeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateExtensionPeriod() {
            Period.PeriodBuilder result = this.extensionPeriod != null ? this.extensionPeriod : (this.extensionPeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonRenewalNoticePeriod")
        @RuneAttribute(value="nonRenewalNoticePeriod")
        public EvergreenOptionBuilder setNonRenewalNoticePeriod(Period _nonRenewalNoticePeriod) {
            this.nonRenewalNoticePeriod = _nonRenewalNoticePeriod == null ? null : _nonRenewalNoticePeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="extensionPeriod", isRequired=true)
        @RuneAttribute(value="extensionPeriod", isRequired=true)
        public EvergreenOptionBuilder setExtensionPeriod(Period _extensionPeriod) {
            this.extensionPeriod = _extensionPeriod == null ? null : _extensionPeriod.toBuilder();
            return this;
        }

        @Override
        public EvergreenOption build() {
            return new EvergreenOptionImpl(this);
        }

        @Override
        public EvergreenOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public EvergreenOptionBuilder prune() {
            if (this.nonRenewalNoticePeriod != null && !this.nonRenewalNoticePeriod.prune().hasData()) {
                this.nonRenewalNoticePeriod = null;
            }
            if (this.extensionPeriod != null && !this.extensionPeriod.prune().hasData()) {
                this.extensionPeriod = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNonRenewalNoticePeriod() != null && this.getNonRenewalNoticePeriod().hasData()) {
                return true;
            }
            return this.getExtensionPeriod() != null && this.getExtensionPeriod().hasData();
        }

        public EvergreenOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EvergreenOptionBuilder o = (EvergreenOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonRenewalNoticePeriod(), (RosettaModelObjectBuilder)o.getNonRenewalNoticePeriod(), this::setNonRenewalNoticePeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtensionPeriod(), (RosettaModelObjectBuilder)o.getExtensionPeriod(), this::setExtensionPeriod);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EvergreenOption _that = this.getType().cast(o);
            if (!Objects.equals(this.nonRenewalNoticePeriod, _that.getNonRenewalNoticePeriod())) {
                return false;
            }
            return Objects.equals(this.extensionPeriod, _that.getExtensionPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonRenewalNoticePeriod != null ? this.nonRenewalNoticePeriod.hashCode() : 0);
            _result = 31 * _result + (this.extensionPeriod != null ? this.extensionPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EvergreenOptionBuilder {nonRenewalNoticePeriod=" + this.nonRenewalNoticePeriod + ", extensionPeriod=" + this.extensionPeriod + '}';
        }
    }

    public static interface EvergreenOptionBuilder
    extends EvergreenOption,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateNonRenewalNoticePeriod();

        @Override
        public Period.PeriodBuilder getNonRenewalNoticePeriod();

        public Period.PeriodBuilder getOrCreateExtensionPeriod();

        @Override
        public Period.PeriodBuilder getExtensionPeriod();

        public EvergreenOptionBuilder setNonRenewalNoticePeriod(Period var1);

        public EvergreenOptionBuilder setExtensionPeriod(Period var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("nonRenewalNoticePeriod"), processor, Period.PeriodBuilder.class, this.getNonRenewalNoticePeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extensionPeriod"), processor, Period.PeriodBuilder.class, this.getExtensionPeriod(), new AttributeMeta[0]);
        }

        public EvergreenOptionBuilder prune();
    }

    public static class EvergreenOptionImpl
    implements EvergreenOption {
        private final Period nonRenewalNoticePeriod;
        private final Period extensionPeriod;

        protected EvergreenOptionImpl(EvergreenOptionBuilder builder) {
            this.nonRenewalNoticePeriod = Optional.ofNullable(builder.getNonRenewalNoticePeriod()).map(f -> f.build()).orElse(null);
            this.extensionPeriod = Optional.ofNullable(builder.getExtensionPeriod()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="nonRenewalNoticePeriod")
        @RuneAttribute(value="nonRenewalNoticePeriod")
        public Period getNonRenewalNoticePeriod() {
            return this.nonRenewalNoticePeriod;
        }

        @Override
        @RosettaAttribute(value="extensionPeriod", isRequired=true)
        @RuneAttribute(value="extensionPeriod", isRequired=true)
        public Period getExtensionPeriod() {
            return this.extensionPeriod;
        }

        @Override
        public EvergreenOption build() {
            return this;
        }

        @Override
        public EvergreenOptionBuilder toBuilder() {
            EvergreenOptionBuilder builder = EvergreenOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EvergreenOptionBuilder builder) {
            Optional.ofNullable(this.getNonRenewalNoticePeriod()).ifPresent(builder::setNonRenewalNoticePeriod);
            Optional.ofNullable(this.getExtensionPeriod()).ifPresent(builder::setExtensionPeriod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EvergreenOption _that = this.getType().cast(o);
            if (!Objects.equals(this.nonRenewalNoticePeriod, _that.getNonRenewalNoticePeriod())) {
                return false;
            }
            return Objects.equals(this.extensionPeriod, _that.getExtensionPeriod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonRenewalNoticePeriod != null ? this.nonRenewalNoticePeriod.hashCode() : 0);
            _result = 31 * _result + (this.extensionPeriod != null ? this.extensionPeriod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EvergreenOption {nonRenewalNoticePeriod=" + this.nonRenewalNoticePeriod + ", extensionPeriod=" + this.extensionPeriod + '}';
        }
    }
}

