/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.Adjustment;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.CommitmentChangeMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommitmentChange", builder=CommitmentChangeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommitmentChange", model="fpml", builder=CommitmentChangeBuilderImpl.class, version="1.1.0")
public interface CommitmentChange
extends RosettaModelObject {
    public static final CommitmentChangeMeta metaData = new CommitmentChangeMeta();

    public ZonedDateTime getDate();

    public Adjustment getAdjustment();

    public MoneyWithParticipantShare getRemaining();

    public CommitmentChange build();

    public CommitmentChangeBuilder toBuilder();

    public static CommitmentChangeBuilder builder() {
        return new CommitmentChangeBuilderImpl();
    }

    default public RosettaMetaData<? extends CommitmentChange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommitmentChange> getType() {
        return CommitmentChange.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustment"), processor, Adjustment.class, this.getAdjustment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("remaining"), processor, MoneyWithParticipantShare.class, this.getRemaining(), new AttributeMeta[0]);
    }

    public static class CommitmentChangeBuilderImpl
    implements CommitmentChangeBuilder {
        protected ZonedDateTime date;
        protected Adjustment.AdjustmentBuilder adjustment;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder remaining;

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public Adjustment.AdjustmentBuilder getAdjustment() {
            return this.adjustment;
        }

        @Override
        public Adjustment.AdjustmentBuilder getOrCreateAdjustment() {
            Adjustment.AdjustmentBuilder result = this.adjustment != null ? this.adjustment : (this.adjustment = Adjustment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="remaining", isRequired=true)
        @RuneAttribute(value="remaining", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getRemaining() {
            return this.remaining;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateRemaining() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.remaining != null ? this.remaining : (this.remaining = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public CommitmentChangeBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public CommitmentChangeBuilder setAdjustment(Adjustment _adjustment) {
            this.adjustment = _adjustment == null ? null : _adjustment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="remaining", isRequired=true)
        @RuneAttribute(value="remaining", isRequired=true)
        public CommitmentChangeBuilder setRemaining(MoneyWithParticipantShare _remaining) {
            this.remaining = _remaining == null ? null : _remaining.toBuilder();
            return this;
        }

        @Override
        public CommitmentChange build() {
            return new CommitmentChangeImpl(this);
        }

        @Override
        public CommitmentChangeBuilder toBuilder() {
            return this;
        }

        @Override
        public CommitmentChangeBuilder prune() {
            if (this.adjustment != null && !this.adjustment.prune().hasData()) {
                this.adjustment = null;
            }
            if (this.remaining != null && !this.remaining.prune().hasData()) {
                this.remaining = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDate() != null) {
                return true;
            }
            if (this.getAdjustment() != null && this.getAdjustment().hasData()) {
                return true;
            }
            return this.getRemaining() != null && this.getRemaining().hasData();
        }

        public CommitmentChangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommitmentChangeBuilder o = (CommitmentChangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustment(), (RosettaModelObjectBuilder)o.getAdjustment(), this::setAdjustment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRemaining(), (RosettaModelObjectBuilder)o.getRemaining(), this::setRemaining);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommitmentChange _that = this.getType().cast(o);
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustment, _that.getAdjustment())) {
                return false;
            }
            return Objects.equals(this.remaining, _that.getRemaining());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            _result = 31 * _result + (this.remaining != null ? this.remaining.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommitmentChangeBuilder {date=" + this.date + ", adjustment=" + this.adjustment + ", remaining=" + this.remaining + '}';
        }
    }

    public static interface CommitmentChangeBuilder
    extends CommitmentChange,
    RosettaModelObjectBuilder {
        public Adjustment.AdjustmentBuilder getOrCreateAdjustment();

        @Override
        public Adjustment.AdjustmentBuilder getAdjustment();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateRemaining();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getRemaining();

        public CommitmentChangeBuilder setDate(ZonedDateTime var1);

        public CommitmentChangeBuilder setAdjustment(Adjustment var1);

        public CommitmentChangeBuilder setRemaining(MoneyWithParticipantShare var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustment"), processor, Adjustment.AdjustmentBuilder.class, this.getAdjustment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("remaining"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getRemaining(), new AttributeMeta[0]);
        }

        public CommitmentChangeBuilder prune();
    }

    public static class CommitmentChangeImpl
    implements CommitmentChange {
        private final ZonedDateTime date;
        private final Adjustment adjustment;
        private final MoneyWithParticipantShare remaining;

        protected CommitmentChangeImpl(CommitmentChangeBuilder builder) {
            this.date = builder.getDate();
            this.adjustment = Optional.ofNullable(builder.getAdjustment()).map(f -> f.build()).orElse(null);
            this.remaining = Optional.ofNullable(builder.getRemaining()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="adjustment", isRequired=true)
        @RuneAttribute(value="adjustment", isRequired=true)
        public Adjustment getAdjustment() {
            return this.adjustment;
        }

        @Override
        @RosettaAttribute(value="remaining", isRequired=true)
        @RuneAttribute(value="remaining", isRequired=true)
        public MoneyWithParticipantShare getRemaining() {
            return this.remaining;
        }

        @Override
        public CommitmentChange build() {
            return this;
        }

        @Override
        public CommitmentChangeBuilder toBuilder() {
            CommitmentChangeBuilder builder = CommitmentChange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommitmentChangeBuilder builder) {
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getAdjustment()).ifPresent(builder::setAdjustment);
            Optional.ofNullable(this.getRemaining()).ifPresent(builder::setRemaining);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommitmentChange _that = this.getType().cast(o);
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustment, _that.getAdjustment())) {
                return false;
            }
            return Objects.equals(this.remaining, _that.getRemaining());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.adjustment != null ? this.adjustment.hashCode() : 0);
            _result = 31 * _result + (this.remaining != null ? this.remaining.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommitmentChange {date=" + this.date + ", adjustment=" + this.adjustment + ", remaining=" + this.remaining + '}';
        }
    }
}

