/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractBaseRateSet;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.meta.BaseRateSetMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="BaseRateSet", builder=BaseRateSetBuilderImpl.class, version="1.1.0")
@RuneDataType(value="BaseRateSet", model="fpml", builder=BaseRateSetBuilderImpl.class, version="1.1.0")
public interface BaseRateSet
extends LoanContractBaseRateSet {
    public static final BaseRateSetMeta metaData = new BaseRateSetMeta();

    @Override
    public BaseRateSet build();

    @Override
    public BaseRateSetBuilder toBuilder();

    public static BaseRateSetBuilder builder() {
        return new BaseRateSetBuilderImpl();
    }

    default public RosettaMetaData<? extends BaseRateSet> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BaseRateSet> getType() {
        return BaseRateSet.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadAdjustment"), BigDecimal.class, (Object)this.getSpreadAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class BaseRateSetBuilderImpl
    extends LoanContractBaseRateSet.LoanContractBaseRateSetBuilderImpl
    implements BaseRateSetBuilder {
        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public BaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public BaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public BaseRateSetBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public BaseRateSetBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public BaseRateSetBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public BaseRateSetBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public BaseRateSetBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public BaseRateSetBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public BaseRateSetBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public BaseRateSetBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public BaseRateSetBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public BaseRateSetBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BaseRateSetBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadAdjustment")
        @RuneAttribute(value="spreadAdjustment")
        public BaseRateSetBuilder setSpreadAdjustment(BigDecimal _spreadAdjustment) {
            this.spreadAdjustment = _spreadAdjustment == null ? null : _spreadAdjustment;
            return this;
        }

        @Override
        public BaseRateSet build() {
            return new BaseRateSetImpl(this);
        }

        @Override
        public BaseRateSetBuilder toBuilder() {
            return this;
        }

        @Override
        public BaseRateSetBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public BaseRateSetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BaseRateSetBuilder o = (BaseRateSetBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "BaseRateSetBuilder {} " + super.toString();
        }
    }

    public static interface BaseRateSetBuilder
    extends BaseRateSet,
    LoanContractBaseRateSet.LoanContractBaseRateSetBuilder {
        @Override
        public BaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public BaseRateSetBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public BaseRateSetBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public BaseRateSetBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public BaseRateSetBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public BaseRateSetBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public BaseRateSetBuilder setComment(String var1);

        @Override
        public BaseRateSetBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public BaseRateSetBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public BaseRateSetBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public BaseRateSetBuilder setLoanContractReference(LoanContractReference var1);

        @Override
        public BaseRateSetBuilder setFixingDate(ZonedDateTime var1);

        @Override
        public BaseRateSetBuilder setRate(BigDecimal var1);

        @Override
        public BaseRateSetBuilder setSpreadAdjustment(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadAdjustment"), BigDecimal.class, (Object)this.getSpreadAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public BaseRateSetBuilder prune();
    }

    public static class BaseRateSetImpl
    extends LoanContractBaseRateSet.LoanContractBaseRateSetImpl
    implements BaseRateSet {
        protected BaseRateSetImpl(BaseRateSetBuilder builder) {
            super(builder);
        }

        @Override
        public BaseRateSet build() {
            return this;
        }

        @Override
        public BaseRateSetBuilder toBuilder() {
            BaseRateSetBuilder builder = BaseRateSet.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BaseRateSetBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "BaseRateSet {} " + super.toString();
        }
    }
}

